/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
import $protobuf from "protobufjs/minimal.js";

const $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

const $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

export const proto = $root.proto = (() => {

    const proto = {};

    proto.ADVDeviceIdentity = (function() {

        function ADVDeviceIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVDeviceIdentity.prototype.rawId = null;
        ADVDeviceIdentity.prototype.timestamp = null;
        ADVDeviceIdentity.prototype.keyIndex = null;
        ADVDeviceIdentity.prototype.accountType = null;
        ADVDeviceIdentity.prototype.deviceType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_rawId", {
            get: $util.oneOfGetter($oneOfFields = ["rawId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_keyIndex", {
            get: $util.oneOfGetter($oneOfFields = ["keyIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_deviceType", {
            get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        ADVDeviceIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                w.uint32(8).uint32(m.rawId);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(16).uint64(m.timestamp);
            if (m.keyIndex != null && Object.hasOwnProperty.call(m, "keyIndex"))
                w.uint32(24).uint32(m.keyIndex);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(32).int32(m.accountType);
            if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                w.uint32(40).int32(m.deviceType);
            return w;
        };

        ADVDeviceIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVDeviceIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.rawId = r.uint32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.uint64();
                        break;
                    }
                case 3: {
                        m.keyIndex = r.uint32();
                        break;
                    }
                case 4: {
                        m.accountType = r.int32();
                        break;
                    }
                case 5: {
                        m.deviceType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVDeviceIdentity.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVDeviceIdentity)
                return d;
            var m = new $root.proto.ADVDeviceIdentity();
            if (d.rawId != null) {
                m.rawId = d.rawId >>> 0;
            }
            if (d.timestamp != null) {
                if ($util.Long)
                    (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = true;
                else if (typeof d.timestamp === "string")
                    m.timestamp = parseInt(d.timestamp, 10);
                else if (typeof d.timestamp === "number")
                    m.timestamp = d.timestamp;
                else if (typeof d.timestamp === "object")
                    m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber(true);
            }
            if (d.keyIndex != null) {
                m.keyIndex = d.keyIndex >>> 0;
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.accountType = 1;
                break;
            }
            switch (d.deviceType) {
            default:
                if (typeof d.deviceType === "number") {
                    m.deviceType = d.deviceType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.deviceType = 0;
                break;
            case "HOSTED":
            case 1:
                m.deviceType = 1;
                break;
            }
            return m;
        };

        ADVDeviceIdentity.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.rawId != null && m.hasOwnProperty("rawId")) {
                d.rawId = m.rawId;
                if (o.oneofs)
                    d._rawId = "rawId";
            }
            if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                if (typeof m.timestamp === "number")
                    d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                else
                    d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber(true) : m.timestamp;
                if (o.oneofs)
                    d._timestamp = "timestamp";
            }
            if (m.keyIndex != null && m.hasOwnProperty("keyIndex")) {
                d.keyIndex = m.keyIndex;
                if (o.oneofs)
                    d._keyIndex = "keyIndex";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ADVEncryptionType[m.accountType] === undefined ? m.accountType : $root.proto.ADVEncryptionType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            if (m.deviceType != null && m.hasOwnProperty("deviceType")) {
                d.deviceType = o.enums === String ? $root.proto.ADVEncryptionType[m.deviceType] === undefined ? m.deviceType : $root.proto.ADVEncryptionType[m.deviceType] : m.deviceType;
                if (o.oneofs)
                    d._deviceType = "deviceType";
            }
            return d;
        };

        ADVDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVDeviceIdentity";
        };

        return ADVDeviceIdentity;
    })();

    proto.ADVEncryptionType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "E2EE"] = 0;
        values[valuesById[1] = "HOSTED"] = 1;
        return values;
    })();

    proto.ADVKeyIndexList = (function() {

        function ADVKeyIndexList(p) {
            this.validIndexes = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVKeyIndexList.prototype.rawId = null;
        ADVKeyIndexList.prototype.timestamp = null;
        ADVKeyIndexList.prototype.currentIndex = null;
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;
        ADVKeyIndexList.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_rawId", {
            get: $util.oneOfGetter($oneOfFields = ["rawId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_currentIndex", {
            get: $util.oneOfGetter($oneOfFields = ["currentIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        ADVKeyIndexList.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                w.uint32(8).uint32(m.rawId);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(16).uint64(m.timestamp);
            if (m.currentIndex != null && Object.hasOwnProperty.call(m, "currentIndex"))
                w.uint32(24).uint32(m.currentIndex);
            if (m.validIndexes != null && m.validIndexes.length) {
                w.uint32(34).fork();
                for (var i = 0; i < m.validIndexes.length; ++i)
                    w.uint32(m.validIndexes[i]);
                w.ldelim();
            }
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(40).int32(m.accountType);
            return w;
        };

        ADVKeyIndexList.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVKeyIndexList();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.rawId = r.uint32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.uint64();
                        break;
                    }
                case 3: {
                        m.currentIndex = r.uint32();
                        break;
                    }
                case 4: {
                        if (!(m.validIndexes && m.validIndexes.length))
                            m.validIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.validIndexes.push(r.uint32());
                        } else
                            m.validIndexes.push(r.uint32());
                        break;
                    }
                case 5: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVKeyIndexList.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVKeyIndexList)
                return d;
            var m = new $root.proto.ADVKeyIndexList();
            if (d.rawId != null) {
                m.rawId = d.rawId >>> 0;
            }
            if (d.timestamp != null) {
                if ($util.Long)
                    (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = true;
                else if (typeof d.timestamp === "string")
                    m.timestamp = parseInt(d.timestamp, 10);
                else if (typeof d.timestamp === "number")
                    m.timestamp = d.timestamp;
                else if (typeof d.timestamp === "object")
                    m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber(true);
            }
            if (d.currentIndex != null) {
                m.currentIndex = d.currentIndex >>> 0;
            }
            if (d.validIndexes) {
                if (!Array.isArray(d.validIndexes))
                    throw TypeError(".proto.ADVKeyIndexList.validIndexes: array expected");
                m.validIndexes = [];
                for (var i = 0; i < d.validIndexes.length; ++i) {
                    m.validIndexes[i] = d.validIndexes[i] >>> 0;
                }
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.accountType = 1;
                break;
            }
            return m;
        };

        ADVKeyIndexList.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.validIndexes = [];
            }
            if (m.rawId != null && m.hasOwnProperty("rawId")) {
                d.rawId = m.rawId;
                if (o.oneofs)
                    d._rawId = "rawId";
            }
            if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                if (typeof m.timestamp === "number")
                    d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                else
                    d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber(true) : m.timestamp;
                if (o.oneofs)
                    d._timestamp = "timestamp";
            }
            if (m.currentIndex != null && m.hasOwnProperty("currentIndex")) {
                d.currentIndex = m.currentIndex;
                if (o.oneofs)
                    d._currentIndex = "currentIndex";
            }
            if (m.validIndexes && m.validIndexes.length) {
                d.validIndexes = [];
                for (var j = 0; j < m.validIndexes.length; ++j) {
                    d.validIndexes[j] = m.validIndexes[j];
                }
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ADVEncryptionType[m.accountType] === undefined ? m.accountType : $root.proto.ADVEncryptionType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        ADVKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVKeyIndexList";
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        function ADVSignedDeviceIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedDeviceIdentity.prototype.details = null;
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = null;
        ADVSignedDeviceIdentity.prototype.accountSignature = null;
        ADVSignedDeviceIdentity.prototype.deviceSignature = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_accountSignatureKey", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignatureKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_accountSignature", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_deviceSignature", {
            get: $util.oneOfGetter($oneOfFields = ["deviceSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        ADVSignedDeviceIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.accountSignatureKey != null && Object.hasOwnProperty.call(m, "accountSignatureKey"))
                w.uint32(18).bytes(m.accountSignatureKey);
            if (m.accountSignature != null && Object.hasOwnProperty.call(m, "accountSignature"))
                w.uint32(26).bytes(m.accountSignature);
            if (m.deviceSignature != null && Object.hasOwnProperty.call(m, "deviceSignature"))
                w.uint32(34).bytes(m.deviceSignature);
            return w;
        };

        ADVSignedDeviceIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedDeviceIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.accountSignatureKey = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountSignature = r.bytes();
                        break;
                    }
                case 4: {
                        m.deviceSignature = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedDeviceIdentity.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVSignedDeviceIdentity)
                return d;
            var m = new $root.proto.ADVSignedDeviceIdentity();
            if (d.details != null) {
                if (typeof d.details === "string")
                    $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                else if (d.details.length >= 0)
                    m.details = d.details;
            }
            if (d.accountSignatureKey != null) {
                if (typeof d.accountSignatureKey === "string")
                    $util.base64.decode(d.accountSignatureKey, m.accountSignatureKey = $util.newBuffer($util.base64.length(d.accountSignatureKey)), 0);
                else if (d.accountSignatureKey.length >= 0)
                    m.accountSignatureKey = d.accountSignatureKey;
            }
            if (d.accountSignature != null) {
                if (typeof d.accountSignature === "string")
                    $util.base64.decode(d.accountSignature, m.accountSignature = $util.newBuffer($util.base64.length(d.accountSignature)), 0);
                else if (d.accountSignature.length >= 0)
                    m.accountSignature = d.accountSignature;
            }
            if (d.deviceSignature != null) {
                if (typeof d.deviceSignature === "string")
                    $util.base64.decode(d.deviceSignature, m.deviceSignature = $util.newBuffer($util.base64.length(d.deviceSignature)), 0);
                else if (d.deviceSignature.length >= 0)
                    m.deviceSignature = d.deviceSignature;
            }
            return m;
        };

        ADVSignedDeviceIdentity.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.details != null && m.hasOwnProperty("details")) {
                d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                if (o.oneofs)
                    d._details = "details";
            }
            if (m.accountSignatureKey != null && m.hasOwnProperty("accountSignatureKey")) {
                d.accountSignatureKey = o.bytes === String ? $util.base64.encode(m.accountSignatureKey, 0, m.accountSignatureKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignatureKey) : m.accountSignatureKey;
                if (o.oneofs)
                    d._accountSignatureKey = "accountSignatureKey";
            }
            if (m.accountSignature != null && m.hasOwnProperty("accountSignature")) {
                d.accountSignature = o.bytes === String ? $util.base64.encode(m.accountSignature, 0, m.accountSignature.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignature) : m.accountSignature;
                if (o.oneofs)
                    d._accountSignature = "accountSignature";
            }
            if (m.deviceSignature != null && m.hasOwnProperty("deviceSignature")) {
                d.deviceSignature = o.bytes === String ? $util.base64.encode(m.deviceSignature, 0, m.deviceSignature.length) : o.bytes === Array ? Array.prototype.slice.call(m.deviceSignature) : m.deviceSignature;
                if (o.oneofs)
                    d._deviceSignature = "deviceSignature";
            }
            return d;
        };

        ADVSignedDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVSignedDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentity";
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        function ADVSignedDeviceIdentityHMAC(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedDeviceIdentityHMAC.prototype.details = null;
        ADVSignedDeviceIdentityHMAC.prototype.hmac = null;
        ADVSignedDeviceIdentityHMAC.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_hmac", {
            get: $util.oneOfGetter($oneOfFields = ["hmac"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        ADVSignedDeviceIdentityHMAC.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.hmac != null && Object.hasOwnProperty.call(m, "hmac"))
                w.uint32(18).bytes(m.hmac);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(24).int32(m.accountType);
            return w;
        };

        ADVSignedDeviceIdentityHMAC.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.hmac = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedDeviceIdentityHMAC.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVSignedDeviceIdentityHMAC)
                return d;
            var m = new $root.proto.ADVSignedDeviceIdentityHMAC();
            if (d.details != null) {
                if (typeof d.details === "string")
                    $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                else if (d.details.length >= 0)
                    m.details = d.details;
            }
            if (d.hmac != null) {
                if (typeof d.hmac === "string")
                    $util.base64.decode(d.hmac, m.hmac = $util.newBuffer($util.base64.length(d.hmac)), 0);
                else if (d.hmac.length >= 0)
                    m.hmac = d.hmac;
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.accountType = 1;
                break;
            }
            return m;
        };

        ADVSignedDeviceIdentityHMAC.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.details != null && m.hasOwnProperty("details")) {
                d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                if (o.oneofs)
                    d._details = "details";
            }
            if (m.hmac != null && m.hasOwnProperty("hmac")) {
                d.hmac = o.bytes === String ? $util.base64.encode(m.hmac, 0, m.hmac.length) : o.bytes === Array ? Array.prototype.slice.call(m.hmac) : m.hmac;
                if (o.oneofs)
                    d._hmac = "hmac";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ADVEncryptionType[m.accountType] === undefined ? m.accountType : $root.proto.ADVEncryptionType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        ADVSignedDeviceIdentityHMAC.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVSignedDeviceIdentityHMAC.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentityHMAC";
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        function ADVSignedKeyIndexList(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedKeyIndexList.prototype.details = null;
        ADVSignedKeyIndexList.prototype.accountSignature = null;
        ADVSignedKeyIndexList.prototype.accountSignatureKey = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_accountSignature", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_accountSignatureKey", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignatureKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        ADVSignedKeyIndexList.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.accountSignature != null && Object.hasOwnProperty.call(m, "accountSignature"))
                w.uint32(18).bytes(m.accountSignature);
            if (m.accountSignatureKey != null && Object.hasOwnProperty.call(m, "accountSignatureKey"))
                w.uint32(26).bytes(m.accountSignatureKey);
            return w;
        };

        ADVSignedKeyIndexList.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedKeyIndexList();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.accountSignature = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountSignatureKey = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedKeyIndexList.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ADVSignedKeyIndexList)
                return d;
            var m = new $root.proto.ADVSignedKeyIndexList();
            if (d.details != null) {
                if (typeof d.details === "string")
                    $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                else if (d.details.length >= 0)
                    m.details = d.details;
            }
            if (d.accountSignature != null) {
                if (typeof d.accountSignature === "string")
                    $util.base64.decode(d.accountSignature, m.accountSignature = $util.newBuffer($util.base64.length(d.accountSignature)), 0);
                else if (d.accountSignature.length >= 0)
                    m.accountSignature = d.accountSignature;
            }
            if (d.accountSignatureKey != null) {
                if (typeof d.accountSignatureKey === "string")
                    $util.base64.decode(d.accountSignatureKey, m.accountSignatureKey = $util.newBuffer($util.base64.length(d.accountSignatureKey)), 0);
                else if (d.accountSignatureKey.length >= 0)
                    m.accountSignatureKey = d.accountSignatureKey;
            }
            return m;
        };

        ADVSignedKeyIndexList.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.details != null && m.hasOwnProperty("details")) {
                d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                if (o.oneofs)
                    d._details = "details";
            }
            if (m.accountSignature != null && m.hasOwnProperty("accountSignature")) {
                d.accountSignature = o.bytes === String ? $util.base64.encode(m.accountSignature, 0, m.accountSignature.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignature) : m.accountSignature;
                if (o.oneofs)
                    d._accountSignature = "accountSignature";
            }
            if (m.accountSignatureKey != null && m.hasOwnProperty("accountSignatureKey")) {
                d.accountSignatureKey = o.bytes === String ? $util.base64.encode(m.accountSignatureKey, 0, m.accountSignatureKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.accountSignatureKey) : m.accountSignatureKey;
                if (o.oneofs)
                    d._accountSignatureKey = "accountSignatureKey";
            }
            return d;
        };

        ADVSignedKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ADVSignedKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedKeyIndexList";
        };

        return ADVSignedKeyIndexList;
    })();

    proto.AIQueryFanout = (function() {

        function AIQueryFanout(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIQueryFanout.prototype.messageKey = null;
        AIQueryFanout.prototype.message = null;
        AIQueryFanout.prototype.timestamp = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_messageKey", {
            get: $util.oneOfGetter($oneOfFields = ["messageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_message", {
            get: $util.oneOfGetter($oneOfFields = ["message"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIQueryFanout.create = function create(properties) {
            return new AIQueryFanout(properties);
        };

        AIQueryFanout.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
            if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                $root.proto.Message.encode(m.message, w.uint32(18).fork()).ldelim();
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(24).int64(m.timestamp);
            return w;
        };

        AIQueryFanout.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIQueryFanout();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.message = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.timestamp = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIQueryFanout.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIQueryFanout)
                return d;
            var m = new $root.proto.AIQueryFanout();
            if (d.messageKey != null) {
                if (typeof d.messageKey !== "object")
                    throw TypeError(".proto.AIQueryFanout.messageKey: object expected");
                m.messageKey = $root.proto.MessageKey.fromObject(d.messageKey);
            }
            if (d.message != null) {
                if (typeof d.message !== "object")
                    throw TypeError(".proto.AIQueryFanout.message: object expected");
                m.message = $root.proto.Message.fromObject(d.message);
            }
            if (d.timestamp != null) {
                if ($util.Long)
                    (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = false;
                else if (typeof d.timestamp === "string")
                    m.timestamp = parseInt(d.timestamp, 10);
                else if (typeof d.timestamp === "number")
                    m.timestamp = d.timestamp;
                else if (typeof d.timestamp === "object")
                    m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber();
            }
            return m;
        };

        AIQueryFanout.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.messageKey != null && m.hasOwnProperty("messageKey")) {
                d.messageKey = $root.proto.MessageKey.toObject(m.messageKey, o);
                if (o.oneofs)
                    d._messageKey = "messageKey";
            }
            if (m.message != null && m.hasOwnProperty("message")) {
                d.message = $root.proto.Message.toObject(m.message, o);
                if (o.oneofs)
                    d._message = "message";
            }
            if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                if (typeof m.timestamp === "number")
                    d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                else
                    d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber() : m.timestamp;
                if (o.oneofs)
                    d._timestamp = "timestamp";
            }
            return d;
        };

        AIQueryFanout.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIQueryFanout.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIQueryFanout";
        };

        return AIQueryFanout;
    })();

    proto.AIRichResponseMessage = (function() {

        function AIRichResponseMessage(p) {
            this.submessages = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseMessage.prototype.messageType = null;
        AIRichResponseMessage.prototype.submessages = $util.emptyArray;
        AIRichResponseMessage.prototype.unifiedResponse = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_messageType", {
            get: $util.oneOfGetter($oneOfFields = ["messageType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_unifiedResponse", {
            get: $util.oneOfGetter($oneOfFields = ["unifiedResponse"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AIRichResponseMessage.create = function create(properties) {
            return new AIRichResponseMessage(properties);
        };

        AIRichResponseMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageType != null && Object.hasOwnProperty.call(m, "messageType"))
                w.uint32(8).int32(m.messageType);
            if (m.submessages != null && m.submessages.length) {
                for (var i = 0; i < m.submessages.length; ++i)
                    $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.encode(m.submessages[i], w.uint32(18).fork()).ldelim();
            }
            if (m.unifiedResponse != null && Object.hasOwnProperty.call(m, "unifiedResponse"))
                $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.encode(m.unifiedResponse, w.uint32(26).fork()).ldelim();
            return w;
        };

        AIRichResponseMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageType = r.int32();
                        break;
                    }
                case 2: {
                        if (!(m.submessages && m.submessages.length))
                            m.submessages = [];
                        m.submessages.push($root.proto.AIRichResponseMessage.AIRichResponseSubMessage.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseMessage.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AIRichResponseMessage)
                return d;
            var m = new $root.proto.AIRichResponseMessage();
            switch (d.messageType) {
            default:
                if (typeof d.messageType === "number") {
                    m.messageType = d.messageType;
                    break;
                }
                break;
            case "AI_RICH_RESPONSE_TYPE_UNKNOWN":
            case 0:
                m.messageType = 0;
                break;
            case "AI_RICH_RESPONSE_TYPE_STANDARD":
            case 1:
                m.messageType = 1;
                break;
            }
            if (d.submessages) {
                if (!Array.isArray(d.submessages))
                    throw TypeError(".proto.AIRichResponseMessage.submessages: array expected");
                m.submessages = [];
                for (var i = 0; i < d.submessages.length; ++i) {
                    if (typeof d.submessages[i] !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.submessages: object expected");
                    m.submessages[i] = $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.fromObject(d.submessages[i]);
                }
            }
            if (d.unifiedResponse != null) {
                if (typeof d.unifiedResponse !== "object")
                    throw TypeError(".proto.AIRichResponseMessage.unifiedResponse: object expected");
                m.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.fromObject(d.unifiedResponse);
            }
            return m;
        };

        AIRichResponseMessage.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.submessages = [];
            }
            if (m.messageType != null && m.hasOwnProperty("messageType")) {
                d.messageType = o.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseMessageType[m.messageType] === undefined ? m.messageType : $root.proto.AIRichResponseMessage.AIRichResponseMessageType[m.messageType] : m.messageType;
                if (o.oneofs)
                    d._messageType = "messageType";
            }
            if (m.submessages && m.submessages.length) {
                d.submessages = [];
                for (var j = 0; j < m.submessages.length; ++j) {
                    d.submessages[j] = $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.toObject(m.submessages[j], o);
                }
            }
            if (m.unifiedResponse != null && m.hasOwnProperty("unifiedResponse")) {
                d.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.toObject(m.unifiedResponse, o);
                if (o.oneofs)
                    d._unifiedResponse = "unifiedResponse";
            }
            return d;
        };

        AIRichResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AIRichResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseMessage";
        };

        AIRichResponseMessage.AIRichResponseCodeMetadata = (function() {

            function AIRichResponseCodeMetadata(p) {
                this.codeBlocks = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseCodeMetadata.prototype.codeLanguage = null;
            AIRichResponseCodeMetadata.prototype.codeBlocks = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseCodeMetadata.prototype, "_codeLanguage", {
                get: $util.oneOfGetter($oneOfFields = ["codeLanguage"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseCodeMetadata.create = function create(properties) {
                return new AIRichResponseCodeMetadata(properties);
            };

            AIRichResponseCodeMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.codeLanguage != null && Object.hasOwnProperty.call(m, "codeLanguage"))
                    w.uint32(10).string(m.codeLanguage);
                if (m.codeBlocks != null && m.codeBlocks.length) {
                    for (var i = 0; i < m.codeBlocks.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.encode(m.codeBlocks[i], w.uint32(18).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseCodeMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.codeLanguage = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.codeBlocks && m.codeBlocks.length))
                                m.codeBlocks = [];
                            m.codeBlocks.push($root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseCodeMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata();
                if (d.codeLanguage != null) {
                    m.codeLanguage = String(d.codeLanguage);
                }
                if (d.codeBlocks) {
                    if (!Array.isArray(d.codeBlocks))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseCodeMetadata.codeBlocks: array expected");
                    m.codeBlocks = [];
                    for (var i = 0; i < d.codeBlocks.length; ++i) {
                        if (typeof d.codeBlocks[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseCodeMetadata.codeBlocks: object expected");
                        m.codeBlocks[i] = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.fromObject(d.codeBlocks[i]);
                    }
                }
                return m;
            };

            AIRichResponseCodeMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.codeBlocks = [];
                }
                if (m.codeLanguage != null && m.hasOwnProperty("codeLanguage")) {
                    d.codeLanguage = m.codeLanguage;
                    if (o.oneofs)
                        d._codeLanguage = "codeLanguage";
                }
                if (m.codeBlocks && m.codeBlocks.length) {
                    d.codeBlocks = [];
                    for (var j = 0; j < m.codeBlocks.length; ++j) {
                        d.codeBlocks[j] = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.toObject(m.codeBlocks[j], o);
                    }
                }
                return d;
            };

            AIRichResponseCodeMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseCodeMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseCodeMetadata";
            };

            AIRichResponseCodeMetadata.AIRichResponseCodeBlock = (function() {

                function AIRichResponseCodeBlock(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseCodeBlock.prototype.highlightType = null;
                AIRichResponseCodeBlock.prototype.codeContent = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseCodeBlock.prototype, "_highlightType", {
                    get: $util.oneOfGetter($oneOfFields = ["highlightType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseCodeBlock.prototype, "_codeContent", {
                    get: $util.oneOfGetter($oneOfFields = ["codeContent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseCodeBlock.create = function create(properties) {
                    return new AIRichResponseCodeBlock(properties);
                };

                AIRichResponseCodeBlock.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.highlightType != null && Object.hasOwnProperty.call(m, "highlightType"))
                        w.uint32(8).int32(m.highlightType);
                    if (m.codeContent != null && Object.hasOwnProperty.call(m, "codeContent"))
                        w.uint32(18).string(m.codeContent);
                    return w;
                };

                AIRichResponseCodeBlock.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.highlightType = r.int32();
                                break;
                            }
                        case 2: {
                                m.codeContent = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseCodeBlock.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock)
                        return d;
                    var m = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                    switch (d.highlightType) {
                    default:
                        if (typeof d.highlightType === "number") {
                            m.highlightType = d.highlightType;
                            break;
                        }
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT":
                    case 0:
                        m.highlightType = 0;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD":
                    case 1:
                        m.highlightType = 1;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD":
                    case 2:
                        m.highlightType = 2;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING":
                    case 3:
                        m.highlightType = 3;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER":
                    case 4:
                        m.highlightType = 4;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT":
                    case 5:
                        m.highlightType = 5;
                        break;
                    }
                    if (d.codeContent != null) {
                        m.codeContent = String(d.codeContent);
                    }
                    return m;
                };

                AIRichResponseCodeBlock.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.highlightType != null && m.hasOwnProperty("highlightType")) {
                        d.highlightType = o.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType[m.highlightType] === undefined ? m.highlightType : $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType[m.highlightType] : m.highlightType;
                        if (o.oneofs)
                            d._highlightType = "highlightType";
                    }
                    if (m.codeContent != null && m.hasOwnProperty("codeContent")) {
                        d.codeContent = m.codeContent;
                        if (o.oneofs)
                            d._codeContent = "codeContent";
                    }
                    return d;
                };

                AIRichResponseCodeBlock.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AIRichResponseCodeBlock.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock";
                };

                return AIRichResponseCodeBlock;
            })();

            AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD"] = 2;
                values[valuesById[3] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING"] = 3;
                values[valuesById[4] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER"] = 4;
                values[valuesById[5] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT"] = 5;
                return values;
            })();

            return AIRichResponseCodeMetadata;
        })();

        AIRichResponseMessage.AIRichResponseContentItemsMetadata = (function() {

            function AIRichResponseContentItemsMetadata(p) {
                this.itemsMetadata = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseContentItemsMetadata.prototype.itemsMetadata = $util.emptyArray;
            AIRichResponseContentItemsMetadata.prototype.contentType = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseContentItemsMetadata.prototype, "_contentType", {
                get: $util.oneOfGetter($oneOfFields = ["contentType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseContentItemsMetadata.create = function create(properties) {
                return new AIRichResponseContentItemsMetadata(properties);
            };

            AIRichResponseContentItemsMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.itemsMetadata != null && m.itemsMetadata.length) {
                    for (var i = 0; i < m.itemsMetadata.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.encode(m.itemsMetadata[i], w.uint32(10).fork()).ldelim();
                }
                if (m.contentType != null && Object.hasOwnProperty.call(m, "contentType"))
                    w.uint32(16).int32(m.contentType);
                return w;
            };

            AIRichResponseContentItemsMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.itemsMetadata && m.itemsMetadata.length))
                                m.itemsMetadata = [];
                            m.itemsMetadata.push($root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.decode(r, r.uint32()));
                            break;
                        }
                    case 2: {
                            m.contentType = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseContentItemsMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata();
                if (d.itemsMetadata) {
                    if (!Array.isArray(d.itemsMetadata))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.itemsMetadata: array expected");
                    m.itemsMetadata = [];
                    for (var i = 0; i < d.itemsMetadata.length; ++i) {
                        if (typeof d.itemsMetadata[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.itemsMetadata: object expected");
                        m.itemsMetadata[i] = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.fromObject(d.itemsMetadata[i]);
                    }
                }
                switch (d.contentType) {
                default:
                    if (typeof d.contentType === "number") {
                        m.contentType = d.contentType;
                        break;
                    }
                    break;
                case "DEFAULT":
                case 0:
                    m.contentType = 0;
                    break;
                case "CAROUSEL":
                case 1:
                    m.contentType = 1;
                    break;
                }
                return m;
            };

            AIRichResponseContentItemsMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.itemsMetadata = [];
                }
                if (m.itemsMetadata && m.itemsMetadata.length) {
                    d.itemsMetadata = [];
                    for (var j = 0; j < m.itemsMetadata.length; ++j) {
                        d.itemsMetadata[j] = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.toObject(m.itemsMetadata[j], o);
                    }
                }
                if (m.contentType != null && m.hasOwnProperty("contentType")) {
                    d.contentType = o.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType[m.contentType] === undefined ? m.contentType : $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType[m.contentType] : m.contentType;
                    if (o.oneofs)
                        d._contentType = "contentType";
                }
                return d;
            };

            AIRichResponseContentItemsMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseContentItemsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata";
            };

            AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata = (function() {

                function AIRichResponseContentItemMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseContentItemMetadata.prototype.reelItem = null;

                let $oneOfFields;

                Object.defineProperty(AIRichResponseContentItemMetadata.prototype, "aIRichResponseContentItem", {
                    get: $util.oneOfGetter($oneOfFields = ["reelItem"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseContentItemMetadata.create = function create(properties) {
                    return new AIRichResponseContentItemMetadata(properties);
                };

                AIRichResponseContentItemMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.reelItem != null && Object.hasOwnProperty.call(m, "reelItem"))
                        $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.encode(m.reelItem, w.uint32(10).fork()).ldelim();
                    return w;
                };

                AIRichResponseContentItemMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseContentItemMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata)
                        return d;
                    var m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                    if (d.reelItem != null) {
                        if (typeof d.reelItem !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.reelItem: object expected");
                        m.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.fromObject(d.reelItem);
                    }
                    return m;
                };

                AIRichResponseContentItemMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.reelItem != null && m.hasOwnProperty("reelItem")) {
                        d.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.toObject(m.reelItem, o);
                        if (o.oneofs)
                            d.aIRichResponseContentItem = "reelItem";
                    }
                    return d;
                };

                AIRichResponseContentItemMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AIRichResponseContentItemMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata";
                };

                return AIRichResponseContentItemMetadata;
            })();

            AIRichResponseContentItemsMetadata.AIRichResponseReelItem = (function() {

                function AIRichResponseReelItem(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseReelItem.prototype.title = null;
                AIRichResponseReelItem.prototype.profileIconUrl = null;
                AIRichResponseReelItem.prototype.thumbnailUrl = null;
                AIRichResponseReelItem.prototype.videoUrl = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_profileIconUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["profileIconUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_thumbnailUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_videoUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["videoUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseReelItem.create = function create(properties) {
                    return new AIRichResponseReelItem(properties);
                };

                AIRichResponseReelItem.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.profileIconUrl != null && Object.hasOwnProperty.call(m, "profileIconUrl"))
                        w.uint32(18).string(m.profileIconUrl);
                    if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                        w.uint32(26).string(m.thumbnailUrl);
                    if (m.videoUrl != null && Object.hasOwnProperty.call(m, "videoUrl"))
                        w.uint32(34).string(m.videoUrl);
                    return w;
                };

                AIRichResponseReelItem.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.profileIconUrl = r.string();
                                break;
                            }
                        case 3: {
                                m.thumbnailUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.videoUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseReelItem.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem)
                        return d;
                    var m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                    if (d.title != null) {
                        m.title = String(d.title);
                    }
                    if (d.profileIconUrl != null) {
                        m.profileIconUrl = String(d.profileIconUrl);
                    }
                    if (d.thumbnailUrl != null) {
                        m.thumbnailUrl = String(d.thumbnailUrl);
                    }
                    if (d.videoUrl != null) {
                        m.videoUrl = String(d.videoUrl);
                    }
                    return m;
                };

                AIRichResponseReelItem.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.title != null && m.hasOwnProperty("title")) {
                        d.title = m.title;
                        if (o.oneofs)
                            d._title = "title";
                    }
                    if (m.profileIconUrl != null && m.hasOwnProperty("profileIconUrl")) {
                        d.profileIconUrl = m.profileIconUrl;
                        if (o.oneofs)
                            d._profileIconUrl = "profileIconUrl";
                    }
                    if (m.thumbnailUrl != null && m.hasOwnProperty("thumbnailUrl")) {
                        d.thumbnailUrl = m.thumbnailUrl;
                        if (o.oneofs)
                            d._thumbnailUrl = "thumbnailUrl";
                    }
                    if (m.videoUrl != null && m.hasOwnProperty("videoUrl")) {
                        d.videoUrl = m.videoUrl;
                        if (o.oneofs)
                            d._videoUrl = "videoUrl";
                    }
                    return d;
                };

                AIRichResponseReelItem.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AIRichResponseReelItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem";
                };

                return AIRichResponseReelItem;
            })();

            AIRichResponseContentItemsMetadata.ContentType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "DEFAULT"] = 0;
                values[valuesById[1] = "CAROUSEL"] = 1;
                return values;
            })();

            return AIRichResponseContentItemsMetadata;
        })();

        AIRichResponseMessage.AIRichResponseDynamicMetadata = (function() {

            function AIRichResponseDynamicMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseDynamicMetadata.prototype.type = null;
            AIRichResponseDynamicMetadata.prototype.version = null;
            AIRichResponseDynamicMetadata.prototype.url = null;
            AIRichResponseDynamicMetadata.prototype.loopCount = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_type", {
                get: $util.oneOfGetter($oneOfFields = ["type"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_version", {
                get: $util.oneOfGetter($oneOfFields = ["version"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_url", {
                get: $util.oneOfGetter($oneOfFields = ["url"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_loopCount", {
                get: $util.oneOfGetter($oneOfFields = ["loopCount"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseDynamicMetadata.create = function create(properties) {
                return new AIRichResponseDynamicMetadata(properties);
            };

            AIRichResponseDynamicMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(8).int32(m.type);
                if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                    w.uint32(16).uint64(m.version);
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(26).string(m.url);
                if (m.loopCount != null && Object.hasOwnProperty.call(m, "loopCount"))
                    w.uint32(32).uint32(m.loopCount);
                return w;
            };

            AIRichResponseDynamicMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.type = r.int32();
                            break;
                        }
                    case 2: {
                            m.version = r.uint64();
                            break;
                        }
                    case 3: {
                            m.url = r.string();
                            break;
                        }
                    case 4: {
                            m.loopCount = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseDynamicMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata();
                switch (d.type) {
                default:
                    if (typeof d.type === "number") {
                        m.type = d.type;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN":
                case 0:
                    m.type = 0;
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE":
                case 1:
                    m.type = 1;
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF":
                case 2:
                    m.type = 2;
                    break;
                }
                if (d.version != null) {
                    if ($util.Long)
                        (m.version = $util.Long.fromValue(d.version)).unsigned = true;
                    else if (typeof d.version === "string")
                        m.version = parseInt(d.version, 10);
                    else if (typeof d.version === "number")
                        m.version = d.version;
                    else if (typeof d.version === "object")
                        m.version = new $util.LongBits(d.version.low >>> 0, d.version.high >>> 0).toNumber(true);
                }
                if (d.url != null) {
                    m.url = String(d.url);
                }
                if (d.loopCount != null) {
                    m.loopCount = d.loopCount >>> 0;
                }
                return m;
            };

            AIRichResponseDynamicMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.type != null && m.hasOwnProperty("type")) {
                    d.type = o.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType[m.type] === undefined ? m.type : $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType[m.type] : m.type;
                    if (o.oneofs)
                        d._type = "type";
                }
                if (m.version != null && m.hasOwnProperty("version")) {
                    if (typeof m.version === "number")
                        d.version = o.longs === String ? String(m.version) : m.version;
                    else
                        d.version = o.longs === String ? $util.Long.prototype.toString.call(m.version) : o.longs === Number ? new $util.LongBits(m.version.low >>> 0, m.version.high >>> 0).toNumber(true) : m.version;
                    if (o.oneofs)
                        d._version = "version";
                }
                if (m.url != null && m.hasOwnProperty("url")) {
                    d.url = m.url;
                    if (o.oneofs)
                        d._url = "url";
                }
                if (m.loopCount != null && m.hasOwnProperty("loopCount")) {
                    d.loopCount = m.loopCount;
                    if (o.oneofs)
                        d._loopCount = "loopCount";
                }
                return d;
            };

            AIRichResponseDynamicMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseDynamicMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseDynamicMetadata";
            };

            AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF"] = 2;
                return values;
            })();

            return AIRichResponseDynamicMetadata;
        })();

        AIRichResponseMessage.AIRichResponseGridImageMetadata = (function() {

            function AIRichResponseGridImageMetadata(p) {
                this.imageUrls = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseGridImageMetadata.prototype.gridImageUrl = null;
            AIRichResponseGridImageMetadata.prototype.imageUrls = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseGridImageMetadata.prototype, "_gridImageUrl", {
                get: $util.oneOfGetter($oneOfFields = ["gridImageUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseGridImageMetadata.create = function create(properties) {
                return new AIRichResponseGridImageMetadata(properties);
            };

            AIRichResponseGridImageMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.gridImageUrl != null && Object.hasOwnProperty.call(m, "gridImageUrl"))
                    $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(m.gridImageUrl, w.uint32(10).fork()).ldelim();
                if (m.imageUrls != null && m.imageUrls.length) {
                    for (var i = 0; i < m.imageUrls.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(m.imageUrls[i], w.uint32(18).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseGridImageMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            if (!(m.imageUrls && m.imageUrls.length))
                                m.imageUrls = [];
                            m.imageUrls.push($root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseGridImageMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata();
                if (d.gridImageUrl != null) {
                    if (typeof d.gridImageUrl !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.gridImageUrl: object expected");
                    m.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.fromObject(d.gridImageUrl);
                }
                if (d.imageUrls) {
                    if (!Array.isArray(d.imageUrls))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.imageUrls: array expected");
                    m.imageUrls = [];
                    for (var i = 0; i < d.imageUrls.length; ++i) {
                        if (typeof d.imageUrls[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.imageUrls: object expected");
                        m.imageUrls[i] = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.fromObject(d.imageUrls[i]);
                    }
                }
                return m;
            };

            AIRichResponseGridImageMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.imageUrls = [];
                }
                if (m.gridImageUrl != null && m.hasOwnProperty("gridImageUrl")) {
                    d.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.toObject(m.gridImageUrl, o);
                    if (o.oneofs)
                        d._gridImageUrl = "gridImageUrl";
                }
                if (m.imageUrls && m.imageUrls.length) {
                    d.imageUrls = [];
                    for (var j = 0; j < m.imageUrls.length; ++j) {
                        d.imageUrls[j] = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.toObject(m.imageUrls[j], o);
                    }
                }
                return d;
            };

            AIRichResponseGridImageMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseGridImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseGridImageMetadata";
            };

            return AIRichResponseGridImageMetadata;
        })();

        AIRichResponseMessage.AIRichResponseImageURL = (function() {

            function AIRichResponseImageURL(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseImageURL.prototype.imagePreviewUrl = null;
            AIRichResponseImageURL.prototype.imageHighResUrl = null;
            AIRichResponseImageURL.prototype.sourceUrl = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseImageURL.prototype, "_imagePreviewUrl", {
                get: $util.oneOfGetter($oneOfFields = ["imagePreviewUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseImageURL.prototype, "_imageHighResUrl", {
                get: $util.oneOfGetter($oneOfFields = ["imageHighResUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseImageURL.prototype, "_sourceUrl", {
                get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseImageURL.create = function create(properties) {
                return new AIRichResponseImageURL(properties);
            };

            AIRichResponseImageURL.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.imagePreviewUrl != null && Object.hasOwnProperty.call(m, "imagePreviewUrl"))
                    w.uint32(10).string(m.imagePreviewUrl);
                if (m.imageHighResUrl != null && Object.hasOwnProperty.call(m, "imageHighResUrl"))
                    w.uint32(18).string(m.imageHighResUrl);
                if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                    w.uint32(26).string(m.sourceUrl);
                return w;
            };

            AIRichResponseImageURL.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseImageURL();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.imagePreviewUrl = r.string();
                            break;
                        }
                    case 2: {
                            m.imageHighResUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.sourceUrl = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseImageURL.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseImageURL)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseImageURL();
                if (d.imagePreviewUrl != null) {
                    m.imagePreviewUrl = String(d.imagePreviewUrl);
                }
                if (d.imageHighResUrl != null) {
                    m.imageHighResUrl = String(d.imageHighResUrl);
                }
                if (d.sourceUrl != null) {
                    m.sourceUrl = String(d.sourceUrl);
                }
                return m;
            };

            AIRichResponseImageURL.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.imagePreviewUrl != null && m.hasOwnProperty("imagePreviewUrl")) {
                    d.imagePreviewUrl = m.imagePreviewUrl;
                    if (o.oneofs)
                        d._imagePreviewUrl = "imagePreviewUrl";
                }
                if (m.imageHighResUrl != null && m.hasOwnProperty("imageHighResUrl")) {
                    d.imageHighResUrl = m.imageHighResUrl;
                    if (o.oneofs)
                        d._imageHighResUrl = "imageHighResUrl";
                }
                if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                    d.sourceUrl = m.sourceUrl;
                    if (o.oneofs)
                        d._sourceUrl = "sourceUrl";
                }
                return d;
            };

            AIRichResponseImageURL.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseImageURL.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseImageURL";
            };

            return AIRichResponseImageURL;
        })();

        AIRichResponseMessage.AIRichResponseInlineImageMetadata = (function() {

            function AIRichResponseInlineImageMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseInlineImageMetadata.prototype.imageUrl = null;
            AIRichResponseInlineImageMetadata.prototype.imageText = null;
            AIRichResponseInlineImageMetadata.prototype.alignment = null;
            AIRichResponseInlineImageMetadata.prototype.tapLinkUrl = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_imageUrl", {
                get: $util.oneOfGetter($oneOfFields = ["imageUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_imageText", {
                get: $util.oneOfGetter($oneOfFields = ["imageText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_alignment", {
                get: $util.oneOfGetter($oneOfFields = ["alignment"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_tapLinkUrl", {
                get: $util.oneOfGetter($oneOfFields = ["tapLinkUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseInlineImageMetadata.create = function create(properties) {
                return new AIRichResponseInlineImageMetadata(properties);
            };

            AIRichResponseInlineImageMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.imageUrl != null && Object.hasOwnProperty.call(m, "imageUrl"))
                    $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(m.imageUrl, w.uint32(10).fork()).ldelim();
                if (m.imageText != null && Object.hasOwnProperty.call(m, "imageText"))
                    w.uint32(18).string(m.imageText);
                if (m.alignment != null && Object.hasOwnProperty.call(m, "alignment"))
                    w.uint32(24).int32(m.alignment);
                if (m.tapLinkUrl != null && Object.hasOwnProperty.call(m, "tapLinkUrl"))
                    w.uint32(34).string(m.tapLinkUrl);
                return w;
            };

            AIRichResponseInlineImageMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.imageText = r.string();
                            break;
                        }
                    case 3: {
                            m.alignment = r.int32();
                            break;
                        }
                    case 4: {
                            m.tapLinkUrl = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseInlineImageMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata();
                if (d.imageUrl != null) {
                    if (typeof d.imageUrl !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.imageUrl: object expected");
                    m.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.fromObject(d.imageUrl);
                }
                if (d.imageText != null) {
                    m.imageText = String(d.imageText);
                }
                switch (d.alignment) {
                default:
                    if (typeof d.alignment === "number") {
                        m.alignment = d.alignment;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED":
                case 0:
                    m.alignment = 0;
                    break;
                case "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED":
                case 1:
                    m.alignment = 1;
                    break;
                case "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED":
                case 2:
                    m.alignment = 2;
                    break;
                }
                if (d.tapLinkUrl != null) {
                    m.tapLinkUrl = String(d.tapLinkUrl);
                }
                return m;
            };

            AIRichResponseInlineImageMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.imageUrl != null && m.hasOwnProperty("imageUrl")) {
                    d.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.toObject(m.imageUrl, o);
                    if (o.oneofs)
                        d._imageUrl = "imageUrl";
                }
                if (m.imageText != null && m.hasOwnProperty("imageText")) {
                    d.imageText = m.imageText;
                    if (o.oneofs)
                        d._imageText = "imageText";
                }
                if (m.alignment != null && m.hasOwnProperty("alignment")) {
                    d.alignment = o.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment[m.alignment] === undefined ? m.alignment : $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment[m.alignment] : m.alignment;
                    if (o.oneofs)
                        d._alignment = "alignment";
                }
                if (m.tapLinkUrl != null && m.hasOwnProperty("tapLinkUrl")) {
                    d.tapLinkUrl = m.tapLinkUrl;
                    if (o.oneofs)
                        d._tapLinkUrl = "tapLinkUrl";
                }
                return d;
            };

            AIRichResponseInlineImageMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseInlineImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata";
            };

            AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED"] = 2;
                return values;
            })();

            return AIRichResponseInlineImageMetadata;
        })();

        AIRichResponseMessage.AIRichResponseLatexMetadata = (function() {

            function AIRichResponseLatexMetadata(p) {
                this.expressions = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseLatexMetadata.prototype.text = null;
            AIRichResponseLatexMetadata.prototype.expressions = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexMetadata.prototype, "_text", {
                get: $util.oneOfGetter($oneOfFields = ["text"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseLatexMetadata.create = function create(properties) {
                return new AIRichResponseLatexMetadata(properties);
            };

            AIRichResponseLatexMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.expressions != null && m.expressions.length) {
                    for (var i = 0; i < m.expressions.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.encode(m.expressions[i], w.uint32(18).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseLatexMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.expressions && m.expressions.length))
                                m.expressions = [];
                            m.expressions.push($root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseLatexMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata();
                if (d.text != null) {
                    m.text = String(d.text);
                }
                if (d.expressions) {
                    if (!Array.isArray(d.expressions))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseLatexMetadata.expressions: array expected");
                    m.expressions = [];
                    for (var i = 0; i < d.expressions.length; ++i) {
                        if (typeof d.expressions[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseLatexMetadata.expressions: object expected");
                        m.expressions[i] = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.fromObject(d.expressions[i]);
                    }
                }
                return m;
            };

            AIRichResponseLatexMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.expressions = [];
                }
                if (m.text != null && m.hasOwnProperty("text")) {
                    d.text = m.text;
                    if (o.oneofs)
                        d._text = "text";
                }
                if (m.expressions && m.expressions.length) {
                    d.expressions = [];
                    for (var j = 0; j < m.expressions.length; ++j) {
                        d.expressions[j] = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.toObject(m.expressions[j], o);
                    }
                }
                return d;
            };

            AIRichResponseLatexMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseLatexMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseLatexMetadata";
            };

            AIRichResponseLatexMetadata.AIRichResponseLatexExpression = (function() {

                function AIRichResponseLatexExpression(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseLatexExpression.prototype.latexExpression = null;
                AIRichResponseLatexExpression.prototype.url = null;
                AIRichResponseLatexExpression.prototype.width = null;
                AIRichResponseLatexExpression.prototype.height = null;
                AIRichResponseLatexExpression.prototype.fontHeight = null;
                AIRichResponseLatexExpression.prototype.imageTopPadding = null;
                AIRichResponseLatexExpression.prototype.imageLeadingPadding = null;
                AIRichResponseLatexExpression.prototype.imageBottomPadding = null;
                AIRichResponseLatexExpression.prototype.imageTrailingPadding = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_latexExpression", {
                    get: $util.oneOfGetter($oneOfFields = ["latexExpression"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_url", {
                    get: $util.oneOfGetter($oneOfFields = ["url"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_width", {
                    get: $util.oneOfGetter($oneOfFields = ["width"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_height", {
                    get: $util.oneOfGetter($oneOfFields = ["height"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_fontHeight", {
                    get: $util.oneOfGetter($oneOfFields = ["fontHeight"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageTopPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageTopPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageLeadingPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageLeadingPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageBottomPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageBottomPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageTrailingPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageTrailingPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseLatexExpression.create = function create(properties) {
                    return new AIRichResponseLatexExpression(properties);
                };

                AIRichResponseLatexExpression.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.latexExpression != null && Object.hasOwnProperty.call(m, "latexExpression"))
                        w.uint32(10).string(m.latexExpression);
                    if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                        w.uint32(18).string(m.url);
                    if (m.width != null && Object.hasOwnProperty.call(m, "width"))
                        w.uint32(25).double(m.width);
                    if (m.height != null && Object.hasOwnProperty.call(m, "height"))
                        w.uint32(33).double(m.height);
                    if (m.fontHeight != null && Object.hasOwnProperty.call(m, "fontHeight"))
                        w.uint32(41).double(m.fontHeight);
                    if (m.imageTopPadding != null && Object.hasOwnProperty.call(m, "imageTopPadding"))
                        w.uint32(49).double(m.imageTopPadding);
                    if (m.imageLeadingPadding != null && Object.hasOwnProperty.call(m, "imageLeadingPadding"))
                        w.uint32(57).double(m.imageLeadingPadding);
                    if (m.imageBottomPadding != null && Object.hasOwnProperty.call(m, "imageBottomPadding"))
                        w.uint32(65).double(m.imageBottomPadding);
                    if (m.imageTrailingPadding != null && Object.hasOwnProperty.call(m, "imageTrailingPadding"))
                        w.uint32(73).double(m.imageTrailingPadding);
                    return w;
                };

                AIRichResponseLatexExpression.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.latexExpression = r.string();
                                break;
                            }
                        case 2: {
                                m.url = r.string();
                                break;
                            }
                        case 3: {
                                m.width = r.double();
                                break;
                            }
                        case 4: {
                                m.height = r.double();
                                break;
                            }
                        case 5: {
                                m.fontHeight = r.double();
                                break;
                            }
                        case 6: {
                                m.imageTopPadding = r.double();
                                break;
                            }
                        case 7: {
                                m.imageLeadingPadding = r.double();
                                break;
                            }
                        case 8: {
                                m.imageBottomPadding = r.double();
                                break;
                            }
                        case 9: {
                                m.imageTrailingPadding = r.double();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseLatexExpression.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression)
                        return d;
                    var m = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                    if (d.latexExpression != null) {
                        m.latexExpression = String(d.latexExpression);
                    }
                    if (d.url != null) {
                        m.url = String(d.url);
                    }
                    if (d.width != null) {
                        m.width = Number(d.width);
                    }
                    if (d.height != null) {
                        m.height = Number(d.height);
                    }
                    if (d.fontHeight != null) {
                        m.fontHeight = Number(d.fontHeight);
                    }
                    if (d.imageTopPadding != null) {
                        m.imageTopPadding = Number(d.imageTopPadding);
                    }
                    if (d.imageLeadingPadding != null) {
                        m.imageLeadingPadding = Number(d.imageLeadingPadding);
                    }
                    if (d.imageBottomPadding != null) {
                        m.imageBottomPadding = Number(d.imageBottomPadding);
                    }
                    if (d.imageTrailingPadding != null) {
                        m.imageTrailingPadding = Number(d.imageTrailingPadding);
                    }
                    return m;
                };

                AIRichResponseLatexExpression.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.latexExpression != null && m.hasOwnProperty("latexExpression")) {
                        d.latexExpression = m.latexExpression;
                        if (o.oneofs)
                            d._latexExpression = "latexExpression";
                    }
                    if (m.url != null && m.hasOwnProperty("url")) {
                        d.url = m.url;
                        if (o.oneofs)
                            d._url = "url";
                    }
                    if (m.width != null && m.hasOwnProperty("width")) {
                        d.width = o.json && !isFinite(m.width) ? String(m.width) : m.width;
                        if (o.oneofs)
                            d._width = "width";
                    }
                    if (m.height != null && m.hasOwnProperty("height")) {
                        d.height = o.json && !isFinite(m.height) ? String(m.height) : m.height;
                        if (o.oneofs)
                            d._height = "height";
                    }
                    if (m.fontHeight != null && m.hasOwnProperty("fontHeight")) {
                        d.fontHeight = o.json && !isFinite(m.fontHeight) ? String(m.fontHeight) : m.fontHeight;
                        if (o.oneofs)
                            d._fontHeight = "fontHeight";
                    }
                    if (m.imageTopPadding != null && m.hasOwnProperty("imageTopPadding")) {
                        d.imageTopPadding = o.json && !isFinite(m.imageTopPadding) ? String(m.imageTopPadding) : m.imageTopPadding;
                        if (o.oneofs)
                            d._imageTopPadding = "imageTopPadding";
                    }
                    if (m.imageLeadingPadding != null && m.hasOwnProperty("imageLeadingPadding")) {
                        d.imageLeadingPadding = o.json && !isFinite(m.imageLeadingPadding) ? String(m.imageLeadingPadding) : m.imageLeadingPadding;
                        if (o.oneofs)
                            d._imageLeadingPadding = "imageLeadingPadding";
                    }
                    if (m.imageBottomPadding != null && m.hasOwnProperty("imageBottomPadding")) {
                        d.imageBottomPadding = o.json && !isFinite(m.imageBottomPadding) ? String(m.imageBottomPadding) : m.imageBottomPadding;
                        if (o.oneofs)
                            d._imageBottomPadding = "imageBottomPadding";
                    }
                    if (m.imageTrailingPadding != null && m.hasOwnProperty("imageTrailingPadding")) {
                        d.imageTrailingPadding = o.json && !isFinite(m.imageTrailingPadding) ? String(m.imageTrailingPadding) : m.imageTrailingPadding;
                        if (o.oneofs)
                            d._imageTrailingPadding = "imageTrailingPadding";
                    }
                    return d;
                };

                AIRichResponseLatexExpression.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AIRichResponseLatexExpression.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression";
                };

                return AIRichResponseLatexExpression;
            })();

            return AIRichResponseLatexMetadata;
        })();

        AIRichResponseMessage.AIRichResponseMapMetadata = (function() {

            function AIRichResponseMapMetadata(p) {
                this.annotations = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseMapMetadata.prototype.centerLatitude = null;
            AIRichResponseMapMetadata.prototype.centerLongitude = null;
            AIRichResponseMapMetadata.prototype.latitudeDelta = null;
            AIRichResponseMapMetadata.prototype.longitudeDelta = null;
            AIRichResponseMapMetadata.prototype.annotations = $util.emptyArray;
            AIRichResponseMapMetadata.prototype.showInfoList = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_centerLatitude", {
                get: $util.oneOfGetter($oneOfFields = ["centerLatitude"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_centerLongitude", {
                get: $util.oneOfGetter($oneOfFields = ["centerLongitude"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_latitudeDelta", {
                get: $util.oneOfGetter($oneOfFields = ["latitudeDelta"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_longitudeDelta", {
                get: $util.oneOfGetter($oneOfFields = ["longitudeDelta"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_showInfoList", {
                get: $util.oneOfGetter($oneOfFields = ["showInfoList"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseMapMetadata.create = function create(properties) {
                return new AIRichResponseMapMetadata(properties);
            };

            AIRichResponseMapMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.centerLatitude != null && Object.hasOwnProperty.call(m, "centerLatitude"))
                    w.uint32(9).double(m.centerLatitude);
                if (m.centerLongitude != null && Object.hasOwnProperty.call(m, "centerLongitude"))
                    w.uint32(17).double(m.centerLongitude);
                if (m.latitudeDelta != null && Object.hasOwnProperty.call(m, "latitudeDelta"))
                    w.uint32(25).double(m.latitudeDelta);
                if (m.longitudeDelta != null && Object.hasOwnProperty.call(m, "longitudeDelta"))
                    w.uint32(33).double(m.longitudeDelta);
                if (m.annotations != null && m.annotations.length) {
                    for (var i = 0; i < m.annotations.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.encode(m.annotations[i], w.uint32(42).fork()).ldelim();
                }
                if (m.showInfoList != null && Object.hasOwnProperty.call(m, "showInfoList"))
                    w.uint32(48).bool(m.showInfoList);
                return w;
            };

            AIRichResponseMapMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.centerLatitude = r.double();
                            break;
                        }
                    case 2: {
                            m.centerLongitude = r.double();
                            break;
                        }
                    case 3: {
                            m.latitudeDelta = r.double();
                            break;
                        }
                    case 4: {
                            m.longitudeDelta = r.double();
                            break;
                        }
                    case 5: {
                            if (!(m.annotations && m.annotations.length))
                                m.annotations = [];
                            m.annotations.push($root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.decode(r, r.uint32()));
                            break;
                        }
                    case 6: {
                            m.showInfoList = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseMapMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata();
                if (d.centerLatitude != null) {
                    m.centerLatitude = Number(d.centerLatitude);
                }
                if (d.centerLongitude != null) {
                    m.centerLongitude = Number(d.centerLongitude);
                }
                if (d.latitudeDelta != null) {
                    m.latitudeDelta = Number(d.latitudeDelta);
                }
                if (d.longitudeDelta != null) {
                    m.longitudeDelta = Number(d.longitudeDelta);
                }
                if (d.annotations) {
                    if (!Array.isArray(d.annotations))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseMapMetadata.annotations: array expected");
                    m.annotations = [];
                    for (var i = 0; i < d.annotations.length; ++i) {
                        if (typeof d.annotations[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseMapMetadata.annotations: object expected");
                        m.annotations[i] = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.fromObject(d.annotations[i]);
                    }
                }
                if (d.showInfoList != null) {
                    m.showInfoList = Boolean(d.showInfoList);
                }
                return m;
            };

            AIRichResponseMapMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.annotations = [];
                }
                if (m.centerLatitude != null && m.hasOwnProperty("centerLatitude")) {
                    d.centerLatitude = o.json && !isFinite(m.centerLatitude) ? String(m.centerLatitude) : m.centerLatitude;
                    if (o.oneofs)
                        d._centerLatitude = "centerLatitude";
                }
                if (m.centerLongitude != null && m.hasOwnProperty("centerLongitude")) {
                    d.centerLongitude = o.json && !isFinite(m.centerLongitude) ? String(m.centerLongitude) : m.centerLongitude;
                    if (o.oneofs)
                        d._centerLongitude = "centerLongitude";
                }
                if (m.latitudeDelta != null && m.hasOwnProperty("latitudeDelta")) {
                    d.latitudeDelta = o.json && !isFinite(m.latitudeDelta) ? String(m.latitudeDelta) : m.latitudeDelta;
                    if (o.oneofs)
                        d._latitudeDelta = "latitudeDelta";
                }
                if (m.longitudeDelta != null && m.hasOwnProperty("longitudeDelta")) {
                    d.longitudeDelta = o.json && !isFinite(m.longitudeDelta) ? String(m.longitudeDelta) : m.longitudeDelta;
                    if (o.oneofs)
                        d._longitudeDelta = "longitudeDelta";
                }
                if (m.annotations && m.annotations.length) {
                    d.annotations = [];
                    for (var j = 0; j < m.annotations.length; ++j) {
                        d.annotations[j] = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.toObject(m.annotations[j], o);
                    }
                }
                if (m.showInfoList != null && m.hasOwnProperty("showInfoList")) {
                    d.showInfoList = m.showInfoList;
                    if (o.oneofs)
                        d._showInfoList = "showInfoList";
                }
                return d;
            };

            AIRichResponseMapMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseMapMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseMapMetadata";
            };

            AIRichResponseMapMetadata.AIRichResponseMapAnnotation = (function() {

                function AIRichResponseMapAnnotation(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseMapAnnotation.prototype.annotationNumber = null;
                AIRichResponseMapAnnotation.prototype.latitude = null;
                AIRichResponseMapAnnotation.prototype.longitude = null;
                AIRichResponseMapAnnotation.prototype.title = null;
                AIRichResponseMapAnnotation.prototype.body = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_annotationNumber", {
                    get: $util.oneOfGetter($oneOfFields = ["annotationNumber"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_latitude", {
                    get: $util.oneOfGetter($oneOfFields = ["latitude"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_longitude", {
                    get: $util.oneOfGetter($oneOfFields = ["longitude"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_body", {
                    get: $util.oneOfGetter($oneOfFields = ["body"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseMapAnnotation.create = function create(properties) {
                    return new AIRichResponseMapAnnotation(properties);
                };

                AIRichResponseMapAnnotation.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.annotationNumber != null && Object.hasOwnProperty.call(m, "annotationNumber"))
                        w.uint32(8).uint32(m.annotationNumber);
                    if (m.latitude != null && Object.hasOwnProperty.call(m, "latitude"))
                        w.uint32(17).double(m.latitude);
                    if (m.longitude != null && Object.hasOwnProperty.call(m, "longitude"))
                        w.uint32(25).double(m.longitude);
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(34).string(m.title);
                    if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                        w.uint32(42).string(m.body);
                    return w;
                };

                AIRichResponseMapAnnotation.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.annotationNumber = r.uint32();
                                break;
                            }
                        case 2: {
                                m.latitude = r.double();
                                break;
                            }
                        case 3: {
                                m.longitude = r.double();
                                break;
                            }
                        case 4: {
                                m.title = r.string();
                                break;
                            }
                        case 5: {
                                m.body = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseMapAnnotation.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation)
                        return d;
                    var m = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                    if (d.annotationNumber != null) {
                        m.annotationNumber = d.annotationNumber >>> 0;
                    }
                    if (d.latitude != null) {
                        m.latitude = Number(d.latitude);
                    }
                    if (d.longitude != null) {
                        m.longitude = Number(d.longitude);
                    }
                    if (d.title != null) {
                        m.title = String(d.title);
                    }
                    if (d.body != null) {
                        m.body = String(d.body);
                    }
                    return m;
                };

                AIRichResponseMapAnnotation.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.annotationNumber != null && m.hasOwnProperty("annotationNumber")) {
                        d.annotationNumber = m.annotationNumber;
                        if (o.oneofs)
                            d._annotationNumber = "annotationNumber";
                    }
                    if (m.latitude != null && m.hasOwnProperty("latitude")) {
                        d.latitude = o.json && !isFinite(m.latitude) ? String(m.latitude) : m.latitude;
                        if (o.oneofs)
                            d._latitude = "latitude";
                    }
                    if (m.longitude != null && m.hasOwnProperty("longitude")) {
                        d.longitude = o.json && !isFinite(m.longitude) ? String(m.longitude) : m.longitude;
                        if (o.oneofs)
                            d._longitude = "longitude";
                    }
                    if (m.title != null && m.hasOwnProperty("title")) {
                        d.title = m.title;
                        if (o.oneofs)
                            d._title = "title";
                    }
                    if (m.body != null && m.hasOwnProperty("body")) {
                        d.body = m.body;
                        if (o.oneofs)
                            d._body = "body";
                    }
                    return d;
                };

                AIRichResponseMapAnnotation.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AIRichResponseMapAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation";
                };

                return AIRichResponseMapAnnotation;
            })();

            return AIRichResponseMapMetadata;
        })();

        AIRichResponseMessage.AIRichResponseMessageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_TYPE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_TYPE_STANDARD"] = 1;
            return values;
        })();

        AIRichResponseMessage.AIRichResponseSubMessage = (function() {

            function AIRichResponseSubMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseSubMessage.prototype.messageType = null;
            AIRichResponseSubMessage.prototype.gridImageMetadata = null;
            AIRichResponseSubMessage.prototype.messageText = null;
            AIRichResponseSubMessage.prototype.imageMetadata = null;
            AIRichResponseSubMessage.prototype.codeMetadata = null;
            AIRichResponseSubMessage.prototype.tableMetadata = null;
            AIRichResponseSubMessage.prototype.dynamicMetadata = null;
            AIRichResponseSubMessage.prototype.latexMetadata = null;
            AIRichResponseSubMessage.prototype.mapMetadata = null;
            AIRichResponseSubMessage.prototype.contentItemsMetadata = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_messageType", {
                get: $util.oneOfGetter($oneOfFields = ["messageType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_gridImageMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["gridImageMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_messageText", {
                get: $util.oneOfGetter($oneOfFields = ["messageText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_imageMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["imageMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_codeMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["codeMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_tableMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["tableMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_dynamicMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["dynamicMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_latexMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["latexMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_mapMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["mapMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_contentItemsMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["contentItemsMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseSubMessage.create = function create(properties) {
                return new AIRichResponseSubMessage(properties);
            };

            AIRichResponseSubMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.messageType != null && Object.hasOwnProperty.call(m, "messageType"))
                    w.uint32(8).int32(m.messageType);
                if (m.gridImageMetadata != null && Object.hasOwnProperty.call(m, "gridImageMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.encode(m.gridImageMetadata, w.uint32(18).fork()).ldelim();
                if (m.messageText != null && Object.hasOwnProperty.call(m, "messageText"))
                    w.uint32(26).string(m.messageText);
                if (m.imageMetadata != null && Object.hasOwnProperty.call(m, "imageMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.encode(m.imageMetadata, w.uint32(34).fork()).ldelim();
                if (m.codeMetadata != null && Object.hasOwnProperty.call(m, "codeMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.encode(m.codeMetadata, w.uint32(42).fork()).ldelim();
                if (m.tableMetadata != null && Object.hasOwnProperty.call(m, "tableMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.encode(m.tableMetadata, w.uint32(50).fork()).ldelim();
                if (m.dynamicMetadata != null && Object.hasOwnProperty.call(m, "dynamicMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.encode(m.dynamicMetadata, w.uint32(58).fork()).ldelim();
                if (m.latexMetadata != null && Object.hasOwnProperty.call(m, "latexMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.encode(m.latexMetadata, w.uint32(66).fork()).ldelim();
                if (m.mapMetadata != null && Object.hasOwnProperty.call(m, "mapMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.encode(m.mapMetadata, w.uint32(74).fork()).ldelim();
                if (m.contentItemsMetadata != null && Object.hasOwnProperty.call(m, "contentItemsMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.encode(m.contentItemsMetadata, w.uint32(82).fork()).ldelim();
                return w;
            };

            AIRichResponseSubMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseSubMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.messageType = r.int32();
                            break;
                        }
                    case 2: {
                            m.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.messageText = r.string();
                            break;
                        }
                    case 4: {
                            m.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 6: {
                            m.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 7: {
                            m.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 8: {
                            m.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 9: {
                            m.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 10: {
                            m.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseSubMessage.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseSubMessage)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseSubMessage();
                switch (d.messageType) {
                default:
                    if (typeof d.messageType === "number") {
                        m.messageType = d.messageType;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_UNKNOWN":
                case 0:
                    m.messageType = 0;
                    break;
                case "AI_RICH_RESPONSE_GRID_IMAGE":
                case 1:
                    m.messageType = 1;
                    break;
                case "AI_RICH_RESPONSE_TEXT":
                case 2:
                    m.messageType = 2;
                    break;
                case "AI_RICH_RESPONSE_INLINE_IMAGE":
                case 3:
                    m.messageType = 3;
                    break;
                case "AI_RICH_RESPONSE_TABLE":
                case 4:
                    m.messageType = 4;
                    break;
                case "AI_RICH_RESPONSE_CODE":
                case 5:
                    m.messageType = 5;
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC":
                case 6:
                    m.messageType = 6;
                    break;
                case "AI_RICH_RESPONSE_MAP":
                case 7:
                    m.messageType = 7;
                    break;
                case "AI_RICH_RESPONSE_LATEX":
                case 8:
                    m.messageType = 8;
                    break;
                case "AI_RICH_RESPONSE_CONTENT_ITEMS":
                case 9:
                    m.messageType = 9;
                    break;
                }
                if (d.gridImageMetadata != null) {
                    if (typeof d.gridImageMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.gridImageMetadata: object expected");
                    m.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.fromObject(d.gridImageMetadata);
                }
                if (d.messageText != null) {
                    m.messageText = String(d.messageText);
                }
                if (d.imageMetadata != null) {
                    if (typeof d.imageMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.imageMetadata: object expected");
                    m.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.fromObject(d.imageMetadata);
                }
                if (d.codeMetadata != null) {
                    if (typeof d.codeMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.codeMetadata: object expected");
                    m.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.fromObject(d.codeMetadata);
                }
                if (d.tableMetadata != null) {
                    if (typeof d.tableMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.tableMetadata: object expected");
                    m.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.fromObject(d.tableMetadata);
                }
                if (d.dynamicMetadata != null) {
                    if (typeof d.dynamicMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.dynamicMetadata: object expected");
                    m.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.fromObject(d.dynamicMetadata);
                }
                if (d.latexMetadata != null) {
                    if (typeof d.latexMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.latexMetadata: object expected");
                    m.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.fromObject(d.latexMetadata);
                }
                if (d.mapMetadata != null) {
                    if (typeof d.mapMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.mapMetadata: object expected");
                    m.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.fromObject(d.mapMetadata);
                }
                if (d.contentItemsMetadata != null) {
                    if (typeof d.contentItemsMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.contentItemsMetadata: object expected");
                    m.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.fromObject(d.contentItemsMetadata);
                }
                return m;
            };

            AIRichResponseSubMessage.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.messageType != null && m.hasOwnProperty("messageType")) {
                    d.messageType = o.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseSubMessageType[m.messageType] === undefined ? m.messageType : $root.proto.AIRichResponseMessage.AIRichResponseSubMessageType[m.messageType] : m.messageType;
                    if (o.oneofs)
                        d._messageType = "messageType";
                }
                if (m.gridImageMetadata != null && m.hasOwnProperty("gridImageMetadata")) {
                    d.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.toObject(m.gridImageMetadata, o);
                    if (o.oneofs)
                        d._gridImageMetadata = "gridImageMetadata";
                }
                if (m.messageText != null && m.hasOwnProperty("messageText")) {
                    d.messageText = m.messageText;
                    if (o.oneofs)
                        d._messageText = "messageText";
                }
                if (m.imageMetadata != null && m.hasOwnProperty("imageMetadata")) {
                    d.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.toObject(m.imageMetadata, o);
                    if (o.oneofs)
                        d._imageMetadata = "imageMetadata";
                }
                if (m.codeMetadata != null && m.hasOwnProperty("codeMetadata")) {
                    d.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.toObject(m.codeMetadata, o);
                    if (o.oneofs)
                        d._codeMetadata = "codeMetadata";
                }
                if (m.tableMetadata != null && m.hasOwnProperty("tableMetadata")) {
                    d.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.toObject(m.tableMetadata, o);
                    if (o.oneofs)
                        d._tableMetadata = "tableMetadata";
                }
                if (m.dynamicMetadata != null && m.hasOwnProperty("dynamicMetadata")) {
                    d.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.toObject(m.dynamicMetadata, o);
                    if (o.oneofs)
                        d._dynamicMetadata = "dynamicMetadata";
                }
                if (m.latexMetadata != null && m.hasOwnProperty("latexMetadata")) {
                    d.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.toObject(m.latexMetadata, o);
                    if (o.oneofs)
                        d._latexMetadata = "latexMetadata";
                }
                if (m.mapMetadata != null && m.hasOwnProperty("mapMetadata")) {
                    d.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.toObject(m.mapMetadata, o);
                    if (o.oneofs)
                        d._mapMetadata = "mapMetadata";
                }
                if (m.contentItemsMetadata != null && m.hasOwnProperty("contentItemsMetadata")) {
                    d.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.toObject(m.contentItemsMetadata, o);
                    if (o.oneofs)
                        d._contentItemsMetadata = "contentItemsMetadata";
                }
                return d;
            };

            AIRichResponseSubMessage.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseSubMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseSubMessage";
            };

            return AIRichResponseSubMessage;
        })();

        AIRichResponseMessage.AIRichResponseSubMessageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_GRID_IMAGE"] = 1;
            values[valuesById[2] = "AI_RICH_RESPONSE_TEXT"] = 2;
            values[valuesById[3] = "AI_RICH_RESPONSE_INLINE_IMAGE"] = 3;
            values[valuesById[4] = "AI_RICH_RESPONSE_TABLE"] = 4;
            values[valuesById[5] = "AI_RICH_RESPONSE_CODE"] = 5;
            values[valuesById[6] = "AI_RICH_RESPONSE_DYNAMIC"] = 6;
            values[valuesById[7] = "AI_RICH_RESPONSE_MAP"] = 7;
            values[valuesById[8] = "AI_RICH_RESPONSE_LATEX"] = 8;
            values[valuesById[9] = "AI_RICH_RESPONSE_CONTENT_ITEMS"] = 9;
            return values;
        })();

        AIRichResponseMessage.AIRichResponseTableMetadata = (function() {

            function AIRichResponseTableMetadata(p) {
                this.rows = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseTableMetadata.prototype.rows = $util.emptyArray;

            AIRichResponseTableMetadata.create = function create(properties) {
                return new AIRichResponseTableMetadata(properties);
            };

            AIRichResponseTableMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.rows != null && m.rows.length) {
                    for (var i = 0; i < m.rows.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.encode(m.rows[i], w.uint32(10).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseTableMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.rows && m.rows.length))
                                m.rows = [];
                            m.rows.push($root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseTableMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata();
                if (d.rows) {
                    if (!Array.isArray(d.rows))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseTableMetadata.rows: array expected");
                    m.rows = [];
                    for (var i = 0; i < d.rows.length; ++i) {
                        if (typeof d.rows[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseTableMetadata.rows: object expected");
                        m.rows[i] = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.fromObject(d.rows[i]);
                    }
                }
                return m;
            };

            AIRichResponseTableMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.rows = [];
                }
                if (m.rows && m.rows.length) {
                    d.rows = [];
                    for (var j = 0; j < m.rows.length; ++j) {
                        d.rows[j] = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.toObject(m.rows[j], o);
                    }
                }
                return d;
            };

            AIRichResponseTableMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseTableMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseTableMetadata";
            };

            AIRichResponseTableMetadata.AIRichResponseTableRow = (function() {

                function AIRichResponseTableRow(p) {
                    this.items = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseTableRow.prototype.items = $util.emptyArray;
                AIRichResponseTableRow.prototype.isHeading = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseTableRow.prototype, "_isHeading", {
                    get: $util.oneOfGetter($oneOfFields = ["isHeading"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseTableRow.create = function create(properties) {
                    return new AIRichResponseTableRow(properties);
                };

                AIRichResponseTableRow.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.items != null && m.items.length) {
                        for (var i = 0; i < m.items.length; ++i)
                            w.uint32(10).string(m.items[i]);
                    }
                    if (m.isHeading != null && Object.hasOwnProperty.call(m, "isHeading"))
                        w.uint32(16).bool(m.isHeading);
                    return w;
                };

                AIRichResponseTableRow.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                if (!(m.items && m.items.length))
                                    m.items = [];
                                m.items.push(r.string());
                                break;
                            }
                        case 2: {
                                m.isHeading = r.bool();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseTableRow.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow)
                        return d;
                    var m = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow();
                    if (d.items) {
                        if (!Array.isArray(d.items))
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.items: array expected");
                        m.items = [];
                        for (var i = 0; i < d.items.length; ++i) {
                            m.items[i] = String(d.items[i]);
                        }
                    }
                    if (d.isHeading != null) {
                        m.isHeading = Boolean(d.isHeading);
                    }
                    return m;
                };

                AIRichResponseTableRow.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (o.arrays || o.defaults) {
                        d.items = [];
                    }
                    if (m.items && m.items.length) {
                        d.items = [];
                        for (var j = 0; j < m.items.length; ++j) {
                            d.items[j] = m.items[j];
                        }
                    }
                    if (m.isHeading != null && m.hasOwnProperty("isHeading")) {
                        d.isHeading = m.isHeading;
                        if (o.oneofs)
                            d._isHeading = "isHeading";
                    }
                    return d;
                };

                AIRichResponseTableRow.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AIRichResponseTableRow.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow";
                };

                return AIRichResponseTableRow;
            })();

            return AIRichResponseTableMetadata;
        })();

        AIRichResponseMessage.AIRichResponseUnifiedResponse = (function() {

            function AIRichResponseUnifiedResponse(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseUnifiedResponse.prototype.data = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseUnifiedResponse.prototype, "_data", {
                get: $util.oneOfGetter($oneOfFields = ["data"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AIRichResponseUnifiedResponse.create = function create(properties) {
                return new AIRichResponseUnifiedResponse(properties);
            };

            AIRichResponseUnifiedResponse.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.data != null && Object.hasOwnProperty.call(m, "data"))
                    w.uint32(10).bytes(m.data);
                return w;
            };

            AIRichResponseUnifiedResponse.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.data = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseUnifiedResponse.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse)
                    return d;
                var m = new $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse();
                if (d.data != null) {
                    if (typeof d.data === "string")
                        $util.base64.decode(d.data, m.data = $util.newBuffer($util.base64.length(d.data)), 0);
                    else if (d.data.length >= 0)
                        m.data = d.data;
                }
                return m;
            };

            AIRichResponseUnifiedResponse.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.data != null && m.hasOwnProperty("data")) {
                    d.data = o.bytes === String ? $util.base64.encode(m.data, 0, m.data.length) : o.bytes === Array ? Array.prototype.slice.call(m.data) : m.data;
                    if (o.oneofs)
                        d._data = "data";
                }
                return d;
            };

            AIRichResponseUnifiedResponse.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AIRichResponseUnifiedResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseUnifiedResponse";
            };

            return AIRichResponseUnifiedResponse;
        })();

        return AIRichResponseMessage;
    })();

    proto.Account = (function() {

        function Account(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Account.prototype.lid = null;
        Account.prototype.username = null;
        Account.prototype.countryCode = null;
        Account.prototype.isUsernameDeleted = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_lid", {
            get: $util.oneOfGetter($oneOfFields = ["lid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_username", {
            get: $util.oneOfGetter($oneOfFields = ["username"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_countryCode", {
            get: $util.oneOfGetter($oneOfFields = ["countryCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_isUsernameDeleted", {
            get: $util.oneOfGetter($oneOfFields = ["isUsernameDeleted"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        Account.create = function create(properties) {
            return new Account(properties);
        };

        Account.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.lid != null && Object.hasOwnProperty.call(m, "lid"))
                w.uint32(10).string(m.lid);
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(18).string(m.username);
            if (m.countryCode != null && Object.hasOwnProperty.call(m, "countryCode"))
                w.uint32(26).string(m.countryCode);
            if (m.isUsernameDeleted != null && Object.hasOwnProperty.call(m, "isUsernameDeleted"))
                w.uint32(32).bool(m.isUsernameDeleted);
            return w;
        };

        Account.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Account();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.lid = r.string();
                        break;
                    }
                case 2: {
                        m.username = r.string();
                        break;
                    }
                case 3: {
                        m.countryCode = r.string();
                        break;
                    }
                case 4: {
                        m.isUsernameDeleted = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Account.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Account)
                return d;
            var m = new $root.proto.Account();
            if (d.lid != null) {
                m.lid = String(d.lid);
            }
            if (d.username != null) {
                m.username = String(d.username);
            }
            if (d.countryCode != null) {
                m.countryCode = String(d.countryCode);
            }
            if (d.isUsernameDeleted != null) {
                m.isUsernameDeleted = Boolean(d.isUsernameDeleted);
            }
            return m;
        };

        Account.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.lid != null && m.hasOwnProperty("lid")) {
                d.lid = m.lid;
                if (o.oneofs)
                    d._lid = "lid";
            }
            if (m.username != null && m.hasOwnProperty("username")) {
                d.username = m.username;
                if (o.oneofs)
                    d._username = "username";
            }
            if (m.countryCode != null && m.hasOwnProperty("countryCode")) {
                d.countryCode = m.countryCode;
                if (o.oneofs)
                    d._countryCode = "countryCode";
            }
            if (m.isUsernameDeleted != null && m.hasOwnProperty("isUsernameDeleted")) {
                d.isUsernameDeleted = m.isUsernameDeleted;
                if (o.oneofs)
                    d._isUsernameDeleted = "isUsernameDeleted";
            }
            return d;
        };

        Account.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Account.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Account";
        };

        return Account;
    })();

    proto.ActionLink = (function() {

        function ActionLink(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ActionLink.prototype.url = null;
        ActionLink.prototype.buttonTitle = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ActionLink.prototype, "_url", {
            get: $util.oneOfGetter($oneOfFields = ["url"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ActionLink.prototype, "_buttonTitle", {
            get: $util.oneOfGetter($oneOfFields = ["buttonTitle"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        ActionLink.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                w.uint32(10).string(m.url);
            if (m.buttonTitle != null && Object.hasOwnProperty.call(m, "buttonTitle"))
                w.uint32(18).string(m.buttonTitle);
            return w;
        };

        ActionLink.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ActionLink();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.url = r.string();
                        break;
                    }
                case 2: {
                        m.buttonTitle = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ActionLink.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ActionLink)
                return d;
            var m = new $root.proto.ActionLink();
            if (d.url != null) {
                m.url = String(d.url);
            }
            if (d.buttonTitle != null) {
                m.buttonTitle = String(d.buttonTitle);
            }
            return m;
        };

        ActionLink.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.url != null && m.hasOwnProperty("url")) {
                d.url = m.url;
                if (o.oneofs)
                    d._url = "url";
            }
            if (m.buttonTitle != null && m.hasOwnProperty("buttonTitle")) {
                d.buttonTitle = m.buttonTitle;
                if (o.oneofs)
                    d._buttonTitle = "buttonTitle";
            }
            return d;
        };

        ActionLink.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ActionLink.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ActionLink";
        };

        return ActionLink;
    })();

    proto.AutoDownloadSettings = (function() {

        function AutoDownloadSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AutoDownloadSettings.prototype.downloadImages = null;
        AutoDownloadSettings.prototype.downloadAudio = null;
        AutoDownloadSettings.prototype.downloadVideo = null;
        AutoDownloadSettings.prototype.downloadDocuments = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadImages", {
            get: $util.oneOfGetter($oneOfFields = ["downloadImages"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadAudio", {
            get: $util.oneOfGetter($oneOfFields = ["downloadAudio"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadVideo", {
            get: $util.oneOfGetter($oneOfFields = ["downloadVideo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadDocuments", {
            get: $util.oneOfGetter($oneOfFields = ["downloadDocuments"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AutoDownloadSettings.create = function create(properties) {
            return new AutoDownloadSettings(properties);
        };

        AutoDownloadSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.downloadImages != null && Object.hasOwnProperty.call(m, "downloadImages"))
                w.uint32(8).bool(m.downloadImages);
            if (m.downloadAudio != null && Object.hasOwnProperty.call(m, "downloadAudio"))
                w.uint32(16).bool(m.downloadAudio);
            if (m.downloadVideo != null && Object.hasOwnProperty.call(m, "downloadVideo"))
                w.uint32(24).bool(m.downloadVideo);
            if (m.downloadDocuments != null && Object.hasOwnProperty.call(m, "downloadDocuments"))
                w.uint32(32).bool(m.downloadDocuments);
            return w;
        };

        AutoDownloadSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AutoDownloadSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.downloadImages = r.bool();
                        break;
                    }
                case 2: {
                        m.downloadAudio = r.bool();
                        break;
                    }
                case 3: {
                        m.downloadVideo = r.bool();
                        break;
                    }
                case 4: {
                        m.downloadDocuments = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AutoDownloadSettings.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AutoDownloadSettings)
                return d;
            var m = new $root.proto.AutoDownloadSettings();
            if (d.downloadImages != null) {
                m.downloadImages = Boolean(d.downloadImages);
            }
            if (d.downloadAudio != null) {
                m.downloadAudio = Boolean(d.downloadAudio);
            }
            if (d.downloadVideo != null) {
                m.downloadVideo = Boolean(d.downloadVideo);
            }
            if (d.downloadDocuments != null) {
                m.downloadDocuments = Boolean(d.downloadDocuments);
            }
            return m;
        };

        AutoDownloadSettings.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.downloadImages != null && m.hasOwnProperty("downloadImages")) {
                d.downloadImages = m.downloadImages;
                if (o.oneofs)
                    d._downloadImages = "downloadImages";
            }
            if (m.downloadAudio != null && m.hasOwnProperty("downloadAudio")) {
                d.downloadAudio = m.downloadAudio;
                if (o.oneofs)
                    d._downloadAudio = "downloadAudio";
            }
            if (m.downloadVideo != null && m.hasOwnProperty("downloadVideo")) {
                d.downloadVideo = m.downloadVideo;
                if (o.oneofs)
                    d._downloadVideo = "downloadVideo";
            }
            if (m.downloadDocuments != null && m.hasOwnProperty("downloadDocuments")) {
                d.downloadDocuments = m.downloadDocuments;
                if (o.oneofs)
                    d._downloadDocuments = "downloadDocuments";
            }
            return d;
        };

        AutoDownloadSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AutoDownloadSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AutoDownloadSettings";
        };

        return AutoDownloadSettings;
    })();

    proto.AvatarUserSettings = (function() {

        function AvatarUserSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AvatarUserSettings.prototype.fbid = null;
        AvatarUserSettings.prototype.password = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AvatarUserSettings.prototype, "_fbid", {
            get: $util.oneOfGetter($oneOfFields = ["fbid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AvatarUserSettings.prototype, "_password", {
            get: $util.oneOfGetter($oneOfFields = ["password"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        AvatarUserSettings.create = function create(properties) {
            return new AvatarUserSettings(properties);
        };

        AvatarUserSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fbid != null && Object.hasOwnProperty.call(m, "fbid"))
                w.uint32(10).string(m.fbid);
            if (m.password != null && Object.hasOwnProperty.call(m, "password"))
                w.uint32(18).string(m.password);
            return w;
        };

        AvatarUserSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AvatarUserSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fbid = r.string();
                        break;
                    }
                case 2: {
                        m.password = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AvatarUserSettings.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.AvatarUserSettings)
                return d;
            var m = new $root.proto.AvatarUserSettings();
            if (d.fbid != null) {
                m.fbid = String(d.fbid);
            }
            if (d.password != null) {
                m.password = String(d.password);
            }
            return m;
        };

        AvatarUserSettings.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.fbid != null && m.hasOwnProperty("fbid")) {
                d.fbid = m.fbid;
                if (o.oneofs)
                    d._fbid = "fbid";
            }
            if (m.password != null && m.hasOwnProperty("password")) {
                d.password = m.password;
                if (o.oneofs)
                    d._password = "password";
            }
            return d;
        };

        AvatarUserSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        AvatarUserSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AvatarUserSettings";
        };

        return AvatarUserSettings;
    })();

    proto.BizAccountLinkInfo = (function() {

        function BizAccountLinkInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = null;
        BizAccountLinkInfo.prototype.whatsappAcctNumber = null;
        BizAccountLinkInfo.prototype.issueTime = null;
        BizAccountLinkInfo.prototype.hostStorage = null;
        BizAccountLinkInfo.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_whatsappBizAcctFbid", {
            get: $util.oneOfGetter($oneOfFields = ["whatsappBizAcctFbid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_whatsappAcctNumber", {
            get: $util.oneOfGetter($oneOfFields = ["whatsappAcctNumber"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_issueTime", {
            get: $util.oneOfGetter($oneOfFields = ["issueTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_hostStorage", {
            get: $util.oneOfGetter($oneOfFields = ["hostStorage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        BizAccountLinkInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(m, "whatsappBizAcctFbid"))
                w.uint32(8).uint64(m.whatsappBizAcctFbid);
            if (m.whatsappAcctNumber != null && Object.hasOwnProperty.call(m, "whatsappAcctNumber"))
                w.uint32(18).string(m.whatsappAcctNumber);
            if (m.issueTime != null && Object.hasOwnProperty.call(m, "issueTime"))
                w.uint32(24).uint64(m.issueTime);
            if (m.hostStorage != null && Object.hasOwnProperty.call(m, "hostStorage"))
                w.uint32(32).int32(m.hostStorage);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(40).int32(m.accountType);
            return w;
        };

        BizAccountLinkInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizAccountLinkInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.whatsappBizAcctFbid = r.uint64();
                        break;
                    }
                case 2: {
                        m.whatsappAcctNumber = r.string();
                        break;
                    }
                case 3: {
                        m.issueTime = r.uint64();
                        break;
                    }
                case 4: {
                        m.hostStorage = r.int32();
                        break;
                    }
                case 5: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizAccountLinkInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BizAccountLinkInfo)
                return d;
            var m = new $root.proto.BizAccountLinkInfo();
            if (d.whatsappBizAcctFbid != null) {
                if ($util.Long)
                    (m.whatsappBizAcctFbid = $util.Long.fromValue(d.whatsappBizAcctFbid)).unsigned = true;
                else if (typeof d.whatsappBizAcctFbid === "string")
                    m.whatsappBizAcctFbid = parseInt(d.whatsappBizAcctFbid, 10);
                else if (typeof d.whatsappBizAcctFbid === "number")
                    m.whatsappBizAcctFbid = d.whatsappBizAcctFbid;
                else if (typeof d.whatsappBizAcctFbid === "object")
                    m.whatsappBizAcctFbid = new $util.LongBits(d.whatsappBizAcctFbid.low >>> 0, d.whatsappBizAcctFbid.high >>> 0).toNumber(true);
            }
            if (d.whatsappAcctNumber != null) {
                m.whatsappAcctNumber = String(d.whatsappAcctNumber);
            }
            if (d.issueTime != null) {
                if ($util.Long)
                    (m.issueTime = $util.Long.fromValue(d.issueTime)).unsigned = true;
                else if (typeof d.issueTime === "string")
                    m.issueTime = parseInt(d.issueTime, 10);
                else if (typeof d.issueTime === "number")
                    m.issueTime = d.issueTime;
                else if (typeof d.issueTime === "object")
                    m.issueTime = new $util.LongBits(d.issueTime.low >>> 0, d.issueTime.high >>> 0).toNumber(true);
            }
            switch (d.hostStorage) {
            default:
                if (typeof d.hostStorage === "number") {
                    m.hostStorage = d.hostStorage;
                    break;
                }
                break;
            case "ON_PREMISE":
            case 0:
                m.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                m.hostStorage = 1;
                break;
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "ENTERPRISE":
            case 0:
                m.accountType = 0;
                break;
            }
            return m;
        };

        BizAccountLinkInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.whatsappBizAcctFbid != null && m.hasOwnProperty("whatsappBizAcctFbid")) {
                if (typeof m.whatsappBizAcctFbid === "number")
                    d.whatsappBizAcctFbid = o.longs === String ? String(m.whatsappBizAcctFbid) : m.whatsappBizAcctFbid;
                else
                    d.whatsappBizAcctFbid = o.longs === String ? $util.Long.prototype.toString.call(m.whatsappBizAcctFbid) : o.longs === Number ? new $util.LongBits(m.whatsappBizAcctFbid.low >>> 0, m.whatsappBizAcctFbid.high >>> 0).toNumber(true) : m.whatsappBizAcctFbid;
                if (o.oneofs)
                    d._whatsappBizAcctFbid = "whatsappBizAcctFbid";
            }
            if (m.whatsappAcctNumber != null && m.hasOwnProperty("whatsappAcctNumber")) {
                d.whatsappAcctNumber = m.whatsappAcctNumber;
                if (o.oneofs)
                    d._whatsappAcctNumber = "whatsappAcctNumber";
            }
            if (m.issueTime != null && m.hasOwnProperty("issueTime")) {
                if (typeof m.issueTime === "number")
                    d.issueTime = o.longs === String ? String(m.issueTime) : m.issueTime;
                else
                    d.issueTime = o.longs === String ? $util.Long.prototype.toString.call(m.issueTime) : o.longs === Number ? new $util.LongBits(m.issueTime.low >>> 0, m.issueTime.high >>> 0).toNumber(true) : m.issueTime;
                if (o.oneofs)
                    d._issueTime = "issueTime";
            }
            if (m.hostStorage != null && m.hasOwnProperty("hostStorage")) {
                d.hostStorage = o.enums === String ? $root.proto.BizAccountLinkInfo.HostStorageType[m.hostStorage] === undefined ? m.hostStorage : $root.proto.BizAccountLinkInfo.HostStorageType[m.hostStorage] : m.hostStorage;
                if (o.oneofs)
                    d._hostStorage = "hostStorage";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.BizAccountLinkInfo.AccountType[m.accountType] === undefined ? m.accountType : $root.proto.BizAccountLinkInfo.AccountType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        BizAccountLinkInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BizAccountLinkInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountLinkInfo";
        };

        BizAccountLinkInfo.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        BizAccountLinkInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        function BizAccountPayload(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizAccountPayload.prototype.vnameCert = null;
        BizAccountPayload.prototype.bizAcctLinkInfo = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountPayload.prototype, "_vnameCert", {
            get: $util.oneOfGetter($oneOfFields = ["vnameCert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountPayload.prototype, "_bizAcctLinkInfo", {
            get: $util.oneOfGetter($oneOfFields = ["bizAcctLinkInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        BizAccountPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.vnameCert != null && Object.hasOwnProperty.call(m, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(m.vnameCert, w.uint32(10).fork()).ldelim();
            if (m.bizAcctLinkInfo != null && Object.hasOwnProperty.call(m, "bizAcctLinkInfo"))
                w.uint32(18).bytes(m.bizAcctLinkInfo);
            return w;
        };

        BizAccountPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizAccountPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.vnameCert = $root.proto.VerifiedNameCertificate.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.bizAcctLinkInfo = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizAccountPayload.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BizAccountPayload)
                return d;
            var m = new $root.proto.BizAccountPayload();
            if (d.vnameCert != null) {
                if (typeof d.vnameCert !== "object")
                    throw TypeError(".proto.BizAccountPayload.vnameCert: object expected");
                m.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(d.vnameCert);
            }
            if (d.bizAcctLinkInfo != null) {
                if (typeof d.bizAcctLinkInfo === "string")
                    $util.base64.decode(d.bizAcctLinkInfo, m.bizAcctLinkInfo = $util.newBuffer($util.base64.length(d.bizAcctLinkInfo)), 0);
                else if (d.bizAcctLinkInfo.length >= 0)
                    m.bizAcctLinkInfo = d.bizAcctLinkInfo;
            }
            return m;
        };

        BizAccountPayload.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.vnameCert != null && m.hasOwnProperty("vnameCert")) {
                d.vnameCert = $root.proto.VerifiedNameCertificate.toObject(m.vnameCert, o);
                if (o.oneofs)
                    d._vnameCert = "vnameCert";
            }
            if (m.bizAcctLinkInfo != null && m.hasOwnProperty("bizAcctLinkInfo")) {
                d.bizAcctLinkInfo = o.bytes === String ? $util.base64.encode(m.bizAcctLinkInfo, 0, m.bizAcctLinkInfo.length) : o.bytes === Array ? Array.prototype.slice.call(m.bizAcctLinkInfo) : m.bizAcctLinkInfo;
                if (o.oneofs)
                    d._bizAcctLinkInfo = "bizAcctLinkInfo";
            }
            return d;
        };

        BizAccountPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BizAccountPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountPayload";
        };

        return BizAccountPayload;
    })();

    proto.BizIdentityInfo = (function() {

        function BizIdentityInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizIdentityInfo.prototype.vlevel = null;
        BizIdentityInfo.prototype.vnameCert = null;
        BizIdentityInfo.prototype.signed = null;
        BizIdentityInfo.prototype.revoked = null;
        BizIdentityInfo.prototype.hostStorage = null;
        BizIdentityInfo.prototype.actualActors = null;
        BizIdentityInfo.prototype.privacyModeTs = null;
        BizIdentityInfo.prototype.featureControls = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_vlevel", {
            get: $util.oneOfGetter($oneOfFields = ["vlevel"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_vnameCert", {
            get: $util.oneOfGetter($oneOfFields = ["vnameCert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_signed", {
            get: $util.oneOfGetter($oneOfFields = ["signed"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_revoked", {
            get: $util.oneOfGetter($oneOfFields = ["revoked"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_hostStorage", {
            get: $util.oneOfGetter($oneOfFields = ["hostStorage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_actualActors", {
            get: $util.oneOfGetter($oneOfFields = ["actualActors"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_privacyModeTs", {
            get: $util.oneOfGetter($oneOfFields = ["privacyModeTs"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_featureControls", {
            get: $util.oneOfGetter($oneOfFields = ["featureControls"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        BizIdentityInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.vlevel != null && Object.hasOwnProperty.call(m, "vlevel"))
                w.uint32(8).int32(m.vlevel);
            if (m.vnameCert != null && Object.hasOwnProperty.call(m, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(m.vnameCert, w.uint32(18).fork()).ldelim();
            if (m.signed != null && Object.hasOwnProperty.call(m, "signed"))
                w.uint32(24).bool(m.signed);
            if (m.revoked != null && Object.hasOwnProperty.call(m, "revoked"))
                w.uint32(32).bool(m.revoked);
            if (m.hostStorage != null && Object.hasOwnProperty.call(m, "hostStorage"))
                w.uint32(40).int32(m.hostStorage);
            if (m.actualActors != null && Object.hasOwnProperty.call(m, "actualActors"))
                w.uint32(48).int32(m.actualActors);
            if (m.privacyModeTs != null && Object.hasOwnProperty.call(m, "privacyModeTs"))
                w.uint32(56).uint64(m.privacyModeTs);
            if (m.featureControls != null && Object.hasOwnProperty.call(m, "featureControls"))
                w.uint32(64).uint64(m.featureControls);
            return w;
        };

        BizIdentityInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizIdentityInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.vlevel = r.int32();
                        break;
                    }
                case 2: {
                        m.vnameCert = $root.proto.VerifiedNameCertificate.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.signed = r.bool();
                        break;
                    }
                case 4: {
                        m.revoked = r.bool();
                        break;
                    }
                case 5: {
                        m.hostStorage = r.int32();
                        break;
                    }
                case 6: {
                        m.actualActors = r.int32();
                        break;
                    }
                case 7: {
                        m.privacyModeTs = r.uint64();
                        break;
                    }
                case 8: {
                        m.featureControls = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizIdentityInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BizIdentityInfo)
                return d;
            var m = new $root.proto.BizIdentityInfo();
            switch (d.vlevel) {
            default:
                if (typeof d.vlevel === "number") {
                    m.vlevel = d.vlevel;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.vlevel = 0;
                break;
            case "LOW":
            case 1:
                m.vlevel = 1;
                break;
            case "HIGH":
            case 2:
                m.vlevel = 2;
                break;
            }
            if (d.vnameCert != null) {
                if (typeof d.vnameCert !== "object")
                    throw TypeError(".proto.BizIdentityInfo.vnameCert: object expected");
                m.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(d.vnameCert);
            }
            if (d.signed != null) {
                m.signed = Boolean(d.signed);
            }
            if (d.revoked != null) {
                m.revoked = Boolean(d.revoked);
            }
            switch (d.hostStorage) {
            default:
                if (typeof d.hostStorage === "number") {
                    m.hostStorage = d.hostStorage;
                    break;
                }
                break;
            case "ON_PREMISE":
            case 0:
                m.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                m.hostStorage = 1;
                break;
            }
            switch (d.actualActors) {
            default:
                if (typeof d.actualActors === "number") {
                    m.actualActors = d.actualActors;
                    break;
                }
                break;
            case "SELF":
            case 0:
                m.actualActors = 0;
                break;
            case "BSP":
            case 1:
                m.actualActors = 1;
                break;
            }
            if (d.privacyModeTs != null) {
                if ($util.Long)
                    (m.privacyModeTs = $util.Long.fromValue(d.privacyModeTs)).unsigned = true;
                else if (typeof d.privacyModeTs === "string")
                    m.privacyModeTs = parseInt(d.privacyModeTs, 10);
                else if (typeof d.privacyModeTs === "number")
                    m.privacyModeTs = d.privacyModeTs;
                else if (typeof d.privacyModeTs === "object")
                    m.privacyModeTs = new $util.LongBits(d.privacyModeTs.low >>> 0, d.privacyModeTs.high >>> 0).toNumber(true);
            }
            if (d.featureControls != null) {
                if ($util.Long)
                    (m.featureControls = $util.Long.fromValue(d.featureControls)).unsigned = true;
                else if (typeof d.featureControls === "string")
                    m.featureControls = parseInt(d.featureControls, 10);
                else if (typeof d.featureControls === "number")
                    m.featureControls = d.featureControls;
                else if (typeof d.featureControls === "object")
                    m.featureControls = new $util.LongBits(d.featureControls.low >>> 0, d.featureControls.high >>> 0).toNumber(true);
            }
            return m;
        };

        BizIdentityInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.vlevel != null && m.hasOwnProperty("vlevel")) {
                d.vlevel = o.enums === String ? $root.proto.BizIdentityInfo.VerifiedLevelValue[m.vlevel] === undefined ? m.vlevel : $root.proto.BizIdentityInfo.VerifiedLevelValue[m.vlevel] : m.vlevel;
                if (o.oneofs)
                    d._vlevel = "vlevel";
            }
            if (m.vnameCert != null && m.hasOwnProperty("vnameCert")) {
                d.vnameCert = $root.proto.VerifiedNameCertificate.toObject(m.vnameCert, o);
                if (o.oneofs)
                    d._vnameCert = "vnameCert";
            }
            if (m.signed != null && m.hasOwnProperty("signed")) {
                d.signed = m.signed;
                if (o.oneofs)
                    d._signed = "signed";
            }
            if (m.revoked != null && m.hasOwnProperty("revoked")) {
                d.revoked = m.revoked;
                if (o.oneofs)
                    d._revoked = "revoked";
            }
            if (m.hostStorage != null && m.hasOwnProperty("hostStorage")) {
                d.hostStorage = o.enums === String ? $root.proto.BizIdentityInfo.HostStorageType[m.hostStorage] === undefined ? m.hostStorage : $root.proto.BizIdentityInfo.HostStorageType[m.hostStorage] : m.hostStorage;
                if (o.oneofs)
                    d._hostStorage = "hostStorage";
            }
            if (m.actualActors != null && m.hasOwnProperty("actualActors")) {
                d.actualActors = o.enums === String ? $root.proto.BizIdentityInfo.ActualActorsType[m.actualActors] === undefined ? m.actualActors : $root.proto.BizIdentityInfo.ActualActorsType[m.actualActors] : m.actualActors;
                if (o.oneofs)
                    d._actualActors = "actualActors";
            }
            if (m.privacyModeTs != null && m.hasOwnProperty("privacyModeTs")) {
                if (typeof m.privacyModeTs === "number")
                    d.privacyModeTs = o.longs === String ? String(m.privacyModeTs) : m.privacyModeTs;
                else
                    d.privacyModeTs = o.longs === String ? $util.Long.prototype.toString.call(m.privacyModeTs) : o.longs === Number ? new $util.LongBits(m.privacyModeTs.low >>> 0, m.privacyModeTs.high >>> 0).toNumber(true) : m.privacyModeTs;
                if (o.oneofs)
                    d._privacyModeTs = "privacyModeTs";
            }
            if (m.featureControls != null && m.hasOwnProperty("featureControls")) {
                if (typeof m.featureControls === "number")
                    d.featureControls = o.longs === String ? String(m.featureControls) : m.featureControls;
                else
                    d.featureControls = o.longs === String ? $util.Long.prototype.toString.call(m.featureControls) : o.longs === Number ? new $util.LongBits(m.featureControls.low >>> 0, m.featureControls.high >>> 0).toNumber(true) : m.featureControls;
                if (o.oneofs)
                    d._featureControls = "featureControls";
            }
            return d;
        };

        BizIdentityInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BizIdentityInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizIdentityInfo";
        };

        BizIdentityInfo.ActualActorsType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        BizIdentityInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        BizIdentityInfo.VerifiedLevelValue = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.BotAgeCollectionMetadata = (function() {

        function BotAgeCollectionMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotAgeCollectionMetadata.prototype.ageCollectionEligible = null;
        BotAgeCollectionMetadata.prototype.shouldTriggerAgeCollectionOnClient = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_ageCollectionEligible", {
            get: $util.oneOfGetter($oneOfFields = ["ageCollectionEligible"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_shouldTriggerAgeCollectionOnClient", {
            get: $util.oneOfGetter($oneOfFields = ["shouldTriggerAgeCollectionOnClient"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotAgeCollectionMetadata.create = function create(properties) {
            return new BotAgeCollectionMetadata(properties);
        };

        BotAgeCollectionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.ageCollectionEligible != null && Object.hasOwnProperty.call(m, "ageCollectionEligible"))
                w.uint32(8).bool(m.ageCollectionEligible);
            if (m.shouldTriggerAgeCollectionOnClient != null && Object.hasOwnProperty.call(m, "shouldTriggerAgeCollectionOnClient"))
                w.uint32(16).bool(m.shouldTriggerAgeCollectionOnClient);
            return w;
        };

        BotAgeCollectionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotAgeCollectionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.ageCollectionEligible = r.bool();
                        break;
                    }
                case 2: {
                        m.shouldTriggerAgeCollectionOnClient = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotAgeCollectionMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotAgeCollectionMetadata)
                return d;
            var m = new $root.proto.BotAgeCollectionMetadata();
            if (d.ageCollectionEligible != null) {
                m.ageCollectionEligible = Boolean(d.ageCollectionEligible);
            }
            if (d.shouldTriggerAgeCollectionOnClient != null) {
                m.shouldTriggerAgeCollectionOnClient = Boolean(d.shouldTriggerAgeCollectionOnClient);
            }
            return m;
        };

        BotAgeCollectionMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.ageCollectionEligible != null && m.hasOwnProperty("ageCollectionEligible")) {
                d.ageCollectionEligible = m.ageCollectionEligible;
                if (o.oneofs)
                    d._ageCollectionEligible = "ageCollectionEligible";
            }
            if (m.shouldTriggerAgeCollectionOnClient != null && m.hasOwnProperty("shouldTriggerAgeCollectionOnClient")) {
                d.shouldTriggerAgeCollectionOnClient = m.shouldTriggerAgeCollectionOnClient;
                if (o.oneofs)
                    d._shouldTriggerAgeCollectionOnClient = "shouldTriggerAgeCollectionOnClient";
            }
            return d;
        };

        BotAgeCollectionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotAgeCollectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAgeCollectionMetadata";
        };

        return BotAgeCollectionMetadata;
    })();

    proto.BotAvatarMetadata = (function() {

        function BotAvatarMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotAvatarMetadata.prototype.sentiment = null;
        BotAvatarMetadata.prototype.behaviorGraph = null;
        BotAvatarMetadata.prototype.action = null;
        BotAvatarMetadata.prototype.intensity = null;
        BotAvatarMetadata.prototype.wordCount = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_sentiment", {
            get: $util.oneOfGetter($oneOfFields = ["sentiment"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_behaviorGraph", {
            get: $util.oneOfGetter($oneOfFields = ["behaviorGraph"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_action", {
            get: $util.oneOfGetter($oneOfFields = ["action"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_intensity", {
            get: $util.oneOfGetter($oneOfFields = ["intensity"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_wordCount", {
            get: $util.oneOfGetter($oneOfFields = ["wordCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotAvatarMetadata.create = function create(properties) {
            return new BotAvatarMetadata(properties);
        };

        BotAvatarMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sentiment != null && Object.hasOwnProperty.call(m, "sentiment"))
                w.uint32(8).uint32(m.sentiment);
            if (m.behaviorGraph != null && Object.hasOwnProperty.call(m, "behaviorGraph"))
                w.uint32(18).string(m.behaviorGraph);
            if (m.action != null && Object.hasOwnProperty.call(m, "action"))
                w.uint32(24).uint32(m.action);
            if (m.intensity != null && Object.hasOwnProperty.call(m, "intensity"))
                w.uint32(32).uint32(m.intensity);
            if (m.wordCount != null && Object.hasOwnProperty.call(m, "wordCount"))
                w.uint32(40).uint32(m.wordCount);
            return w;
        };

        BotAvatarMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotAvatarMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sentiment = r.uint32();
                        break;
                    }
                case 2: {
                        m.behaviorGraph = r.string();
                        break;
                    }
                case 3: {
                        m.action = r.uint32();
                        break;
                    }
                case 4: {
                        m.intensity = r.uint32();
                        break;
                    }
                case 5: {
                        m.wordCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotAvatarMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotAvatarMetadata)
                return d;
            var m = new $root.proto.BotAvatarMetadata();
            if (d.sentiment != null) {
                m.sentiment = d.sentiment >>> 0;
            }
            if (d.behaviorGraph != null) {
                m.behaviorGraph = String(d.behaviorGraph);
            }
            if (d.action != null) {
                m.action = d.action >>> 0;
            }
            if (d.intensity != null) {
                m.intensity = d.intensity >>> 0;
            }
            if (d.wordCount != null) {
                m.wordCount = d.wordCount >>> 0;
            }
            return m;
        };

        BotAvatarMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.sentiment != null && m.hasOwnProperty("sentiment")) {
                d.sentiment = m.sentiment;
                if (o.oneofs)
                    d._sentiment = "sentiment";
            }
            if (m.behaviorGraph != null && m.hasOwnProperty("behaviorGraph")) {
                d.behaviorGraph = m.behaviorGraph;
                if (o.oneofs)
                    d._behaviorGraph = "behaviorGraph";
            }
            if (m.action != null && m.hasOwnProperty("action")) {
                d.action = m.action;
                if (o.oneofs)
                    d._action = "action";
            }
            if (m.intensity != null && m.hasOwnProperty("intensity")) {
                d.intensity = m.intensity;
                if (o.oneofs)
                    d._intensity = "intensity";
            }
            if (m.wordCount != null && m.hasOwnProperty("wordCount")) {
                d.wordCount = m.wordCount;
                if (o.oneofs)
                    d._wordCount = "wordCount";
            }
            return d;
        };

        BotAvatarMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotAvatarMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAvatarMetadata";
        };

        return BotAvatarMetadata;
    })();

    proto.BotCapabilityMetadata = (function() {

        function BotCapabilityMetadata(p) {
            this.capabilities = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotCapabilityMetadata.prototype.capabilities = $util.emptyArray;

        BotCapabilityMetadata.create = function create(properties) {
            return new BotCapabilityMetadata(properties);
        };

        BotCapabilityMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.capabilities != null && m.capabilities.length) {
                w.uint32(10).fork();
                for (var i = 0; i < m.capabilities.length; ++i)
                    w.int32(m.capabilities[i]);
                w.ldelim();
            }
            return w;
        };

        BotCapabilityMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotCapabilityMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.capabilities && m.capabilities.length))
                            m.capabilities = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.capabilities.push(r.int32());
                        } else
                            m.capabilities.push(r.int32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotCapabilityMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotCapabilityMetadata)
                return d;
            var m = new $root.proto.BotCapabilityMetadata();
            if (d.capabilities) {
                if (!Array.isArray(d.capabilities))
                    throw TypeError(".proto.BotCapabilityMetadata.capabilities: array expected");
                m.capabilities = [];
                for (var i = 0; i < d.capabilities.length; ++i) {
                    switch (d.capabilities[i]) {
                    default:
                        if (typeof d.capabilities[i] === "number") {
                            m.capabilities[i] = d.capabilities[i];
                            break;
                        }
                    case "UNKNOWN":
                    case 0:
                        m.capabilities[i] = 0;
                        break;
                    case "PROGRESS_INDICATOR":
                    case 1:
                        m.capabilities[i] = 1;
                        break;
                    case "RICH_RESPONSE_HEADING":
                    case 2:
                        m.capabilities[i] = 2;
                        break;
                    case "RICH_RESPONSE_NESTED_LIST":
                    case 3:
                        m.capabilities[i] = 3;
                        break;
                    case "AI_MEMORY":
                    case 4:
                        m.capabilities[i] = 4;
                        break;
                    case "RICH_RESPONSE_THREAD_SURFING":
                    case 5:
                        m.capabilities[i] = 5;
                        break;
                    case "RICH_RESPONSE_TABLE":
                    case 6:
                        m.capabilities[i] = 6;
                        break;
                    case "RICH_RESPONSE_CODE":
                    case 7:
                        m.capabilities[i] = 7;
                        break;
                    case "RICH_RESPONSE_STRUCTURED_RESPONSE":
                    case 8:
                        m.capabilities[i] = 8;
                        break;
                    case "RICH_RESPONSE_INLINE_IMAGE":
                    case 9:
                        m.capabilities[i] = 9;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_CONTROL":
                    case 10:
                        m.capabilities[i] = 10;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_1":
                    case 11:
                        m.capabilities[i] = 11;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_2":
                    case 12:
                        m.capabilities[i] = 12;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_3":
                    case 13:
                        m.capabilities[i] = 13;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_4":
                    case 14:
                        m.capabilities[i] = 14;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_5":
                    case 15:
                        m.capabilities[i] = 15;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_6":
                    case 16:
                        m.capabilities[i] = 16;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_7":
                    case 17:
                        m.capabilities[i] = 17;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_8":
                    case 18:
                        m.capabilities[i] = 18;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_9":
                    case 19:
                        m.capabilities[i] = 19;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_10":
                    case 20:
                        m.capabilities[i] = 20;
                        break;
                    case "RICH_RESPONSE_SUB_HEADING":
                    case 21:
                        m.capabilities[i] = 21;
                        break;
                    case "RICH_RESPONSE_GRID_IMAGE":
                    case 22:
                        m.capabilities[i] = 22;
                        break;
                    case "AI_STUDIO_UGC_MEMORY":
                    case 23:
                        m.capabilities[i] = 23;
                        break;
                    case "RICH_RESPONSE_LATEX":
                    case 24:
                        m.capabilities[i] = 24;
                        break;
                    case "RICH_RESPONSE_MAPS":
                    case 25:
                        m.capabilities[i] = 25;
                        break;
                    case "RICH_RESPONSE_INLINE_REELS":
                    case 26:
                        m.capabilities[i] = 26;
                        break;
                    case "AGENTIC_PLANNING":
                    case 27:
                        m.capabilities[i] = 27;
                        break;
                    case "ACCOUNT_LINKING":
                    case 28:
                        m.capabilities[i] = 28;
                        break;
                    case "STREAMING_DISAGGREGATION":
                    case 29:
                        m.capabilities[i] = 29;
                        break;
                    case "RICH_RESPONSE_GRID_IMAGE_3P":
                    case 30:
                        m.capabilities[i] = 30;
                        break;
                    case "RICH_RESPONSE_LATEX_INLINE":
                    case 31:
                        m.capabilities[i] = 31;
                        break;
                    case "QUERY_PLAN":
                    case 32:
                        m.capabilities[i] = 32;
                        break;
                    case "PROACTIVE_MESSAGE":
                    case 33:
                        m.capabilities[i] = 33;
                        break;
                    case "RICH_RESPONSE_UNIFIED_RESPONSE":
                    case 34:
                        m.capabilities[i] = 34;
                        break;
                    case "PROMOTION_MESSAGE":
                    case 35:
                        m.capabilities[i] = 35;
                        break;
                    }
                }
            }
            return m;
        };

        BotCapabilityMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.capabilities = [];
            }
            if (m.capabilities && m.capabilities.length) {
                d.capabilities = [];
                for (var j = 0; j < m.capabilities.length; ++j) {
                    d.capabilities[j] = o.enums === String ? $root.proto.BotCapabilityMetadata.BotCapabilityType[m.capabilities[j]] === undefined ? m.capabilities[j] : $root.proto.BotCapabilityMetadata.BotCapabilityType[m.capabilities[j]] : m.capabilities[j];
                }
            }
            return d;
        };

        BotCapabilityMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotCapabilityMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotCapabilityMetadata";
        };

        BotCapabilityMetadata.BotCapabilityType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "PROGRESS_INDICATOR"] = 1;
            values[valuesById[2] = "RICH_RESPONSE_HEADING"] = 2;
            values[valuesById[3] = "RICH_RESPONSE_NESTED_LIST"] = 3;
            values[valuesById[4] = "AI_MEMORY"] = 4;
            values[valuesById[5] = "RICH_RESPONSE_THREAD_SURFING"] = 5;
            values[valuesById[6] = "RICH_RESPONSE_TABLE"] = 6;
            values[valuesById[7] = "RICH_RESPONSE_CODE"] = 7;
            values[valuesById[8] = "RICH_RESPONSE_STRUCTURED_RESPONSE"] = 8;
            values[valuesById[9] = "RICH_RESPONSE_INLINE_IMAGE"] = 9;
            values[valuesById[10] = "WA_IG_1P_PLUGIN_RANKING_CONTROL"] = 10;
            values[valuesById[11] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_1"] = 11;
            values[valuesById[12] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_2"] = 12;
            values[valuesById[13] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_3"] = 13;
            values[valuesById[14] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_4"] = 14;
            values[valuesById[15] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_5"] = 15;
            values[valuesById[16] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_6"] = 16;
            values[valuesById[17] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_7"] = 17;
            values[valuesById[18] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_8"] = 18;
            values[valuesById[19] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_9"] = 19;
            values[valuesById[20] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_10"] = 20;
            values[valuesById[21] = "RICH_RESPONSE_SUB_HEADING"] = 21;
            values[valuesById[22] = "RICH_RESPONSE_GRID_IMAGE"] = 22;
            values[valuesById[23] = "AI_STUDIO_UGC_MEMORY"] = 23;
            values[valuesById[24] = "RICH_RESPONSE_LATEX"] = 24;
            values[valuesById[25] = "RICH_RESPONSE_MAPS"] = 25;
            values[valuesById[26] = "RICH_RESPONSE_INLINE_REELS"] = 26;
            values[valuesById[27] = "AGENTIC_PLANNING"] = 27;
            values[valuesById[28] = "ACCOUNT_LINKING"] = 28;
            values[valuesById[29] = "STREAMING_DISAGGREGATION"] = 29;
            values[valuesById[30] = "RICH_RESPONSE_GRID_IMAGE_3P"] = 30;
            values[valuesById[31] = "RICH_RESPONSE_LATEX_INLINE"] = 31;
            values[valuesById[32] = "QUERY_PLAN"] = 32;
            values[valuesById[33] = "PROACTIVE_MESSAGE"] = 33;
            values[valuesById[34] = "RICH_RESPONSE_UNIFIED_RESPONSE"] = 34;
            values[valuesById[35] = "PROMOTION_MESSAGE"] = 35;
            return values;
        })();

        return BotCapabilityMetadata;
    })();

    proto.BotImagineMetadata = (function() {

        function BotImagineMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotImagineMetadata.prototype.imagineType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotImagineMetadata.prototype, "_imagineType", {
            get: $util.oneOfGetter($oneOfFields = ["imagineType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotImagineMetadata.create = function create(properties) {
            return new BotImagineMetadata(properties);
        };

        BotImagineMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.imagineType != null && Object.hasOwnProperty.call(m, "imagineType"))
                w.uint32(8).int32(m.imagineType);
            return w;
        };

        BotImagineMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotImagineMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.imagineType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotImagineMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotImagineMetadata)
                return d;
            var m = new $root.proto.BotImagineMetadata();
            switch (d.imagineType) {
            default:
                if (typeof d.imagineType === "number") {
                    m.imagineType = d.imagineType;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.imagineType = 0;
                break;
            case "IMAGINE":
            case 1:
                m.imagineType = 1;
                break;
            case "MEMU":
            case 2:
                m.imagineType = 2;
                break;
            case "FLASH":
            case 3:
                m.imagineType = 3;
                break;
            case "EDIT":
            case 4:
                m.imagineType = 4;
                break;
            }
            return m;
        };

        BotImagineMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.imagineType != null && m.hasOwnProperty("imagineType")) {
                d.imagineType = o.enums === String ? $root.proto.BotImagineMetadata.ImagineType[m.imagineType] === undefined ? m.imagineType : $root.proto.BotImagineMetadata.ImagineType[m.imagineType] : m.imagineType;
                if (o.oneofs)
                    d._imagineType = "imagineType";
            }
            return d;
        };

        BotImagineMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotImagineMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotImagineMetadata";
        };

        BotImagineMetadata.ImagineType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "IMAGINE"] = 1;
            values[valuesById[2] = "MEMU"] = 2;
            values[valuesById[3] = "FLASH"] = 3;
            values[valuesById[4] = "EDIT"] = 4;
            return values;
        })();

        return BotImagineMetadata;
    })();

    proto.BotLinkedAccount = (function() {

        function BotLinkedAccount(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotLinkedAccount.prototype.type = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccount.prototype, "_type", {
            get: $util.oneOfGetter($oneOfFields = ["type"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotLinkedAccount.create = function create(properties) {
            return new BotLinkedAccount(properties);
        };

        BotLinkedAccount.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                w.uint32(8).int32(m.type);
            return w;
        };

        BotLinkedAccount.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotLinkedAccount();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.type = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotLinkedAccount.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotLinkedAccount)
                return d;
            var m = new $root.proto.BotLinkedAccount();
            switch (d.type) {
            default:
                if (typeof d.type === "number") {
                    m.type = d.type;
                    break;
                }
                break;
            case "BOT_LINKED_ACCOUNT_TYPE_1P":
            case 0:
                m.type = 0;
                break;
            }
            return m;
        };

        BotLinkedAccount.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.type != null && m.hasOwnProperty("type")) {
                d.type = o.enums === String ? $root.proto.BotLinkedAccount.BotLinkedAccountType[m.type] === undefined ? m.type : $root.proto.BotLinkedAccount.BotLinkedAccountType[m.type] : m.type;
                if (o.oneofs)
                    d._type = "type";
            }
            return d;
        };

        BotLinkedAccount.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotLinkedAccount.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccount";
        };

        BotLinkedAccount.BotLinkedAccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "BOT_LINKED_ACCOUNT_TYPE_1P"] = 0;
            return values;
        })();

        return BotLinkedAccount;
    })();

    proto.BotLinkedAccountsMetadata = (function() {

        function BotLinkedAccountsMetadata(p) {
            this.accounts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotLinkedAccountsMetadata.prototype.accounts = $util.emptyArray;
        BotLinkedAccountsMetadata.prototype.acAuthTokens = null;
        BotLinkedAccountsMetadata.prototype.acErrorCode = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccountsMetadata.prototype, "_acAuthTokens", {
            get: $util.oneOfGetter($oneOfFields = ["acAuthTokens"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccountsMetadata.prototype, "_acErrorCode", {
            get: $util.oneOfGetter($oneOfFields = ["acErrorCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotLinkedAccountsMetadata.create = function create(properties) {
            return new BotLinkedAccountsMetadata(properties);
        };

        BotLinkedAccountsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.accounts != null && m.accounts.length) {
                for (var i = 0; i < m.accounts.length; ++i)
                    $root.proto.BotLinkedAccount.encode(m.accounts[i], w.uint32(10).fork()).ldelim();
            }
            if (m.acAuthTokens != null && Object.hasOwnProperty.call(m, "acAuthTokens"))
                w.uint32(18).bytes(m.acAuthTokens);
            if (m.acErrorCode != null && Object.hasOwnProperty.call(m, "acErrorCode"))
                w.uint32(24).int32(m.acErrorCode);
            return w;
        };

        BotLinkedAccountsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotLinkedAccountsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.accounts && m.accounts.length))
                            m.accounts = [];
                        m.accounts.push($root.proto.BotLinkedAccount.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        m.acAuthTokens = r.bytes();
                        break;
                    }
                case 3: {
                        m.acErrorCode = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotLinkedAccountsMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotLinkedAccountsMetadata)
                return d;
            var m = new $root.proto.BotLinkedAccountsMetadata();
            if (d.accounts) {
                if (!Array.isArray(d.accounts))
                    throw TypeError(".proto.BotLinkedAccountsMetadata.accounts: array expected");
                m.accounts = [];
                for (var i = 0; i < d.accounts.length; ++i) {
                    if (typeof d.accounts[i] !== "object")
                        throw TypeError(".proto.BotLinkedAccountsMetadata.accounts: object expected");
                    m.accounts[i] = $root.proto.BotLinkedAccount.fromObject(d.accounts[i]);
                }
            }
            if (d.acAuthTokens != null) {
                if (typeof d.acAuthTokens === "string")
                    $util.base64.decode(d.acAuthTokens, m.acAuthTokens = $util.newBuffer($util.base64.length(d.acAuthTokens)), 0);
                else if (d.acAuthTokens.length >= 0)
                    m.acAuthTokens = d.acAuthTokens;
            }
            if (d.acErrorCode != null) {
                m.acErrorCode = d.acErrorCode | 0;
            }
            return m;
        };

        BotLinkedAccountsMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.accounts = [];
            }
            if (m.accounts && m.accounts.length) {
                d.accounts = [];
                for (var j = 0; j < m.accounts.length; ++j) {
                    d.accounts[j] = $root.proto.BotLinkedAccount.toObject(m.accounts[j], o);
                }
            }
            if (m.acAuthTokens != null && m.hasOwnProperty("acAuthTokens")) {
                d.acAuthTokens = o.bytes === String ? $util.base64.encode(m.acAuthTokens, 0, m.acAuthTokens.length) : o.bytes === Array ? Array.prototype.slice.call(m.acAuthTokens) : m.acAuthTokens;
                if (o.oneofs)
                    d._acAuthTokens = "acAuthTokens";
            }
            if (m.acErrorCode != null && m.hasOwnProperty("acErrorCode")) {
                d.acErrorCode = m.acErrorCode;
                if (o.oneofs)
                    d._acErrorCode = "acErrorCode";
            }
            return d;
        };

        BotLinkedAccountsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotLinkedAccountsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccountsMetadata";
        };

        return BotLinkedAccountsMetadata;
    })();

    proto.BotMediaMetadata = (function() {

        function BotMediaMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMediaMetadata.prototype.fileSha256 = null;
        BotMediaMetadata.prototype.mediaKey = null;
        BotMediaMetadata.prototype.fileEncSha256 = null;
        BotMediaMetadata.prototype.directPath = null;
        BotMediaMetadata.prototype.mediaKeyTimestamp = null;
        BotMediaMetadata.prototype.mimetype = null;
        BotMediaMetadata.prototype.orientationType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_fileSha256", {
            get: $util.oneOfGetter($oneOfFields = ["fileSha256"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mediaKey", {
            get: $util.oneOfGetter($oneOfFields = ["mediaKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_fileEncSha256", {
            get: $util.oneOfGetter($oneOfFields = ["fileEncSha256"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_directPath", {
            get: $util.oneOfGetter($oneOfFields = ["directPath"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mediaKeyTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["mediaKeyTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mimetype", {
            get: $util.oneOfGetter($oneOfFields = ["mimetype"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_orientationType", {
            get: $util.oneOfGetter($oneOfFields = ["orientationType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMediaMetadata.create = function create(properties) {
            return new BotMediaMetadata(properties);
        };

        BotMediaMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                w.uint32(10).string(m.fileSha256);
            if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                w.uint32(18).string(m.mediaKey);
            if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                w.uint32(26).string(m.fileEncSha256);
            if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                w.uint32(34).string(m.directPath);
            if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                w.uint32(40).int64(m.mediaKeyTimestamp);
            if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                w.uint32(50).string(m.mimetype);
            if (m.orientationType != null && Object.hasOwnProperty.call(m, "orientationType"))
                w.uint32(56).int32(m.orientationType);
            return w;
        };

        BotMediaMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMediaMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fileSha256 = r.string();
                        break;
                    }
                case 2: {
                        m.mediaKey = r.string();
                        break;
                    }
                case 3: {
                        m.fileEncSha256 = r.string();
                        break;
                    }
                case 4: {
                        m.directPath = r.string();
                        break;
                    }
                case 5: {
                        m.mediaKeyTimestamp = r.int64();
                        break;
                    }
                case 6: {
                        m.mimetype = r.string();
                        break;
                    }
                case 7: {
                        m.orientationType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMediaMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMediaMetadata)
                return d;
            var m = new $root.proto.BotMediaMetadata();
            if (d.fileSha256 != null) {
                m.fileSha256 = String(d.fileSha256);
            }
            if (d.mediaKey != null) {
                m.mediaKey = String(d.mediaKey);
            }
            if (d.fileEncSha256 != null) {
                m.fileEncSha256 = String(d.fileEncSha256);
            }
            if (d.directPath != null) {
                m.directPath = String(d.directPath);
            }
            if (d.mediaKeyTimestamp != null) {
                if ($util.Long)
                    (m.mediaKeyTimestamp = $util.Long.fromValue(d.mediaKeyTimestamp)).unsigned = false;
                else if (typeof d.mediaKeyTimestamp === "string")
                    m.mediaKeyTimestamp = parseInt(d.mediaKeyTimestamp, 10);
                else if (typeof d.mediaKeyTimestamp === "number")
                    m.mediaKeyTimestamp = d.mediaKeyTimestamp;
                else if (typeof d.mediaKeyTimestamp === "object")
                    m.mediaKeyTimestamp = new $util.LongBits(d.mediaKeyTimestamp.low >>> 0, d.mediaKeyTimestamp.high >>> 0).toNumber();
            }
            if (d.mimetype != null) {
                m.mimetype = String(d.mimetype);
            }
            switch (d.orientationType) {
            default:
                if (typeof d.orientationType === "number") {
                    m.orientationType = d.orientationType;
                    break;
                }
                break;
            case "CENTER":
            case 1:
                m.orientationType = 1;
                break;
            case "LEFT":
            case 2:
                m.orientationType = 2;
                break;
            case "RIGHT":
            case 3:
                m.orientationType = 3;
                break;
            }
            return m;
        };

        BotMediaMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.fileSha256 != null && m.hasOwnProperty("fileSha256")) {
                d.fileSha256 = m.fileSha256;
                if (o.oneofs)
                    d._fileSha256 = "fileSha256";
            }
            if (m.mediaKey != null && m.hasOwnProperty("mediaKey")) {
                d.mediaKey = m.mediaKey;
                if (o.oneofs)
                    d._mediaKey = "mediaKey";
            }
            if (m.fileEncSha256 != null && m.hasOwnProperty("fileEncSha256")) {
                d.fileEncSha256 = m.fileEncSha256;
                if (o.oneofs)
                    d._fileEncSha256 = "fileEncSha256";
            }
            if (m.directPath != null && m.hasOwnProperty("directPath")) {
                d.directPath = m.directPath;
                if (o.oneofs)
                    d._directPath = "directPath";
            }
            if (m.mediaKeyTimestamp != null && m.hasOwnProperty("mediaKeyTimestamp")) {
                if (typeof m.mediaKeyTimestamp === "number")
                    d.mediaKeyTimestamp = o.longs === String ? String(m.mediaKeyTimestamp) : m.mediaKeyTimestamp;
                else
                    d.mediaKeyTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.mediaKeyTimestamp) : o.longs === Number ? new $util.LongBits(m.mediaKeyTimestamp.low >>> 0, m.mediaKeyTimestamp.high >>> 0).toNumber() : m.mediaKeyTimestamp;
                if (o.oneofs)
                    d._mediaKeyTimestamp = "mediaKeyTimestamp";
            }
            if (m.mimetype != null && m.hasOwnProperty("mimetype")) {
                d.mimetype = m.mimetype;
                if (o.oneofs)
                    d._mimetype = "mimetype";
            }
            if (m.orientationType != null && m.hasOwnProperty("orientationType")) {
                d.orientationType = o.enums === String ? $root.proto.BotMediaMetadata.OrientationType[m.orientationType] === undefined ? m.orientationType : $root.proto.BotMediaMetadata.OrientationType[m.orientationType] : m.orientationType;
                if (o.oneofs)
                    d._orientationType = "orientationType";
            }
            return d;
        };

        BotMediaMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMediaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMediaMetadata";
        };

        BotMediaMetadata.OrientationType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "CENTER"] = 1;
            values[valuesById[2] = "LEFT"] = 2;
            values[valuesById[3] = "RIGHT"] = 3;
            return values;
        })();

        return BotMediaMetadata;
    })();

    proto.BotMemoryFact = (function() {

        function BotMemoryFact(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemoryFact.prototype.fact = null;
        BotMemoryFact.prototype.factId = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryFact.prototype, "_fact", {
            get: $util.oneOfGetter($oneOfFields = ["fact"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryFact.prototype, "_factId", {
            get: $util.oneOfGetter($oneOfFields = ["factId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMemoryFact.create = function create(properties) {
            return new BotMemoryFact(properties);
        };

        BotMemoryFact.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fact != null && Object.hasOwnProperty.call(m, "fact"))
                w.uint32(10).string(m.fact);
            if (m.factId != null && Object.hasOwnProperty.call(m, "factId"))
                w.uint32(18).string(m.factId);
            return w;
        };

        BotMemoryFact.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemoryFact();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fact = r.string();
                        break;
                    }
                case 2: {
                        m.factId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemoryFact.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMemoryFact)
                return d;
            var m = new $root.proto.BotMemoryFact();
            if (d.fact != null) {
                m.fact = String(d.fact);
            }
            if (d.factId != null) {
                m.factId = String(d.factId);
            }
            return m;
        };

        BotMemoryFact.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.fact != null && m.hasOwnProperty("fact")) {
                d.fact = m.fact;
                if (o.oneofs)
                    d._fact = "fact";
            }
            if (m.factId != null && m.hasOwnProperty("factId")) {
                d.factId = m.factId;
                if (o.oneofs)
                    d._factId = "factId";
            }
            return d;
        };

        BotMemoryFact.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMemoryFact.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryFact";
        };

        return BotMemoryFact;
    })();

    proto.BotMemoryMetadata = (function() {

        function BotMemoryMetadata(p) {
            this.addedFacts = [];
            this.removedFacts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemoryMetadata.prototype.addedFacts = $util.emptyArray;
        BotMemoryMetadata.prototype.removedFacts = $util.emptyArray;
        BotMemoryMetadata.prototype.disclaimer = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryMetadata.prototype, "_disclaimer", {
            get: $util.oneOfGetter($oneOfFields = ["disclaimer"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMemoryMetadata.create = function create(properties) {
            return new BotMemoryMetadata(properties);
        };

        BotMemoryMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.addedFacts != null && m.addedFacts.length) {
                for (var i = 0; i < m.addedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(m.addedFacts[i], w.uint32(10).fork()).ldelim();
            }
            if (m.removedFacts != null && m.removedFacts.length) {
                for (var i = 0; i < m.removedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(m.removedFacts[i], w.uint32(18).fork()).ldelim();
            }
            if (m.disclaimer != null && Object.hasOwnProperty.call(m, "disclaimer"))
                w.uint32(26).string(m.disclaimer);
            return w;
        };

        BotMemoryMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemoryMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.addedFacts && m.addedFacts.length))
                            m.addedFacts = [];
                        m.addedFacts.push($root.proto.BotMemoryFact.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        if (!(m.removedFacts && m.removedFacts.length))
                            m.removedFacts = [];
                        m.removedFacts.push($root.proto.BotMemoryFact.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.disclaimer = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemoryMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMemoryMetadata)
                return d;
            var m = new $root.proto.BotMemoryMetadata();
            if (d.addedFacts) {
                if (!Array.isArray(d.addedFacts))
                    throw TypeError(".proto.BotMemoryMetadata.addedFacts: array expected");
                m.addedFacts = [];
                for (var i = 0; i < d.addedFacts.length; ++i) {
                    if (typeof d.addedFacts[i] !== "object")
                        throw TypeError(".proto.BotMemoryMetadata.addedFacts: object expected");
                    m.addedFacts[i] = $root.proto.BotMemoryFact.fromObject(d.addedFacts[i]);
                }
            }
            if (d.removedFacts) {
                if (!Array.isArray(d.removedFacts))
                    throw TypeError(".proto.BotMemoryMetadata.removedFacts: array expected");
                m.removedFacts = [];
                for (var i = 0; i < d.removedFacts.length; ++i) {
                    if (typeof d.removedFacts[i] !== "object")
                        throw TypeError(".proto.BotMemoryMetadata.removedFacts: object expected");
                    m.removedFacts[i] = $root.proto.BotMemoryFact.fromObject(d.removedFacts[i]);
                }
            }
            if (d.disclaimer != null) {
                m.disclaimer = String(d.disclaimer);
            }
            return m;
        };

        BotMemoryMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.addedFacts = [];
                d.removedFacts = [];
            }
            if (m.addedFacts && m.addedFacts.length) {
                d.addedFacts = [];
                for (var j = 0; j < m.addedFacts.length; ++j) {
                    d.addedFacts[j] = $root.proto.BotMemoryFact.toObject(m.addedFacts[j], o);
                }
            }
            if (m.removedFacts && m.removedFacts.length) {
                d.removedFacts = [];
                for (var j = 0; j < m.removedFacts.length; ++j) {
                    d.removedFacts[j] = $root.proto.BotMemoryFact.toObject(m.removedFacts[j], o);
                }
            }
            if (m.disclaimer != null && m.hasOwnProperty("disclaimer")) {
                d.disclaimer = m.disclaimer;
                if (o.oneofs)
                    d._disclaimer = "disclaimer";
            }
            return d;
        };

        BotMemoryMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMemoryMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryMetadata";
        };

        return BotMemoryMetadata;
    })();

    proto.BotMemuMetadata = (function() {

        function BotMemuMetadata(p) {
            this.faceImages = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemuMetadata.prototype.faceImages = $util.emptyArray;

        BotMemuMetadata.create = function create(properties) {
            return new BotMemuMetadata(properties);
        };

        BotMemuMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.faceImages != null && m.faceImages.length) {
                for (var i = 0; i < m.faceImages.length; ++i)
                    $root.proto.BotMediaMetadata.encode(m.faceImages[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotMemuMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemuMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.faceImages && m.faceImages.length))
                            m.faceImages = [];
                        m.faceImages.push($root.proto.BotMediaMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemuMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMemuMetadata)
                return d;
            var m = new $root.proto.BotMemuMetadata();
            if (d.faceImages) {
                if (!Array.isArray(d.faceImages))
                    throw TypeError(".proto.BotMemuMetadata.faceImages: array expected");
                m.faceImages = [];
                for (var i = 0; i < d.faceImages.length; ++i) {
                    if (typeof d.faceImages[i] !== "object")
                        throw TypeError(".proto.BotMemuMetadata.faceImages: object expected");
                    m.faceImages[i] = $root.proto.BotMediaMetadata.fromObject(d.faceImages[i]);
                }
            }
            return m;
        };

        BotMemuMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.faceImages = [];
            }
            if (m.faceImages && m.faceImages.length) {
                d.faceImages = [];
                for (var j = 0; j < m.faceImages.length; ++j) {
                    d.faceImages[j] = $root.proto.BotMediaMetadata.toObject(m.faceImages[j], o);
                }
            }
            return d;
        };

        BotMemuMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMemuMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemuMetadata";
        };

        return BotMemuMetadata;
    })();

    proto.BotMetadata = (function() {

        function BotMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMetadata.prototype.avatarMetadata = null;
        BotMetadata.prototype.personaId = null;
        BotMetadata.prototype.pluginMetadata = null;
        BotMetadata.prototype.suggestedPromptMetadata = null;
        BotMetadata.prototype.invokerJid = null;
        BotMetadata.prototype.sessionMetadata = null;
        BotMetadata.prototype.memuMetadata = null;
        BotMetadata.prototype.timezone = null;
        BotMetadata.prototype.reminderMetadata = null;
        BotMetadata.prototype.modelMetadata = null;
        BotMetadata.prototype.messageDisclaimerText = null;
        BotMetadata.prototype.progressIndicatorMetadata = null;
        BotMetadata.prototype.capabilityMetadata = null;
        BotMetadata.prototype.imagineMetadata = null;
        BotMetadata.prototype.memoryMetadata = null;
        BotMetadata.prototype.renderingMetadata = null;
        BotMetadata.prototype.botMetricsMetadata = null;
        BotMetadata.prototype.botLinkedAccountsMetadata = null;
        BotMetadata.prototype.richResponseSourcesMetadata = null;
        BotMetadata.prototype.aiConversationContext = null;
        BotMetadata.prototype.botPromotionMessageMetadata = null;
        BotMetadata.prototype.botModeSelectionMetadata = null;
        BotMetadata.prototype.botQuotaMetadata = null;
        BotMetadata.prototype.botAgeCollectionMetadata = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_avatarMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["avatarMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_personaId", {
            get: $util.oneOfGetter($oneOfFields = ["personaId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_pluginMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["pluginMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_suggestedPromptMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["suggestedPromptMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_invokerJid", {
            get: $util.oneOfGetter($oneOfFields = ["invokerJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_sessionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["sessionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_memuMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["memuMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_timezone", {
            get: $util.oneOfGetter($oneOfFields = ["timezone"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_reminderMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["reminderMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_modelMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["modelMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_messageDisclaimerText", {
            get: $util.oneOfGetter($oneOfFields = ["messageDisclaimerText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_progressIndicatorMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["progressIndicatorMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_capabilityMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["capabilityMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_imagineMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["imagineMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_memoryMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["memoryMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_renderingMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["renderingMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botMetricsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botMetricsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botLinkedAccountsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botLinkedAccountsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_richResponseSourcesMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["richResponseSourcesMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_aiConversationContext", {
            get: $util.oneOfGetter($oneOfFields = ["aiConversationContext"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botPromotionMessageMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botPromotionMessageMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botModeSelectionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botModeSelectionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botQuotaMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botQuotaMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botAgeCollectionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botAgeCollectionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMetadata.create = function create(properties) {
            return new BotMetadata(properties);
        };

        BotMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.avatarMetadata != null && Object.hasOwnProperty.call(m, "avatarMetadata"))
                $root.proto.BotAvatarMetadata.encode(m.avatarMetadata, w.uint32(10).fork()).ldelim();
            if (m.personaId != null && Object.hasOwnProperty.call(m, "personaId"))
                w.uint32(18).string(m.personaId);
            if (m.pluginMetadata != null && Object.hasOwnProperty.call(m, "pluginMetadata"))
                $root.proto.BotPluginMetadata.encode(m.pluginMetadata, w.uint32(26).fork()).ldelim();
            if (m.suggestedPromptMetadata != null && Object.hasOwnProperty.call(m, "suggestedPromptMetadata"))
                $root.proto.BotSuggestedPromptMetadata.encode(m.suggestedPromptMetadata, w.uint32(34).fork()).ldelim();
            if (m.invokerJid != null && Object.hasOwnProperty.call(m, "invokerJid"))
                w.uint32(42).string(m.invokerJid);
            if (m.sessionMetadata != null && Object.hasOwnProperty.call(m, "sessionMetadata"))
                $root.proto.BotSessionMetadata.encode(m.sessionMetadata, w.uint32(50).fork()).ldelim();
            if (m.memuMetadata != null && Object.hasOwnProperty.call(m, "memuMetadata"))
                $root.proto.BotMemuMetadata.encode(m.memuMetadata, w.uint32(58).fork()).ldelim();
            if (m.timezone != null && Object.hasOwnProperty.call(m, "timezone"))
                w.uint32(66).string(m.timezone);
            if (m.reminderMetadata != null && Object.hasOwnProperty.call(m, "reminderMetadata"))
                $root.proto.BotReminderMetadata.encode(m.reminderMetadata, w.uint32(74).fork()).ldelim();
            if (m.modelMetadata != null && Object.hasOwnProperty.call(m, "modelMetadata"))
                $root.proto.BotModelMetadata.encode(m.modelMetadata, w.uint32(82).fork()).ldelim();
            if (m.messageDisclaimerText != null && Object.hasOwnProperty.call(m, "messageDisclaimerText"))
                w.uint32(90).string(m.messageDisclaimerText);
            if (m.progressIndicatorMetadata != null && Object.hasOwnProperty.call(m, "progressIndicatorMetadata"))
                $root.proto.BotProgressIndicatorMetadata.encode(m.progressIndicatorMetadata, w.uint32(98).fork()).ldelim();
            if (m.capabilityMetadata != null && Object.hasOwnProperty.call(m, "capabilityMetadata"))
                $root.proto.BotCapabilityMetadata.encode(m.capabilityMetadata, w.uint32(106).fork()).ldelim();
            if (m.imagineMetadata != null && Object.hasOwnProperty.call(m, "imagineMetadata"))
                $root.proto.BotImagineMetadata.encode(m.imagineMetadata, w.uint32(114).fork()).ldelim();
            if (m.memoryMetadata != null && Object.hasOwnProperty.call(m, "memoryMetadata"))
                $root.proto.BotMemoryMetadata.encode(m.memoryMetadata, w.uint32(122).fork()).ldelim();
            if (m.renderingMetadata != null && Object.hasOwnProperty.call(m, "renderingMetadata"))
                $root.proto.BotRenderingMetadata.encode(m.renderingMetadata, w.uint32(130).fork()).ldelim();
            if (m.botMetricsMetadata != null && Object.hasOwnProperty.call(m, "botMetricsMetadata"))
                $root.proto.BotMetricsMetadata.encode(m.botMetricsMetadata, w.uint32(138).fork()).ldelim();
            if (m.botLinkedAccountsMetadata != null && Object.hasOwnProperty.call(m, "botLinkedAccountsMetadata"))
                $root.proto.BotLinkedAccountsMetadata.encode(m.botLinkedAccountsMetadata, w.uint32(146).fork()).ldelim();
            if (m.richResponseSourcesMetadata != null && Object.hasOwnProperty.call(m, "richResponseSourcesMetadata"))
                $root.proto.BotSourcesMetadata.encode(m.richResponseSourcesMetadata, w.uint32(154).fork()).ldelim();
            if (m.aiConversationContext != null && Object.hasOwnProperty.call(m, "aiConversationContext"))
                w.uint32(162).bytes(m.aiConversationContext);
            if (m.botPromotionMessageMetadata != null && Object.hasOwnProperty.call(m, "botPromotionMessageMetadata"))
                $root.proto.BotPromotionMessageMetadata.encode(m.botPromotionMessageMetadata, w.uint32(170).fork()).ldelim();
            if (m.botModeSelectionMetadata != null && Object.hasOwnProperty.call(m, "botModeSelectionMetadata"))
                $root.proto.BotModeSelectionMetadata.encode(m.botModeSelectionMetadata, w.uint32(178).fork()).ldelim();
            if (m.botQuotaMetadata != null && Object.hasOwnProperty.call(m, "botQuotaMetadata"))
                $root.proto.BotQuotaMetadata.encode(m.botQuotaMetadata, w.uint32(186).fork()).ldelim();
            if (m.botAgeCollectionMetadata != null && Object.hasOwnProperty.call(m, "botAgeCollectionMetadata"))
                $root.proto.BotAgeCollectionMetadata.encode(m.botAgeCollectionMetadata, w.uint32(194).fork()).ldelim();
            return w;
        };

        BotMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.avatarMetadata = $root.proto.BotAvatarMetadata.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.personaId = r.string();
                        break;
                    }
                case 3: {
                        m.pluginMetadata = $root.proto.BotPluginMetadata.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.decode(r, r.uint32());
                        break;
                    }
                case 5: {
                        m.invokerJid = r.string();
                        break;
                    }
                case 6: {
                        m.sessionMetadata = $root.proto.BotSessionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.memuMetadata = $root.proto.BotMemuMetadata.decode(r, r.uint32());
                        break;
                    }
                case 8: {
                        m.timezone = r.string();
                        break;
                    }
                case 9: {
                        m.reminderMetadata = $root.proto.BotReminderMetadata.decode(r, r.uint32());
                        break;
                    }
                case 10: {
                        m.modelMetadata = $root.proto.BotModelMetadata.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.messageDisclaimerText = r.string();
                        break;
                    }
                case 12: {
                        m.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.decode(r, r.uint32());
                        break;
                    }
                case 13: {
                        m.capabilityMetadata = $root.proto.BotCapabilityMetadata.decode(r, r.uint32());
                        break;
                    }
                case 14: {
                        m.imagineMetadata = $root.proto.BotImagineMetadata.decode(r, r.uint32());
                        break;
                    }
                case 15: {
                        m.memoryMetadata = $root.proto.BotMemoryMetadata.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.renderingMetadata = $root.proto.BotRenderingMetadata.decode(r, r.uint32());
                        break;
                    }
                case 17: {
                        m.botMetricsMetadata = $root.proto.BotMetricsMetadata.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.decode(r, r.uint32());
                        break;
                    }
                case 19: {
                        m.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.aiConversationContext = r.bytes();
                        break;
                    }
                case 21: {
                        m.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.decode(r, r.uint32());
                        break;
                    }
                case 22: {
                        m.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 23: {
                        m.botQuotaMetadata = $root.proto.BotQuotaMetadata.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMetadata)
                return d;
            var m = new $root.proto.BotMetadata();
            if (d.avatarMetadata != null) {
                if (typeof d.avatarMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.avatarMetadata: object expected");
                m.avatarMetadata = $root.proto.BotAvatarMetadata.fromObject(d.avatarMetadata);
            }
            if (d.personaId != null) {
                m.personaId = String(d.personaId);
            }
            if (d.pluginMetadata != null) {
                if (typeof d.pluginMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.pluginMetadata: object expected");
                m.pluginMetadata = $root.proto.BotPluginMetadata.fromObject(d.pluginMetadata);
            }
            if (d.suggestedPromptMetadata != null) {
                if (typeof d.suggestedPromptMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.suggestedPromptMetadata: object expected");
                m.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.fromObject(d.suggestedPromptMetadata);
            }
            if (d.invokerJid != null) {
                m.invokerJid = String(d.invokerJid);
            }
            if (d.sessionMetadata != null) {
                if (typeof d.sessionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.sessionMetadata: object expected");
                m.sessionMetadata = $root.proto.BotSessionMetadata.fromObject(d.sessionMetadata);
            }
            if (d.memuMetadata != null) {
                if (typeof d.memuMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.memuMetadata: object expected");
                m.memuMetadata = $root.proto.BotMemuMetadata.fromObject(d.memuMetadata);
            }
            if (d.timezone != null) {
                m.timezone = String(d.timezone);
            }
            if (d.reminderMetadata != null) {
                if (typeof d.reminderMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.reminderMetadata: object expected");
                m.reminderMetadata = $root.proto.BotReminderMetadata.fromObject(d.reminderMetadata);
            }
            if (d.modelMetadata != null) {
                if (typeof d.modelMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.modelMetadata: object expected");
                m.modelMetadata = $root.proto.BotModelMetadata.fromObject(d.modelMetadata);
            }
            if (d.messageDisclaimerText != null) {
                m.messageDisclaimerText = String(d.messageDisclaimerText);
            }
            if (d.progressIndicatorMetadata != null) {
                if (typeof d.progressIndicatorMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.progressIndicatorMetadata: object expected");
                m.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.fromObject(d.progressIndicatorMetadata);
            }
            if (d.capabilityMetadata != null) {
                if (typeof d.capabilityMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.capabilityMetadata: object expected");
                m.capabilityMetadata = $root.proto.BotCapabilityMetadata.fromObject(d.capabilityMetadata);
            }
            if (d.imagineMetadata != null) {
                if (typeof d.imagineMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.imagineMetadata: object expected");
                m.imagineMetadata = $root.proto.BotImagineMetadata.fromObject(d.imagineMetadata);
            }
            if (d.memoryMetadata != null) {
                if (typeof d.memoryMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.memoryMetadata: object expected");
                m.memoryMetadata = $root.proto.BotMemoryMetadata.fromObject(d.memoryMetadata);
            }
            if (d.renderingMetadata != null) {
                if (typeof d.renderingMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.renderingMetadata: object expected");
                m.renderingMetadata = $root.proto.BotRenderingMetadata.fromObject(d.renderingMetadata);
            }
            if (d.botMetricsMetadata != null) {
                if (typeof d.botMetricsMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botMetricsMetadata: object expected");
                m.botMetricsMetadata = $root.proto.BotMetricsMetadata.fromObject(d.botMetricsMetadata);
            }
            if (d.botLinkedAccountsMetadata != null) {
                if (typeof d.botLinkedAccountsMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botLinkedAccountsMetadata: object expected");
                m.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.fromObject(d.botLinkedAccountsMetadata);
            }
            if (d.richResponseSourcesMetadata != null) {
                if (typeof d.richResponseSourcesMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.richResponseSourcesMetadata: object expected");
                m.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.fromObject(d.richResponseSourcesMetadata);
            }
            if (d.aiConversationContext != null) {
                if (typeof d.aiConversationContext === "string")
                    $util.base64.decode(d.aiConversationContext, m.aiConversationContext = $util.newBuffer($util.base64.length(d.aiConversationContext)), 0);
                else if (d.aiConversationContext.length >= 0)
                    m.aiConversationContext = d.aiConversationContext;
            }
            if (d.botPromotionMessageMetadata != null) {
                if (typeof d.botPromotionMessageMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botPromotionMessageMetadata: object expected");
                m.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.fromObject(d.botPromotionMessageMetadata);
            }
            if (d.botModeSelectionMetadata != null) {
                if (typeof d.botModeSelectionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botModeSelectionMetadata: object expected");
                m.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.fromObject(d.botModeSelectionMetadata);
            }
            if (d.botQuotaMetadata != null) {
                if (typeof d.botQuotaMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botQuotaMetadata: object expected");
                m.botQuotaMetadata = $root.proto.BotQuotaMetadata.fromObject(d.botQuotaMetadata);
            }
            if (d.botAgeCollectionMetadata != null) {
                if (typeof d.botAgeCollectionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botAgeCollectionMetadata: object expected");
                m.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.fromObject(d.botAgeCollectionMetadata);
            }
            return m;
        };

        BotMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.avatarMetadata != null && m.hasOwnProperty("avatarMetadata")) {
                d.avatarMetadata = $root.proto.BotAvatarMetadata.toObject(m.avatarMetadata, o);
                if (o.oneofs)
                    d._avatarMetadata = "avatarMetadata";
            }
            if (m.personaId != null && m.hasOwnProperty("personaId")) {
                d.personaId = m.personaId;
                if (o.oneofs)
                    d._personaId = "personaId";
            }
            if (m.pluginMetadata != null && m.hasOwnProperty("pluginMetadata")) {
                d.pluginMetadata = $root.proto.BotPluginMetadata.toObject(m.pluginMetadata, o);
                if (o.oneofs)
                    d._pluginMetadata = "pluginMetadata";
            }
            if (m.suggestedPromptMetadata != null && m.hasOwnProperty("suggestedPromptMetadata")) {
                d.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.toObject(m.suggestedPromptMetadata, o);
                if (o.oneofs)
                    d._suggestedPromptMetadata = "suggestedPromptMetadata";
            }
            if (m.invokerJid != null && m.hasOwnProperty("invokerJid")) {
                d.invokerJid = m.invokerJid;
                if (o.oneofs)
                    d._invokerJid = "invokerJid";
            }
            if (m.sessionMetadata != null && m.hasOwnProperty("sessionMetadata")) {
                d.sessionMetadata = $root.proto.BotSessionMetadata.toObject(m.sessionMetadata, o);
                if (o.oneofs)
                    d._sessionMetadata = "sessionMetadata";
            }
            if (m.memuMetadata != null && m.hasOwnProperty("memuMetadata")) {
                d.memuMetadata = $root.proto.BotMemuMetadata.toObject(m.memuMetadata, o);
                if (o.oneofs)
                    d._memuMetadata = "memuMetadata";
            }
            if (m.timezone != null && m.hasOwnProperty("timezone")) {
                d.timezone = m.timezone;
                if (o.oneofs)
                    d._timezone = "timezone";
            }
            if (m.reminderMetadata != null && m.hasOwnProperty("reminderMetadata")) {
                d.reminderMetadata = $root.proto.BotReminderMetadata.toObject(m.reminderMetadata, o);
                if (o.oneofs)
                    d._reminderMetadata = "reminderMetadata";
            }
            if (m.modelMetadata != null && m.hasOwnProperty("modelMetadata")) {
                d.modelMetadata = $root.proto.BotModelMetadata.toObject(m.modelMetadata, o);
                if (o.oneofs)
                    d._modelMetadata = "modelMetadata";
            }
            if (m.messageDisclaimerText != null && m.hasOwnProperty("messageDisclaimerText")) {
                d.messageDisclaimerText = m.messageDisclaimerText;
                if (o.oneofs)
                    d._messageDisclaimerText = "messageDisclaimerText";
            }
            if (m.progressIndicatorMetadata != null && m.hasOwnProperty("progressIndicatorMetadata")) {
                d.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.toObject(m.progressIndicatorMetadata, o);
                if (o.oneofs)
                    d._progressIndicatorMetadata = "progressIndicatorMetadata";
            }
            if (m.capabilityMetadata != null && m.hasOwnProperty("capabilityMetadata")) {
                d.capabilityMetadata = $root.proto.BotCapabilityMetadata.toObject(m.capabilityMetadata, o);
                if (o.oneofs)
                    d._capabilityMetadata = "capabilityMetadata";
            }
            if (m.imagineMetadata != null && m.hasOwnProperty("imagineMetadata")) {
                d.imagineMetadata = $root.proto.BotImagineMetadata.toObject(m.imagineMetadata, o);
                if (o.oneofs)
                    d._imagineMetadata = "imagineMetadata";
            }
            if (m.memoryMetadata != null && m.hasOwnProperty("memoryMetadata")) {
                d.memoryMetadata = $root.proto.BotMemoryMetadata.toObject(m.memoryMetadata, o);
                if (o.oneofs)
                    d._memoryMetadata = "memoryMetadata";
            }
            if (m.renderingMetadata != null && m.hasOwnProperty("renderingMetadata")) {
                d.renderingMetadata = $root.proto.BotRenderingMetadata.toObject(m.renderingMetadata, o);
                if (o.oneofs)
                    d._renderingMetadata = "renderingMetadata";
            }
            if (m.botMetricsMetadata != null && m.hasOwnProperty("botMetricsMetadata")) {
                d.botMetricsMetadata = $root.proto.BotMetricsMetadata.toObject(m.botMetricsMetadata, o);
                if (o.oneofs)
                    d._botMetricsMetadata = "botMetricsMetadata";
            }
            if (m.botLinkedAccountsMetadata != null && m.hasOwnProperty("botLinkedAccountsMetadata")) {
                d.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.toObject(m.botLinkedAccountsMetadata, o);
                if (o.oneofs)
                    d._botLinkedAccountsMetadata = "botLinkedAccountsMetadata";
            }
            if (m.richResponseSourcesMetadata != null && m.hasOwnProperty("richResponseSourcesMetadata")) {
                d.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.toObject(m.richResponseSourcesMetadata, o);
                if (o.oneofs)
                    d._richResponseSourcesMetadata = "richResponseSourcesMetadata";
            }
            if (m.aiConversationContext != null && m.hasOwnProperty("aiConversationContext")) {
                d.aiConversationContext = o.bytes === String ? $util.base64.encode(m.aiConversationContext, 0, m.aiConversationContext.length) : o.bytes === Array ? Array.prototype.slice.call(m.aiConversationContext) : m.aiConversationContext;
                if (o.oneofs)
                    d._aiConversationContext = "aiConversationContext";
            }
            if (m.botPromotionMessageMetadata != null && m.hasOwnProperty("botPromotionMessageMetadata")) {
                d.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.toObject(m.botPromotionMessageMetadata, o);
                if (o.oneofs)
                    d._botPromotionMessageMetadata = "botPromotionMessageMetadata";
            }
            if (m.botModeSelectionMetadata != null && m.hasOwnProperty("botModeSelectionMetadata")) {
                d.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.toObject(m.botModeSelectionMetadata, o);
                if (o.oneofs)
                    d._botModeSelectionMetadata = "botModeSelectionMetadata";
            }
            if (m.botQuotaMetadata != null && m.hasOwnProperty("botQuotaMetadata")) {
                d.botQuotaMetadata = $root.proto.BotQuotaMetadata.toObject(m.botQuotaMetadata, o);
                if (o.oneofs)
                    d._botQuotaMetadata = "botQuotaMetadata";
            }
            if (m.botAgeCollectionMetadata != null && m.hasOwnProperty("botAgeCollectionMetadata")) {
                d.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.toObject(m.botAgeCollectionMetadata, o);
                if (o.oneofs)
                    d._botAgeCollectionMetadata = "botAgeCollectionMetadata";
            }
            return d;
        };

        BotMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetadata";
        };

        return BotMetadata;
    })();

    proto.BotMetricsEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "FAVICON"] = 1;
        values[valuesById[2] = "CHATLIST"] = 2;
        values[valuesById[3] = "AISEARCH_NULL_STATE_PAPER_PLANE"] = 3;
        values[valuesById[4] = "AISEARCH_NULL_STATE_SUGGESTION"] = 4;
        values[valuesById[5] = "AISEARCH_TYPE_AHEAD_SUGGESTION"] = 5;
        values[valuesById[6] = "AISEARCH_TYPE_AHEAD_PAPER_PLANE"] = 6;
        values[valuesById[7] = "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST"] = 7;
        values[valuesById[8] = "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES"] = 8;
        values[valuesById[9] = "AIVOICE_SEARCH_BAR"] = 9;
        values[valuesById[10] = "AIVOICE_FAVICON"] = 10;
        values[valuesById[11] = "AISTUDIO"] = 11;
        values[valuesById[12] = "DEEPLINK"] = 12;
        values[valuesById[13] = "NOTIFICATION"] = 13;
        values[valuesById[14] = "PROFILE_MESSAGE_BUTTON"] = 14;
        values[valuesById[15] = "FORWARD"] = 15;
        values[valuesById[16] = "APP_SHORTCUT"] = 16;
        values[valuesById[17] = "FF_FAMILY"] = 17;
        values[valuesById[18] = "AI_TAB"] = 18;
        values[valuesById[19] = "AI_HOME"] = 19;
        values[valuesById[20] = "AI_DEEPLINK_IMMERSIVE"] = 20;
        values[valuesById[21] = "AI_DEEPLINK"] = 21;
        values[valuesById[22] = "META_AI_CHAT_SHORTCUT_AI_STUDIO"] = 22;
        values[valuesById[23] = "UGC_CHAT_SHORTCUT_AI_STUDIO"] = 23;
        values[valuesById[24] = "NEW_CHAT_AI_STUDIO"] = 24;
        return values;
    })();

    proto.BotMetricsMetadata = (function() {

        function BotMetricsMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMetricsMetadata.prototype.destinationId = null;
        BotMetricsMetadata.prototype.destinationEntryPoint = null;
        BotMetricsMetadata.prototype.threadOrigin = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_destinationId", {
            get: $util.oneOfGetter($oneOfFields = ["destinationId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_destinationEntryPoint", {
            get: $util.oneOfGetter($oneOfFields = ["destinationEntryPoint"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_threadOrigin", {
            get: $util.oneOfGetter($oneOfFields = ["threadOrigin"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotMetricsMetadata.create = function create(properties) {
            return new BotMetricsMetadata(properties);
        };

        BotMetricsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.destinationId != null && Object.hasOwnProperty.call(m, "destinationId"))
                w.uint32(10).string(m.destinationId);
            if (m.destinationEntryPoint != null && Object.hasOwnProperty.call(m, "destinationEntryPoint"))
                w.uint32(16).int32(m.destinationEntryPoint);
            if (m.threadOrigin != null && Object.hasOwnProperty.call(m, "threadOrigin"))
                w.uint32(24).int32(m.threadOrigin);
            return w;
        };

        BotMetricsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMetricsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.destinationId = r.string();
                        break;
                    }
                case 2: {
                        m.destinationEntryPoint = r.int32();
                        break;
                    }
                case 3: {
                        m.threadOrigin = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMetricsMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotMetricsMetadata)
                return d;
            var m = new $root.proto.BotMetricsMetadata();
            if (d.destinationId != null) {
                m.destinationId = String(d.destinationId);
            }
            switch (d.destinationEntryPoint) {
            default:
                if (typeof d.destinationEntryPoint === "number") {
                    m.destinationEntryPoint = d.destinationEntryPoint;
                    break;
                }
                break;
            case "FAVICON":
            case 1:
                m.destinationEntryPoint = 1;
                break;
            case "CHATLIST":
            case 2:
                m.destinationEntryPoint = 2;
                break;
            case "AISEARCH_NULL_STATE_PAPER_PLANE":
            case 3:
                m.destinationEntryPoint = 3;
                break;
            case "AISEARCH_NULL_STATE_SUGGESTION":
            case 4:
                m.destinationEntryPoint = 4;
                break;
            case "AISEARCH_TYPE_AHEAD_SUGGESTION":
            case 5:
                m.destinationEntryPoint = 5;
                break;
            case "AISEARCH_TYPE_AHEAD_PAPER_PLANE":
            case 6:
                m.destinationEntryPoint = 6;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST":
            case 7:
                m.destinationEntryPoint = 7;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES":
            case 8:
                m.destinationEntryPoint = 8;
                break;
            case "AIVOICE_SEARCH_BAR":
            case 9:
                m.destinationEntryPoint = 9;
                break;
            case "AIVOICE_FAVICON":
            case 10:
                m.destinationEntryPoint = 10;
                break;
            case "AISTUDIO":
            case 11:
                m.destinationEntryPoint = 11;
                break;
            case "DEEPLINK":
            case 12:
                m.destinationEntryPoint = 12;
                break;
            case "NOTIFICATION":
            case 13:
                m.destinationEntryPoint = 13;
                break;
            case "PROFILE_MESSAGE_BUTTON":
            case 14:
                m.destinationEntryPoint = 14;
                break;
            case "FORWARD":
            case 15:
                m.destinationEntryPoint = 15;
                break;
            case "APP_SHORTCUT":
            case 16:
                m.destinationEntryPoint = 16;
                break;
            case "FF_FAMILY":
            case 17:
                m.destinationEntryPoint = 17;
                break;
            case "AI_TAB":
            case 18:
                m.destinationEntryPoint = 18;
                break;
            case "AI_HOME":
            case 19:
                m.destinationEntryPoint = 19;
                break;
            case "AI_DEEPLINK_IMMERSIVE":
            case 20:
                m.destinationEntryPoint = 20;
                break;
            case "AI_DEEPLINK":
            case 21:
                m.destinationEntryPoint = 21;
                break;
            case "META_AI_CHAT_SHORTCUT_AI_STUDIO":
            case 22:
                m.destinationEntryPoint = 22;
                break;
            case "UGC_CHAT_SHORTCUT_AI_STUDIO":
            case 23:
                m.destinationEntryPoint = 23;
                break;
            case "NEW_CHAT_AI_STUDIO":
            case 24:
                m.destinationEntryPoint = 24;
                break;
            }
            switch (d.threadOrigin) {
            default:
                if (typeof d.threadOrigin === "number") {
                    m.threadOrigin = d.threadOrigin;
                    break;
                }
                break;
            case "AI_TAB_THREAD":
            case 1:
                m.threadOrigin = 1;
                break;
            case "AI_HOME_THREAD":
            case 2:
                m.threadOrigin = 2;
                break;
            case "AI_DEEPLINK_IMMERSIVE_THREAD":
            case 3:
                m.threadOrigin = 3;
                break;
            case "AI_DEEPLINK_THREAD":
            case 4:
                m.threadOrigin = 4;
                break;
            }
            return m;
        };

        BotMetricsMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.destinationId != null && m.hasOwnProperty("destinationId")) {
                d.destinationId = m.destinationId;
                if (o.oneofs)
                    d._destinationId = "destinationId";
            }
            if (m.destinationEntryPoint != null && m.hasOwnProperty("destinationEntryPoint")) {
                d.destinationEntryPoint = o.enums === String ? $root.proto.BotMetricsEntryPoint[m.destinationEntryPoint] === undefined ? m.destinationEntryPoint : $root.proto.BotMetricsEntryPoint[m.destinationEntryPoint] : m.destinationEntryPoint;
                if (o.oneofs)
                    d._destinationEntryPoint = "destinationEntryPoint";
            }
            if (m.threadOrigin != null && m.hasOwnProperty("threadOrigin")) {
                d.threadOrigin = o.enums === String ? $root.proto.BotMetricsThreadEntryPoint[m.threadOrigin] === undefined ? m.threadOrigin : $root.proto.BotMetricsThreadEntryPoint[m.threadOrigin] : m.threadOrigin;
                if (o.oneofs)
                    d._threadOrigin = "threadOrigin";
            }
            return d;
        };

        BotMetricsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotMetricsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetricsMetadata";
        };

        return BotMetricsMetadata;
    })();

    proto.BotMetricsThreadEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "AI_TAB_THREAD"] = 1;
        values[valuesById[2] = "AI_HOME_THREAD"] = 2;
        values[valuesById[3] = "AI_DEEPLINK_IMMERSIVE_THREAD"] = 3;
        values[valuesById[4] = "AI_DEEPLINK_THREAD"] = 4;
        return values;
    })();

    proto.BotModeSelectionMetadata = (function() {

        function BotModeSelectionMetadata(p) {
            this.mode = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotModeSelectionMetadata.prototype.mode = $util.emptyArray;

        BotModeSelectionMetadata.create = function create(properties) {
            return new BotModeSelectionMetadata(properties);
        };

        BotModeSelectionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.mode != null && m.mode.length) {
                w.uint32(10).fork();
                for (var i = 0; i < m.mode.length; ++i)
                    w.int32(m.mode[i]);
                w.ldelim();
            }
            return w;
        };

        BotModeSelectionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotModeSelectionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.mode && m.mode.length))
                            m.mode = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.mode.push(r.int32());
                        } else
                            m.mode.push(r.int32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotModeSelectionMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotModeSelectionMetadata)
                return d;
            var m = new $root.proto.BotModeSelectionMetadata();
            if (d.mode) {
                if (!Array.isArray(d.mode))
                    throw TypeError(".proto.BotModeSelectionMetadata.mode: array expected");
                m.mode = [];
                for (var i = 0; i < d.mode.length; ++i) {
                    switch (d.mode[i]) {
                    default:
                        if (typeof d.mode[i] === "number") {
                            m.mode[i] = d.mode[i];
                            break;
                        }
                    case "UNKNOWN_MODE":
                    case 0:
                        m.mode[i] = 0;
                        break;
                    case "REASONING_MODE":
                    case 1:
                        m.mode[i] = 1;
                        break;
                    }
                }
            }
            return m;
        };

        BotModeSelectionMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.mode = [];
            }
            if (m.mode && m.mode.length) {
                d.mode = [];
                for (var j = 0; j < m.mode.length; ++j) {
                    d.mode[j] = o.enums === String ? $root.proto.BotModeSelectionMetadata.BotUserSelectionMode[m.mode[j]] === undefined ? m.mode[j] : $root.proto.BotModeSelectionMetadata.BotUserSelectionMode[m.mode[j]] : m.mode[j];
                }
            }
            return d;
        };

        BotModeSelectionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotModeSelectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModeSelectionMetadata";
        };

        BotModeSelectionMetadata.BotUserSelectionMode = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_MODE"] = 0;
            values[valuesById[1] = "REASONING_MODE"] = 1;
            return values;
        })();

        return BotModeSelectionMetadata;
    })();

    proto.BotModelMetadata = (function() {

        function BotModelMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotModelMetadata.prototype.modelType = null;
        BotModelMetadata.prototype.premiumModelStatus = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_modelType", {
            get: $util.oneOfGetter($oneOfFields = ["modelType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_premiumModelStatus", {
            get: $util.oneOfGetter($oneOfFields = ["premiumModelStatus"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotModelMetadata.create = function create(properties) {
            return new BotModelMetadata(properties);
        };

        BotModelMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.modelType != null && Object.hasOwnProperty.call(m, "modelType"))
                w.uint32(8).int32(m.modelType);
            if (m.premiumModelStatus != null && Object.hasOwnProperty.call(m, "premiumModelStatus"))
                w.uint32(16).int32(m.premiumModelStatus);
            return w;
        };

        BotModelMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotModelMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.modelType = r.int32();
                        break;
                    }
                case 2: {
                        m.premiumModelStatus = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotModelMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotModelMetadata)
                return d;
            var m = new $root.proto.BotModelMetadata();
            switch (d.modelType) {
            default:
                if (typeof d.modelType === "number") {
                    m.modelType = d.modelType;
                    break;
                }
                break;
            case "UNKNOWN_TYPE":
            case 0:
                m.modelType = 0;
                break;
            case "LLAMA_PROD":
            case 1:
                m.modelType = 1;
                break;
            case "LLAMA_PROD_PREMIUM":
            case 2:
                m.modelType = 2;
                break;
            }
            switch (d.premiumModelStatus) {
            default:
                if (typeof d.premiumModelStatus === "number") {
                    m.premiumModelStatus = d.premiumModelStatus;
                    break;
                }
                break;
            case "UNKNOWN_STATUS":
            case 0:
                m.premiumModelStatus = 0;
                break;
            case "AVAILABLE":
            case 1:
                m.premiumModelStatus = 1;
                break;
            case "QUOTA_EXCEED_LIMIT":
            case 2:
                m.premiumModelStatus = 2;
                break;
            }
            return m;
        };

        BotModelMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.modelType != null && m.hasOwnProperty("modelType")) {
                d.modelType = o.enums === String ? $root.proto.BotModelMetadata.ModelType[m.modelType] === undefined ? m.modelType : $root.proto.BotModelMetadata.ModelType[m.modelType] : m.modelType;
                if (o.oneofs)
                    d._modelType = "modelType";
            }
            if (m.premiumModelStatus != null && m.hasOwnProperty("premiumModelStatus")) {
                d.premiumModelStatus = o.enums === String ? $root.proto.BotModelMetadata.PremiumModelStatus[m.premiumModelStatus] === undefined ? m.premiumModelStatus : $root.proto.BotModelMetadata.PremiumModelStatus[m.premiumModelStatus] : m.premiumModelStatus;
                if (o.oneofs)
                    d._premiumModelStatus = "premiumModelStatus";
            }
            return d;
        };

        BotModelMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotModelMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModelMetadata";
        };

        BotModelMetadata.ModelType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "LLAMA_PROD"] = 1;
            values[valuesById[2] = "LLAMA_PROD_PREMIUM"] = 2;
            return values;
        })();

        BotModelMetadata.PremiumModelStatus = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_STATUS"] = 0;
            values[valuesById[1] = "AVAILABLE"] = 1;
            values[valuesById[2] = "QUOTA_EXCEED_LIMIT"] = 2;
            return values;
        })();

        return BotModelMetadata;
    })();

    proto.BotPluginMetadata = (function() {

        function BotPluginMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPluginMetadata.prototype.provider = null;
        BotPluginMetadata.prototype.pluginType = null;
        BotPluginMetadata.prototype.thumbnailCdnUrl = null;
        BotPluginMetadata.prototype.profilePhotoCdnUrl = null;
        BotPluginMetadata.prototype.searchProviderUrl = null;
        BotPluginMetadata.prototype.referenceIndex = null;
        BotPluginMetadata.prototype.expectedLinksCount = null;
        BotPluginMetadata.prototype.searchQuery = null;
        BotPluginMetadata.prototype.parentPluginMessageKey = null;
        BotPluginMetadata.prototype.deprecatedField = null;
        BotPluginMetadata.prototype.parentPluginType = null;
        BotPluginMetadata.prototype.faviconCdnUrl = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_provider", {
            get: $util.oneOfGetter($oneOfFields = ["provider"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_pluginType", {
            get: $util.oneOfGetter($oneOfFields = ["pluginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_thumbnailCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["thumbnailCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_profilePhotoCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["profilePhotoCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_searchProviderUrl", {
            get: $util.oneOfGetter($oneOfFields = ["searchProviderUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_referenceIndex", {
            get: $util.oneOfGetter($oneOfFields = ["referenceIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_expectedLinksCount", {
            get: $util.oneOfGetter($oneOfFields = ["expectedLinksCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_searchQuery", {
            get: $util.oneOfGetter($oneOfFields = ["searchQuery"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_parentPluginMessageKey", {
            get: $util.oneOfGetter($oneOfFields = ["parentPluginMessageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_deprecatedField", {
            get: $util.oneOfGetter($oneOfFields = ["deprecatedField"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_parentPluginType", {
            get: $util.oneOfGetter($oneOfFields = ["parentPluginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_faviconCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["faviconCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotPluginMetadata.create = function create(properties) {
            return new BotPluginMetadata(properties);
        };

        BotPluginMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                w.uint32(8).int32(m.provider);
            if (m.pluginType != null && Object.hasOwnProperty.call(m, "pluginType"))
                w.uint32(16).int32(m.pluginType);
            if (m.thumbnailCdnUrl != null && Object.hasOwnProperty.call(m, "thumbnailCdnUrl"))
                w.uint32(26).string(m.thumbnailCdnUrl);
            if (m.profilePhotoCdnUrl != null && Object.hasOwnProperty.call(m, "profilePhotoCdnUrl"))
                w.uint32(34).string(m.profilePhotoCdnUrl);
            if (m.searchProviderUrl != null && Object.hasOwnProperty.call(m, "searchProviderUrl"))
                w.uint32(42).string(m.searchProviderUrl);
            if (m.referenceIndex != null && Object.hasOwnProperty.call(m, "referenceIndex"))
                w.uint32(48).uint32(m.referenceIndex);
            if (m.expectedLinksCount != null && Object.hasOwnProperty.call(m, "expectedLinksCount"))
                w.uint32(56).uint32(m.expectedLinksCount);
            if (m.searchQuery != null && Object.hasOwnProperty.call(m, "searchQuery"))
                w.uint32(74).string(m.searchQuery);
            if (m.parentPluginMessageKey != null && Object.hasOwnProperty.call(m, "parentPluginMessageKey"))
                $root.proto.MessageKey.encode(m.parentPluginMessageKey, w.uint32(82).fork()).ldelim();
            if (m.deprecatedField != null && Object.hasOwnProperty.call(m, "deprecatedField"))
                w.uint32(88).int32(m.deprecatedField);
            if (m.parentPluginType != null && Object.hasOwnProperty.call(m, "parentPluginType"))
                w.uint32(96).int32(m.parentPluginType);
            if (m.faviconCdnUrl != null && Object.hasOwnProperty.call(m, "faviconCdnUrl"))
                w.uint32(106).string(m.faviconCdnUrl);
            return w;
        };

        BotPluginMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPluginMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.provider = r.int32();
                        break;
                    }
                case 2: {
                        m.pluginType = r.int32();
                        break;
                    }
                case 3: {
                        m.thumbnailCdnUrl = r.string();
                        break;
                    }
                case 4: {
                        m.profilePhotoCdnUrl = r.string();
                        break;
                    }
                case 5: {
                        m.searchProviderUrl = r.string();
                        break;
                    }
                case 6: {
                        m.referenceIndex = r.uint32();
                        break;
                    }
                case 7: {
                        m.expectedLinksCount = r.uint32();
                        break;
                    }
                case 9: {
                        m.searchQuery = r.string();
                        break;
                    }
                case 10: {
                        m.parentPluginMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.deprecatedField = r.int32();
                        break;
                    }
                case 12: {
                        m.parentPluginType = r.int32();
                        break;
                    }
                case 13: {
                        m.faviconCdnUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPluginMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPluginMetadata)
                return d;
            var m = new $root.proto.BotPluginMetadata();
            switch (d.provider) {
            default:
                if (typeof d.provider === "number") {
                    m.provider = d.provider;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.provider = 0;
                break;
            case "BING":
            case 1:
                m.provider = 1;
                break;
            case "GOOGLE":
            case 2:
                m.provider = 2;
                break;
            case "SUPPORT":
            case 3:
                m.provider = 3;
                break;
            }
            switch (d.pluginType) {
            default:
                if (typeof d.pluginType === "number") {
                    m.pluginType = d.pluginType;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                m.pluginType = 0;
                break;
            case "REELS":
            case 1:
                m.pluginType = 1;
                break;
            case "SEARCH":
            case 2:
                m.pluginType = 2;
                break;
            }
            if (d.thumbnailCdnUrl != null) {
                m.thumbnailCdnUrl = String(d.thumbnailCdnUrl);
            }
            if (d.profilePhotoCdnUrl != null) {
                m.profilePhotoCdnUrl = String(d.profilePhotoCdnUrl);
            }
            if (d.searchProviderUrl != null) {
                m.searchProviderUrl = String(d.searchProviderUrl);
            }
            if (d.referenceIndex != null) {
                m.referenceIndex = d.referenceIndex >>> 0;
            }
            if (d.expectedLinksCount != null) {
                m.expectedLinksCount = d.expectedLinksCount >>> 0;
            }
            if (d.searchQuery != null) {
                m.searchQuery = String(d.searchQuery);
            }
            if (d.parentPluginMessageKey != null) {
                if (typeof d.parentPluginMessageKey !== "object")
                    throw TypeError(".proto.BotPluginMetadata.parentPluginMessageKey: object expected");
                m.parentPluginMessageKey = $root.proto.MessageKey.fromObject(d.parentPluginMessageKey);
            }
            switch (d.deprecatedField) {
            default:
                if (typeof d.deprecatedField === "number") {
                    m.deprecatedField = d.deprecatedField;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                m.deprecatedField = 0;
                break;
            case "REELS":
            case 1:
                m.deprecatedField = 1;
                break;
            case "SEARCH":
            case 2:
                m.deprecatedField = 2;
                break;
            }
            switch (d.parentPluginType) {
            default:
                if (typeof d.parentPluginType === "number") {
                    m.parentPluginType = d.parentPluginType;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                m.parentPluginType = 0;
                break;
            case "REELS":
            case 1:
                m.parentPluginType = 1;
                break;
            case "SEARCH":
            case 2:
                m.parentPluginType = 2;
                break;
            }
            if (d.faviconCdnUrl != null) {
                m.faviconCdnUrl = String(d.faviconCdnUrl);
            }
            return m;
        };

        BotPluginMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.provider != null && m.hasOwnProperty("provider")) {
                d.provider = o.enums === String ? $root.proto.BotPluginMetadata.SearchProvider[m.provider] === undefined ? m.provider : $root.proto.BotPluginMetadata.SearchProvider[m.provider] : m.provider;
                if (o.oneofs)
                    d._provider = "provider";
            }
            if (m.pluginType != null && m.hasOwnProperty("pluginType")) {
                d.pluginType = o.enums === String ? $root.proto.BotPluginMetadata.PluginType[m.pluginType] === undefined ? m.pluginType : $root.proto.BotPluginMetadata.PluginType[m.pluginType] : m.pluginType;
                if (o.oneofs)
                    d._pluginType = "pluginType";
            }
            if (m.thumbnailCdnUrl != null && m.hasOwnProperty("thumbnailCdnUrl")) {
                d.thumbnailCdnUrl = m.thumbnailCdnUrl;
                if (o.oneofs)
                    d._thumbnailCdnUrl = "thumbnailCdnUrl";
            }
            if (m.profilePhotoCdnUrl != null && m.hasOwnProperty("profilePhotoCdnUrl")) {
                d.profilePhotoCdnUrl = m.profilePhotoCdnUrl;
                if (o.oneofs)
                    d._profilePhotoCdnUrl = "profilePhotoCdnUrl";
            }
            if (m.searchProviderUrl != null && m.hasOwnProperty("searchProviderUrl")) {
                d.searchProviderUrl = m.searchProviderUrl;
                if (o.oneofs)
                    d._searchProviderUrl = "searchProviderUrl";
            }
            if (m.referenceIndex != null && m.hasOwnProperty("referenceIndex")) {
                d.referenceIndex = m.referenceIndex;
                if (o.oneofs)
                    d._referenceIndex = "referenceIndex";
            }
            if (m.expectedLinksCount != null && m.hasOwnProperty("expectedLinksCount")) {
                d.expectedLinksCount = m.expectedLinksCount;
                if (o.oneofs)
                    d._expectedLinksCount = "expectedLinksCount";
            }
            if (m.searchQuery != null && m.hasOwnProperty("searchQuery")) {
                d.searchQuery = m.searchQuery;
                if (o.oneofs)
                    d._searchQuery = "searchQuery";
            }
            if (m.parentPluginMessageKey != null && m.hasOwnProperty("parentPluginMessageKey")) {
                d.parentPluginMessageKey = $root.proto.MessageKey.toObject(m.parentPluginMessageKey, o);
                if (o.oneofs)
                    d._parentPluginMessageKey = "parentPluginMessageKey";
            }
            if (m.deprecatedField != null && m.hasOwnProperty("deprecatedField")) {
                d.deprecatedField = o.enums === String ? $root.proto.BotPluginMetadata.PluginType[m.deprecatedField] === undefined ? m.deprecatedField : $root.proto.BotPluginMetadata.PluginType[m.deprecatedField] : m.deprecatedField;
                if (o.oneofs)
                    d._deprecatedField = "deprecatedField";
            }
            if (m.parentPluginType != null && m.hasOwnProperty("parentPluginType")) {
                d.parentPluginType = o.enums === String ? $root.proto.BotPluginMetadata.PluginType[m.parentPluginType] === undefined ? m.parentPluginType : $root.proto.BotPluginMetadata.PluginType[m.parentPluginType] : m.parentPluginType;
                if (o.oneofs)
                    d._parentPluginType = "parentPluginType";
            }
            if (m.faviconCdnUrl != null && m.hasOwnProperty("faviconCdnUrl")) {
                d.faviconCdnUrl = m.faviconCdnUrl;
                if (o.oneofs)
                    d._faviconCdnUrl = "faviconCdnUrl";
            }
            return d;
        };

        BotPluginMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPluginMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPluginMetadata";
        };

        BotPluginMetadata.PluginType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_PLUGIN"] = 0;
            values[valuesById[1] = "REELS"] = 1;
            values[valuesById[2] = "SEARCH"] = 2;
            return values;
        })();

        BotPluginMetadata.SearchProvider = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "BING"] = 1;
            values[valuesById[2] = "GOOGLE"] = 2;
            values[valuesById[3] = "SUPPORT"] = 3;
            return values;
        })();

        return BotPluginMetadata;
    })();

    proto.BotProgressIndicatorMetadata = (function() {

        function BotProgressIndicatorMetadata(p) {
            this.stepsMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotProgressIndicatorMetadata.prototype.progressDescription = null;
        BotProgressIndicatorMetadata.prototype.stepsMetadata = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotProgressIndicatorMetadata.prototype, "_progressDescription", {
            get: $util.oneOfGetter($oneOfFields = ["progressDescription"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotProgressIndicatorMetadata.create = function create(properties) {
            return new BotProgressIndicatorMetadata(properties);
        };

        BotProgressIndicatorMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.progressDescription != null && Object.hasOwnProperty.call(m, "progressDescription"))
                w.uint32(10).string(m.progressDescription);
            if (m.stepsMetadata != null && m.stepsMetadata.length) {
                for (var i = 0; i < m.stepsMetadata.length; ++i)
                    $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.encode(m.stepsMetadata[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        BotProgressIndicatorMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.progressDescription = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.stepsMetadata && m.stepsMetadata.length))
                            m.stepsMetadata = [];
                        m.stepsMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotProgressIndicatorMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotProgressIndicatorMetadata)
                return d;
            var m = new $root.proto.BotProgressIndicatorMetadata();
            if (d.progressDescription != null) {
                m.progressDescription = String(d.progressDescription);
            }
            if (d.stepsMetadata) {
                if (!Array.isArray(d.stepsMetadata))
                    throw TypeError(".proto.BotProgressIndicatorMetadata.stepsMetadata: array expected");
                m.stepsMetadata = [];
                for (var i = 0; i < d.stepsMetadata.length; ++i) {
                    if (typeof d.stepsMetadata[i] !== "object")
                        throw TypeError(".proto.BotProgressIndicatorMetadata.stepsMetadata: object expected");
                    m.stepsMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.fromObject(d.stepsMetadata[i]);
                }
            }
            return m;
        };

        BotProgressIndicatorMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.stepsMetadata = [];
            }
            if (m.progressDescription != null && m.hasOwnProperty("progressDescription")) {
                d.progressDescription = m.progressDescription;
                if (o.oneofs)
                    d._progressDescription = "progressDescription";
            }
            if (m.stepsMetadata && m.stepsMetadata.length) {
                d.stepsMetadata = [];
                for (var j = 0; j < m.stepsMetadata.length; ++j) {
                    d.stepsMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.toObject(m.stepsMetadata[j], o);
                }
            }
            return d;
        };

        BotProgressIndicatorMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotProgressIndicatorMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata";
        };

        BotProgressIndicatorMetadata.BotPlanningStepMetadata = (function() {

            function BotPlanningStepMetadata(p) {
                this.sourcesMetadata = [];
                this.sections = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotPlanningStepMetadata.prototype.statusTitle = null;
            BotPlanningStepMetadata.prototype.statusBody = null;
            BotPlanningStepMetadata.prototype.sourcesMetadata = $util.emptyArray;
            BotPlanningStepMetadata.prototype.status = null;
            BotPlanningStepMetadata.prototype.isReasoning = null;
            BotPlanningStepMetadata.prototype.isEnhancedSearch = null;
            BotPlanningStepMetadata.prototype.sections = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_statusTitle", {
                get: $util.oneOfGetter($oneOfFields = ["statusTitle"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_statusBody", {
                get: $util.oneOfGetter($oneOfFields = ["statusBody"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_status", {
                get: $util.oneOfGetter($oneOfFields = ["status"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_isReasoning", {
                get: $util.oneOfGetter($oneOfFields = ["isReasoning"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_isEnhancedSearch", {
                get: $util.oneOfGetter($oneOfFields = ["isEnhancedSearch"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BotPlanningStepMetadata.create = function create(properties) {
                return new BotPlanningStepMetadata(properties);
            };

            BotPlanningStepMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.statusTitle != null && Object.hasOwnProperty.call(m, "statusTitle"))
                    w.uint32(10).string(m.statusTitle);
                if (m.statusBody != null && Object.hasOwnProperty.call(m, "statusBody"))
                    w.uint32(18).string(m.statusBody);
                if (m.sourcesMetadata != null && m.sourcesMetadata.length) {
                    for (var i = 0; i < m.sourcesMetadata.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.encode(m.sourcesMetadata[i], w.uint32(26).fork()).ldelim();
                }
                if (m.status != null && Object.hasOwnProperty.call(m, "status"))
                    w.uint32(32).int32(m.status);
                if (m.isReasoning != null && Object.hasOwnProperty.call(m, "isReasoning"))
                    w.uint32(40).bool(m.isReasoning);
                if (m.isEnhancedSearch != null && Object.hasOwnProperty.call(m, "isEnhancedSearch"))
                    w.uint32(48).bool(m.isEnhancedSearch);
                if (m.sections != null && m.sections.length) {
                    for (var i = 0; i < m.sections.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.encode(m.sections[i], w.uint32(58).fork()).ldelim();
                }
                return w;
            };

            BotPlanningStepMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.statusTitle = r.string();
                            break;
                        }
                    case 2: {
                            m.statusBody = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.sourcesMetadata && m.sourcesMetadata.length))
                                m.sourcesMetadata = [];
                            m.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.decode(r, r.uint32()));
                            break;
                        }
                    case 4: {
                            m.status = r.int32();
                            break;
                        }
                    case 5: {
                            m.isReasoning = r.bool();
                            break;
                        }
                    case 6: {
                            m.isEnhancedSearch = r.bool();
                            break;
                        }
                    case 7: {
                            if (!(m.sections && m.sections.length))
                                m.sections = [];
                            m.sections.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotPlanningStepMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata)
                    return d;
                var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                if (d.statusTitle != null) {
                    m.statusTitle = String(d.statusTitle);
                }
                if (d.statusBody != null) {
                    m.statusBody = String(d.statusBody);
                }
                if (d.sourcesMetadata) {
                    if (!Array.isArray(d.sourcesMetadata))
                        throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sourcesMetadata: array expected");
                    m.sourcesMetadata = [];
                    for (var i = 0; i < d.sourcesMetadata.length; ++i) {
                        if (typeof d.sourcesMetadata[i] !== "object")
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sourcesMetadata: object expected");
                        m.sourcesMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.fromObject(d.sourcesMetadata[i]);
                    }
                }
                switch (d.status) {
                default:
                    if (typeof d.status === "number") {
                        m.status = d.status;
                        break;
                    }
                    break;
                case "UNKNOWN":
                case 0:
                    m.status = 0;
                    break;
                case "PLANNED":
                case 1:
                    m.status = 1;
                    break;
                case "EXECUTING":
                case 2:
                    m.status = 2;
                    break;
                case "FINISHED":
                case 3:
                    m.status = 3;
                    break;
                }
                if (d.isReasoning != null) {
                    m.isReasoning = Boolean(d.isReasoning);
                }
                if (d.isEnhancedSearch != null) {
                    m.isEnhancedSearch = Boolean(d.isEnhancedSearch);
                }
                if (d.sections) {
                    if (!Array.isArray(d.sections))
                        throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sections: array expected");
                    m.sections = [];
                    for (var i = 0; i < d.sections.length; ++i) {
                        if (typeof d.sections[i] !== "object")
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sections: object expected");
                        m.sections[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.fromObject(d.sections[i]);
                    }
                }
                return m;
            };

            BotPlanningStepMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.sourcesMetadata = [];
                    d.sections = [];
                }
                if (m.statusTitle != null && m.hasOwnProperty("statusTitle")) {
                    d.statusTitle = m.statusTitle;
                    if (o.oneofs)
                        d._statusTitle = "statusTitle";
                }
                if (m.statusBody != null && m.hasOwnProperty("statusBody")) {
                    d.statusBody = m.statusBody;
                    if (o.oneofs)
                        d._statusBody = "statusBody";
                }
                if (m.sourcesMetadata && m.sourcesMetadata.length) {
                    d.sourcesMetadata = [];
                    for (var j = 0; j < m.sourcesMetadata.length; ++j) {
                        d.sourcesMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.toObject(m.sourcesMetadata[j], o);
                    }
                }
                if (m.status != null && m.hasOwnProperty("status")) {
                    d.status = o.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus[m.status] === undefined ? m.status : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus[m.status] : m.status;
                    if (o.oneofs)
                        d._status = "status";
                }
                if (m.isReasoning != null && m.hasOwnProperty("isReasoning")) {
                    d.isReasoning = m.isReasoning;
                    if (o.oneofs)
                        d._isReasoning = "isReasoning";
                }
                if (m.isEnhancedSearch != null && m.hasOwnProperty("isEnhancedSearch")) {
                    d.isEnhancedSearch = m.isEnhancedSearch;
                    if (o.oneofs)
                        d._isEnhancedSearch = "isEnhancedSearch";
                }
                if (m.sections && m.sections.length) {
                    d.sections = [];
                    for (var j = 0; j < m.sections.length; ++j) {
                        d.sections[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.toObject(m.sections[j], o);
                    }
                }
                return d;
            };

            BotPlanningStepMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BotPlanningStepMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata";
            };

            BotPlanningStepMetadata.BotPlanningSearchSourceMetadata = (function() {

                function BotPlanningSearchSourceMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningSearchSourceMetadata.prototype.title = null;
                BotPlanningSearchSourceMetadata.prototype.provider = null;
                BotPlanningSearchSourceMetadata.prototype.sourceUrl = null;
                BotPlanningSearchSourceMetadata.prototype.favIconUrl = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_provider", {
                    get: $util.oneOfGetter($oneOfFields = ["provider"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_favIconUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["favIconUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                BotPlanningSearchSourceMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourceMetadata(properties);
                };

                BotPlanningSearchSourceMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                        w.uint32(16).int32(m.provider);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    if (m.favIconUrl != null && Object.hasOwnProperty.call(m, "favIconUrl"))
                        w.uint32(34).string(m.favIconUrl);
                    return w;
                };

                BotPlanningSearchSourceMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.provider = r.int32();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.favIconUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningSearchSourceMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata)
                        return d;
                    var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    if (d.title != null) {
                        m.title = String(d.title);
                    }
                    switch (d.provider) {
                    default:
                        if (typeof d.provider === "number") {
                            m.provider = d.provider;
                            break;
                        }
                        break;
                    case "UNKNOWN_PROVIDER":
                    case 0:
                        m.provider = 0;
                        break;
                    case "OTHER":
                    case 1:
                        m.provider = 1;
                        break;
                    case "GOOGLE":
                    case 2:
                        m.provider = 2;
                        break;
                    case "BING":
                    case 3:
                        m.provider = 3;
                        break;
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    if (d.favIconUrl != null) {
                        m.favIconUrl = String(d.favIconUrl);
                    }
                    return m;
                };

                BotPlanningSearchSourceMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.title != null && m.hasOwnProperty("title")) {
                        d.title = m.title;
                        if (o.oneofs)
                            d._title = "title";
                    }
                    if (m.provider != null && m.hasOwnProperty("provider")) {
                        d.provider = o.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider[m.provider] === undefined ? m.provider : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider[m.provider] : m.provider;
                        if (o.oneofs)
                            d._provider = "provider";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    if (m.favIconUrl != null && m.hasOwnProperty("favIconUrl")) {
                        d.favIconUrl = m.favIconUrl;
                        if (o.oneofs)
                            d._favIconUrl = "favIconUrl";
                    }
                    return d;
                };

                BotPlanningSearchSourceMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                BotPlanningSearchSourceMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata";
                };

                return BotPlanningSearchSourceMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata = (function() {

                function BotPlanningSearchSourcesMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningSearchSourcesMetadata.prototype.sourceTitle = null;
                BotPlanningSearchSourcesMetadata.prototype.provider = null;
                BotPlanningSearchSourcesMetadata.prototype.sourceUrl = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_sourceTitle", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceTitle"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_provider", {
                    get: $util.oneOfGetter($oneOfFields = ["provider"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                BotPlanningSearchSourcesMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourcesMetadata(properties);
                };

                BotPlanningSearchSourcesMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.sourceTitle != null && Object.hasOwnProperty.call(m, "sourceTitle"))
                        w.uint32(10).string(m.sourceTitle);
                    if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                        w.uint32(16).int32(m.provider);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    return w;
                };

                BotPlanningSearchSourcesMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.sourceTitle = r.string();
                                break;
                            }
                        case 2: {
                                m.provider = r.int32();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningSearchSourcesMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata)
                        return d;
                    var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    if (d.sourceTitle != null) {
                        m.sourceTitle = String(d.sourceTitle);
                    }
                    switch (d.provider) {
                    default:
                        if (typeof d.provider === "number") {
                            m.provider = d.provider;
                            break;
                        }
                        break;
                    case "UNKNOWN":
                    case 0:
                        m.provider = 0;
                        break;
                    case "OTHER":
                    case 1:
                        m.provider = 1;
                        break;
                    case "GOOGLE":
                    case 2:
                        m.provider = 2;
                        break;
                    case "BING":
                    case 3:
                        m.provider = 3;
                        break;
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    return m;
                };

                BotPlanningSearchSourcesMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.sourceTitle != null && m.hasOwnProperty("sourceTitle")) {
                        d.sourceTitle = m.sourceTitle;
                        if (o.oneofs)
                            d._sourceTitle = "sourceTitle";
                    }
                    if (m.provider != null && m.hasOwnProperty("provider")) {
                        d.provider = o.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider[m.provider] === undefined ? m.provider : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider[m.provider] : m.provider;
                        if (o.oneofs)
                            d._provider = "provider";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    return d;
                };

                BotPlanningSearchSourcesMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                BotPlanningSearchSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata";
                };

                BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "OTHER"] = 1;
                    values[valuesById[2] = "GOOGLE"] = 2;
                    values[valuesById[3] = "BING"] = 3;
                    return values;
                })();

                return BotPlanningSearchSourcesMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningStepSectionMetadata = (function() {

                function BotPlanningStepSectionMetadata(p) {
                    this.sourcesMetadata = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningStepSectionMetadata.prototype.sectionTitle = null;
                BotPlanningStepSectionMetadata.prototype.sectionBody = null;
                BotPlanningStepSectionMetadata.prototype.sourcesMetadata = $util.emptyArray;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningStepSectionMetadata.prototype, "_sectionTitle", {
                    get: $util.oneOfGetter($oneOfFields = ["sectionTitle"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningStepSectionMetadata.prototype, "_sectionBody", {
                    get: $util.oneOfGetter($oneOfFields = ["sectionBody"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                BotPlanningStepSectionMetadata.create = function create(properties) {
                    return new BotPlanningStepSectionMetadata(properties);
                };

                BotPlanningStepSectionMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.sectionTitle != null && Object.hasOwnProperty.call(m, "sectionTitle"))
                        w.uint32(10).string(m.sectionTitle);
                    if (m.sectionBody != null && Object.hasOwnProperty.call(m, "sectionBody"))
                        w.uint32(18).string(m.sectionBody);
                    if (m.sourcesMetadata != null && m.sourcesMetadata.length) {
                        for (var i = 0; i < m.sourcesMetadata.length; ++i)
                            $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.encode(m.sourcesMetadata[i], w.uint32(26).fork()).ldelim();
                    }
                    return w;
                };

                BotPlanningStepSectionMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.sectionTitle = r.string();
                                break;
                            }
                        case 2: {
                                m.sectionBody = r.string();
                                break;
                            }
                        case 3: {
                                if (!(m.sourcesMetadata && m.sourcesMetadata.length))
                                    m.sourcesMetadata = [];
                                m.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.decode(r, r.uint32()));
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningStepSectionMetadata.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata)
                        return d;
                    var m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    if (d.sectionTitle != null) {
                        m.sectionTitle = String(d.sectionTitle);
                    }
                    if (d.sectionBody != null) {
                        m.sectionBody = String(d.sectionBody);
                    }
                    if (d.sourcesMetadata) {
                        if (!Array.isArray(d.sourcesMetadata))
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.sourcesMetadata: array expected");
                        m.sourcesMetadata = [];
                        for (var i = 0; i < d.sourcesMetadata.length; ++i) {
                            if (typeof d.sourcesMetadata[i] !== "object")
                                throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.sourcesMetadata: object expected");
                            m.sourcesMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.fromObject(d.sourcesMetadata[i]);
                        }
                    }
                    return m;
                };

                BotPlanningStepSectionMetadata.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (o.arrays || o.defaults) {
                        d.sourcesMetadata = [];
                    }
                    if (m.sectionTitle != null && m.hasOwnProperty("sectionTitle")) {
                        d.sectionTitle = m.sectionTitle;
                        if (o.oneofs)
                            d._sectionTitle = "sectionTitle";
                    }
                    if (m.sectionBody != null && m.hasOwnProperty("sectionBody")) {
                        d.sectionBody = m.sectionBody;
                        if (o.oneofs)
                            d._sectionBody = "sectionBody";
                    }
                    if (m.sourcesMetadata && m.sourcesMetadata.length) {
                        d.sourcesMetadata = [];
                        for (var j = 0; j < m.sourcesMetadata.length; ++j) {
                            d.sourcesMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.toObject(m.sourcesMetadata[j], o);
                        }
                    }
                    return d;
                };

                BotPlanningStepSectionMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                BotPlanningStepSectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata";
                };

                return BotPlanningStepSectionMetadata;
            })();

            BotPlanningStepMetadata.BotSearchSourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_PROVIDER"] = 0;
                values[valuesById[1] = "OTHER"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "BING"] = 3;
                return values;
            })();

            BotPlanningStepMetadata.PlanningStepStatus = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "PLANNED"] = 1;
                values[valuesById[2] = "EXECUTING"] = 2;
                values[valuesById[3] = "FINISHED"] = 3;
                return values;
            })();

            return BotPlanningStepMetadata;
        })();

        return BotProgressIndicatorMetadata;
    })();

    proto.BotPromotionMessageMetadata = (function() {

        function BotPromotionMessageMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromotionMessageMetadata.prototype.promotionType = null;
        BotPromotionMessageMetadata.prototype.buttonTitle = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromotionMessageMetadata.prototype, "_promotionType", {
            get: $util.oneOfGetter($oneOfFields = ["promotionType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromotionMessageMetadata.prototype, "_buttonTitle", {
            get: $util.oneOfGetter($oneOfFields = ["buttonTitle"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotPromotionMessageMetadata.create = function create(properties) {
            return new BotPromotionMessageMetadata(properties);
        };

        BotPromotionMessageMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.promotionType != null && Object.hasOwnProperty.call(m, "promotionType"))
                w.uint32(8).int32(m.promotionType);
            if (m.buttonTitle != null && Object.hasOwnProperty.call(m, "buttonTitle"))
                w.uint32(18).string(m.buttonTitle);
            return w;
        };

        BotPromotionMessageMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromotionMessageMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.promotionType = r.int32();
                        break;
                    }
                case 2: {
                        m.buttonTitle = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromotionMessageMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPromotionMessageMetadata)
                return d;
            var m = new $root.proto.BotPromotionMessageMetadata();
            switch (d.promotionType) {
            default:
                if (typeof d.promotionType === "number") {
                    m.promotionType = d.promotionType;
                    break;
                }
                break;
            case "UNKNOWN_TYPE":
            case 0:
                m.promotionType = 0;
                break;
            case "C50":
            case 1:
                m.promotionType = 1;
                break;
            }
            if (d.buttonTitle != null) {
                m.buttonTitle = String(d.buttonTitle);
            }
            return m;
        };

        BotPromotionMessageMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.promotionType != null && m.hasOwnProperty("promotionType")) {
                d.promotionType = o.enums === String ? $root.proto.BotPromotionMessageMetadata.BotPromotionType[m.promotionType] === undefined ? m.promotionType : $root.proto.BotPromotionMessageMetadata.BotPromotionType[m.promotionType] : m.promotionType;
                if (o.oneofs)
                    d._promotionType = "promotionType";
            }
            if (m.buttonTitle != null && m.hasOwnProperty("buttonTitle")) {
                d.buttonTitle = m.buttonTitle;
                if (o.oneofs)
                    d._buttonTitle = "buttonTitle";
            }
            return d;
        };

        BotPromotionMessageMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPromotionMessageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromotionMessageMetadata";
        };

        BotPromotionMessageMetadata.BotPromotionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "C50"] = 1;
            return values;
        })();

        return BotPromotionMessageMetadata;
    })();

    proto.BotPromptSuggestion = (function() {

        function BotPromptSuggestion(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromptSuggestion.prototype.prompt = null;
        BotPromptSuggestion.prototype.promptId = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromptSuggestion.prototype, "_prompt", {
            get: $util.oneOfGetter($oneOfFields = ["prompt"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromptSuggestion.prototype, "_promptId", {
            get: $util.oneOfGetter($oneOfFields = ["promptId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotPromptSuggestion.create = function create(properties) {
            return new BotPromptSuggestion(properties);
        };

        BotPromptSuggestion.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.prompt != null && Object.hasOwnProperty.call(m, "prompt"))
                w.uint32(10).string(m.prompt);
            if (m.promptId != null && Object.hasOwnProperty.call(m, "promptId"))
                w.uint32(18).string(m.promptId);
            return w;
        };

        BotPromptSuggestion.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromptSuggestion();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.prompt = r.string();
                        break;
                    }
                case 2: {
                        m.promptId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromptSuggestion.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPromptSuggestion)
                return d;
            var m = new $root.proto.BotPromptSuggestion();
            if (d.prompt != null) {
                m.prompt = String(d.prompt);
            }
            if (d.promptId != null) {
                m.promptId = String(d.promptId);
            }
            return m;
        };

        BotPromptSuggestion.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.prompt != null && m.hasOwnProperty("prompt")) {
                d.prompt = m.prompt;
                if (o.oneofs)
                    d._prompt = "prompt";
            }
            if (m.promptId != null && m.hasOwnProperty("promptId")) {
                d.promptId = m.promptId;
                if (o.oneofs)
                    d._promptId = "promptId";
            }
            return d;
        };

        BotPromptSuggestion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPromptSuggestion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestion";
        };

        return BotPromptSuggestion;
    })();

    proto.BotPromptSuggestions = (function() {

        function BotPromptSuggestions(p) {
            this.suggestions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromptSuggestions.prototype.suggestions = $util.emptyArray;

        BotPromptSuggestions.create = function create(properties) {
            return new BotPromptSuggestions(properties);
        };

        BotPromptSuggestions.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.suggestions != null && m.suggestions.length) {
                for (var i = 0; i < m.suggestions.length; ++i)
                    $root.proto.BotPromptSuggestion.encode(m.suggestions[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotPromptSuggestions.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromptSuggestions();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.suggestions && m.suggestions.length))
                            m.suggestions = [];
                        m.suggestions.push($root.proto.BotPromptSuggestion.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromptSuggestions.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotPromptSuggestions)
                return d;
            var m = new $root.proto.BotPromptSuggestions();
            if (d.suggestions) {
                if (!Array.isArray(d.suggestions))
                    throw TypeError(".proto.BotPromptSuggestions.suggestions: array expected");
                m.suggestions = [];
                for (var i = 0; i < d.suggestions.length; ++i) {
                    if (typeof d.suggestions[i] !== "object")
                        throw TypeError(".proto.BotPromptSuggestions.suggestions: object expected");
                    m.suggestions[i] = $root.proto.BotPromptSuggestion.fromObject(d.suggestions[i]);
                }
            }
            return m;
        };

        BotPromptSuggestions.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.suggestions = [];
            }
            if (m.suggestions && m.suggestions.length) {
                d.suggestions = [];
                for (var j = 0; j < m.suggestions.length; ++j) {
                    d.suggestions[j] = $root.proto.BotPromptSuggestion.toObject(m.suggestions[j], o);
                }
            }
            return d;
        };

        BotPromptSuggestions.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotPromptSuggestions.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestions";
        };

        return BotPromptSuggestions;
    })();

    proto.BotQuotaMetadata = (function() {

        function BotQuotaMetadata(p) {
            this.botFeatureQuotaMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotQuotaMetadata.prototype.botFeatureQuotaMetadata = $util.emptyArray;

        BotQuotaMetadata.create = function create(properties) {
            return new BotQuotaMetadata(properties);
        };

        BotQuotaMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.botFeatureQuotaMetadata != null && m.botFeatureQuotaMetadata.length) {
                for (var i = 0; i < m.botFeatureQuotaMetadata.length; ++i)
                    $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.encode(m.botFeatureQuotaMetadata[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotQuotaMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotQuotaMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.botFeatureQuotaMetadata && m.botFeatureQuotaMetadata.length))
                            m.botFeatureQuotaMetadata = [];
                        m.botFeatureQuotaMetadata.push($root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotQuotaMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotQuotaMetadata)
                return d;
            var m = new $root.proto.BotQuotaMetadata();
            if (d.botFeatureQuotaMetadata) {
                if (!Array.isArray(d.botFeatureQuotaMetadata))
                    throw TypeError(".proto.BotQuotaMetadata.botFeatureQuotaMetadata: array expected");
                m.botFeatureQuotaMetadata = [];
                for (var i = 0; i < d.botFeatureQuotaMetadata.length; ++i) {
                    if (typeof d.botFeatureQuotaMetadata[i] !== "object")
                        throw TypeError(".proto.BotQuotaMetadata.botFeatureQuotaMetadata: object expected");
                    m.botFeatureQuotaMetadata[i] = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.fromObject(d.botFeatureQuotaMetadata[i]);
                }
            }
            return m;
        };

        BotQuotaMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.botFeatureQuotaMetadata = [];
            }
            if (m.botFeatureQuotaMetadata && m.botFeatureQuotaMetadata.length) {
                d.botFeatureQuotaMetadata = [];
                for (var j = 0; j < m.botFeatureQuotaMetadata.length; ++j) {
                    d.botFeatureQuotaMetadata[j] = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.toObject(m.botFeatureQuotaMetadata[j], o);
                }
            }
            return d;
        };

        BotQuotaMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotQuotaMetadata";
        };

        BotQuotaMetadata.BotFeatureQuotaMetadata = (function() {

            function BotFeatureQuotaMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotFeatureQuotaMetadata.prototype.featureType = null;
            BotFeatureQuotaMetadata.prototype.remainingQuota = null;
            BotFeatureQuotaMetadata.prototype.expirationTimestamp = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_featureType", {
                get: $util.oneOfGetter($oneOfFields = ["featureType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_remainingQuota", {
                get: $util.oneOfGetter($oneOfFields = ["remainingQuota"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_expirationTimestamp", {
                get: $util.oneOfGetter($oneOfFields = ["expirationTimestamp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BotFeatureQuotaMetadata.create = function create(properties) {
                return new BotFeatureQuotaMetadata(properties);
            };

            BotFeatureQuotaMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.featureType != null && Object.hasOwnProperty.call(m, "featureType"))
                    w.uint32(8).int32(m.featureType);
                if (m.remainingQuota != null && Object.hasOwnProperty.call(m, "remainingQuota"))
                    w.uint32(16).uint32(m.remainingQuota);
                if (m.expirationTimestamp != null && Object.hasOwnProperty.call(m, "expirationTimestamp"))
                    w.uint32(24).uint64(m.expirationTimestamp);
                return w;
            };

            BotFeatureQuotaMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.featureType = r.int32();
                            break;
                        }
                    case 2: {
                            m.remainingQuota = r.uint32();
                            break;
                        }
                    case 3: {
                            m.expirationTimestamp = r.uint64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotFeatureQuotaMetadata.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata)
                    return d;
                var m = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                switch (d.featureType) {
                default:
                    if (typeof d.featureType === "number") {
                        m.featureType = d.featureType;
                        break;
                    }
                    break;
                case "UNKNOWN_FEATURE":
                case 0:
                    m.featureType = 0;
                    break;
                case "REASONING_FEATURE":
                case 1:
                    m.featureType = 1;
                    break;
                }
                if (d.remainingQuota != null) {
                    m.remainingQuota = d.remainingQuota >>> 0;
                }
                if (d.expirationTimestamp != null) {
                    if ($util.Long)
                        (m.expirationTimestamp = $util.Long.fromValue(d.expirationTimestamp)).unsigned = true;
                    else if (typeof d.expirationTimestamp === "string")
                        m.expirationTimestamp = parseInt(d.expirationTimestamp, 10);
                    else if (typeof d.expirationTimestamp === "number")
                        m.expirationTimestamp = d.expirationTimestamp;
                    else if (typeof d.expirationTimestamp === "object")
                        m.expirationTimestamp = new $util.LongBits(d.expirationTimestamp.low >>> 0, d.expirationTimestamp.high >>> 0).toNumber(true);
                }
                return m;
            };

            BotFeatureQuotaMetadata.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.featureType != null && m.hasOwnProperty("featureType")) {
                    d.featureType = o.enums === String ? $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType[m.featureType] === undefined ? m.featureType : $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType[m.featureType] : m.featureType;
                    if (o.oneofs)
                        d._featureType = "featureType";
                }
                if (m.remainingQuota != null && m.hasOwnProperty("remainingQuota")) {
                    d.remainingQuota = m.remainingQuota;
                    if (o.oneofs)
                        d._remainingQuota = "remainingQuota";
                }
                if (m.expirationTimestamp != null && m.hasOwnProperty("expirationTimestamp")) {
                    if (typeof m.expirationTimestamp === "number")
                        d.expirationTimestamp = o.longs === String ? String(m.expirationTimestamp) : m.expirationTimestamp;
                    else
                        d.expirationTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.expirationTimestamp) : o.longs === Number ? new $util.LongBits(m.expirationTimestamp.low >>> 0, m.expirationTimestamp.high >>> 0).toNumber(true) : m.expirationTimestamp;
                    if (o.oneofs)
                        d._expirationTimestamp = "expirationTimestamp";
                }
                return d;
            };

            BotFeatureQuotaMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BotFeatureQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotQuotaMetadata.BotFeatureQuotaMetadata";
            };

            BotFeatureQuotaMetadata.BotFeatureType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_FEATURE"] = 0;
                values[valuesById[1] = "REASONING_FEATURE"] = 1;
                return values;
            })();

            return BotFeatureQuotaMetadata;
        })();

        return BotQuotaMetadata;
    })();

    proto.BotReminderMetadata = (function() {

        function BotReminderMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotReminderMetadata.prototype.requestMessageKey = null;
        BotReminderMetadata.prototype.action = null;
        BotReminderMetadata.prototype.name = null;
        BotReminderMetadata.prototype.nextTriggerTimestamp = null;
        BotReminderMetadata.prototype.frequency = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_requestMessageKey", {
            get: $util.oneOfGetter($oneOfFields = ["requestMessageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_action", {
            get: $util.oneOfGetter($oneOfFields = ["action"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_name", {
            get: $util.oneOfGetter($oneOfFields = ["name"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_nextTriggerTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["nextTriggerTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_frequency", {
            get: $util.oneOfGetter($oneOfFields = ["frequency"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotReminderMetadata.create = function create(properties) {
            return new BotReminderMetadata(properties);
        };

        BotReminderMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.requestMessageKey != null && Object.hasOwnProperty.call(m, "requestMessageKey"))
                $root.proto.MessageKey.encode(m.requestMessageKey, w.uint32(10).fork()).ldelim();
            if (m.action != null && Object.hasOwnProperty.call(m, "action"))
                w.uint32(16).int32(m.action);
            if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                w.uint32(26).string(m.name);
            if (m.nextTriggerTimestamp != null && Object.hasOwnProperty.call(m, "nextTriggerTimestamp"))
                w.uint32(32).uint64(m.nextTriggerTimestamp);
            if (m.frequency != null && Object.hasOwnProperty.call(m, "frequency"))
                w.uint32(40).int32(m.frequency);
            return w;
        };

        BotReminderMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotReminderMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.requestMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.action = r.int32();
                        break;
                    }
                case 3: {
                        m.name = r.string();
                        break;
                    }
                case 4: {
                        m.nextTriggerTimestamp = r.uint64();
                        break;
                    }
                case 5: {
                        m.frequency = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotReminderMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotReminderMetadata)
                return d;
            var m = new $root.proto.BotReminderMetadata();
            if (d.requestMessageKey != null) {
                if (typeof d.requestMessageKey !== "object")
                    throw TypeError(".proto.BotReminderMetadata.requestMessageKey: object expected");
                m.requestMessageKey = $root.proto.MessageKey.fromObject(d.requestMessageKey);
            }
            switch (d.action) {
            default:
                if (typeof d.action === "number") {
                    m.action = d.action;
                    break;
                }
                break;
            case "NOTIFY":
            case 1:
                m.action = 1;
                break;
            case "CREATE":
            case 2:
                m.action = 2;
                break;
            case "DELETE":
            case 3:
                m.action = 3;
                break;
            case "UPDATE":
            case 4:
                m.action = 4;
                break;
            }
            if (d.name != null) {
                m.name = String(d.name);
            }
            if (d.nextTriggerTimestamp != null) {
                if ($util.Long)
                    (m.nextTriggerTimestamp = $util.Long.fromValue(d.nextTriggerTimestamp)).unsigned = true;
                else if (typeof d.nextTriggerTimestamp === "string")
                    m.nextTriggerTimestamp = parseInt(d.nextTriggerTimestamp, 10);
                else if (typeof d.nextTriggerTimestamp === "number")
                    m.nextTriggerTimestamp = d.nextTriggerTimestamp;
                else if (typeof d.nextTriggerTimestamp === "object")
                    m.nextTriggerTimestamp = new $util.LongBits(d.nextTriggerTimestamp.low >>> 0, d.nextTriggerTimestamp.high >>> 0).toNumber(true);
            }
            switch (d.frequency) {
            default:
                if (typeof d.frequency === "number") {
                    m.frequency = d.frequency;
                    break;
                }
                break;
            case "ONCE":
            case 1:
                m.frequency = 1;
                break;
            case "DAILY":
            case 2:
                m.frequency = 2;
                break;
            case "WEEKLY":
            case 3:
                m.frequency = 3;
                break;
            case "BIWEEKLY":
            case 4:
                m.frequency = 4;
                break;
            case "MONTHLY":
            case 5:
                m.frequency = 5;
                break;
            }
            return m;
        };

        BotReminderMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.requestMessageKey != null && m.hasOwnProperty("requestMessageKey")) {
                d.requestMessageKey = $root.proto.MessageKey.toObject(m.requestMessageKey, o);
                if (o.oneofs)
                    d._requestMessageKey = "requestMessageKey";
            }
            if (m.action != null && m.hasOwnProperty("action")) {
                d.action = o.enums === String ? $root.proto.BotReminderMetadata.ReminderAction[m.action] === undefined ? m.action : $root.proto.BotReminderMetadata.ReminderAction[m.action] : m.action;
                if (o.oneofs)
                    d._action = "action";
            }
            if (m.name != null && m.hasOwnProperty("name")) {
                d.name = m.name;
                if (o.oneofs)
                    d._name = "name";
            }
            if (m.nextTriggerTimestamp != null && m.hasOwnProperty("nextTriggerTimestamp")) {
                if (typeof m.nextTriggerTimestamp === "number")
                    d.nextTriggerTimestamp = o.longs === String ? String(m.nextTriggerTimestamp) : m.nextTriggerTimestamp;
                else
                    d.nextTriggerTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.nextTriggerTimestamp) : o.longs === Number ? new $util.LongBits(m.nextTriggerTimestamp.low >>> 0, m.nextTriggerTimestamp.high >>> 0).toNumber(true) : m.nextTriggerTimestamp;
                if (o.oneofs)
                    d._nextTriggerTimestamp = "nextTriggerTimestamp";
            }
            if (m.frequency != null && m.hasOwnProperty("frequency")) {
                d.frequency = o.enums === String ? $root.proto.BotReminderMetadata.ReminderFrequency[m.frequency] === undefined ? m.frequency : $root.proto.BotReminderMetadata.ReminderFrequency[m.frequency] : m.frequency;
                if (o.oneofs)
                    d._frequency = "frequency";
            }
            return d;
        };

        BotReminderMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotReminderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotReminderMetadata";
        };

        BotReminderMetadata.ReminderAction = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "NOTIFY"] = 1;
            values[valuesById[2] = "CREATE"] = 2;
            values[valuesById[3] = "DELETE"] = 3;
            values[valuesById[4] = "UPDATE"] = 4;
            return values;
        })();

        BotReminderMetadata.ReminderFrequency = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "ONCE"] = 1;
            values[valuesById[2] = "DAILY"] = 2;
            values[valuesById[3] = "WEEKLY"] = 3;
            values[valuesById[4] = "BIWEEKLY"] = 4;
            values[valuesById[5] = "MONTHLY"] = 5;
            return values;
        })();

        return BotReminderMetadata;
    })();

    proto.BotRenderingMetadata = (function() {

        function BotRenderingMetadata(p) {
            this.keywords = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotRenderingMetadata.prototype.keywords = $util.emptyArray;

        BotRenderingMetadata.create = function create(properties) {
            return new BotRenderingMetadata(properties);
        };

        BotRenderingMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.keywords != null && m.keywords.length) {
                for (var i = 0; i < m.keywords.length; ++i)
                    $root.proto.BotRenderingMetadata.Keyword.encode(m.keywords[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotRenderingMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotRenderingMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.keywords && m.keywords.length))
                            m.keywords = [];
                        m.keywords.push($root.proto.BotRenderingMetadata.Keyword.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotRenderingMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotRenderingMetadata)
                return d;
            var m = new $root.proto.BotRenderingMetadata();
            if (d.keywords) {
                if (!Array.isArray(d.keywords))
                    throw TypeError(".proto.BotRenderingMetadata.keywords: array expected");
                m.keywords = [];
                for (var i = 0; i < d.keywords.length; ++i) {
                    if (typeof d.keywords[i] !== "object")
                        throw TypeError(".proto.BotRenderingMetadata.keywords: object expected");
                    m.keywords[i] = $root.proto.BotRenderingMetadata.Keyword.fromObject(d.keywords[i]);
                }
            }
            return m;
        };

        BotRenderingMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.keywords = [];
            }
            if (m.keywords && m.keywords.length) {
                d.keywords = [];
                for (var j = 0; j < m.keywords.length; ++j) {
                    d.keywords[j] = $root.proto.BotRenderingMetadata.Keyword.toObject(m.keywords[j], o);
                }
            }
            return d;
        };

        BotRenderingMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotRenderingMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotRenderingMetadata";
        };

        BotRenderingMetadata.Keyword = (function() {

            function Keyword(p) {
                this.associatedPrompts = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            Keyword.prototype.value = null;
            Keyword.prototype.associatedPrompts = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(Keyword.prototype, "_value", {
                get: $util.oneOfGetter($oneOfFields = ["value"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            Keyword.create = function create(properties) {
                return new Keyword(properties);
            };

            Keyword.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.value != null && Object.hasOwnProperty.call(m, "value"))
                    w.uint32(10).string(m.value);
                if (m.associatedPrompts != null && m.associatedPrompts.length) {
                    for (var i = 0; i < m.associatedPrompts.length; ++i)
                        w.uint32(18).string(m.associatedPrompts[i]);
                }
                return w;
            };

            Keyword.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotRenderingMetadata.Keyword();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.value = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.associatedPrompts && m.associatedPrompts.length))
                                m.associatedPrompts = [];
                            m.associatedPrompts.push(r.string());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            Keyword.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotRenderingMetadata.Keyword)
                    return d;
                var m = new $root.proto.BotRenderingMetadata.Keyword();
                if (d.value != null) {
                    m.value = String(d.value);
                }
                if (d.associatedPrompts) {
                    if (!Array.isArray(d.associatedPrompts))
                        throw TypeError(".proto.BotRenderingMetadata.Keyword.associatedPrompts: array expected");
                    m.associatedPrompts = [];
                    for (var i = 0; i < d.associatedPrompts.length; ++i) {
                        m.associatedPrompts[i] = String(d.associatedPrompts[i]);
                    }
                }
                return m;
            };

            Keyword.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.associatedPrompts = [];
                }
                if (m.value != null && m.hasOwnProperty("value")) {
                    d.value = m.value;
                    if (o.oneofs)
                        d._value = "value";
                }
                if (m.associatedPrompts && m.associatedPrompts.length) {
                    d.associatedPrompts = [];
                    for (var j = 0; j < m.associatedPrompts.length; ++j) {
                        d.associatedPrompts[j] = m.associatedPrompts[j];
                    }
                }
                return d;
            };

            Keyword.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            Keyword.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotRenderingMetadata.Keyword";
            };

            return Keyword;
        })();

        return BotRenderingMetadata;
    })();

    proto.BotSessionMetadata = (function() {

        function BotSessionMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSessionMetadata.prototype.sessionId = null;
        BotSessionMetadata.prototype.sessionSource = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSessionMetadata.prototype, "_sessionId", {
            get: $util.oneOfGetter($oneOfFields = ["sessionId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSessionMetadata.prototype, "_sessionSource", {
            get: $util.oneOfGetter($oneOfFields = ["sessionSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotSessionMetadata.create = function create(properties) {
            return new BotSessionMetadata(properties);
        };

        BotSessionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                w.uint32(10).string(m.sessionId);
            if (m.sessionSource != null && Object.hasOwnProperty.call(m, "sessionSource"))
                w.uint32(16).int32(m.sessionSource);
            return w;
        };

        BotSessionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSessionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sessionId = r.string();
                        break;
                    }
                case 2: {
                        m.sessionSource = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSessionMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSessionMetadata)
                return d;
            var m = new $root.proto.BotSessionMetadata();
            if (d.sessionId != null) {
                m.sessionId = String(d.sessionId);
            }
            switch (d.sessionSource) {
            default:
                if (typeof d.sessionSource === "number") {
                    m.sessionSource = d.sessionSource;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.sessionSource = 0;
                break;
            case "NULL_STATE":
            case 1:
                m.sessionSource = 1;
                break;
            case "TYPEAHEAD":
            case 2:
                m.sessionSource = 2;
                break;
            case "USER_INPUT":
            case 3:
                m.sessionSource = 3;
                break;
            case "EMU_FLASH":
            case 4:
                m.sessionSource = 4;
                break;
            case "EMU_FLASH_FOLLOWUP":
            case 5:
                m.sessionSource = 5;
                break;
            case "VOICE":
            case 6:
                m.sessionSource = 6;
                break;
            }
            return m;
        };

        BotSessionMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.sessionId != null && m.hasOwnProperty("sessionId")) {
                d.sessionId = m.sessionId;
                if (o.oneofs)
                    d._sessionId = "sessionId";
            }
            if (m.sessionSource != null && m.hasOwnProperty("sessionSource")) {
                d.sessionSource = o.enums === String ? $root.proto.BotSessionSource[m.sessionSource] === undefined ? m.sessionSource : $root.proto.BotSessionSource[m.sessionSource] : m.sessionSource;
                if (o.oneofs)
                    d._sessionSource = "sessionSource";
            }
            return d;
        };

        BotSessionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSessionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSessionMetadata";
        };

        return BotSessionMetadata;
    })();

    proto.BotSessionSource = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "NONE"] = 0;
        values[valuesById[1] = "NULL_STATE"] = 1;
        values[valuesById[2] = "TYPEAHEAD"] = 2;
        values[valuesById[3] = "USER_INPUT"] = 3;
        values[valuesById[4] = "EMU_FLASH"] = 4;
        values[valuesById[5] = "EMU_FLASH_FOLLOWUP"] = 5;
        values[valuesById[6] = "VOICE"] = 6;
        return values;
    })();

    proto.BotSourcesMetadata = (function() {

        function BotSourcesMetadata(p) {
            this.sources = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSourcesMetadata.prototype.sources = $util.emptyArray;

        BotSourcesMetadata.create = function create(properties) {
            return new BotSourcesMetadata(properties);
        };

        BotSourcesMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sources != null && m.sources.length) {
                for (var i = 0; i < m.sources.length; ++i)
                    $root.proto.BotSourcesMetadata.BotSourceItem.encode(m.sources[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotSourcesMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSourcesMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.sources && m.sources.length))
                            m.sources = [];
                        m.sources.push($root.proto.BotSourcesMetadata.BotSourceItem.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSourcesMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSourcesMetadata)
                return d;
            var m = new $root.proto.BotSourcesMetadata();
            if (d.sources) {
                if (!Array.isArray(d.sources))
                    throw TypeError(".proto.BotSourcesMetadata.sources: array expected");
                m.sources = [];
                for (var i = 0; i < d.sources.length; ++i) {
                    if (typeof d.sources[i] !== "object")
                        throw TypeError(".proto.BotSourcesMetadata.sources: object expected");
                    m.sources[i] = $root.proto.BotSourcesMetadata.BotSourceItem.fromObject(d.sources[i]);
                }
            }
            return m;
        };

        BotSourcesMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.sources = [];
            }
            if (m.sources && m.sources.length) {
                d.sources = [];
                for (var j = 0; j < m.sources.length; ++j) {
                    d.sources[j] = $root.proto.BotSourcesMetadata.BotSourceItem.toObject(m.sources[j], o);
                }
            }
            return d;
        };

        BotSourcesMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSourcesMetadata";
        };

        BotSourcesMetadata.BotSourceItem = (function() {

            function BotSourceItem(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotSourceItem.prototype.provider = null;
            BotSourceItem.prototype.thumbnailCdnUrl = null;
            BotSourceItem.prototype.sourceProviderUrl = null;
            BotSourceItem.prototype.sourceQuery = null;
            BotSourceItem.prototype.faviconCdnUrl = null;
            BotSourceItem.prototype.citationNumber = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_provider", {
                get: $util.oneOfGetter($oneOfFields = ["provider"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_thumbnailCdnUrl", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnailCdnUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_sourceProviderUrl", {
                get: $util.oneOfGetter($oneOfFields = ["sourceProviderUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_sourceQuery", {
                get: $util.oneOfGetter($oneOfFields = ["sourceQuery"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_faviconCdnUrl", {
                get: $util.oneOfGetter($oneOfFields = ["faviconCdnUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotSourceItem.prototype, "_citationNumber", {
                get: $util.oneOfGetter($oneOfFields = ["citationNumber"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BotSourceItem.create = function create(properties) {
                return new BotSourceItem(properties);
            };

            BotSourceItem.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                    w.uint32(8).int32(m.provider);
                if (m.thumbnailCdnUrl != null && Object.hasOwnProperty.call(m, "thumbnailCdnUrl"))
                    w.uint32(18).string(m.thumbnailCdnUrl);
                if (m.sourceProviderUrl != null && Object.hasOwnProperty.call(m, "sourceProviderUrl"))
                    w.uint32(26).string(m.sourceProviderUrl);
                if (m.sourceQuery != null && Object.hasOwnProperty.call(m, "sourceQuery"))
                    w.uint32(34).string(m.sourceQuery);
                if (m.faviconCdnUrl != null && Object.hasOwnProperty.call(m, "faviconCdnUrl"))
                    w.uint32(42).string(m.faviconCdnUrl);
                if (m.citationNumber != null && Object.hasOwnProperty.call(m, "citationNumber"))
                    w.uint32(48).uint32(m.citationNumber);
                return w;
            };

            BotSourceItem.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSourcesMetadata.BotSourceItem();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.provider = r.int32();
                            break;
                        }
                    case 2: {
                            m.thumbnailCdnUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.sourceProviderUrl = r.string();
                            break;
                        }
                    case 4: {
                            m.sourceQuery = r.string();
                            break;
                        }
                    case 5: {
                            m.faviconCdnUrl = r.string();
                            break;
                        }
                    case 6: {
                            m.citationNumber = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotSourceItem.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.BotSourcesMetadata.BotSourceItem)
                    return d;
                var m = new $root.proto.BotSourcesMetadata.BotSourceItem();
                switch (d.provider) {
                default:
                    if (typeof d.provider === "number") {
                        m.provider = d.provider;
                        break;
                    }
                    break;
                case "UNKNOWN":
                case 0:
                    m.provider = 0;
                    break;
                case "BING":
                case 1:
                    m.provider = 1;
                    break;
                case "GOOGLE":
                case 2:
                    m.provider = 2;
                    break;
                case "SUPPORT":
                case 3:
                    m.provider = 3;
                    break;
                }
                if (d.thumbnailCdnUrl != null) {
                    m.thumbnailCdnUrl = String(d.thumbnailCdnUrl);
                }
                if (d.sourceProviderUrl != null) {
                    m.sourceProviderUrl = String(d.sourceProviderUrl);
                }
                if (d.sourceQuery != null) {
                    m.sourceQuery = String(d.sourceQuery);
                }
                if (d.faviconCdnUrl != null) {
                    m.faviconCdnUrl = String(d.faviconCdnUrl);
                }
                if (d.citationNumber != null) {
                    m.citationNumber = d.citationNumber >>> 0;
                }
                return m;
            };

            BotSourceItem.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.provider != null && m.hasOwnProperty("provider")) {
                    d.provider = o.enums === String ? $root.proto.BotSourcesMetadata.BotSourceItem.SourceProvider[m.provider] === undefined ? m.provider : $root.proto.BotSourcesMetadata.BotSourceItem.SourceProvider[m.provider] : m.provider;
                    if (o.oneofs)
                        d._provider = "provider";
                }
                if (m.thumbnailCdnUrl != null && m.hasOwnProperty("thumbnailCdnUrl")) {
                    d.thumbnailCdnUrl = m.thumbnailCdnUrl;
                    if (o.oneofs)
                        d._thumbnailCdnUrl = "thumbnailCdnUrl";
                }
                if (m.sourceProviderUrl != null && m.hasOwnProperty("sourceProviderUrl")) {
                    d.sourceProviderUrl = m.sourceProviderUrl;
                    if (o.oneofs)
                        d._sourceProviderUrl = "sourceProviderUrl";
                }
                if (m.sourceQuery != null && m.hasOwnProperty("sourceQuery")) {
                    d.sourceQuery = m.sourceQuery;
                    if (o.oneofs)
                        d._sourceQuery = "sourceQuery";
                }
                if (m.faviconCdnUrl != null && m.hasOwnProperty("faviconCdnUrl")) {
                    d.faviconCdnUrl = m.faviconCdnUrl;
                    if (o.oneofs)
                        d._faviconCdnUrl = "faviconCdnUrl";
                }
                if (m.citationNumber != null && m.hasOwnProperty("citationNumber")) {
                    d.citationNumber = m.citationNumber;
                    if (o.oneofs)
                        d._citationNumber = "citationNumber";
                }
                return d;
            };

            BotSourceItem.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BotSourceItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotSourcesMetadata.BotSourceItem";
            };

            BotSourceItem.SourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "BING"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "SUPPORT"] = 3;
                return values;
            })();

            return BotSourceItem;
        })();

        return BotSourcesMetadata;
    })();

    proto.BotSuggestedPromptMetadata = (function() {

        function BotSuggestedPromptMetadata(p) {
            this.suggestedPrompts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSuggestedPromptMetadata.prototype.suggestedPrompts = $util.emptyArray;
        BotSuggestedPromptMetadata.prototype.selectedPromptIndex = null;
        BotSuggestedPromptMetadata.prototype.promptSuggestions = null;
        BotSuggestedPromptMetadata.prototype.selectedPromptId = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSuggestedPromptMetadata.prototype, "_selectedPromptIndex", {
            get: $util.oneOfGetter($oneOfFields = ["selectedPromptIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSuggestedPromptMetadata.prototype, "_promptSuggestions", {
            get: $util.oneOfGetter($oneOfFields = ["promptSuggestions"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotSuggestedPromptMetadata.prototype, "_selectedPromptId", {
            get: $util.oneOfGetter($oneOfFields = ["selectedPromptId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        BotSuggestedPromptMetadata.create = function create(properties) {
            return new BotSuggestedPromptMetadata(properties);
        };

        BotSuggestedPromptMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.suggestedPrompts != null && m.suggestedPrompts.length) {
                for (var i = 0; i < m.suggestedPrompts.length; ++i)
                    w.uint32(10).string(m.suggestedPrompts[i]);
            }
            if (m.selectedPromptIndex != null && Object.hasOwnProperty.call(m, "selectedPromptIndex"))
                w.uint32(16).uint32(m.selectedPromptIndex);
            if (m.promptSuggestions != null && Object.hasOwnProperty.call(m, "promptSuggestions"))
                $root.proto.BotPromptSuggestions.encode(m.promptSuggestions, w.uint32(26).fork()).ldelim();
            if (m.selectedPromptId != null && Object.hasOwnProperty.call(m, "selectedPromptId"))
                w.uint32(34).string(m.selectedPromptId);
            return w;
        };

        BotSuggestedPromptMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSuggestedPromptMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.suggestedPrompts && m.suggestedPrompts.length))
                            m.suggestedPrompts = [];
                        m.suggestedPrompts.push(r.string());
                        break;
                    }
                case 2: {
                        m.selectedPromptIndex = r.uint32();
                        break;
                    }
                case 3: {
                        m.promptSuggestions = $root.proto.BotPromptSuggestions.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.selectedPromptId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSuggestedPromptMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.BotSuggestedPromptMetadata)
                return d;
            var m = new $root.proto.BotSuggestedPromptMetadata();
            if (d.suggestedPrompts) {
                if (!Array.isArray(d.suggestedPrompts))
                    throw TypeError(".proto.BotSuggestedPromptMetadata.suggestedPrompts: array expected");
                m.suggestedPrompts = [];
                for (var i = 0; i < d.suggestedPrompts.length; ++i) {
                    m.suggestedPrompts[i] = String(d.suggestedPrompts[i]);
                }
            }
            if (d.selectedPromptIndex != null) {
                m.selectedPromptIndex = d.selectedPromptIndex >>> 0;
            }
            if (d.promptSuggestions != null) {
                if (typeof d.promptSuggestions !== "object")
                    throw TypeError(".proto.BotSuggestedPromptMetadata.promptSuggestions: object expected");
                m.promptSuggestions = $root.proto.BotPromptSuggestions.fromObject(d.promptSuggestions);
            }
            if (d.selectedPromptId != null) {
                m.selectedPromptId = String(d.selectedPromptId);
            }
            return m;
        };

        BotSuggestedPromptMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.suggestedPrompts = [];
            }
            if (m.suggestedPrompts && m.suggestedPrompts.length) {
                d.suggestedPrompts = [];
                for (var j = 0; j < m.suggestedPrompts.length; ++j) {
                    d.suggestedPrompts[j] = m.suggestedPrompts[j];
                }
            }
            if (m.selectedPromptIndex != null && m.hasOwnProperty("selectedPromptIndex")) {
                d.selectedPromptIndex = m.selectedPromptIndex;
                if (o.oneofs)
                    d._selectedPromptIndex = "selectedPromptIndex";
            }
            if (m.promptSuggestions != null && m.hasOwnProperty("promptSuggestions")) {
                d.promptSuggestions = $root.proto.BotPromptSuggestions.toObject(m.promptSuggestions, o);
                if (o.oneofs)
                    d._promptSuggestions = "promptSuggestions";
            }
            if (m.selectedPromptId != null && m.hasOwnProperty("selectedPromptId")) {
                d.selectedPromptId = m.selectedPromptId;
                if (o.oneofs)
                    d._selectedPromptId = "selectedPromptId";
            }
            return d;
        };

        BotSuggestedPromptMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        BotSuggestedPromptMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSuggestedPromptMetadata";
        };

        return BotSuggestedPromptMetadata;
    })();

    proto.CallLogRecord = (function() {

        function CallLogRecord(p) {
            this.participants = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CallLogRecord.prototype.callResult = null;
        CallLogRecord.prototype.isDndMode = null;
        CallLogRecord.prototype.silenceReason = null;
        CallLogRecord.prototype.duration = null;
        CallLogRecord.prototype.startTime = null;
        CallLogRecord.prototype.isIncoming = null;
        CallLogRecord.prototype.isVideo = null;
        CallLogRecord.prototype.isCallLink = null;
        CallLogRecord.prototype.callLinkToken = null;
        CallLogRecord.prototype.scheduledCallId = null;
        CallLogRecord.prototype.callId = null;
        CallLogRecord.prototype.callCreatorJid = null;
        CallLogRecord.prototype.groupJid = null;
        CallLogRecord.prototype.participants = $util.emptyArray;
        CallLogRecord.prototype.callType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callResult", {
            get: $util.oneOfGetter($oneOfFields = ["callResult"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isDndMode", {
            get: $util.oneOfGetter($oneOfFields = ["isDndMode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_silenceReason", {
            get: $util.oneOfGetter($oneOfFields = ["silenceReason"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_duration", {
            get: $util.oneOfGetter($oneOfFields = ["duration"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_startTime", {
            get: $util.oneOfGetter($oneOfFields = ["startTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isIncoming", {
            get: $util.oneOfGetter($oneOfFields = ["isIncoming"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isVideo", {
            get: $util.oneOfGetter($oneOfFields = ["isVideo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_isCallLink", {
            get: $util.oneOfGetter($oneOfFields = ["isCallLink"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callLinkToken", {
            get: $util.oneOfGetter($oneOfFields = ["callLinkToken"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_scheduledCallId", {
            get: $util.oneOfGetter($oneOfFields = ["scheduledCallId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callId", {
            get: $util.oneOfGetter($oneOfFields = ["callId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callCreatorJid", {
            get: $util.oneOfGetter($oneOfFields = ["callCreatorJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_groupJid", {
            get: $util.oneOfGetter($oneOfFields = ["groupJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CallLogRecord.prototype, "_callType", {
            get: $util.oneOfGetter($oneOfFields = ["callType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CallLogRecord.create = function create(properties) {
            return new CallLogRecord(properties);
        };

        CallLogRecord.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.callResult != null && Object.hasOwnProperty.call(m, "callResult"))
                w.uint32(8).int32(m.callResult);
            if (m.isDndMode != null && Object.hasOwnProperty.call(m, "isDndMode"))
                w.uint32(16).bool(m.isDndMode);
            if (m.silenceReason != null && Object.hasOwnProperty.call(m, "silenceReason"))
                w.uint32(24).int32(m.silenceReason);
            if (m.duration != null && Object.hasOwnProperty.call(m, "duration"))
                w.uint32(32).int64(m.duration);
            if (m.startTime != null && Object.hasOwnProperty.call(m, "startTime"))
                w.uint32(40).int64(m.startTime);
            if (m.isIncoming != null && Object.hasOwnProperty.call(m, "isIncoming"))
                w.uint32(48).bool(m.isIncoming);
            if (m.isVideo != null && Object.hasOwnProperty.call(m, "isVideo"))
                w.uint32(56).bool(m.isVideo);
            if (m.isCallLink != null && Object.hasOwnProperty.call(m, "isCallLink"))
                w.uint32(64).bool(m.isCallLink);
            if (m.callLinkToken != null && Object.hasOwnProperty.call(m, "callLinkToken"))
                w.uint32(74).string(m.callLinkToken);
            if (m.scheduledCallId != null && Object.hasOwnProperty.call(m, "scheduledCallId"))
                w.uint32(82).string(m.scheduledCallId);
            if (m.callId != null && Object.hasOwnProperty.call(m, "callId"))
                w.uint32(90).string(m.callId);
            if (m.callCreatorJid != null && Object.hasOwnProperty.call(m, "callCreatorJid"))
                w.uint32(98).string(m.callCreatorJid);
            if (m.groupJid != null && Object.hasOwnProperty.call(m, "groupJid"))
                w.uint32(106).string(m.groupJid);
            if (m.participants != null && m.participants.length) {
                for (var i = 0; i < m.participants.length; ++i)
                    $root.proto.CallLogRecord.ParticipantInfo.encode(m.participants[i], w.uint32(114).fork()).ldelim();
            }
            if (m.callType != null && Object.hasOwnProperty.call(m, "callType"))
                w.uint32(120).int32(m.callType);
            return w;
        };

        CallLogRecord.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CallLogRecord();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.callResult = r.int32();
                        break;
                    }
                case 2: {
                        m.isDndMode = r.bool();
                        break;
                    }
                case 3: {
                        m.silenceReason = r.int32();
                        break;
                    }
                case 4: {
                        m.duration = r.int64();
                        break;
                    }
                case 5: {
                        m.startTime = r.int64();
                        break;
                    }
                case 6: {
                        m.isIncoming = r.bool();
                        break;
                    }
                case 7: {
                        m.isVideo = r.bool();
                        break;
                    }
                case 8: {
                        m.isCallLink = r.bool();
                        break;
                    }
                case 9: {
                        m.callLinkToken = r.string();
                        break;
                    }
                case 10: {
                        m.scheduledCallId = r.string();
                        break;
                    }
                case 11: {
                        m.callId = r.string();
                        break;
                    }
                case 12: {
                        m.callCreatorJid = r.string();
                        break;
                    }
                case 13: {
                        m.groupJid = r.string();
                        break;
                    }
                case 14: {
                        if (!(m.participants && m.participants.length))
                            m.participants = [];
                        m.participants.push($root.proto.CallLogRecord.ParticipantInfo.decode(r, r.uint32()));
                        break;
                    }
                case 15: {
                        m.callType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CallLogRecord.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CallLogRecord)
                return d;
            var m = new $root.proto.CallLogRecord();
            switch (d.callResult) {
            default:
                if (typeof d.callResult === "number") {
                    m.callResult = d.callResult;
                    break;
                }
                break;
            case "CONNECTED":
            case 0:
                m.callResult = 0;
                break;
            case "REJECTED":
            case 1:
                m.callResult = 1;
                break;
            case "CANCELLED":
            case 2:
                m.callResult = 2;
                break;
            case "ACCEPTEDELSEWHERE":
            case 3:
                m.callResult = 3;
                break;
            case "MISSED":
            case 4:
                m.callResult = 4;
                break;
            case "INVALID":
            case 5:
                m.callResult = 5;
                break;
            case "UNAVAILABLE":
            case 6:
                m.callResult = 6;
                break;
            case "UPCOMING":
            case 7:
                m.callResult = 7;
                break;
            case "FAILED":
            case 8:
                m.callResult = 8;
                break;
            case "ABANDONED":
            case 9:
                m.callResult = 9;
                break;
            case "ONGOING":
            case 10:
                m.callResult = 10;
                break;
            }
            if (d.isDndMode != null) {
                m.isDndMode = Boolean(d.isDndMode);
            }
            switch (d.silenceReason) {
            default:
                if (typeof d.silenceReason === "number") {
                    m.silenceReason = d.silenceReason;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.silenceReason = 0;
                break;
            case "SCHEDULED":
            case 1:
                m.silenceReason = 1;
                break;
            case "PRIVACY":
            case 2:
                m.silenceReason = 2;
                break;
            case "LIGHTWEIGHT":
            case 3:
                m.silenceReason = 3;
                break;
            }
            if (d.duration != null) {
                if ($util.Long)
                    (m.duration = $util.Long.fromValue(d.duration)).unsigned = false;
                else if (typeof d.duration === "string")
                    m.duration = parseInt(d.duration, 10);
                else if (typeof d.duration === "number")
                    m.duration = d.duration;
                else if (typeof d.duration === "object")
                    m.duration = new $util.LongBits(d.duration.low >>> 0, d.duration.high >>> 0).toNumber();
            }
            if (d.startTime != null) {
                if ($util.Long)
                    (m.startTime = $util.Long.fromValue(d.startTime)).unsigned = false;
                else if (typeof d.startTime === "string")
                    m.startTime = parseInt(d.startTime, 10);
                else if (typeof d.startTime === "number")
                    m.startTime = d.startTime;
                else if (typeof d.startTime === "object")
                    m.startTime = new $util.LongBits(d.startTime.low >>> 0, d.startTime.high >>> 0).toNumber();
            }
            if (d.isIncoming != null) {
                m.isIncoming = Boolean(d.isIncoming);
            }
            if (d.isVideo != null) {
                m.isVideo = Boolean(d.isVideo);
            }
            if (d.isCallLink != null) {
                m.isCallLink = Boolean(d.isCallLink);
            }
            if (d.callLinkToken != null) {
                m.callLinkToken = String(d.callLinkToken);
            }
            if (d.scheduledCallId != null) {
                m.scheduledCallId = String(d.scheduledCallId);
            }
            if (d.callId != null) {
                m.callId = String(d.callId);
            }
            if (d.callCreatorJid != null) {
                m.callCreatorJid = String(d.callCreatorJid);
            }
            if (d.groupJid != null) {
                m.groupJid = String(d.groupJid);
            }
            if (d.participants) {
                if (!Array.isArray(d.participants))
                    throw TypeError(".proto.CallLogRecord.participants: array expected");
                m.participants = [];
                for (var i = 0; i < d.participants.length; ++i) {
                    if (typeof d.participants[i] !== "object")
                        throw TypeError(".proto.CallLogRecord.participants: object expected");
                    m.participants[i] = $root.proto.CallLogRecord.ParticipantInfo.fromObject(d.participants[i]);
                }
            }
            switch (d.callType) {
            default:
                if (typeof d.callType === "number") {
                    m.callType = d.callType;
                    break;
                }
                break;
            case "REGULAR":
            case 0:
                m.callType = 0;
                break;
            case "SCHEDULED_CALL":
            case 1:
                m.callType = 1;
                break;
            case "VOICE_CHAT":
            case 2:
                m.callType = 2;
                break;
            }
            return m;
        };

        CallLogRecord.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.participants = [];
            }
            if (m.callResult != null && m.hasOwnProperty("callResult")) {
                d.callResult = o.enums === String ? $root.proto.CallLogRecord.CallResult[m.callResult] === undefined ? m.callResult : $root.proto.CallLogRecord.CallResult[m.callResult] : m.callResult;
                if (o.oneofs)
                    d._callResult = "callResult";
            }
            if (m.isDndMode != null && m.hasOwnProperty("isDndMode")) {
                d.isDndMode = m.isDndMode;
                if (o.oneofs)
                    d._isDndMode = "isDndMode";
            }
            if (m.silenceReason != null && m.hasOwnProperty("silenceReason")) {
                d.silenceReason = o.enums === String ? $root.proto.CallLogRecord.SilenceReason[m.silenceReason] === undefined ? m.silenceReason : $root.proto.CallLogRecord.SilenceReason[m.silenceReason] : m.silenceReason;
                if (o.oneofs)
                    d._silenceReason = "silenceReason";
            }
            if (m.duration != null && m.hasOwnProperty("duration")) {
                if (typeof m.duration === "number")
                    d.duration = o.longs === String ? String(m.duration) : m.duration;
                else
                    d.duration = o.longs === String ? $util.Long.prototype.toString.call(m.duration) : o.longs === Number ? new $util.LongBits(m.duration.low >>> 0, m.duration.high >>> 0).toNumber() : m.duration;
                if (o.oneofs)
                    d._duration = "duration";
            }
            if (m.startTime != null && m.hasOwnProperty("startTime")) {
                if (typeof m.startTime === "number")
                    d.startTime = o.longs === String ? String(m.startTime) : m.startTime;
                else
                    d.startTime = o.longs === String ? $util.Long.prototype.toString.call(m.startTime) : o.longs === Number ? new $util.LongBits(m.startTime.low >>> 0, m.startTime.high >>> 0).toNumber() : m.startTime;
                if (o.oneofs)
                    d._startTime = "startTime";
            }
            if (m.isIncoming != null && m.hasOwnProperty("isIncoming")) {
                d.isIncoming = m.isIncoming;
                if (o.oneofs)
                    d._isIncoming = "isIncoming";
            }
            if (m.isVideo != null && m.hasOwnProperty("isVideo")) {
                d.isVideo = m.isVideo;
                if (o.oneofs)
                    d._isVideo = "isVideo";
            }
            if (m.isCallLink != null && m.hasOwnProperty("isCallLink")) {
                d.isCallLink = m.isCallLink;
                if (o.oneofs)
                    d._isCallLink = "isCallLink";
            }
            if (m.callLinkToken != null && m.hasOwnProperty("callLinkToken")) {
                d.callLinkToken = m.callLinkToken;
                if (o.oneofs)
                    d._callLinkToken = "callLinkToken";
            }
            if (m.scheduledCallId != null && m.hasOwnProperty("scheduledCallId")) {
                d.scheduledCallId = m.scheduledCallId;
                if (o.oneofs)
                    d._scheduledCallId = "scheduledCallId";
            }
            if (m.callId != null && m.hasOwnProperty("callId")) {
                d.callId = m.callId;
                if (o.oneofs)
                    d._callId = "callId";
            }
            if (m.callCreatorJid != null && m.hasOwnProperty("callCreatorJid")) {
                d.callCreatorJid = m.callCreatorJid;
                if (o.oneofs)
                    d._callCreatorJid = "callCreatorJid";
            }
            if (m.groupJid != null && m.hasOwnProperty("groupJid")) {
                d.groupJid = m.groupJid;
                if (o.oneofs)
                    d._groupJid = "groupJid";
            }
            if (m.participants && m.participants.length) {
                d.participants = [];
                for (var j = 0; j < m.participants.length; ++j) {
                    d.participants[j] = $root.proto.CallLogRecord.ParticipantInfo.toObject(m.participants[j], o);
                }
            }
            if (m.callType != null && m.hasOwnProperty("callType")) {
                d.callType = o.enums === String ? $root.proto.CallLogRecord.CallType[m.callType] === undefined ? m.callType : $root.proto.CallLogRecord.CallType[m.callType] : m.callType;
                if (o.oneofs)
                    d._callType = "callType";
            }
            return d;
        };

        CallLogRecord.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CallLogRecord.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CallLogRecord";
        };

        CallLogRecord.CallResult = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CONNECTED"] = 0;
            values[valuesById[1] = "REJECTED"] = 1;
            values[valuesById[2] = "CANCELLED"] = 2;
            values[valuesById[3] = "ACCEPTEDELSEWHERE"] = 3;
            values[valuesById[4] = "MISSED"] = 4;
            values[valuesById[5] = "INVALID"] = 5;
            values[valuesById[6] = "UNAVAILABLE"] = 6;
            values[valuesById[7] = "UPCOMING"] = 7;
            values[valuesById[8] = "FAILED"] = 8;
            values[valuesById[9] = "ABANDONED"] = 9;
            values[valuesById[10] = "ONGOING"] = 10;
            return values;
        })();

        CallLogRecord.CallType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "REGULAR"] = 0;
            values[valuesById[1] = "SCHEDULED_CALL"] = 1;
            values[valuesById[2] = "VOICE_CHAT"] = 2;
            return values;
        })();

        CallLogRecord.ParticipantInfo = (function() {

            function ParticipantInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ParticipantInfo.prototype.userJid = null;
            ParticipantInfo.prototype.callResult = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ParticipantInfo.prototype, "_userJid", {
                get: $util.oneOfGetter($oneOfFields = ["userJid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ParticipantInfo.prototype, "_callResult", {
                get: $util.oneOfGetter($oneOfFields = ["callResult"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ParticipantInfo.create = function create(properties) {
                return new ParticipantInfo(properties);
            };

            ParticipantInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.userJid != null && Object.hasOwnProperty.call(m, "userJid"))
                    w.uint32(10).string(m.userJid);
                if (m.callResult != null && Object.hasOwnProperty.call(m, "callResult"))
                    w.uint32(16).int32(m.callResult);
                return w;
            };

            ParticipantInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CallLogRecord.ParticipantInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.userJid = r.string();
                            break;
                        }
                    case 2: {
                            m.callResult = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ParticipantInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.CallLogRecord.ParticipantInfo)
                    return d;
                var m = new $root.proto.CallLogRecord.ParticipantInfo();
                if (d.userJid != null) {
                    m.userJid = String(d.userJid);
                }
                switch (d.callResult) {
                default:
                    if (typeof d.callResult === "number") {
                        m.callResult = d.callResult;
                        break;
                    }
                    break;
                case "CONNECTED":
                case 0:
                    m.callResult = 0;
                    break;
                case "REJECTED":
                case 1:
                    m.callResult = 1;
                    break;
                case "CANCELLED":
                case 2:
                    m.callResult = 2;
                    break;
                case "ACCEPTEDELSEWHERE":
                case 3:
                    m.callResult = 3;
                    break;
                case "MISSED":
                case 4:
                    m.callResult = 4;
                    break;
                case "INVALID":
                case 5:
                    m.callResult = 5;
                    break;
                case "UNAVAILABLE":
                case 6:
                    m.callResult = 6;
                    break;
                case "UPCOMING":
                case 7:
                    m.callResult = 7;
                    break;
                case "FAILED":
                case 8:
                    m.callResult = 8;
                    break;
                case "ABANDONED":
                case 9:
                    m.callResult = 9;
                    break;
                case "ONGOING":
                case 10:
                    m.callResult = 10;
                    break;
                }
                return m;
            };

            ParticipantInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.userJid != null && m.hasOwnProperty("userJid")) {
                    d.userJid = m.userJid;
                    if (o.oneofs)
                        d._userJid = "userJid";
                }
                if (m.callResult != null && m.hasOwnProperty("callResult")) {
                    d.callResult = o.enums === String ? $root.proto.CallLogRecord.CallResult[m.callResult] === undefined ? m.callResult : $root.proto.CallLogRecord.CallResult[m.callResult] : m.callResult;
                    if (o.oneofs)
                        d._callResult = "callResult";
                }
                return d;
            };

            ParticipantInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            ParticipantInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.CallLogRecord.ParticipantInfo";
            };

            return ParticipantInfo;
        })();

        CallLogRecord.SilenceReason = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "SCHEDULED"] = 1;
            values[valuesById[2] = "PRIVACY"] = 2;
            values[valuesById[3] = "LIGHTWEIGHT"] = 3;
            return values;
        })();

        return CallLogRecord;
    })();

    proto.CertChain = (function() {

        function CertChain(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CertChain.prototype.leaf = null;
        CertChain.prototype.intermediate = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CertChain.prototype, "_leaf", {
            get: $util.oneOfGetter($oneOfFields = ["leaf"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CertChain.prototype, "_intermediate", {
            get: $util.oneOfGetter($oneOfFields = ["intermediate"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CertChain.create = function create(properties) {
            return new CertChain(properties);
        };

        CertChain.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.leaf != null && Object.hasOwnProperty.call(m, "leaf"))
                $root.proto.CertChain.NoiseCertificate.encode(m.leaf, w.uint32(10).fork()).ldelim();
            if (m.intermediate != null && Object.hasOwnProperty.call(m, "intermediate"))
                $root.proto.CertChain.NoiseCertificate.encode(m.intermediate, w.uint32(18).fork()).ldelim();
            return w;
        };

        CertChain.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.leaf = $root.proto.CertChain.NoiseCertificate.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.intermediate = $root.proto.CertChain.NoiseCertificate.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CertChain.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CertChain)
                return d;
            var m = new $root.proto.CertChain();
            if (d.leaf != null) {
                if (typeof d.leaf !== "object")
                    throw TypeError(".proto.CertChain.leaf: object expected");
                m.leaf = $root.proto.CertChain.NoiseCertificate.fromObject(d.leaf);
            }
            if (d.intermediate != null) {
                if (typeof d.intermediate !== "object")
                    throw TypeError(".proto.CertChain.intermediate: object expected");
                m.intermediate = $root.proto.CertChain.NoiseCertificate.fromObject(d.intermediate);
            }
            return m;
        };

        CertChain.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.leaf != null && m.hasOwnProperty("leaf")) {
                d.leaf = $root.proto.CertChain.NoiseCertificate.toObject(m.leaf, o);
                if (o.oneofs)
                    d._leaf = "leaf";
            }
            if (m.intermediate != null && m.hasOwnProperty("intermediate")) {
                d.intermediate = $root.proto.CertChain.NoiseCertificate.toObject(m.intermediate, o);
                if (o.oneofs)
                    d._intermediate = "intermediate";
            }
            return d;
        };

        CertChain.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CertChain.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CertChain";
        };

        CertChain.NoiseCertificate = (function() {

            function NoiseCertificate(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            NoiseCertificate.prototype.details = null;
            NoiseCertificate.prototype.signature = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(NoiseCertificate.prototype, "_details", {
                get: $util.oneOfGetter($oneOfFields = ["details"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(NoiseCertificate.prototype, "_signature", {
                get: $util.oneOfGetter($oneOfFields = ["signature"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            NoiseCertificate.create = function create(properties) {
                return new NoiseCertificate(properties);
            };

            NoiseCertificate.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                    w.uint32(10).bytes(m.details);
                if (m.signature != null && Object.hasOwnProperty.call(m, "signature"))
                    w.uint32(18).bytes(m.signature);
                return w;
            };

            NoiseCertificate.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain.NoiseCertificate();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.details = r.bytes();
                            break;
                        }
                    case 2: {
                            m.signature = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            NoiseCertificate.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.CertChain.NoiseCertificate)
                    return d;
                var m = new $root.proto.CertChain.NoiseCertificate();
                if (d.details != null) {
                    if (typeof d.details === "string")
                        $util.base64.decode(d.details, m.details = $util.newBuffer($util.base64.length(d.details)), 0);
                    else if (d.details.length >= 0)
                        m.details = d.details;
                }
                if (d.signature != null) {
                    if (typeof d.signature === "string")
                        $util.base64.decode(d.signature, m.signature = $util.newBuffer($util.base64.length(d.signature)), 0);
                    else if (d.signature.length >= 0)
                        m.signature = d.signature;
                }
                return m;
            };

            NoiseCertificate.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.details != null && m.hasOwnProperty("details")) {
                    d.details = o.bytes === String ? $util.base64.encode(m.details, 0, m.details.length) : o.bytes === Array ? Array.prototype.slice.call(m.details) : m.details;
                    if (o.oneofs)
                        d._details = "details";
                }
                if (m.signature != null && m.hasOwnProperty("signature")) {
                    d.signature = o.bytes === String ? $util.base64.encode(m.signature, 0, m.signature.length) : o.bytes === Array ? Array.prototype.slice.call(m.signature) : m.signature;
                    if (o.oneofs)
                        d._signature = "signature";
                }
                return d;
            };

            NoiseCertificate.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            NoiseCertificate.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.CertChain.NoiseCertificate";
            };

            NoiseCertificate.Details = (function() {

                function Details(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Details.prototype.serial = null;
                Details.prototype.issuerSerial = null;
                Details.prototype.key = null;
                Details.prototype.notBefore = null;
                Details.prototype.notAfter = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_serial", {
                    get: $util.oneOfGetter($oneOfFields = ["serial"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_issuerSerial", {
                    get: $util.oneOfGetter($oneOfFields = ["issuerSerial"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_key", {
                    get: $util.oneOfGetter($oneOfFields = ["key"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_notBefore", {
                    get: $util.oneOfGetter($oneOfFields = ["notBefore"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Details.prototype, "_notAfter", {
                    get: $util.oneOfGetter($oneOfFields = ["notAfter"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                Details.create = function create(properties) {
                    return new Details(properties);
                };

                Details.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.serial != null && Object.hasOwnProperty.call(m, "serial"))
                        w.uint32(8).uint32(m.serial);
                    if (m.issuerSerial != null && Object.hasOwnProperty.call(m, "issuerSerial"))
                        w.uint32(16).uint32(m.issuerSerial);
                    if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                        w.uint32(26).bytes(m.key);
                    if (m.notBefore != null && Object.hasOwnProperty.call(m, "notBefore"))
                        w.uint32(32).uint64(m.notBefore);
                    if (m.notAfter != null && Object.hasOwnProperty.call(m, "notAfter"))
                        w.uint32(40).uint64(m.notAfter);
                    return w;
                };

                Details.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain.NoiseCertificate.Details();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.serial = r.uint32();
                                break;
                            }
                        case 2: {
                                m.issuerSerial = r.uint32();
                                break;
                            }
                        case 3: {
                                m.key = r.bytes();
                                break;
                            }
                        case 4: {
                                m.notBefore = r.uint64();
                                break;
                            }
                        case 5: {
                                m.notAfter = r.uint64();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Details.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.CertChain.NoiseCertificate.Details)
                        return d;
                    var m = new $root.proto.CertChain.NoiseCertificate.Details();
                    if (d.serial != null) {
                        m.serial = d.serial >>> 0;
                    }
                    if (d.issuerSerial != null) {
                        m.issuerSerial = d.issuerSerial >>> 0;
                    }
                    if (d.key != null) {
                        if (typeof d.key === "string")
                            $util.base64.decode(d.key, m.key = $util.newBuffer($util.base64.length(d.key)), 0);
                        else if (d.key.length >= 0)
                            m.key = d.key;
                    }
                    if (d.notBefore != null) {
                        if ($util.Long)
                            (m.notBefore = $util.Long.fromValue(d.notBefore)).unsigned = true;
                        else if (typeof d.notBefore === "string")
                            m.notBefore = parseInt(d.notBefore, 10);
                        else if (typeof d.notBefore === "number")
                            m.notBefore = d.notBefore;
                        else if (typeof d.notBefore === "object")
                            m.notBefore = new $util.LongBits(d.notBefore.low >>> 0, d.notBefore.high >>> 0).toNumber(true);
                    }
                    if (d.notAfter != null) {
                        if ($util.Long)
                            (m.notAfter = $util.Long.fromValue(d.notAfter)).unsigned = true;
                        else if (typeof d.notAfter === "string")
                            m.notAfter = parseInt(d.notAfter, 10);
                        else if (typeof d.notAfter === "number")
                            m.notAfter = d.notAfter;
                        else if (typeof d.notAfter === "object")
                            m.notAfter = new $util.LongBits(d.notAfter.low >>> 0, d.notAfter.high >>> 0).toNumber(true);
                    }
                    return m;
                };

                Details.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.serial != null && m.hasOwnProperty("serial")) {
                        d.serial = m.serial;
                        if (o.oneofs)
                            d._serial = "serial";
                    }
                    if (m.issuerSerial != null && m.hasOwnProperty("issuerSerial")) {
                        d.issuerSerial = m.issuerSerial;
                        if (o.oneofs)
                            d._issuerSerial = "issuerSerial";
                    }
                    if (m.key != null && m.hasOwnProperty("key")) {
                        d.key = o.bytes === String ? $util.base64.encode(m.key, 0, m.key.length) : o.bytes === Array ? Array.prototype.slice.call(m.key) : m.key;
                        if (o.oneofs)
                            d._key = "key";
                    }
                    if (m.notBefore != null && m.hasOwnProperty("notBefore")) {
                        if (typeof m.notBefore === "number")
                            d.notBefore = o.longs === String ? String(m.notBefore) : m.notBefore;
                        else
                            d.notBefore = o.longs === String ? $util.Long.prototype.toString.call(m.notBefore) : o.longs === Number ? new $util.LongBits(m.notBefore.low >>> 0, m.notBefore.high >>> 0).toNumber(true) : m.notBefore;
                        if (o.oneofs)
                            d._notBefore = "notBefore";
                    }
                    if (m.notAfter != null && m.hasOwnProperty("notAfter")) {
                        if (typeof m.notAfter === "number")
                            d.notAfter = o.longs === String ? String(m.notAfter) : m.notAfter;
                        else
                            d.notAfter = o.longs === String ? $util.Long.prototype.toString.call(m.notAfter) : o.longs === Number ? new $util.LongBits(m.notAfter.low >>> 0, m.notAfter.high >>> 0).toNumber(true) : m.notAfter;
                        if (o.oneofs)
                            d._notAfter = "notAfter";
                    }
                    return d;
                };

                Details.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                Details.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.CertChain.NoiseCertificate.Details";
                };

                return Details;
            })();

            return NoiseCertificate;
        })();

        return CertChain;
    })();

    proto.ChatLockSettings = (function() {

        function ChatLockSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ChatLockSettings.prototype.hideLockedChats = null;
        ChatLockSettings.prototype.secretCode = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ChatLockSettings.prototype, "_hideLockedChats", {
            get: $util.oneOfGetter($oneOfFields = ["hideLockedChats"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ChatLockSettings.prototype, "_secretCode", {
            get: $util.oneOfGetter($oneOfFields = ["secretCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ChatLockSettings.create = function create(properties) {
            return new ChatLockSettings(properties);
        };

        ChatLockSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.hideLockedChats != null && Object.hasOwnProperty.call(m, "hideLockedChats"))
                w.uint32(8).bool(m.hideLockedChats);
            if (m.secretCode != null && Object.hasOwnProperty.call(m, "secretCode"))
                $root.proto.UserPassword.encode(m.secretCode, w.uint32(18).fork()).ldelim();
            return w;
        };

        ChatLockSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatLockSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.hideLockedChats = r.bool();
                        break;
                    }
                case 2: {
                        m.secretCode = $root.proto.UserPassword.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ChatLockSettings.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ChatLockSettings)
                return d;
            var m = new $root.proto.ChatLockSettings();
            if (d.hideLockedChats != null) {
                m.hideLockedChats = Boolean(d.hideLockedChats);
            }
            if (d.secretCode != null) {
                if (typeof d.secretCode !== "object")
                    throw TypeError(".proto.ChatLockSettings.secretCode: object expected");
                m.secretCode = $root.proto.UserPassword.fromObject(d.secretCode);
            }
            return m;
        };

        ChatLockSettings.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.hideLockedChats != null && m.hasOwnProperty("hideLockedChats")) {
                d.hideLockedChats = m.hideLockedChats;
                if (o.oneofs)
                    d._hideLockedChats = "hideLockedChats";
            }
            if (m.secretCode != null && m.hasOwnProperty("secretCode")) {
                d.secretCode = $root.proto.UserPassword.toObject(m.secretCode, o);
                if (o.oneofs)
                    d._secretCode = "secretCode";
            }
            return d;
        };

        ChatLockSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ChatLockSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ChatLockSettings";
        };

        return ChatLockSettings;
    })();

    proto.ChatRowOpaqueData = (function() {

        function ChatRowOpaqueData(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ChatRowOpaqueData.prototype.draftMessage = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ChatRowOpaqueData.prototype, "_draftMessage", {
            get: $util.oneOfGetter($oneOfFields = ["draftMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ChatRowOpaqueData.create = function create(properties) {
            return new ChatRowOpaqueData(properties);
        };

        ChatRowOpaqueData.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.draftMessage != null && Object.hasOwnProperty.call(m, "draftMessage"))
                $root.proto.ChatRowOpaqueData.DraftMessage.encode(m.draftMessage, w.uint32(10).fork()).ldelim();
            return w;
        };

        ChatRowOpaqueData.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ChatRowOpaqueData.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ChatRowOpaqueData)
                return d;
            var m = new $root.proto.ChatRowOpaqueData();
            if (d.draftMessage != null) {
                if (typeof d.draftMessage !== "object")
                    throw TypeError(".proto.ChatRowOpaqueData.draftMessage: object expected");
                m.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.fromObject(d.draftMessage);
            }
            return m;
        };

        ChatRowOpaqueData.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.draftMessage != null && m.hasOwnProperty("draftMessage")) {
                d.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.toObject(m.draftMessage, o);
                if (o.oneofs)
                    d._draftMessage = "draftMessage";
            }
            return d;
        };

        ChatRowOpaqueData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ChatRowOpaqueData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ChatRowOpaqueData";
        };

        ChatRowOpaqueData.DraftMessage = (function() {

            function DraftMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DraftMessage.prototype.text = null;
            DraftMessage.prototype.omittedUrl = null;
            DraftMessage.prototype.ctwaContextLinkData = null;
            DraftMessage.prototype.ctwaContext = null;
            DraftMessage.prototype.timestamp = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_text", {
                get: $util.oneOfGetter($oneOfFields = ["text"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_omittedUrl", {
                get: $util.oneOfGetter($oneOfFields = ["omittedUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_ctwaContextLinkData", {
                get: $util.oneOfGetter($oneOfFields = ["ctwaContextLinkData"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_ctwaContext", {
                get: $util.oneOfGetter($oneOfFields = ["ctwaContext"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DraftMessage.prototype, "_timestamp", {
                get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DraftMessage.create = function create(properties) {
                return new DraftMessage(properties);
            };

            DraftMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.omittedUrl != null && Object.hasOwnProperty.call(m, "omittedUrl"))
                    w.uint32(18).string(m.omittedUrl);
                if (m.ctwaContextLinkData != null && Object.hasOwnProperty.call(m, "ctwaContextLinkData"))
                    $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.encode(m.ctwaContextLinkData, w.uint32(26).fork()).ldelim();
                if (m.ctwaContext != null && Object.hasOwnProperty.call(m, "ctwaContext"))
                    $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.encode(m.ctwaContext, w.uint32(34).fork()).ldelim();
                if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                    w.uint32(40).int64(m.timestamp);
                return w;
            };

            DraftMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            m.omittedUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.timestamp = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DraftMessage.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ChatRowOpaqueData.DraftMessage)
                    return d;
                var m = new $root.proto.ChatRowOpaqueData.DraftMessage();
                if (d.text != null) {
                    m.text = String(d.text);
                }
                if (d.omittedUrl != null) {
                    m.omittedUrl = String(d.omittedUrl);
                }
                if (d.ctwaContextLinkData != null) {
                    if (typeof d.ctwaContextLinkData !== "object")
                        throw TypeError(".proto.ChatRowOpaqueData.DraftMessage.ctwaContextLinkData: object expected");
                    m.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.fromObject(d.ctwaContextLinkData);
                }
                if (d.ctwaContext != null) {
                    if (typeof d.ctwaContext !== "object")
                        throw TypeError(".proto.ChatRowOpaqueData.DraftMessage.ctwaContext: object expected");
                    m.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.fromObject(d.ctwaContext);
                }
                if (d.timestamp != null) {
                    if ($util.Long)
                        (m.timestamp = $util.Long.fromValue(d.timestamp)).unsigned = false;
                    else if (typeof d.timestamp === "string")
                        m.timestamp = parseInt(d.timestamp, 10);
                    else if (typeof d.timestamp === "number")
                        m.timestamp = d.timestamp;
                    else if (typeof d.timestamp === "object")
                        m.timestamp = new $util.LongBits(d.timestamp.low >>> 0, d.timestamp.high >>> 0).toNumber();
                }
                return m;
            };

            DraftMessage.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.text != null && m.hasOwnProperty("text")) {
                    d.text = m.text;
                    if (o.oneofs)
                        d._text = "text";
                }
                if (m.omittedUrl != null && m.hasOwnProperty("omittedUrl")) {
                    d.omittedUrl = m.omittedUrl;
                    if (o.oneofs)
                        d._omittedUrl = "omittedUrl";
                }
                if (m.ctwaContextLinkData != null && m.hasOwnProperty("ctwaContextLinkData")) {
                    d.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.toObject(m.ctwaContextLinkData, o);
                    if (o.oneofs)
                        d._ctwaContextLinkData = "ctwaContextLinkData";
                }
                if (m.ctwaContext != null && m.hasOwnProperty("ctwaContext")) {
                    d.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.toObject(m.ctwaContext, o);
                    if (o.oneofs)
                        d._ctwaContext = "ctwaContext";
                }
                if (m.timestamp != null && m.hasOwnProperty("timestamp")) {
                    if (typeof m.timestamp === "number")
                        d.timestamp = o.longs === String ? String(m.timestamp) : m.timestamp;
                    else
                        d.timestamp = o.longs === String ? $util.Long.prototype.toString.call(m.timestamp) : o.longs === Number ? new $util.LongBits(m.timestamp.low >>> 0, m.timestamp.high >>> 0).toNumber() : m.timestamp;
                    if (o.oneofs)
                        d._timestamp = "timestamp";
                }
                return d;
            };

            DraftMessage.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DraftMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage";
            };

            DraftMessage.CtwaContextData = (function() {

                function CtwaContextData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CtwaContextData.prototype.conversionSource = null;
                CtwaContextData.prototype.conversionData = null;
                CtwaContextData.prototype.sourceUrl = null;
                CtwaContextData.prototype.sourceId = null;
                CtwaContextData.prototype.sourceType = null;
                CtwaContextData.prototype.title = null;
                CtwaContextData.prototype.description = null;
                CtwaContextData.prototype.thumbnail = null;
                CtwaContextData.prototype.thumbnailUrl = null;
                CtwaContextData.prototype.mediaType = null;
                CtwaContextData.prototype.mediaUrl = null;
                CtwaContextData.prototype.isSuspiciousLink = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_conversionSource", {
                    get: $util.oneOfGetter($oneOfFields = ["conversionSource"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_conversionData", {
                    get: $util.oneOfGetter($oneOfFields = ["conversionData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_sourceId", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_sourceType", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_description", {
                    get: $util.oneOfGetter($oneOfFields = ["description"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_thumbnail", {
                    get: $util.oneOfGetter($oneOfFields = ["thumbnail"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_thumbnailUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_mediaType", {
                    get: $util.oneOfGetter($oneOfFields = ["mediaType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_mediaUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["mediaUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextData.prototype, "_isSuspiciousLink", {
                    get: $util.oneOfGetter($oneOfFields = ["isSuspiciousLink"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                CtwaContextData.create = function create(properties) {
                    return new CtwaContextData(properties);
                };

                CtwaContextData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                        w.uint32(10).string(m.conversionSource);
                    if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                        w.uint32(18).bytes(m.conversionData);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    if (m.sourceId != null && Object.hasOwnProperty.call(m, "sourceId"))
                        w.uint32(34).string(m.sourceId);
                    if (m.sourceType != null && Object.hasOwnProperty.call(m, "sourceType"))
                        w.uint32(42).string(m.sourceType);
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(50).string(m.title);
                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                        w.uint32(58).string(m.description);
                    if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                        w.uint32(66).string(m.thumbnail);
                    if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                        w.uint32(74).string(m.thumbnailUrl);
                    if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                        w.uint32(80).int32(m.mediaType);
                    if (m.mediaUrl != null && Object.hasOwnProperty.call(m, "mediaUrl"))
                        w.uint32(90).string(m.mediaUrl);
                    if (m.isSuspiciousLink != null && Object.hasOwnProperty.call(m, "isSuspiciousLink"))
                        w.uint32(96).bool(m.isSuspiciousLink);
                    return w;
                };

                CtwaContextData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.conversionSource = r.string();
                                break;
                            }
                        case 2: {
                                m.conversionData = r.bytes();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.sourceId = r.string();
                                break;
                            }
                        case 5: {
                                m.sourceType = r.string();
                                break;
                            }
                        case 6: {
                                m.title = r.string();
                                break;
                            }
                        case 7: {
                                m.description = r.string();
                                break;
                            }
                        case 8: {
                                m.thumbnail = r.string();
                                break;
                            }
                        case 9: {
                                m.thumbnailUrl = r.string();
                                break;
                            }
                        case 10: {
                                m.mediaType = r.int32();
                                break;
                            }
                        case 11: {
                                m.mediaUrl = r.string();
                                break;
                            }
                        case 12: {
                                m.isSuspiciousLink = r.bool();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CtwaContextData.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData)
                        return d;
                    var m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData();
                    if (d.conversionSource != null) {
                        m.conversionSource = String(d.conversionSource);
                    }
                    if (d.conversionData != null) {
                        if (typeof d.conversionData === "string")
                            $util.base64.decode(d.conversionData, m.conversionData = $util.newBuffer($util.base64.length(d.conversionData)), 0);
                        else if (d.conversionData.length >= 0)
                            m.conversionData = d.conversionData;
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    if (d.sourceId != null) {
                        m.sourceId = String(d.sourceId);
                    }
                    if (d.sourceType != null) {
                        m.sourceType = String(d.sourceType);
                    }
                    if (d.title != null) {
                        m.title = String(d.title);
                    }
                    if (d.description != null) {
                        m.description = String(d.description);
                    }
                    if (d.thumbnail != null) {
                        m.thumbnail = String(d.thumbnail);
                    }
                    if (d.thumbnailUrl != null) {
                        m.thumbnailUrl = String(d.thumbnailUrl);
                    }
                    switch (d.mediaType) {
                    default:
                        if (typeof d.mediaType === "number") {
                            m.mediaType = d.mediaType;
                            break;
                        }
                        break;
                    case "NONE":
                    case 0:
                        m.mediaType = 0;
                        break;
                    case "IMAGE":
                    case 1:
                        m.mediaType = 1;
                        break;
                    case "VIDEO":
                    case 2:
                        m.mediaType = 2;
                        break;
                    }
                    if (d.mediaUrl != null) {
                        m.mediaUrl = String(d.mediaUrl);
                    }
                    if (d.isSuspiciousLink != null) {
                        m.isSuspiciousLink = Boolean(d.isSuspiciousLink);
                    }
                    return m;
                };

                CtwaContextData.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.conversionSource != null && m.hasOwnProperty("conversionSource")) {
                        d.conversionSource = m.conversionSource;
                        if (o.oneofs)
                            d._conversionSource = "conversionSource";
                    }
                    if (m.conversionData != null && m.hasOwnProperty("conversionData")) {
                        d.conversionData = o.bytes === String ? $util.base64.encode(m.conversionData, 0, m.conversionData.length) : o.bytes === Array ? Array.prototype.slice.call(m.conversionData) : m.conversionData;
                        if (o.oneofs)
                            d._conversionData = "conversionData";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    if (m.sourceId != null && m.hasOwnProperty("sourceId")) {
                        d.sourceId = m.sourceId;
                        if (o.oneofs)
                            d._sourceId = "sourceId";
                    }
                    if (m.sourceType != null && m.hasOwnProperty("sourceType")) {
                        d.sourceType = m.sourceType;
                        if (o.oneofs)
                            d._sourceType = "sourceType";
                    }
                    if (m.title != null && m.hasOwnProperty("title")) {
                        d.title = m.title;
                        if (o.oneofs)
                            d._title = "title";
                    }
                    if (m.description != null && m.hasOwnProperty("description")) {
                        d.description = m.description;
                        if (o.oneofs)
                            d._description = "description";
                    }
                    if (m.thumbnail != null && m.hasOwnProperty("thumbnail")) {
                        d.thumbnail = m.thumbnail;
                        if (o.oneofs)
                            d._thumbnail = "thumbnail";
                    }
                    if (m.thumbnailUrl != null && m.hasOwnProperty("thumbnailUrl")) {
                        d.thumbnailUrl = m.thumbnailUrl;
                        if (o.oneofs)
                            d._thumbnailUrl = "thumbnailUrl";
                    }
                    if (m.mediaType != null && m.hasOwnProperty("mediaType")) {
                        d.mediaType = o.enums === String ? $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.ContextInfoExternalAdReplyInfoMediaType[m.mediaType] === undefined ? m.mediaType : $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.ContextInfoExternalAdReplyInfoMediaType[m.mediaType] : m.mediaType;
                        if (o.oneofs)
                            d._mediaType = "mediaType";
                    }
                    if (m.mediaUrl != null && m.hasOwnProperty("mediaUrl")) {
                        d.mediaUrl = m.mediaUrl;
                        if (o.oneofs)
                            d._mediaUrl = "mediaUrl";
                    }
                    if (m.isSuspiciousLink != null && m.hasOwnProperty("isSuspiciousLink")) {
                        d.isSuspiciousLink = m.isSuspiciousLink;
                        if (o.oneofs)
                            d._isSuspiciousLink = "isSuspiciousLink";
                    }
                    return d;
                };

                CtwaContextData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                CtwaContextData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage.CtwaContextData";
                };

                CtwaContextData.ContextInfoExternalAdReplyInfoMediaType = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "NONE"] = 0;
                    values[valuesById[1] = "IMAGE"] = 1;
                    values[valuesById[2] = "VIDEO"] = 2;
                    return values;
                })();

                return CtwaContextData;
            })();

            DraftMessage.CtwaContextLinkData = (function() {

                function CtwaContextLinkData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CtwaContextLinkData.prototype.context = null;
                CtwaContextLinkData.prototype.sourceUrl = null;
                CtwaContextLinkData.prototype.icebreaker = null;
                CtwaContextLinkData.prototype.phone = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_context", {
                    get: $util.oneOfGetter($oneOfFields = ["context"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_icebreaker", {
                    get: $util.oneOfGetter($oneOfFields = ["icebreaker"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(CtwaContextLinkData.prototype, "_phone", {
                    get: $util.oneOfGetter($oneOfFields = ["phone"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                CtwaContextLinkData.create = function create(properties) {
                    return new CtwaContextLinkData(properties);
                };

                CtwaContextLinkData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.context != null && Object.hasOwnProperty.call(m, "context"))
                        w.uint32(10).string(m.context);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(18).string(m.sourceUrl);
                    if (m.icebreaker != null && Object.hasOwnProperty.call(m, "icebreaker"))
                        w.uint32(26).string(m.icebreaker);
                    if (m.phone != null && Object.hasOwnProperty.call(m, "phone"))
                        w.uint32(34).string(m.phone);
                    return w;
                };

                CtwaContextLinkData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.context = r.string();
                                break;
                            }
                        case 2: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 3: {
                                m.icebreaker = r.string();
                                break;
                            }
                        case 4: {
                                m.phone = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CtwaContextLinkData.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData)
                        return d;
                    var m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData();
                    if (d.context != null) {
                        m.context = String(d.context);
                    }
                    if (d.sourceUrl != null) {
                        m.sourceUrl = String(d.sourceUrl);
                    }
                    if (d.icebreaker != null) {
                        m.icebreaker = String(d.icebreaker);
                    }
                    if (d.phone != null) {
                        m.phone = String(d.phone);
                    }
                    return m;
                };

                CtwaContextLinkData.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.context != null && m.hasOwnProperty("context")) {
                        d.context = m.context;
                        if (o.oneofs)
                            d._context = "context";
                    }
                    if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                        d.sourceUrl = m.sourceUrl;
                        if (o.oneofs)
                            d._sourceUrl = "sourceUrl";
                    }
                    if (m.icebreaker != null && m.hasOwnProperty("icebreaker")) {
                        d.icebreaker = m.icebreaker;
                        if (o.oneofs)
                            d._icebreaker = "icebreaker";
                    }
                    if (m.phone != null && m.hasOwnProperty("phone")) {
                        d.phone = m.phone;
                        if (o.oneofs)
                            d._phone = "phone";
                    }
                    return d;
                };

                CtwaContextLinkData.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                CtwaContextLinkData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData";
                };

                return CtwaContextLinkData;
            })();

            return DraftMessage;
        })();

        return ChatRowOpaqueData;
    })();

    proto.Citation = (function() {

        function Citation(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Citation.prototype.title = "";
        Citation.prototype.subtitle = "";
        Citation.prototype.cmsId = "";
        Citation.prototype.imageUrl = "";

        Citation.create = function create(properties) {
            return new Citation(properties);
        };

        Citation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                w.uint32(10).string(m.title);
            if (m.subtitle != null && Object.hasOwnProperty.call(m, "subtitle"))
                w.uint32(18).string(m.subtitle);
            if (m.cmsId != null && Object.hasOwnProperty.call(m, "cmsId"))
                w.uint32(26).string(m.cmsId);
            if (m.imageUrl != null && Object.hasOwnProperty.call(m, "imageUrl"))
                w.uint32(34).string(m.imageUrl);
            return w;
        };

        Citation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Citation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.title = r.string();
                        break;
                    }
                case 2: {
                        m.subtitle = r.string();
                        break;
                    }
                case 3: {
                        m.cmsId = r.string();
                        break;
                    }
                case 4: {
                        m.imageUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Citation.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Citation)
                return d;
            var m = new $root.proto.Citation();
            if (d.title != null) {
                m.title = String(d.title);
            }
            if (d.subtitle != null) {
                m.subtitle = String(d.subtitle);
            }
            if (d.cmsId != null) {
                m.cmsId = String(d.cmsId);
            }
            if (d.imageUrl != null) {
                m.imageUrl = String(d.imageUrl);
            }
            return m;
        };

        Citation.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.defaults) {
                d.title = "";
                d.subtitle = "";
                d.cmsId = "";
                d.imageUrl = "";
            }
            if (m.title != null && m.hasOwnProperty("title")) {
                d.title = m.title;
            }
            if (m.subtitle != null && m.hasOwnProperty("subtitle")) {
                d.subtitle = m.subtitle;
            }
            if (m.cmsId != null && m.hasOwnProperty("cmsId")) {
                d.cmsId = m.cmsId;
            }
            if (m.imageUrl != null && m.hasOwnProperty("imageUrl")) {
                d.imageUrl = m.imageUrl;
            }
            return d;
        };

        Citation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Citation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Citation";
        };

        return Citation;
    })();

    proto.ClientPairingProps = (function() {

        function ClientPairingProps(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ClientPairingProps.prototype.isChatDbLidMigrated = null;
        ClientPairingProps.prototype.isSyncdPureLidSession = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPairingProps.prototype, "_isChatDbLidMigrated", {
            get: $util.oneOfGetter($oneOfFields = ["isChatDbLidMigrated"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPairingProps.prototype, "_isSyncdPureLidSession", {
            get: $util.oneOfGetter($oneOfFields = ["isSyncdPureLidSession"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ClientPairingProps.create = function create(properties) {
            return new ClientPairingProps(properties);
        };

        ClientPairingProps.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.isChatDbLidMigrated != null && Object.hasOwnProperty.call(m, "isChatDbLidMigrated"))
                w.uint32(8).bool(m.isChatDbLidMigrated);
            if (m.isSyncdPureLidSession != null && Object.hasOwnProperty.call(m, "isSyncdPureLidSession"))
                w.uint32(16).bool(m.isSyncdPureLidSession);
            return w;
        };

        ClientPairingProps.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPairingProps();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.isChatDbLidMigrated = r.bool();
                        break;
                    }
                case 2: {
                        m.isSyncdPureLidSession = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ClientPairingProps.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ClientPairingProps)
                return d;
            var m = new $root.proto.ClientPairingProps();
            if (d.isChatDbLidMigrated != null) {
                m.isChatDbLidMigrated = Boolean(d.isChatDbLidMigrated);
            }
            if (d.isSyncdPureLidSession != null) {
                m.isSyncdPureLidSession = Boolean(d.isSyncdPureLidSession);
            }
            return m;
        };

        ClientPairingProps.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.isChatDbLidMigrated != null && m.hasOwnProperty("isChatDbLidMigrated")) {
                d.isChatDbLidMigrated = m.isChatDbLidMigrated;
                if (o.oneofs)
                    d._isChatDbLidMigrated = "isChatDbLidMigrated";
            }
            if (m.isSyncdPureLidSession != null && m.hasOwnProperty("isSyncdPureLidSession")) {
                d.isSyncdPureLidSession = m.isSyncdPureLidSession;
                if (o.oneofs)
                    d._isSyncdPureLidSession = "isSyncdPureLidSession";
            }
            return d;
        };

        ClientPairingProps.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ClientPairingProps.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ClientPairingProps";
        };

        return ClientPairingProps;
    })();

    proto.ClientPayload = (function() {

        function ClientPayload(p) {
            this.shards = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ClientPayload.prototype.username = null;
        ClientPayload.prototype.passive = null;
        ClientPayload.prototype.userAgent = null;
        ClientPayload.prototype.webInfo = null;
        ClientPayload.prototype.pushName = null;
        ClientPayload.prototype.sessionId = null;
        ClientPayload.prototype.shortConnect = null;
        ClientPayload.prototype.connectType = null;
        ClientPayload.prototype.connectReason = null;
        ClientPayload.prototype.shards = $util.emptyArray;
        ClientPayload.prototype.dnsSource = null;
        ClientPayload.prototype.connectAttemptCount = null;
        ClientPayload.prototype.device = null;
        ClientPayload.prototype.devicePairingData = null;
        ClientPayload.prototype.product = null;
        ClientPayload.prototype.fbCat = null;
        ClientPayload.prototype.fbUserAgent = null;
        ClientPayload.prototype.oc = null;
        ClientPayload.prototype.lc = null;
        ClientPayload.prototype.iosAppExtension = null;
        ClientPayload.prototype.fbAppId = null;
        ClientPayload.prototype.fbDeviceId = null;
        ClientPayload.prototype.pull = null;
        ClientPayload.prototype.paddingBytes = null;
        ClientPayload.prototype.yearClass = null;
        ClientPayload.prototype.memClass = null;
        ClientPayload.prototype.interopData = null;
        ClientPayload.prototype.trafficAnonymization = null;
        ClientPayload.prototype.lidDbMigrated = null;
        ClientPayload.prototype.accountType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_username", {
            get: $util.oneOfGetter($oneOfFields = ["username"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_passive", {
            get: $util.oneOfGetter($oneOfFields = ["passive"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_userAgent", {
            get: $util.oneOfGetter($oneOfFields = ["userAgent"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_webInfo", {
            get: $util.oneOfGetter($oneOfFields = ["webInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_pushName", {
            get: $util.oneOfGetter($oneOfFields = ["pushName"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_sessionId", {
            get: $util.oneOfGetter($oneOfFields = ["sessionId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_shortConnect", {
            get: $util.oneOfGetter($oneOfFields = ["shortConnect"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectType", {
            get: $util.oneOfGetter($oneOfFields = ["connectType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectReason", {
            get: $util.oneOfGetter($oneOfFields = ["connectReason"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_dnsSource", {
            get: $util.oneOfGetter($oneOfFields = ["dnsSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_connectAttemptCount", {
            get: $util.oneOfGetter($oneOfFields = ["connectAttemptCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_device", {
            get: $util.oneOfGetter($oneOfFields = ["device"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_devicePairingData", {
            get: $util.oneOfGetter($oneOfFields = ["devicePairingData"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_product", {
            get: $util.oneOfGetter($oneOfFields = ["product"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbCat", {
            get: $util.oneOfGetter($oneOfFields = ["fbCat"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbUserAgent", {
            get: $util.oneOfGetter($oneOfFields = ["fbUserAgent"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_oc", {
            get: $util.oneOfGetter($oneOfFields = ["oc"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_lc", {
            get: $util.oneOfGetter($oneOfFields = ["lc"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_iosAppExtension", {
            get: $util.oneOfGetter($oneOfFields = ["iosAppExtension"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbAppId", {
            get: $util.oneOfGetter($oneOfFields = ["fbAppId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_fbDeviceId", {
            get: $util.oneOfGetter($oneOfFields = ["fbDeviceId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_pull", {
            get: $util.oneOfGetter($oneOfFields = ["pull"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_paddingBytes", {
            get: $util.oneOfGetter($oneOfFields = ["paddingBytes"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_yearClass", {
            get: $util.oneOfGetter($oneOfFields = ["yearClass"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_memClass", {
            get: $util.oneOfGetter($oneOfFields = ["memClass"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_interopData", {
            get: $util.oneOfGetter($oneOfFields = ["interopData"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_trafficAnonymization", {
            get: $util.oneOfGetter($oneOfFields = ["trafficAnonymization"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_lidDbMigrated", {
            get: $util.oneOfGetter($oneOfFields = ["lidDbMigrated"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ClientPayload.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ClientPayload.create = function create(properties) {
            return new ClientPayload(properties);
        };

        ClientPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(8).uint64(m.username);
            if (m.passive != null && Object.hasOwnProperty.call(m, "passive"))
                w.uint32(24).bool(m.passive);
            if (m.userAgent != null && Object.hasOwnProperty.call(m, "userAgent"))
                $root.proto.ClientPayload.UserAgent.encode(m.userAgent, w.uint32(42).fork()).ldelim();
            if (m.webInfo != null && Object.hasOwnProperty.call(m, "webInfo"))
                $root.proto.ClientPayload.WebInfo.encode(m.webInfo, w.uint32(50).fork()).ldelim();
            if (m.pushName != null && Object.hasOwnProperty.call(m, "pushName"))
                w.uint32(58).string(m.pushName);
            if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                w.uint32(77).sfixed32(m.sessionId);
            if (m.shortConnect != null && Object.hasOwnProperty.call(m, "shortConnect"))
                w.uint32(80).bool(m.shortConnect);
            if (m.connectType != null && Object.hasOwnProperty.call(m, "connectType"))
                w.uint32(96).int32(m.connectType);
            if (m.connectReason != null && Object.hasOwnProperty.call(m, "connectReason"))
                w.uint32(104).int32(m.connectReason);
            if (m.shards != null && m.shards.length) {
                w.uint32(114).fork();
                for (var i = 0; i < m.shards.length; ++i)
                    w.int32(m.shards[i]);
                w.ldelim();
            }
            if (m.dnsSource != null && Object.hasOwnProperty.call(m, "dnsSource"))
                $root.proto.ClientPayload.DNSSource.encode(m.dnsSource, w.uint32(122).fork()).ldelim();
            if (m.connectAttemptCount != null && Object.hasOwnProperty.call(m, "connectAttemptCount"))
                w.uint32(128).uint32(m.connectAttemptCount);
            if (m.device != null && Object.hasOwnProperty.call(m, "device"))
                w.uint32(144).uint32(m.device);
            if (m.devicePairingData != null && Object.hasOwnProperty.call(m, "devicePairingData"))
                $root.proto.ClientPayload.DevicePairingRegistrationData.encode(m.devicePairingData, w.uint32(154).fork()).ldelim();
            if (m.product != null && Object.hasOwnProperty.call(m, "product"))
                w.uint32(160).int32(m.product);
            if (m.fbCat != null && Object.hasOwnProperty.call(m, "fbCat"))
                w.uint32(170).bytes(m.fbCat);
            if (m.fbUserAgent != null && Object.hasOwnProperty.call(m, "fbUserAgent"))
                w.uint32(178).bytes(m.fbUserAgent);
            if (m.oc != null && Object.hasOwnProperty.call(m, "oc"))
                w.uint32(184).bool(m.oc);
            if (m.lc != null && Object.hasOwnProperty.call(m, "lc"))
                w.uint32(192).int32(m.lc);
            if (m.iosAppExtension != null && Object.hasOwnProperty.call(m, "iosAppExtension"))
                w.uint32(240).int32(m.iosAppExtension);
            if (m.fbAppId != null && Object.hasOwnProperty.call(m, "fbAppId"))
                w.uint32(248).uint64(m.fbAppId);
            if (m.fbDeviceId != null && Object.hasOwnProperty.call(m, "fbDeviceId"))
                w.uint32(258).bytes(m.fbDeviceId);
            if (m.pull != null && Object.hasOwnProperty.call(m, "pull"))
                w.uint32(264).bool(m.pull);
            if (m.paddingBytes != null && Object.hasOwnProperty.call(m, "paddingBytes"))
                w.uint32(274).bytes(m.paddingBytes);
            if (m.yearClass != null && Object.hasOwnProperty.call(m, "yearClass"))
                w.uint32(288).int32(m.yearClass);
            if (m.memClass != null && Object.hasOwnProperty.call(m, "memClass"))
                w.uint32(296).int32(m.memClass);
            if (m.interopData != null && Object.hasOwnProperty.call(m, "interopData"))
                $root.proto.ClientPayload.InteropData.encode(m.interopData, w.uint32(306).fork()).ldelim();
            if (m.trafficAnonymization != null && Object.hasOwnProperty.call(m, "trafficAnonymization"))
                w.uint32(320).int32(m.trafficAnonymization);
            if (m.lidDbMigrated != null && Object.hasOwnProperty.call(m, "lidDbMigrated"))
                w.uint32(328).bool(m.lidDbMigrated);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(336).int32(m.accountType);
            return w;
        };

        ClientPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.username = r.uint64();
                        break;
                    }
                case 3: {
                        m.passive = r.bool();
                        break;
                    }
                case 5: {
                        m.userAgent = $root.proto.ClientPayload.UserAgent.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.webInfo = $root.proto.ClientPayload.WebInfo.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.pushName = r.string();
                        break;
                    }
                case 9: {
                        m.sessionId = r.sfixed32();
                        break;
                    }
                case 10: {
                        m.shortConnect = r.bool();
                        break;
                    }
                case 12: {
                        m.connectType = r.int32();
                        break;
                    }
                case 13: {
                        m.connectReason = r.int32();
                        break;
                    }
                case 14: {
                        if (!(m.shards && m.shards.length))
                            m.shards = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.shards.push(r.int32());
                        } else
                            m.shards.push(r.int32());
                        break;
                    }
                case 15: {
                        m.dnsSource = $root.proto.ClientPayload.DNSSource.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.connectAttemptCount = r.uint32();
                        break;
                    }
                case 18: {
                        m.device = r.uint32();
                        break;
                    }
                case 19: {
                        m.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.product = r.int32();
                        break;
                    }
                case 21: {
                        m.fbCat = r.bytes();
                        break;
                    }
                case 22: {
                        m.fbUserAgent = r.bytes();
                        break;
                    }
                case 23: {
                        m.oc = r.bool();
                        break;
                    }
                case 24: {
                        m.lc = r.int32();
                        break;
                    }
                case 30: {
                        m.iosAppExtension = r.int32();
                        break;
                    }
                case 31: {
                        m.fbAppId = r.uint64();
                        break;
                    }
                case 32: {
                        m.fbDeviceId = r.bytes();
                        break;
                    }
                case 33: {
                        m.pull = r.bool();
                        break;
                    }
                case 34: {
                        m.paddingBytes = r.bytes();
                        break;
                    }
                case 36: {
                        m.yearClass = r.int32();
                        break;
                    }
                case 37: {
                        m.memClass = r.int32();
                        break;
                    }
                case 38: {
                        m.interopData = $root.proto.ClientPayload.InteropData.decode(r, r.uint32());
                        break;
                    }
                case 40: {
                        m.trafficAnonymization = r.int32();
                        break;
                    }
                case 41: {
                        m.lidDbMigrated = r.bool();
                        break;
                    }
                case 42: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ClientPayload.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ClientPayload)
                return d;
            var m = new $root.proto.ClientPayload();
            if (d.username != null) {
                if ($util.Long)
                    (m.username = $util.Long.fromValue(d.username)).unsigned = true;
                else if (typeof d.username === "string")
                    m.username = parseInt(d.username, 10);
                else if (typeof d.username === "number")
                    m.username = d.username;
                else if (typeof d.username === "object")
                    m.username = new $util.LongBits(d.username.low >>> 0, d.username.high >>> 0).toNumber(true);
            }
            if (d.passive != null) {
                m.passive = Boolean(d.passive);
            }
            if (d.userAgent != null) {
                if (typeof d.userAgent !== "object")
                    throw TypeError(".proto.ClientPayload.userAgent: object expected");
                m.userAgent = $root.proto.ClientPayload.UserAgent.fromObject(d.userAgent);
            }
            if (d.webInfo != null) {
                if (typeof d.webInfo !== "object")
                    throw TypeError(".proto.ClientPayload.webInfo: object expected");
                m.webInfo = $root.proto.ClientPayload.WebInfo.fromObject(d.webInfo);
            }
            if (d.pushName != null) {
                m.pushName = String(d.pushName);
            }
            if (d.sessionId != null) {
                m.sessionId = d.sessionId | 0;
            }
            if (d.shortConnect != null) {
                m.shortConnect = Boolean(d.shortConnect);
            }
            switch (d.connectType) {
            default:
                if (typeof d.connectType === "number") {
                    m.connectType = d.connectType;
                    break;
                }
                break;
            case "CELLULAR_UNKNOWN":
            case 0:
                m.connectType = 0;
                break;
            case "WIFI_UNKNOWN":
            case 1:
                m.connectType = 1;
                break;
            case "CELLULAR_EDGE":
            case 100:
                m.connectType = 100;
                break;
            case "CELLULAR_IDEN":
            case 101:
                m.connectType = 101;
                break;
            case "CELLULAR_UMTS":
            case 102:
                m.connectType = 102;
                break;
            case "CELLULAR_EVDO":
            case 103:
                m.connectType = 103;
                break;
            case "CELLULAR_GPRS":
            case 104:
                m.connectType = 104;
                break;
            case "CELLULAR_HSDPA":
            case 105:
                m.connectType = 105;
                break;
            case "CELLULAR_HSUPA":
            case 106:
                m.connectType = 106;
                break;
            case "CELLULAR_HSPA":
            case 107:
                m.connectType = 107;
                break;
            case "CELLULAR_CDMA":
            case 108:
                m.connectType = 108;
                break;
            case "CELLULAR_1XRTT":
            case 109:
                m.connectType = 109;
                break;
            case "CELLULAR_EHRPD":
            case 110:
                m.connectType = 110;
                break;
            case "CELLULAR_LTE":
            case 111:
                m.connectType = 111;
                break;
            case "CELLULAR_HSPAP":
            case 112:
                m.connectType = 112;
                break;
            }
            switch (d.connectReason) {
            default:
                if (typeof d.connectReason === "number") {
                    m.connectReason = d.connectReason;
                    break;
                }
                break;
            case "PUSH":
            case 0:
                m.connectReason = 0;
                break;
            case "USER_ACTIVATED":
            case 1:
                m.connectReason = 1;
                break;
            case "SCHEDULED":
            case 2:
                m.connectReason = 2;
                break;
            case "ERROR_RECONNECT":
            case 3:
                m.connectReason = 3;
                break;
            case "NETWORK_SWITCH":
            case 4:
                m.connectReason = 4;
                break;
            case "PING_RECONNECT":
            case 5:
                m.connectReason = 5;
                break;
            case "UNKNOWN":
            case 6:
                m.connectReason = 6;
                break;
            }
            if (d.shards) {
                if (!Array.isArray(d.shards))
                    throw TypeError(".proto.ClientPayload.shards: array expected");
                m.shards = [];
                for (var i = 0; i < d.shards.length; ++i) {
                    m.shards[i] = d.shards[i] | 0;
                }
            }
            if (d.dnsSource != null) {
                if (typeof d.dnsSource !== "object")
                    throw TypeError(".proto.ClientPayload.dnsSource: object expected");
                m.dnsSource = $root.proto.ClientPayload.DNSSource.fromObject(d.dnsSource);
            }
            if (d.connectAttemptCount != null) {
                m.connectAttemptCount = d.connectAttemptCount >>> 0;
            }
            if (d.device != null) {
                m.device = d.device >>> 0;
            }
            if (d.devicePairingData != null) {
                if (typeof d.devicePairingData !== "object")
                    throw TypeError(".proto.ClientPayload.devicePairingData: object expected");
                m.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.fromObject(d.devicePairingData);
            }
            switch (d.product) {
            default:
                if (typeof d.product === "number") {
                    m.product = d.product;
                    break;
                }
                break;
            case "WHATSAPP":
            case 0:
                m.product = 0;
                break;
            case "MESSENGER":
            case 1:
                m.product = 1;
                break;
            case "INTEROP":
            case 2:
                m.product = 2;
                break;
            case "INTEROP_MSGR":
            case 3:
                m.product = 3;
                break;
            case "WHATSAPP_LID":
            case 4:
                m.product = 4;
                break;
            }
            if (d.fbCat != null) {
                if (typeof d.fbCat === "string")
                    $util.base64.decode(d.fbCat, m.fbCat = $util.newBuffer($util.base64.length(d.fbCat)), 0);
                else if (d.fbCat.length >= 0)
                    m.fbCat = d.fbCat;
            }
            if (d.fbUserAgent != null) {
                if (typeof d.fbUserAgent === "string")
                    $util.base64.decode(d.fbUserAgent, m.fbUserAgent = $util.newBuffer($util.base64.length(d.fbUserAgent)), 0);
                else if (d.fbUserAgent.length >= 0)
                    m.fbUserAgent = d.fbUserAgent;
            }
            if (d.oc != null) {
                m.oc = Boolean(d.oc);
            }
            if (d.lc != null) {
                m.lc = d.lc | 0;
            }
            switch (d.iosAppExtension) {
            default:
                if (typeof d.iosAppExtension === "number") {
                    m.iosAppExtension = d.iosAppExtension;
                    break;
                }
                break;
            case "SHARE_EXTENSION":
            case 0:
                m.iosAppExtension = 0;
                break;
            case "SERVICE_EXTENSION":
            case 1:
                m.iosAppExtension = 1;
                break;
            case "INTENTS_EXTENSION":
            case 2:
                m.iosAppExtension = 2;
                break;
            }
            if (d.fbAppId != null) {
                if ($util.Long)
                    (m.fbAppId = $util.Long.fromValue(d.fbAppId)).unsigned = true;
                else if (typeof d.fbAppId === "string")
                    m.fbAppId = parseInt(d.fbAppId, 10);
                else if (typeof d.fbAppId === "number")
                    m.fbAppId = d.fbAppId;
                else if (typeof d.fbAppId === "object")
                    m.fbAppId = new $util.LongBits(d.fbAppId.low >>> 0, d.fbAppId.high >>> 0).toNumber(true);
            }
            if (d.fbDeviceId != null) {
                if (typeof d.fbDeviceId === "string")
                    $util.base64.decode(d.fbDeviceId, m.fbDeviceId = $util.newBuffer($util.base64.length(d.fbDeviceId)), 0);
                else if (d.fbDeviceId.length >= 0)
                    m.fbDeviceId = d.fbDeviceId;
            }
            if (d.pull != null) {
                m.pull = Boolean(d.pull);
            }
            if (d.paddingBytes != null) {
                if (typeof d.paddingBytes === "string")
                    $util.base64.decode(d.paddingBytes, m.paddingBytes = $util.newBuffer($util.base64.length(d.paddingBytes)), 0);
                else if (d.paddingBytes.length >= 0)
                    m.paddingBytes = d.paddingBytes;
            }
            if (d.yearClass != null) {
                m.yearClass = d.yearClass | 0;
            }
            if (d.memClass != null) {
                m.memClass = d.memClass | 0;
            }
            if (d.interopData != null) {
                if (typeof d.interopData !== "object")
                    throw TypeError(".proto.ClientPayload.interopData: object expected");
                m.interopData = $root.proto.ClientPayload.InteropData.fromObject(d.interopData);
            }
            switch (d.trafficAnonymization) {
            default:
                if (typeof d.trafficAnonymization === "number") {
                    m.trafficAnonymization = d.trafficAnonymization;
                    break;
                }
                break;
            case "OFF":
            case 0:
                m.trafficAnonymization = 0;
                break;
            case "STANDARD":
            case 1:
                m.trafficAnonymization = 1;
                break;
            }
            if (d.lidDbMigrated != null) {
                m.lidDbMigrated = Boolean(d.lidDbMigrated);
            }
            switch (d.accountType) {
            default:
                if (typeof d.accountType === "number") {
                    m.accountType = d.accountType;
                    break;
                }
                break;
            case "DEFAULT":
            case 0:
                m.accountType = 0;
                break;
            case "GUEST":
            case 1:
                m.accountType = 1;
                break;
            }
            return m;
        };

        ClientPayload.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.shards = [];
            }
            if (m.username != null && m.hasOwnProperty("username")) {
                if (typeof m.username === "number")
                    d.username = o.longs === String ? String(m.username) : m.username;
                else
                    d.username = o.longs === String ? $util.Long.prototype.toString.call(m.username) : o.longs === Number ? new $util.LongBits(m.username.low >>> 0, m.username.high >>> 0).toNumber(true) : m.username;
                if (o.oneofs)
                    d._username = "username";
            }
            if (m.passive != null && m.hasOwnProperty("passive")) {
                d.passive = m.passive;
                if (o.oneofs)
                    d._passive = "passive";
            }
            if (m.userAgent != null && m.hasOwnProperty("userAgent")) {
                d.userAgent = $root.proto.ClientPayload.UserAgent.toObject(m.userAgent, o);
                if (o.oneofs)
                    d._userAgent = "userAgent";
            }
            if (m.webInfo != null && m.hasOwnProperty("webInfo")) {
                d.webInfo = $root.proto.ClientPayload.WebInfo.toObject(m.webInfo, o);
                if (o.oneofs)
                    d._webInfo = "webInfo";
            }
            if (m.pushName != null && m.hasOwnProperty("pushName")) {
                d.pushName = m.pushName;
                if (o.oneofs)
                    d._pushName = "pushName";
            }
            if (m.sessionId != null && m.hasOwnProperty("sessionId")) {
                d.sessionId = m.sessionId;
                if (o.oneofs)
                    d._sessionId = "sessionId";
            }
            if (m.shortConnect != null && m.hasOwnProperty("shortConnect")) {
                d.shortConnect = m.shortConnect;
                if (o.oneofs)
                    d._shortConnect = "shortConnect";
            }
            if (m.connectType != null && m.hasOwnProperty("connectType")) {
                d.connectType = o.enums === String ? $root.proto.ClientPayload.ConnectType[m.connectType] === undefined ? m.connectType : $root.proto.ClientPayload.ConnectType[m.connectType] : m.connectType;
                if (o.oneofs)
                    d._connectType = "connectType";
            }
            if (m.connectReason != null && m.hasOwnProperty("connectReason")) {
                d.connectReason = o.enums === String ? $root.proto.ClientPayload.ConnectReason[m.connectReason] === undefined ? m.connectReason : $root.proto.ClientPayload.ConnectReason[m.connectReason] : m.connectReason;
                if (o.oneofs)
                    d._connectReason = "connectReason";
            }
            if (m.shards && m.shards.length) {
                d.shards = [];
                for (var j = 0; j < m.shards.length; ++j) {
                    d.shards[j] = m.shards[j];
                }
            }
            if (m.dnsSource != null && m.hasOwnProperty("dnsSource")) {
                d.dnsSource = $root.proto.ClientPayload.DNSSource.toObject(m.dnsSource, o);
                if (o.oneofs)
                    d._dnsSource = "dnsSource";
            }
            if (m.connectAttemptCount != null && m.hasOwnProperty("connectAttemptCount")) {
                d.connectAttemptCount = m.connectAttemptCount;
                if (o.oneofs)
                    d._connectAttemptCount = "connectAttemptCount";
            }
            if (m.device != null && m.hasOwnProperty("device")) {
                d.device = m.device;
                if (o.oneofs)
                    d._device = "device";
            }
            if (m.devicePairingData != null && m.hasOwnProperty("devicePairingData")) {
                d.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.toObject(m.devicePairingData, o);
                if (o.oneofs)
                    d._devicePairingData = "devicePairingData";
            }
            if (m.product != null && m.hasOwnProperty("product")) {
                d.product = o.enums === String ? $root.proto.ClientPayload.Product[m.product] === undefined ? m.product : $root.proto.ClientPayload.Product[m.product] : m.product;
                if (o.oneofs)
                    d._product = "product";
            }
            if (m.fbCat != null && m.hasOwnProperty("fbCat")) {
                d.fbCat = o.bytes === String ? $util.base64.encode(m.fbCat, 0, m.fbCat.length) : o.bytes === Array ? Array.prototype.slice.call(m.fbCat) : m.fbCat;
                if (o.oneofs)
                    d._fbCat = "fbCat";
            }
            if (m.fbUserAgent != null && m.hasOwnProperty("fbUserAgent")) {
                d.fbUserAgent = o.bytes === String ? $util.base64.encode(m.fbUserAgent, 0, m.fbUserAgent.length) : o.bytes === Array ? Array.prototype.slice.call(m.fbUserAgent) : m.fbUserAgent;
                if (o.oneofs)
                    d._fbUserAgent = "fbUserAgent";
            }
            if (m.oc != null && m.hasOwnProperty("oc")) {
                d.oc = m.oc;
                if (o.oneofs)
                    d._oc = "oc";
            }
            if (m.lc != null && m.hasOwnProperty("lc")) {
                d.lc = m.lc;
                if (o.oneofs)
                    d._lc = "lc";
            }
            if (m.iosAppExtension != null && m.hasOwnProperty("iosAppExtension")) {
                d.iosAppExtension = o.enums === String ? $root.proto.ClientPayload.IOSAppExtension[m.iosAppExtension] === undefined ? m.iosAppExtension : $root.proto.ClientPayload.IOSAppExtension[m.iosAppExtension] : m.iosAppExtension;
                if (o.oneofs)
                    d._iosAppExtension = "iosAppExtension";
            }
            if (m.fbAppId != null && m.hasOwnProperty("fbAppId")) {
                if (typeof m.fbAppId === "number")
                    d.fbAppId = o.longs === String ? String(m.fbAppId) : m.fbAppId;
                else
                    d.fbAppId = o.longs === String ? $util.Long.prototype.toString.call(m.fbAppId) : o.longs === Number ? new $util.LongBits(m.fbAppId.low >>> 0, m.fbAppId.high >>> 0).toNumber(true) : m.fbAppId;
                if (o.oneofs)
                    d._fbAppId = "fbAppId";
            }
            if (m.fbDeviceId != null && m.hasOwnProperty("fbDeviceId")) {
                d.fbDeviceId = o.bytes === String ? $util.base64.encode(m.fbDeviceId, 0, m.fbDeviceId.length) : o.bytes === Array ? Array.prototype.slice.call(m.fbDeviceId) : m.fbDeviceId;
                if (o.oneofs)
                    d._fbDeviceId = "fbDeviceId";
            }
            if (m.pull != null && m.hasOwnProperty("pull")) {
                d.pull = m.pull;
                if (o.oneofs)
                    d._pull = "pull";
            }
            if (m.paddingBytes != null && m.hasOwnProperty("paddingBytes")) {
                d.paddingBytes = o.bytes === String ? $util.base64.encode(m.paddingBytes, 0, m.paddingBytes.length) : o.bytes === Array ? Array.prototype.slice.call(m.paddingBytes) : m.paddingBytes;
                if (o.oneofs)
                    d._paddingBytes = "paddingBytes";
            }
            if (m.yearClass != null && m.hasOwnProperty("yearClass")) {
                d.yearClass = m.yearClass;
                if (o.oneofs)
                    d._yearClass = "yearClass";
            }
            if (m.memClass != null && m.hasOwnProperty("memClass")) {
                d.memClass = m.memClass;
                if (o.oneofs)
                    d._memClass = "memClass";
            }
            if (m.interopData != null && m.hasOwnProperty("interopData")) {
                d.interopData = $root.proto.ClientPayload.InteropData.toObject(m.interopData, o);
                if (o.oneofs)
                    d._interopData = "interopData";
            }
            if (m.trafficAnonymization != null && m.hasOwnProperty("trafficAnonymization")) {
                d.trafficAnonymization = o.enums === String ? $root.proto.ClientPayload.TrafficAnonymization[m.trafficAnonymization] === undefined ? m.trafficAnonymization : $root.proto.ClientPayload.TrafficAnonymization[m.trafficAnonymization] : m.trafficAnonymization;
                if (o.oneofs)
                    d._trafficAnonymization = "trafficAnonymization";
            }
            if (m.lidDbMigrated != null && m.hasOwnProperty("lidDbMigrated")) {
                d.lidDbMigrated = m.lidDbMigrated;
                if (o.oneofs)
                    d._lidDbMigrated = "lidDbMigrated";
            }
            if (m.accountType != null && m.hasOwnProperty("accountType")) {
                d.accountType = o.enums === String ? $root.proto.ClientPayload.AccountType[m.accountType] === undefined ? m.accountType : $root.proto.ClientPayload.AccountType[m.accountType] : m.accountType;
                if (o.oneofs)
                    d._accountType = "accountType";
            }
            return d;
        };

        ClientPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ClientPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ClientPayload";
        };

        ClientPayload.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "GUEST"] = 1;
            return values;
        })();

        ClientPayload.ConnectReason = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "PUSH"] = 0;
            values[valuesById[1] = "USER_ACTIVATED"] = 1;
            values[valuesById[2] = "SCHEDULED"] = 2;
            values[valuesById[3] = "ERROR_RECONNECT"] = 3;
            values[valuesById[4] = "NETWORK_SWITCH"] = 4;
            values[valuesById[5] = "PING_RECONNECT"] = 5;
            values[valuesById[6] = "UNKNOWN"] = 6;
            return values;
        })();

        ClientPayload.ConnectType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CELLULAR_UNKNOWN"] = 0;
            values[valuesById[1] = "WIFI_UNKNOWN"] = 1;
            values[valuesById[100] = "CELLULAR_EDGE"] = 100;
            values[valuesById[101] = "CELLULAR_IDEN"] = 101;
            values[valuesById[102] = "CELLULAR_UMTS"] = 102;
            values[valuesById[103] = "CELLULAR_EVDO"] = 103;
            values[valuesById[104] = "CELLULAR_GPRS"] = 104;
            values[valuesById[105] = "CELLULAR_HSDPA"] = 105;
            values[valuesById[106] = "CELLULAR_HSUPA"] = 106;
            values[valuesById[107] = "CELLULAR_HSPA"] = 107;
            values[valuesById[108] = "CELLULAR_CDMA"] = 108;
            values[valuesById[109] = "CELLULAR_1XRTT"] = 109;
            values[valuesById[110] = "CELLULAR_EHRPD"] = 110;
            values[valuesById[111] = "CELLULAR_LTE"] = 111;
            values[valuesById[112] = "CELLULAR_HSPAP"] = 112;
            return values;
        })();

        ClientPayload.DNSSource = (function() {

            function DNSSource(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DNSSource.prototype.dnsMethod = null;
            DNSSource.prototype.appCached = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DNSSource.prototype, "_dnsMethod", {
                get: $util.oneOfGetter($oneOfFields = ["dnsMethod"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DNSSource.prototype, "_appCached", {
                get: $util.oneOfGetter($oneOfFields = ["appCached"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DNSSource.create = function create(properties) {
                return new DNSSource(properties);
            };

            DNSSource.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.dnsMethod != null && Object.hasOwnProperty.call(m, "dnsMethod"))
                    w.uint32(120).int32(m.dnsMethod);
                if (m.appCached != null && Object.hasOwnProperty.call(m, "appCached"))
                    w.uint32(128).bool(m.appCached);
                return w;
            };

            DNSSource.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.DNSSource();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 15: {
                            m.dnsMethod = r.int32();
                            break;
                        }
                    case 16: {
                            m.appCached = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DNSSource.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.DNSSource)
                    return d;
                var m = new $root.proto.ClientPayload.DNSSource();
                switch (d.dnsMethod) {
                default:
                    if (typeof d.dnsMethod === "number") {
                        m.dnsMethod = d.dnsMethod;
                        break;
                    }
                    break;
                case "SYSTEM":
                case 0:
                    m.dnsMethod = 0;
                    break;
                case "GOOGLE":
                case 1:
                    m.dnsMethod = 1;
                    break;
                case "HARDCODED":
                case 2:
                    m.dnsMethod = 2;
                    break;
                case "OVERRIDE":
                case 3:
                    m.dnsMethod = 3;
                    break;
                case "FALLBACK":
                case 4:
                    m.dnsMethod = 4;
                    break;
                case "MNS":
                case 5:
                    m.dnsMethod = 5;
                    break;
                }
                if (d.appCached != null) {
                    m.appCached = Boolean(d.appCached);
                }
                return m;
            };

            DNSSource.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.dnsMethod != null && m.hasOwnProperty("dnsMethod")) {
                    d.dnsMethod = o.enums === String ? $root.proto.ClientPayload.DNSSource.DNSResolutionMethod[m.dnsMethod] === undefined ? m.dnsMethod : $root.proto.ClientPayload.DNSSource.DNSResolutionMethod[m.dnsMethod] : m.dnsMethod;
                    if (o.oneofs)
                        d._dnsMethod = "dnsMethod";
                }
                if (m.appCached != null && m.hasOwnProperty("appCached")) {
                    d.appCached = m.appCached;
                    if (o.oneofs)
                        d._appCached = "appCached";
                }
                return d;
            };

            DNSSource.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DNSSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.DNSSource";
            };

            DNSSource.DNSResolutionMethod = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "SYSTEM"] = 0;
                values[valuesById[1] = "GOOGLE"] = 1;
                values[valuesById[2] = "HARDCODED"] = 2;
                values[valuesById[3] = "OVERRIDE"] = 3;
                values[valuesById[4] = "FALLBACK"] = 4;
                values[valuesById[5] = "MNS"] = 5;
                return values;
            })();

            return DNSSource;
        })();

        ClientPayload.DevicePairingRegistrationData = (function() {

            function DevicePairingRegistrationData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DevicePairingRegistrationData.prototype.eRegid = null;
            DevicePairingRegistrationData.prototype.eKeytype = null;
            DevicePairingRegistrationData.prototype.eIdent = null;
            DevicePairingRegistrationData.prototype.eSkeyId = null;
            DevicePairingRegistrationData.prototype.eSkeyVal = null;
            DevicePairingRegistrationData.prototype.eSkeySig = null;
            DevicePairingRegistrationData.prototype.buildHash = null;
            DevicePairingRegistrationData.prototype.deviceProps = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eRegid", {
                get: $util.oneOfGetter($oneOfFields = ["eRegid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eKeytype", {
                get: $util.oneOfGetter($oneOfFields = ["eKeytype"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eIdent", {
                get: $util.oneOfGetter($oneOfFields = ["eIdent"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eSkeyId", {
                get: $util.oneOfGetter($oneOfFields = ["eSkeyId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eSkeyVal", {
                get: $util.oneOfGetter($oneOfFields = ["eSkeyVal"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_eSkeySig", {
                get: $util.oneOfGetter($oneOfFields = ["eSkeySig"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_buildHash", {
                get: $util.oneOfGetter($oneOfFields = ["buildHash"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DevicePairingRegistrationData.prototype, "_deviceProps", {
                get: $util.oneOfGetter($oneOfFields = ["deviceProps"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DevicePairingRegistrationData.create = function create(properties) {
                return new DevicePairingRegistrationData(properties);
            };

            DevicePairingRegistrationData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.eRegid != null && Object.hasOwnProperty.call(m, "eRegid"))
                    w.uint32(10).bytes(m.eRegid);
                if (m.eKeytype != null && Object.hasOwnProperty.call(m, "eKeytype"))
                    w.uint32(18).bytes(m.eKeytype);
                if (m.eIdent != null && Object.hasOwnProperty.call(m, "eIdent"))
                    w.uint32(26).bytes(m.eIdent);
                if (m.eSkeyId != null && Object.hasOwnProperty.call(m, "eSkeyId"))
                    w.uint32(34).bytes(m.eSkeyId);
                if (m.eSkeyVal != null && Object.hasOwnProperty.call(m, "eSkeyVal"))
                    w.uint32(42).bytes(m.eSkeyVal);
                if (m.eSkeySig != null && Object.hasOwnProperty.call(m, "eSkeySig"))
                    w.uint32(50).bytes(m.eSkeySig);
                if (m.buildHash != null && Object.hasOwnProperty.call(m, "buildHash"))
                    w.uint32(58).bytes(m.buildHash);
                if (m.deviceProps != null && Object.hasOwnProperty.call(m, "deviceProps"))
                    w.uint32(66).bytes(m.deviceProps);
                return w;
            };

            DevicePairingRegistrationData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.eRegid = r.bytes();
                            break;
                        }
                    case 2: {
                            m.eKeytype = r.bytes();
                            break;
                        }
                    case 3: {
                            m.eIdent = r.bytes();
                            break;
                        }
                    case 4: {
                            m.eSkeyId = r.bytes();
                            break;
                        }
                    case 5: {
                            m.eSkeyVal = r.bytes();
                            break;
                        }
                    case 6: {
                            m.eSkeySig = r.bytes();
                            break;
                        }
                    case 7: {
                            m.buildHash = r.bytes();
                            break;
                        }
                    case 8: {
                            m.deviceProps = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DevicePairingRegistrationData.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.DevicePairingRegistrationData)
                    return d;
                var m = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                if (d.eRegid != null) {
                    if (typeof d.eRegid === "string")
                        $util.base64.decode(d.eRegid, m.eRegid = $util.newBuffer($util.base64.length(d.eRegid)), 0);
                    else if (d.eRegid.length >= 0)
                        m.eRegid = d.eRegid;
                }
                if (d.eKeytype != null) {
                    if (typeof d.eKeytype === "string")
                        $util.base64.decode(d.eKeytype, m.eKeytype = $util.newBuffer($util.base64.length(d.eKeytype)), 0);
                    else if (d.eKeytype.length >= 0)
                        m.eKeytype = d.eKeytype;
                }
                if (d.eIdent != null) {
                    if (typeof d.eIdent === "string")
                        $util.base64.decode(d.eIdent, m.eIdent = $util.newBuffer($util.base64.length(d.eIdent)), 0);
                    else if (d.eIdent.length >= 0)
                        m.eIdent = d.eIdent;
                }
                if (d.eSkeyId != null) {
                    if (typeof d.eSkeyId === "string")
                        $util.base64.decode(d.eSkeyId, m.eSkeyId = $util.newBuffer($util.base64.length(d.eSkeyId)), 0);
                    else if (d.eSkeyId.length >= 0)
                        m.eSkeyId = d.eSkeyId;
                }
                if (d.eSkeyVal != null) {
                    if (typeof d.eSkeyVal === "string")
                        $util.base64.decode(d.eSkeyVal, m.eSkeyVal = $util.newBuffer($util.base64.length(d.eSkeyVal)), 0);
                    else if (d.eSkeyVal.length >= 0)
                        m.eSkeyVal = d.eSkeyVal;
                }
                if (d.eSkeySig != null) {
                    if (typeof d.eSkeySig === "string")
                        $util.base64.decode(d.eSkeySig, m.eSkeySig = $util.newBuffer($util.base64.length(d.eSkeySig)), 0);
                    else if (d.eSkeySig.length >= 0)
                        m.eSkeySig = d.eSkeySig;
                }
                if (d.buildHash != null) {
                    if (typeof d.buildHash === "string")
                        $util.base64.decode(d.buildHash, m.buildHash = $util.newBuffer($util.base64.length(d.buildHash)), 0);
                    else if (d.buildHash.length >= 0)
                        m.buildHash = d.buildHash;
                }
                if (d.deviceProps != null) {
                    if (typeof d.deviceProps === "string")
                        $util.base64.decode(d.deviceProps, m.deviceProps = $util.newBuffer($util.base64.length(d.deviceProps)), 0);
                    else if (d.deviceProps.length >= 0)
                        m.deviceProps = d.deviceProps;
                }
                return m;
            };

            DevicePairingRegistrationData.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.eRegid != null && m.hasOwnProperty("eRegid")) {
                    d.eRegid = o.bytes === String ? $util.base64.encode(m.eRegid, 0, m.eRegid.length) : o.bytes === Array ? Array.prototype.slice.call(m.eRegid) : m.eRegid;
                    if (o.oneofs)
                        d._eRegid = "eRegid";
                }
                if (m.eKeytype != null && m.hasOwnProperty("eKeytype")) {
                    d.eKeytype = o.bytes === String ? $util.base64.encode(m.eKeytype, 0, m.eKeytype.length) : o.bytes === Array ? Array.prototype.slice.call(m.eKeytype) : m.eKeytype;
                    if (o.oneofs)
                        d._eKeytype = "eKeytype";
                }
                if (m.eIdent != null && m.hasOwnProperty("eIdent")) {
                    d.eIdent = o.bytes === String ? $util.base64.encode(m.eIdent, 0, m.eIdent.length) : o.bytes === Array ? Array.prototype.slice.call(m.eIdent) : m.eIdent;
                    if (o.oneofs)
                        d._eIdent = "eIdent";
                }
                if (m.eSkeyId != null && m.hasOwnProperty("eSkeyId")) {
                    d.eSkeyId = o.bytes === String ? $util.base64.encode(m.eSkeyId, 0, m.eSkeyId.length) : o.bytes === Array ? Array.prototype.slice.call(m.eSkeyId) : m.eSkeyId;
                    if (o.oneofs)
                        d._eSkeyId = "eSkeyId";
                }
                if (m.eSkeyVal != null && m.hasOwnProperty("eSkeyVal")) {
                    d.eSkeyVal = o.bytes === String ? $util.base64.encode(m.eSkeyVal, 0, m.eSkeyVal.length) : o.bytes === Array ? Array.prototype.slice.call(m.eSkeyVal) : m.eSkeyVal;
                    if (o.oneofs)
                        d._eSkeyVal = "eSkeyVal";
                }
                if (m.eSkeySig != null && m.hasOwnProperty("eSkeySig")) {
                    d.eSkeySig = o.bytes === String ? $util.base64.encode(m.eSkeySig, 0, m.eSkeySig.length) : o.bytes === Array ? Array.prototype.slice.call(m.eSkeySig) : m.eSkeySig;
                    if (o.oneofs)
                        d._eSkeySig = "eSkeySig";
                }
                if (m.buildHash != null && m.hasOwnProperty("buildHash")) {
                    d.buildHash = o.bytes === String ? $util.base64.encode(m.buildHash, 0, m.buildHash.length) : o.bytes === Array ? Array.prototype.slice.call(m.buildHash) : m.buildHash;
                    if (o.oneofs)
                        d._buildHash = "buildHash";
                }
                if (m.deviceProps != null && m.hasOwnProperty("deviceProps")) {
                    d.deviceProps = o.bytes === String ? $util.base64.encode(m.deviceProps, 0, m.deviceProps.length) : o.bytes === Array ? Array.prototype.slice.call(m.deviceProps) : m.deviceProps;
                    if (o.oneofs)
                        d._deviceProps = "deviceProps";
                }
                return d;
            };

            DevicePairingRegistrationData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DevicePairingRegistrationData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.DevicePairingRegistrationData";
            };

            return DevicePairingRegistrationData;
        })();

        ClientPayload.IOSAppExtension = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SHARE_EXTENSION"] = 0;
            values[valuesById[1] = "SERVICE_EXTENSION"] = 1;
            values[valuesById[2] = "INTENTS_EXTENSION"] = 2;
            return values;
        })();

        ClientPayload.InteropData = (function() {

            function InteropData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InteropData.prototype.accountId = null;
            InteropData.prototype.token = null;
            InteropData.prototype.enableReadReceipts = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(InteropData.prototype, "_accountId", {
                get: $util.oneOfGetter($oneOfFields = ["accountId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(InteropData.prototype, "_token", {
                get: $util.oneOfGetter($oneOfFields = ["token"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(InteropData.prototype, "_enableReadReceipts", {
                get: $util.oneOfGetter($oneOfFields = ["enableReadReceipts"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            InteropData.create = function create(properties) {
                return new InteropData(properties);
            };

            InteropData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.accountId != null && Object.hasOwnProperty.call(m, "accountId"))
                    w.uint32(8).uint64(m.accountId);
                if (m.token != null && Object.hasOwnProperty.call(m, "token"))
                    w.uint32(18).bytes(m.token);
                if (m.enableReadReceipts != null && Object.hasOwnProperty.call(m, "enableReadReceipts"))
                    w.uint32(24).bool(m.enableReadReceipts);
                return w;
            };

            InteropData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.InteropData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.accountId = r.uint64();
                            break;
                        }
                    case 2: {
                            m.token = r.bytes();
                            break;
                        }
                    case 3: {
                            m.enableReadReceipts = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InteropData.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.InteropData)
                    return d;
                var m = new $root.proto.ClientPayload.InteropData();
                if (d.accountId != null) {
                    if ($util.Long)
                        (m.accountId = $util.Long.fromValue(d.accountId)).unsigned = true;
                    else if (typeof d.accountId === "string")
                        m.accountId = parseInt(d.accountId, 10);
                    else if (typeof d.accountId === "number")
                        m.accountId = d.accountId;
                    else if (typeof d.accountId === "object")
                        m.accountId = new $util.LongBits(d.accountId.low >>> 0, d.accountId.high >>> 0).toNumber(true);
                }
                if (d.token != null) {
                    if (typeof d.token === "string")
                        $util.base64.decode(d.token, m.token = $util.newBuffer($util.base64.length(d.token)), 0);
                    else if (d.token.length >= 0)
                        m.token = d.token;
                }
                if (d.enableReadReceipts != null) {
                    m.enableReadReceipts = Boolean(d.enableReadReceipts);
                }
                return m;
            };

            InteropData.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.accountId != null && m.hasOwnProperty("accountId")) {
                    if (typeof m.accountId === "number")
                        d.accountId = o.longs === String ? String(m.accountId) : m.accountId;
                    else
                        d.accountId = o.longs === String ? $util.Long.prototype.toString.call(m.accountId) : o.longs === Number ? new $util.LongBits(m.accountId.low >>> 0, m.accountId.high >>> 0).toNumber(true) : m.accountId;
                    if (o.oneofs)
                        d._accountId = "accountId";
                }
                if (m.token != null && m.hasOwnProperty("token")) {
                    d.token = o.bytes === String ? $util.base64.encode(m.token, 0, m.token.length) : o.bytes === Array ? Array.prototype.slice.call(m.token) : m.token;
                    if (o.oneofs)
                        d._token = "token";
                }
                if (m.enableReadReceipts != null && m.hasOwnProperty("enableReadReceipts")) {
                    d.enableReadReceipts = m.enableReadReceipts;
                    if (o.oneofs)
                        d._enableReadReceipts = "enableReadReceipts";
                }
                return d;
            };

            InteropData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            InteropData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.InteropData";
            };

            return InteropData;
        })();

        ClientPayload.Product = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WHATSAPP"] = 0;
            values[valuesById[1] = "MESSENGER"] = 1;
            values[valuesById[2] = "INTEROP"] = 2;
            values[valuesById[3] = "INTEROP_MSGR"] = 3;
            values[valuesById[4] = "WHATSAPP_LID"] = 4;
            return values;
        })();

        ClientPayload.TrafficAnonymization = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "OFF"] = 0;
            values[valuesById[1] = "STANDARD"] = 1;
            return values;
        })();

        ClientPayload.UserAgent = (function() {

            function UserAgent(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            UserAgent.prototype.platform = null;
            UserAgent.prototype.appVersion = null;
            UserAgent.prototype.mcc = null;
            UserAgent.prototype.mnc = null;
            UserAgent.prototype.osVersion = null;
            UserAgent.prototype.manufacturer = null;
            UserAgent.prototype.device = null;
            UserAgent.prototype.osBuildNumber = null;
            UserAgent.prototype.phoneId = null;
            UserAgent.prototype.releaseChannel = null;
            UserAgent.prototype.localeLanguageIso6391 = null;
            UserAgent.prototype.localeCountryIso31661Alpha2 = null;
            UserAgent.prototype.deviceBoard = null;
            UserAgent.prototype.deviceExpId = null;
            UserAgent.prototype.deviceType = null;
            UserAgent.prototype.deviceModelType = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_platform", {
                get: $util.oneOfGetter($oneOfFields = ["platform"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_appVersion", {
                get: $util.oneOfGetter($oneOfFields = ["appVersion"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_mcc", {
                get: $util.oneOfGetter($oneOfFields = ["mcc"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_mnc", {
                get: $util.oneOfGetter($oneOfFields = ["mnc"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_osVersion", {
                get: $util.oneOfGetter($oneOfFields = ["osVersion"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_manufacturer", {
                get: $util.oneOfGetter($oneOfFields = ["manufacturer"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_device", {
                get: $util.oneOfGetter($oneOfFields = ["device"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_osBuildNumber", {
                get: $util.oneOfGetter($oneOfFields = ["osBuildNumber"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_phoneId", {
                get: $util.oneOfGetter($oneOfFields = ["phoneId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_releaseChannel", {
                get: $util.oneOfGetter($oneOfFields = ["releaseChannel"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_localeLanguageIso6391", {
                get: $util.oneOfGetter($oneOfFields = ["localeLanguageIso6391"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_localeCountryIso31661Alpha2", {
                get: $util.oneOfGetter($oneOfFields = ["localeCountryIso31661Alpha2"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceBoard", {
                get: $util.oneOfGetter($oneOfFields = ["deviceBoard"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceExpId", {
                get: $util.oneOfGetter($oneOfFields = ["deviceExpId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceType", {
                get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UserAgent.prototype, "_deviceModelType", {
                get: $util.oneOfGetter($oneOfFields = ["deviceModelType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            UserAgent.create = function create(properties) {
                return new UserAgent(properties);
            };

            UserAgent.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.platform != null && Object.hasOwnProperty.call(m, "platform"))
                    w.uint32(8).int32(m.platform);
                if (m.appVersion != null && Object.hasOwnProperty.call(m, "appVersion"))
                    $root.proto.ClientPayload.UserAgent.AppVersion.encode(m.appVersion, w.uint32(18).fork()).ldelim();
                if (m.mcc != null && Object.hasOwnProperty.call(m, "mcc"))
                    w.uint32(26).string(m.mcc);
                if (m.mnc != null && Object.hasOwnProperty.call(m, "mnc"))
                    w.uint32(34).string(m.mnc);
                if (m.osVersion != null && Object.hasOwnProperty.call(m, "osVersion"))
                    w.uint32(42).string(m.osVersion);
                if (m.manufacturer != null && Object.hasOwnProperty.call(m, "manufacturer"))
                    w.uint32(50).string(m.manufacturer);
                if (m.device != null && Object.hasOwnProperty.call(m, "device"))
                    w.uint32(58).string(m.device);
                if (m.osBuildNumber != null && Object.hasOwnProperty.call(m, "osBuildNumber"))
                    w.uint32(66).string(m.osBuildNumber);
                if (m.phoneId != null && Object.hasOwnProperty.call(m, "phoneId"))
                    w.uint32(74).string(m.phoneId);
                if (m.releaseChannel != null && Object.hasOwnProperty.call(m, "releaseChannel"))
                    w.uint32(80).int32(m.releaseChannel);
                if (m.localeLanguageIso6391 != null && Object.hasOwnProperty.call(m, "localeLanguageIso6391"))
                    w.uint32(90).string(m.localeLanguageIso6391);
                if (m.localeCountryIso31661Alpha2 != null && Object.hasOwnProperty.call(m, "localeCountryIso31661Alpha2"))
                    w.uint32(98).string(m.localeCountryIso31661Alpha2);
                if (m.deviceBoard != null && Object.hasOwnProperty.call(m, "deviceBoard"))
                    w.uint32(106).string(m.deviceBoard);
                if (m.deviceExpId != null && Object.hasOwnProperty.call(m, "deviceExpId"))
                    w.uint32(114).string(m.deviceExpId);
                if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                    w.uint32(120).int32(m.deviceType);
                if (m.deviceModelType != null && Object.hasOwnProperty.call(m, "deviceModelType"))
                    w.uint32(130).string(m.deviceModelType);
                return w;
            };

            UserAgent.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.UserAgent();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.platform = r.int32();
                            break;
                        }
                    case 2: {
                            m.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.mcc = r.string();
                            break;
                        }
                    case 4: {
                            m.mnc = r.string();
                            break;
                        }
                    case 5: {
                            m.osVersion = r.string();
                            break;
                        }
                    case 6: {
                            m.manufacturer = r.string();
                            break;
                        }
                    case 7: {
                            m.device = r.string();
                            break;
                        }
                    case 8: {
                            m.osBuildNumber = r.string();
                            break;
                        }
                    case 9: {
                            m.phoneId = r.string();
                            break;
                        }
                    case 10: {
                            m.releaseChannel = r.int32();
                            break;
                        }
                    case 11: {
                            m.localeLanguageIso6391 = r.string();
                            break;
                        }
                    case 12: {
                            m.localeCountryIso31661Alpha2 = r.string();
                            break;
                        }
                    case 13: {
                            m.deviceBoard = r.string();
                            break;
                        }
                    case 14: {
                            m.deviceExpId = r.string();
                            break;
                        }
                    case 15: {
                            m.deviceType = r.int32();
                            break;
                        }
                    case 16: {
                            m.deviceModelType = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            UserAgent.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.UserAgent)
                    return d;
                var m = new $root.proto.ClientPayload.UserAgent();
                switch (d.platform) {
                default:
                    if (typeof d.platform === "number") {
                        m.platform = d.platform;
                        break;
                    }
                    break;
                case "ANDROID":
                case 0:
                    m.platform = 0;
                    break;
                case "IOS":
                case 1:
                    m.platform = 1;
                    break;
                case "WINDOWS_PHONE":
                case 2:
                    m.platform = 2;
                    break;
                case "BLACKBERRY":
                case 3:
                    m.platform = 3;
                    break;
                case "BLACKBERRYX":
                case 4:
                    m.platform = 4;
                    break;
                case "S40":
                case 5:
                    m.platform = 5;
                    break;
                case "S60":
                case 6:
                    m.platform = 6;
                    break;
                case "PYTHON_CLIENT":
                case 7:
                    m.platform = 7;
                    break;
                case "TIZEN":
                case 8:
                    m.platform = 8;
                    break;
                case "ENTERPRISE":
                case 9:
                    m.platform = 9;
                    break;
                case "SMB_ANDROID":
                case 10:
                    m.platform = 10;
                    break;
                case "KAIOS":
                case 11:
                    m.platform = 11;
                    break;
                case "SMB_IOS":
                case 12:
                    m.platform = 12;
                    break;
                case "WINDOWS":
                case 13:
                    m.platform = 13;
                    break;
                case "WEB":
                case 14:
                    m.platform = 14;
                    break;
                case "PORTAL":
                case 15:
                    m.platform = 15;
                    break;
                case "GREEN_ANDROID":
                case 16:
                    m.platform = 16;
                    break;
                case "GREEN_IPHONE":
                case 17:
                    m.platform = 17;
                    break;
                case "BLUE_ANDROID":
                case 18:
                    m.platform = 18;
                    break;
                case "BLUE_IPHONE":
                case 19:
                    m.platform = 19;
                    break;
                case "FBLITE_ANDROID":
                case 20:
                    m.platform = 20;
                    break;
                case "MLITE_ANDROID":
                case 21:
                    m.platform = 21;
                    break;
                case "IGLITE_ANDROID":
                case 22:
                    m.platform = 22;
                    break;
                case "PAGE":
                case 23:
                    m.platform = 23;
                    break;
                case "MACOS":
                case 24:
                    m.platform = 24;
                    break;
                case "OCULUS_MSG":
                case 25:
                    m.platform = 25;
                    break;
                case "OCULUS_CALL":
                case 26:
                    m.platform = 26;
                    break;
                case "MILAN":
                case 27:
                    m.platform = 27;
                    break;
                case "CAPI":
                case 28:
                    m.platform = 28;
                    break;
                case "WEAROS":
                case 29:
                    m.platform = 29;
                    break;
                case "ARDEVICE":
                case 30:
                    m.platform = 30;
                    break;
                case "VRDEVICE":
                case 31:
                    m.platform = 31;
                    break;
                case "BLUE_WEB":
                case 32:
                    m.platform = 32;
                    break;
                case "IPAD":
                case 33:
                    m.platform = 33;
                    break;
                case "TEST":
                case 34:
                    m.platform = 34;
                    break;
                case "SMART_GLASSES":
                case 35:
                    m.platform = 35;
                    break;
                }
                if (d.appVersion != null) {
                    if (typeof d.appVersion !== "object")
                        throw TypeError(".proto.ClientPayload.UserAgent.appVersion: object expected");
                    m.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.fromObject(d.appVersion);
                }
                if (d.mcc != null) {
                    m.mcc = String(d.mcc);
                }
                if (d.mnc != null) {
                    m.mnc = String(d.mnc);
                }
                if (d.osVersion != null) {
                    m.osVersion = String(d.osVersion);
                }
                if (d.manufacturer != null) {
                    m.manufacturer = String(d.manufacturer);
                }
                if (d.device != null) {
                    m.device = String(d.device);
                }
                if (d.osBuildNumber != null) {
                    m.osBuildNumber = String(d.osBuildNumber);
                }
                if (d.phoneId != null) {
                    m.phoneId = String(d.phoneId);
                }
                switch (d.releaseChannel) {
                default:
                    if (typeof d.releaseChannel === "number") {
                        m.releaseChannel = d.releaseChannel;
                        break;
                    }
                    break;
                case "RELEASE":
                case 0:
                    m.releaseChannel = 0;
                    break;
                case "BETA":
                case 1:
                    m.releaseChannel = 1;
                    break;
                case "ALPHA":
                case 2:
                    m.releaseChannel = 2;
                    break;
                case "DEBUG":
                case 3:
                    m.releaseChannel = 3;
                    break;
                }
                if (d.localeLanguageIso6391 != null) {
                    m.localeLanguageIso6391 = String(d.localeLanguageIso6391);
                }
                if (d.localeCountryIso31661Alpha2 != null) {
                    m.localeCountryIso31661Alpha2 = String(d.localeCountryIso31661Alpha2);
                }
                if (d.deviceBoard != null) {
                    m.deviceBoard = String(d.deviceBoard);
                }
                if (d.deviceExpId != null) {
                    m.deviceExpId = String(d.deviceExpId);
                }
                switch (d.deviceType) {
                default:
                    if (typeof d.deviceType === "number") {
                        m.deviceType = d.deviceType;
                        break;
                    }
                    break;
                case "PHONE":
                case 0:
                    m.deviceType = 0;
                    break;
                case "TABLET":
                case 1:
                    m.deviceType = 1;
                    break;
                case "DESKTOP":
                case 2:
                    m.deviceType = 2;
                    break;
                case "WEARABLE":
                case 3:
                    m.deviceType = 3;
                    break;
                case "VR":
                case 4:
                    m.deviceType = 4;
                    break;
                }
                if (d.deviceModelType != null) {
                    m.deviceModelType = String(d.deviceModelType);
                }
                return m;
            };

            UserAgent.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.platform != null && m.hasOwnProperty("platform")) {
                    d.platform = o.enums === String ? $root.proto.ClientPayload.UserAgent.Platform[m.platform] === undefined ? m.platform : $root.proto.ClientPayload.UserAgent.Platform[m.platform] : m.platform;
                    if (o.oneofs)
                        d._platform = "platform";
                }
                if (m.appVersion != null && m.hasOwnProperty("appVersion")) {
                    d.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.toObject(m.appVersion, o);
                    if (o.oneofs)
                        d._appVersion = "appVersion";
                }
                if (m.mcc != null && m.hasOwnProperty("mcc")) {
                    d.mcc = m.mcc;
                    if (o.oneofs)
                        d._mcc = "mcc";
                }
                if (m.mnc != null && m.hasOwnProperty("mnc")) {
                    d.mnc = m.mnc;
                    if (o.oneofs)
                        d._mnc = "mnc";
                }
                if (m.osVersion != null && m.hasOwnProperty("osVersion")) {
                    d.osVersion = m.osVersion;
                    if (o.oneofs)
                        d._osVersion = "osVersion";
                }
                if (m.manufacturer != null && m.hasOwnProperty("manufacturer")) {
                    d.manufacturer = m.manufacturer;
                    if (o.oneofs)
                        d._manufacturer = "manufacturer";
                }
                if (m.device != null && m.hasOwnProperty("device")) {
                    d.device = m.device;
                    if (o.oneofs)
                        d._device = "device";
                }
                if (m.osBuildNumber != null && m.hasOwnProperty("osBuildNumber")) {
                    d.osBuildNumber = m.osBuildNumber;
                    if (o.oneofs)
                        d._osBuildNumber = "osBuildNumber";
                }
                if (m.phoneId != null && m.hasOwnProperty("phoneId")) {
                    d.phoneId = m.phoneId;
                    if (o.oneofs)
                        d._phoneId = "phoneId";
                }
                if (m.releaseChannel != null && m.hasOwnProperty("releaseChannel")) {
                    d.releaseChannel = o.enums === String ? $root.proto.ClientPayload.UserAgent.ReleaseChannel[m.releaseChannel] === undefined ? m.releaseChannel : $root.proto.ClientPayload.UserAgent.ReleaseChannel[m.releaseChannel] : m.releaseChannel;
                    if (o.oneofs)
                        d._releaseChannel = "releaseChannel";
                }
                if (m.localeLanguageIso6391 != null && m.hasOwnProperty("localeLanguageIso6391")) {
                    d.localeLanguageIso6391 = m.localeLanguageIso6391;
                    if (o.oneofs)
                        d._localeLanguageIso6391 = "localeLanguageIso6391";
                }
                if (m.localeCountryIso31661Alpha2 != null && m.hasOwnProperty("localeCountryIso31661Alpha2")) {
                    d.localeCountryIso31661Alpha2 = m.localeCountryIso31661Alpha2;
                    if (o.oneofs)
                        d._localeCountryIso31661Alpha2 = "localeCountryIso31661Alpha2";
                }
                if (m.deviceBoard != null && m.hasOwnProperty("deviceBoard")) {
                    d.deviceBoard = m.deviceBoard;
                    if (o.oneofs)
                        d._deviceBoard = "deviceBoard";
                }
                if (m.deviceExpId != null && m.hasOwnProperty("deviceExpId")) {
                    d.deviceExpId = m.deviceExpId;
                    if (o.oneofs)
                        d._deviceExpId = "deviceExpId";
                }
                if (m.deviceType != null && m.hasOwnProperty("deviceType")) {
                    d.deviceType = o.enums === String ? $root.proto.ClientPayload.UserAgent.DeviceType[m.deviceType] === undefined ? m.deviceType : $root.proto.ClientPayload.UserAgent.DeviceType[m.deviceType] : m.deviceType;
                    if (o.oneofs)
                        d._deviceType = "deviceType";
                }
                if (m.deviceModelType != null && m.hasOwnProperty("deviceModelType")) {
                    d.deviceModelType = m.deviceModelType;
                    if (o.oneofs)
                        d._deviceModelType = "deviceModelType";
                }
                return d;
            };

            UserAgent.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            UserAgent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.UserAgent";
            };

            UserAgent.AppVersion = (function() {

                function AppVersion(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AppVersion.prototype.primary = null;
                AppVersion.prototype.secondary = null;
                AppVersion.prototype.tertiary = null;
                AppVersion.prototype.quaternary = null;
                AppVersion.prototype.quinary = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_primary", {
                    get: $util.oneOfGetter($oneOfFields = ["primary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_secondary", {
                    get: $util.oneOfGetter($oneOfFields = ["secondary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_tertiary", {
                    get: $util.oneOfGetter($oneOfFields = ["tertiary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_quaternary", {
                    get: $util.oneOfGetter($oneOfFields = ["quaternary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AppVersion.prototype, "_quinary", {
                    get: $util.oneOfGetter($oneOfFields = ["quinary"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AppVersion.create = function create(properties) {
                    return new AppVersion(properties);
                };

                AppVersion.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.primary != null && Object.hasOwnProperty.call(m, "primary"))
                        w.uint32(8).uint32(m.primary);
                    if (m.secondary != null && Object.hasOwnProperty.call(m, "secondary"))
                        w.uint32(16).uint32(m.secondary);
                    if (m.tertiary != null && Object.hasOwnProperty.call(m, "tertiary"))
                        w.uint32(24).uint32(m.tertiary);
                    if (m.quaternary != null && Object.hasOwnProperty.call(m, "quaternary"))
                        w.uint32(32).uint32(m.quaternary);
                    if (m.quinary != null && Object.hasOwnProperty.call(m, "quinary"))
                        w.uint32(40).uint32(m.quinary);
                    return w;
                };

                AppVersion.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.primary = r.uint32();
                                break;
                            }
                        case 2: {
                                m.secondary = r.uint32();
                                break;
                            }
                        case 3: {
                                m.tertiary = r.uint32();
                                break;
                            }
                        case 4: {
                                m.quaternary = r.uint32();
                                break;
                            }
                        case 5: {
                                m.quinary = r.uint32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AppVersion.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ClientPayload.UserAgent.AppVersion)
                        return d;
                    var m = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    if (d.primary != null) {
                        m.primary = d.primary >>> 0;
                    }
                    if (d.secondary != null) {
                        m.secondary = d.secondary >>> 0;
                    }
                    if (d.tertiary != null) {
                        m.tertiary = d.tertiary >>> 0;
                    }
                    if (d.quaternary != null) {
                        m.quaternary = d.quaternary >>> 0;
                    }
                    if (d.quinary != null) {
                        m.quinary = d.quinary >>> 0;
                    }
                    return m;
                };

                AppVersion.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.primary != null && m.hasOwnProperty("primary")) {
                        d.primary = m.primary;
                        if (o.oneofs)
                            d._primary = "primary";
                    }
                    if (m.secondary != null && m.hasOwnProperty("secondary")) {
                        d.secondary = m.secondary;
                        if (o.oneofs)
                            d._secondary = "secondary";
                    }
                    if (m.tertiary != null && m.hasOwnProperty("tertiary")) {
                        d.tertiary = m.tertiary;
                        if (o.oneofs)
                            d._tertiary = "tertiary";
                    }
                    if (m.quaternary != null && m.hasOwnProperty("quaternary")) {
                        d.quaternary = m.quaternary;
                        if (o.oneofs)
                            d._quaternary = "quaternary";
                    }
                    if (m.quinary != null && m.hasOwnProperty("quinary")) {
                        d.quinary = m.quinary;
                        if (o.oneofs)
                            d._quinary = "quinary";
                    }
                    return d;
                };

                AppVersion.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                AppVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ClientPayload.UserAgent.AppVersion";
                };

                return AppVersion;
            })();

            UserAgent.DeviceType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "PHONE"] = 0;
                values[valuesById[1] = "TABLET"] = 1;
                values[valuesById[2] = "DESKTOP"] = 2;
                values[valuesById[3] = "WEARABLE"] = 3;
                values[valuesById[4] = "VR"] = 4;
                return values;
            })();

            UserAgent.Platform = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "ANDROID"] = 0;
                values[valuesById[1] = "IOS"] = 1;
                values[valuesById[2] = "WINDOWS_PHONE"] = 2;
                values[valuesById[3] = "BLACKBERRY"] = 3;
                values[valuesById[4] = "BLACKBERRYX"] = 4;
                values[valuesById[5] = "S40"] = 5;
                values[valuesById[6] = "S60"] = 6;
                values[valuesById[7] = "PYTHON_CLIENT"] = 7;
                values[valuesById[8] = "TIZEN"] = 8;
                values[valuesById[9] = "ENTERPRISE"] = 9;
                values[valuesById[10] = "SMB_ANDROID"] = 10;
                values[valuesById[11] = "KAIOS"] = 11;
                values[valuesById[12] = "SMB_IOS"] = 12;
                values[valuesById[13] = "WINDOWS"] = 13;
                values[valuesById[14] = "WEB"] = 14;
                values[valuesById[15] = "PORTAL"] = 15;
                values[valuesById[16] = "GREEN_ANDROID"] = 16;
                values[valuesById[17] = "GREEN_IPHONE"] = 17;
                values[valuesById[18] = "BLUE_ANDROID"] = 18;
                values[valuesById[19] = "BLUE_IPHONE"] = 19;
                values[valuesById[20] = "FBLITE_ANDROID"] = 20;
                values[valuesById[21] = "MLITE_ANDROID"] = 21;
                values[valuesById[22] = "IGLITE_ANDROID"] = 22;
                values[valuesById[23] = "PAGE"] = 23;
                values[valuesById[24] = "MACOS"] = 24;
                values[valuesById[25] = "OCULUS_MSG"] = 25;
                values[valuesById[26] = "OCULUS_CALL"] = 26;
                values[valuesById[27] = "MILAN"] = 27;
                values[valuesById[28] = "CAPI"] = 28;
                values[valuesById[29] = "WEAROS"] = 29;
                values[valuesById[30] = "ARDEVICE"] = 30;
                values[valuesById[31] = "VRDEVICE"] = 31;
                values[valuesById[32] = "BLUE_WEB"] = 32;
                values[valuesById[33] = "IPAD"] = 33;
                values[valuesById[34] = "TEST"] = 34;
                values[valuesById[35] = "SMART_GLASSES"] = 35;
                return values;
            })();

            UserAgent.ReleaseChannel = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "RELEASE"] = 0;
                values[valuesById[1] = "BETA"] = 1;
                values[valuesById[2] = "ALPHA"] = 2;
                values[valuesById[3] = "DEBUG"] = 3;
                return values;
            })();

            return UserAgent;
        })();

        ClientPayload.WebInfo = (function() {

            function WebInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            WebInfo.prototype.refToken = null;
            WebInfo.prototype.version = null;
            WebInfo.prototype.webdPayload = null;
            WebInfo.prototype.webSubPlatform = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_refToken", {
                get: $util.oneOfGetter($oneOfFields = ["refToken"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_version", {
                get: $util.oneOfGetter($oneOfFields = ["version"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_webdPayload", {
                get: $util.oneOfGetter($oneOfFields = ["webdPayload"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(WebInfo.prototype, "_webSubPlatform", {
                get: $util.oneOfGetter($oneOfFields = ["webSubPlatform"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            WebInfo.create = function create(properties) {
                return new WebInfo(properties);
            };

            WebInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.refToken != null && Object.hasOwnProperty.call(m, "refToken"))
                    w.uint32(10).string(m.refToken);
                if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                    w.uint32(18).string(m.version);
                if (m.webdPayload != null && Object.hasOwnProperty.call(m, "webdPayload"))
                    $root.proto.ClientPayload.WebInfo.WebdPayload.encode(m.webdPayload, w.uint32(26).fork()).ldelim();
                if (m.webSubPlatform != null && Object.hasOwnProperty.call(m, "webSubPlatform"))
                    w.uint32(32).int32(m.webSubPlatform);
                return w;
            };

            WebInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.WebInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.refToken = r.string();
                            break;
                        }
                    case 2: {
                            m.version = r.string();
                            break;
                        }
                    case 3: {
                            m.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.webSubPlatform = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            WebInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ClientPayload.WebInfo)
                    return d;
                var m = new $root.proto.ClientPayload.WebInfo();
                if (d.refToken != null) {
                    m.refToken = String(d.refToken);
                }
                if (d.version != null) {
                    m.version = String(d.version);
                }
                if (d.webdPayload != null) {
                    if (typeof d.webdPayload !== "object")
                        throw TypeError(".proto.ClientPayload.WebInfo.webdPayload: object expected");
                    m.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.fromObject(d.webdPayload);
                }
                switch (d.webSubPlatform) {
                default:
                    if (typeof d.webSubPlatform === "number") {
                        m.webSubPlatform = d.webSubPlatform;
                        break;
                    }
                    break;
                case "WEB_BROWSER":
                case 0:
                    m.webSubPlatform = 0;
                    break;
                case "APP_STORE":
                case 1:
                    m.webSubPlatform = 1;
                    break;
                case "WIN_STORE":
                case 2:
                    m.webSubPlatform = 2;
                    break;
                case "DARWIN":
                case 3:
                    m.webSubPlatform = 3;
                    break;
                case "WIN32":
                case 4:
                    m.webSubPlatform = 4;
                    break;
                case "WIN_HYBRID":
                case 5:
                    m.webSubPlatform = 5;
                    break;
                }
                return m;
            };

            WebInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.refToken != null && m.hasOwnProperty("refToken")) {
                    d.refToken = m.refToken;
                    if (o.oneofs)
                        d._refToken = "refToken";
                }
                if (m.version != null && m.hasOwnProperty("version")) {
                    d.version = m.version;
                    if (o.oneofs)
                        d._version = "version";
                }
                if (m.webdPayload != null && m.hasOwnProperty("webdPayload")) {
                    d.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.toObject(m.webdPayload, o);
                    if (o.oneofs)
                        d._webdPayload = "webdPayload";
                }
                if (m.webSubPlatform != null && m.hasOwnProperty("webSubPlatform")) {
                    d.webSubPlatform = o.enums === String ? $root.proto.ClientPayload.WebInfo.WebSubPlatform[m.webSubPlatform] === undefined ? m.webSubPlatform : $root.proto.ClientPayload.WebInfo.WebSubPlatform[m.webSubPlatform] : m.webSubPlatform;
                    if (o.oneofs)
                        d._webSubPlatform = "webSubPlatform";
                }
                return d;
            };

            WebInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            WebInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.WebInfo";
            };

            WebInfo.WebSubPlatform = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "WEB_BROWSER"] = 0;
                values[valuesById[1] = "APP_STORE"] = 1;
                values[valuesById[2] = "WIN_STORE"] = 2;
                values[valuesById[3] = "DARWIN"] = 3;
                values[valuesById[4] = "WIN32"] = 4;
                values[valuesById[5] = "WIN_HYBRID"] = 5;
                return values;
            })();

            WebInfo.WebdPayload = (function() {

                function WebdPayload(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                WebdPayload.prototype.usesParticipantInKey = null;
                WebdPayload.prototype.supportsStarredMessages = null;
                WebdPayload.prototype.supportsDocumentMessages = null;
                WebdPayload.prototype.supportsUrlMessages = null;
                WebdPayload.prototype.supportsMediaRetry = null;
                WebdPayload.prototype.supportsE2EImage = null;
                WebdPayload.prototype.supportsE2EVideo = null;
                WebdPayload.prototype.supportsE2EAudio = null;
                WebdPayload.prototype.supportsE2EDocument = null;
                WebdPayload.prototype.documentTypes = null;
                WebdPayload.prototype.features = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_usesParticipantInKey", {
                    get: $util.oneOfGetter($oneOfFields = ["usesParticipantInKey"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsStarredMessages", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsStarredMessages"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsDocumentMessages", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsDocumentMessages"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsUrlMessages", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsUrlMessages"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsMediaRetry", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsMediaRetry"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EImage", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EImage"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EVideo", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EVideo"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EAudio", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EAudio"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_supportsE2EDocument", {
                    get: $util.oneOfGetter($oneOfFields = ["supportsE2EDocument"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_documentTypes", {
                    get: $util.oneOfGetter($oneOfFields = ["documentTypes"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(WebdPayload.prototype, "_features", {
                    get: $util.oneOfGetter($oneOfFields = ["features"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                WebdPayload.create = function create(properties) {
                    return new WebdPayload(properties);
                };

                WebdPayload.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.usesParticipantInKey != null && Object.hasOwnProperty.call(m, "usesParticipantInKey"))
                        w.uint32(8).bool(m.usesParticipantInKey);
                    if (m.supportsStarredMessages != null && Object.hasOwnProperty.call(m, "supportsStarredMessages"))
                        w.uint32(16).bool(m.supportsStarredMessages);
                    if (m.supportsDocumentMessages != null && Object.hasOwnProperty.call(m, "supportsDocumentMessages"))
                        w.uint32(24).bool(m.supportsDocumentMessages);
                    if (m.supportsUrlMessages != null && Object.hasOwnProperty.call(m, "supportsUrlMessages"))
                        w.uint32(32).bool(m.supportsUrlMessages);
                    if (m.supportsMediaRetry != null && Object.hasOwnProperty.call(m, "supportsMediaRetry"))
                        w.uint32(40).bool(m.supportsMediaRetry);
                    if (m.supportsE2EImage != null && Object.hasOwnProperty.call(m, "supportsE2EImage"))
                        w.uint32(48).bool(m.supportsE2EImage);
                    if (m.supportsE2EVideo != null && Object.hasOwnProperty.call(m, "supportsE2EVideo"))
                        w.uint32(56).bool(m.supportsE2EVideo);
                    if (m.supportsE2EAudio != null && Object.hasOwnProperty.call(m, "supportsE2EAudio"))
                        w.uint32(64).bool(m.supportsE2EAudio);
                    if (m.supportsE2EDocument != null && Object.hasOwnProperty.call(m, "supportsE2EDocument"))
                        w.uint32(72).bool(m.supportsE2EDocument);
                    if (m.documentTypes != null && Object.hasOwnProperty.call(m, "documentTypes"))
                        w.uint32(82).string(m.documentTypes);
                    if (m.features != null && Object.hasOwnProperty.call(m, "features"))
                        w.uint32(90).bytes(m.features);
                    return w;
                };

                WebdPayload.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.usesParticipantInKey = r.bool();
                                break;
                            }
                        case 2: {
                                m.supportsStarredMessages = r.bool();
                                break;
                            }
                        case 3: {
                                m.supportsDocumentMessages = r.bool();
                                break;
                            }
                        case 4: {
                                m.supportsUrlMessages = r.bool();
                                break;
                            }
                        case 5: {
                                m.supportsMediaRetry = r.bool();
                                break;
                            }
                        case 6: {
                                m.supportsE2EImage = r.bool();
                                break;
                            }
                        case 7: {
                                m.supportsE2EVideo = r.bool();
                                break;
                            }
                        case 8: {
                                m.supportsE2EAudio = r.bool();
                                break;
                            }
                        case 9: {
                                m.supportsE2EDocument = r.bool();
                                break;
                            }
                        case 10: {
                                m.documentTypes = r.string();
                                break;
                            }
                        case 11: {
                                m.features = r.bytes();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                WebdPayload.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ClientPayload.WebInfo.WebdPayload)
                        return d;
                    var m = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    if (d.usesParticipantInKey != null) {
                        m.usesParticipantInKey = Boolean(d.usesParticipantInKey);
                    }
                    if (d.supportsStarredMessages != null) {
                        m.supportsStarredMessages = Boolean(d.supportsStarredMessages);
                    }
                    if (d.supportsDocumentMessages != null) {
                        m.supportsDocumentMessages = Boolean(d.supportsDocumentMessages);
                    }
                    if (d.supportsUrlMessages != null) {
                        m.supportsUrlMessages = Boolean(d.supportsUrlMessages);
                    }
                    if (d.supportsMediaRetry != null) {
                        m.supportsMediaRetry = Boolean(d.supportsMediaRetry);
                    }
                    if (d.supportsE2EImage != null) {
                        m.supportsE2EImage = Boolean(d.supportsE2EImage);
                    }
                    if (d.supportsE2EVideo != null) {
                        m.supportsE2EVideo = Boolean(d.supportsE2EVideo);
                    }
                    if (d.supportsE2EAudio != null) {
                        m.supportsE2EAudio = Boolean(d.supportsE2EAudio);
                    }
                    if (d.supportsE2EDocument != null) {
                        m.supportsE2EDocument = Boolean(d.supportsE2EDocument);
                    }
                    if (d.documentTypes != null) {
                        m.documentTypes = String(d.documentTypes);
                    }
                    if (d.features != null) {
                        if (typeof d.features === "string")
                            $util.base64.decode(d.features, m.features = $util.newBuffer($util.base64.length(d.features)), 0);
                        else if (d.features.length >= 0)
                            m.features = d.features;
                    }
                    return m;
                };

                WebdPayload.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.usesParticipantInKey != null && m.hasOwnProperty("usesParticipantInKey")) {
                        d.usesParticipantInKey = m.usesParticipantInKey;
                        if (o.oneofs)
                            d._usesParticipantInKey = "usesParticipantInKey";
                    }
                    if (m.supportsStarredMessages != null && m.hasOwnProperty("supportsStarredMessages")) {
                        d.supportsStarredMessages = m.supportsStarredMessages;
                        if (o.oneofs)
                            d._supportsStarredMessages = "supportsStarredMessages";
                    }
                    if (m.supportsDocumentMessages != null && m.hasOwnProperty("supportsDocumentMessages")) {
                        d.supportsDocumentMessages = m.supportsDocumentMessages;
                        if (o.oneofs)
                            d._supportsDocumentMessages = "supportsDocumentMessages";
                    }
                    if (m.supportsUrlMessages != null && m.hasOwnProperty("supportsUrlMessages")) {
                        d.supportsUrlMessages = m.supportsUrlMessages;
                        if (o.oneofs)
                            d._supportsUrlMessages = "supportsUrlMessages";
                    }
                    if (m.supportsMediaRetry != null && m.hasOwnProperty("supportsMediaRetry")) {
                        d.supportsMediaRetry = m.supportsMediaRetry;
                        if (o.oneofs)
                            d._supportsMediaRetry = "supportsMediaRetry";
                    }
                    if (m.supportsE2EImage != null && m.hasOwnProperty("supportsE2EImage")) {
                        d.supportsE2EImage = m.supportsE2EImage;
                        if (o.oneofs)
                            d._supportsE2EImage = "supportsE2EImage";
                    }
                    if (m.supportsE2EVideo != null && m.hasOwnProperty("supportsE2EVideo")) {
                        d.supportsE2EVideo = m.supportsE2EVideo;
                        if (o.oneofs)
                            d._supportsE2EVideo = "supportsE2EVideo";
                    }
                    if (m.supportsE2EAudio != null && m.hasOwnProperty("supportsE2EAudio")) {
                        d.supportsE2EAudio = m.supportsE2EAudio;
                        if (o.oneofs)
                            d._supportsE2EAudio = "supportsE2EAudio";
                    }
                    if (m.supportsE2EDocument != null && m.hasOwnProperty("supportsE2EDocument")) {
                        d.supportsE2EDocument = m.supportsE2EDocument;
                        if (o.oneofs)
                            d._supportsE2EDocument = "supportsE2EDocument";
                    }
                    if (m.documentTypes != null && m.hasOwnProperty("documentTypes")) {
                        d.documentTypes = m.documentTypes;
                        if (o.oneofs)
                            d._documentTypes = "documentTypes";
                    }
                    if (m.features != null && m.hasOwnProperty("features")) {
                        d.features = o.bytes === String ? $util.base64.encode(m.features, 0, m.features.length) : o.bytes === Array ? Array.prototype.slice.call(m.features) : m.features;
                        if (o.oneofs)
                            d._features = "features";
                    }
                    return d;
                };

                WebdPayload.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                WebdPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ClientPayload.WebInfo.WebdPayload";
                };

                return WebdPayload;
            })();

            return WebInfo;
        })();

        return ClientPayload;
    })();

    proto.CommentMetadata = (function() {

        function CommentMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CommentMetadata.prototype.commentParentKey = null;
        CommentMetadata.prototype.replyCount = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CommentMetadata.prototype, "_commentParentKey", {
            get: $util.oneOfGetter($oneOfFields = ["commentParentKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CommentMetadata.prototype, "_replyCount", {
            get: $util.oneOfGetter($oneOfFields = ["replyCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CommentMetadata.create = function create(properties) {
            return new CommentMetadata(properties);
        };

        CommentMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.commentParentKey != null && Object.hasOwnProperty.call(m, "commentParentKey"))
                $root.proto.MessageKey.encode(m.commentParentKey, w.uint32(10).fork()).ldelim();
            if (m.replyCount != null && Object.hasOwnProperty.call(m, "replyCount"))
                w.uint32(16).uint32(m.replyCount);
            return w;
        };

        CommentMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CommentMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.commentParentKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.replyCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CommentMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CommentMetadata)
                return d;
            var m = new $root.proto.CommentMetadata();
            if (d.commentParentKey != null) {
                if (typeof d.commentParentKey !== "object")
                    throw TypeError(".proto.CommentMetadata.commentParentKey: object expected");
                m.commentParentKey = $root.proto.MessageKey.fromObject(d.commentParentKey);
            }
            if (d.replyCount != null) {
                m.replyCount = d.replyCount >>> 0;
            }
            return m;
        };

        CommentMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.commentParentKey != null && m.hasOwnProperty("commentParentKey")) {
                d.commentParentKey = $root.proto.MessageKey.toObject(m.commentParentKey, o);
                if (o.oneofs)
                    d._commentParentKey = "commentParentKey";
            }
            if (m.replyCount != null && m.hasOwnProperty("replyCount")) {
                d.replyCount = m.replyCount;
                if (o.oneofs)
                    d._replyCount = "replyCount";
            }
            return d;
        };

        CommentMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CommentMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CommentMetadata";
        };

        return CommentMetadata;
    })();

    proto.CompanionCommitment = (function() {

        function CompanionCommitment(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CompanionCommitment.prototype.hash = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionCommitment.prototype, "_hash", {
            get: $util.oneOfGetter($oneOfFields = ["hash"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CompanionCommitment.create = function create(properties) {
            return new CompanionCommitment(properties);
        };

        CompanionCommitment.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.hash != null && Object.hasOwnProperty.call(m, "hash"))
                w.uint32(10).bytes(m.hash);
            return w;
        };

        CompanionCommitment.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CompanionCommitment();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.hash = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CompanionCommitment.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CompanionCommitment)
                return d;
            var m = new $root.proto.CompanionCommitment();
            if (d.hash != null) {
                if (typeof d.hash === "string")
                    $util.base64.decode(d.hash, m.hash = $util.newBuffer($util.base64.length(d.hash)), 0);
                else if (d.hash.length >= 0)
                    m.hash = d.hash;
            }
            return m;
        };

        CompanionCommitment.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.hash != null && m.hasOwnProperty("hash")) {
                d.hash = o.bytes === String ? $util.base64.encode(m.hash, 0, m.hash.length) : o.bytes === Array ? Array.prototype.slice.call(m.hash) : m.hash;
                if (o.oneofs)
                    d._hash = "hash";
            }
            return d;
        };

        CompanionCommitment.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CompanionCommitment.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CompanionCommitment";
        };

        return CompanionCommitment;
    })();

    proto.CompanionEphemeralIdentity = (function() {

        function CompanionEphemeralIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CompanionEphemeralIdentity.prototype.publicKey = null;
        CompanionEphemeralIdentity.prototype.deviceType = null;
        CompanionEphemeralIdentity.prototype.ref = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionEphemeralIdentity.prototype, "_publicKey", {
            get: $util.oneOfGetter($oneOfFields = ["publicKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionEphemeralIdentity.prototype, "_deviceType", {
            get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(CompanionEphemeralIdentity.prototype, "_ref", {
            get: $util.oneOfGetter($oneOfFields = ["ref"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        CompanionEphemeralIdentity.create = function create(properties) {
            return new CompanionEphemeralIdentity(properties);
        };

        CompanionEphemeralIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.publicKey != null && Object.hasOwnProperty.call(m, "publicKey"))
                w.uint32(10).bytes(m.publicKey);
            if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                w.uint32(16).int32(m.deviceType);
            if (m.ref != null && Object.hasOwnProperty.call(m, "ref"))
                w.uint32(26).string(m.ref);
            return w;
        };

        CompanionEphemeralIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CompanionEphemeralIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.publicKey = r.bytes();
                        break;
                    }
                case 2: {
                        m.deviceType = r.int32();
                        break;
                    }
                case 3: {
                        m.ref = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CompanionEphemeralIdentity.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.CompanionEphemeralIdentity)
                return d;
            var m = new $root.proto.CompanionEphemeralIdentity();
            if (d.publicKey != null) {
                if (typeof d.publicKey === "string")
                    $util.base64.decode(d.publicKey, m.publicKey = $util.newBuffer($util.base64.length(d.publicKey)), 0);
                else if (d.publicKey.length >= 0)
                    m.publicKey = d.publicKey;
            }
            switch (d.deviceType) {
            default:
                if (typeof d.deviceType === "number") {
                    m.deviceType = d.deviceType;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.deviceType = 0;
                break;
            case "CHROME":
            case 1:
                m.deviceType = 1;
                break;
            case "FIREFOX":
            case 2:
                m.deviceType = 2;
                break;
            case "IE":
            case 3:
                m.deviceType = 3;
                break;
            case "OPERA":
            case 4:
                m.deviceType = 4;
                break;
            case "SAFARI":
            case 5:
                m.deviceType = 5;
                break;
            case "EDGE":
            case 6:
                m.deviceType = 6;
                break;
            case "DESKTOP":
            case 7:
                m.deviceType = 7;
                break;
            case "IPAD":
            case 8:
                m.deviceType = 8;
                break;
            case "ANDROID_TABLET":
            case 9:
                m.deviceType = 9;
                break;
            case "OHANA":
            case 10:
                m.deviceType = 10;
                break;
            case "ALOHA":
            case 11:
                m.deviceType = 11;
                break;
            case "CATALINA":
            case 12:
                m.deviceType = 12;
                break;
            case "TCL_TV":
            case 13:
                m.deviceType = 13;
                break;
            case "IOS_PHONE":
            case 14:
                m.deviceType = 14;
                break;
            case "IOS_CATALYST":
            case 15:
                m.deviceType = 15;
                break;
            case "ANDROID_PHONE":
            case 16:
                m.deviceType = 16;
                break;
            case "ANDROID_AMBIGUOUS":
            case 17:
                m.deviceType = 17;
                break;
            case "WEAR_OS":
            case 18:
                m.deviceType = 18;
                break;
            case "AR_WRIST":
            case 19:
                m.deviceType = 19;
                break;
            case "AR_DEVICE":
            case 20:
                m.deviceType = 20;
                break;
            case "UWP":
            case 21:
                m.deviceType = 21;
                break;
            case "VR":
            case 22:
                m.deviceType = 22;
                break;
            case "CLOUD_API":
            case 23:
                m.deviceType = 23;
                break;
            case "SMARTGLASSES":
            case 24:
                m.deviceType = 24;
                break;
            }
            if (d.ref != null) {
                m.ref = String(d.ref);
            }
            return m;
        };

        CompanionEphemeralIdentity.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.publicKey != null && m.hasOwnProperty("publicKey")) {
                d.publicKey = o.bytes === String ? $util.base64.encode(m.publicKey, 0, m.publicKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.publicKey) : m.publicKey;
                if (o.oneofs)
                    d._publicKey = "publicKey";
            }
            if (m.deviceType != null && m.hasOwnProperty("deviceType")) {
                d.deviceType = o.enums === String ? $root.proto.DeviceProps.PlatformType[m.deviceType] === undefined ? m.deviceType : $root.proto.DeviceProps.PlatformType[m.deviceType] : m.deviceType;
                if (o.oneofs)
                    d._deviceType = "deviceType";
            }
            if (m.ref != null && m.hasOwnProperty("ref")) {
                d.ref = m.ref;
                if (o.oneofs)
                    d._ref = "ref";
            }
            return d;
        };

        CompanionEphemeralIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CompanionEphemeralIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CompanionEphemeralIdentity";
        };

        return CompanionEphemeralIdentity;
    })();

    proto.Config = (function() {

        function Config(p) {
            this.field = {};
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Config.prototype.field = $util.emptyObject;
        Config.prototype.version = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Config.prototype, "_version", {
            get: $util.oneOfGetter($oneOfFields = ["version"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        Config.create = function create(properties) {
            return new Config(properties);
        };

        Config.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.field != null && Object.hasOwnProperty.call(m, "field")) {
                for (var ks = Object.keys(m.field), i = 0; i < ks.length; ++i) {
                    w.uint32(10).fork().uint32(8).uint32(ks[i]);
                    $root.proto.Field.encode(m.field[ks[i]], w.uint32(18).fork()).ldelim().ldelim();
                }
            }
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                w.uint32(16).uint32(m.version);
            return w;
        };

        Config.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Config(), k, value;
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (m.field === $util.emptyObject)
                            m.field = {};
                        var c2 = r.uint32() + r.pos;
                        k = 0;
                        value = null;
                        while (r.pos < c2) {
                            var tag2 = r.uint32();
                            switch (tag2 >>> 3) {
                            case 1:
                                k = r.uint32();
                                break;
                            case 2:
                                value = $root.proto.Field.decode(r, r.uint32());
                                break;
                            default:
                                r.skipType(tag2 & 7);
                                break;
                            }
                        }
                        m.field[k] = value;
                        break;
                    }
                case 2: {
                        m.version = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Config.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Config)
                return d;
            var m = new $root.proto.Config();
            if (d.field) {
                if (typeof d.field !== "object")
                    throw TypeError(".proto.Config.field: object expected");
                m.field = {};
                for (var ks = Object.keys(d.field), i = 0; i < ks.length; ++i) {
                    if (typeof d.field[ks[i]] !== "object")
                        throw TypeError(".proto.Config.field: object expected");
                    m.field[ks[i]] = $root.proto.Field.fromObject(d.field[ks[i]]);
                }
            }
            if (d.version != null) {
                m.version = d.version >>> 0;
            }
            return m;
        };

        Config.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.objects || o.defaults) {
                d.field = {};
            }
            var ks2;
            if (m.field && (ks2 = Object.keys(m.field)).length) {
                d.field = {};
                for (var j = 0; j < ks2.length; ++j) {
                    d.field[ks2[j]] = $root.proto.Field.toObject(m.field[ks2[j]], o);
                }
            }
            if (m.version != null && m.hasOwnProperty("version")) {
                d.version = m.version;
                if (o.oneofs)
                    d._version = "version";
            }
            return d;
        };

        Config.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Config.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Config";
        };

        return Config;
    })();

    proto.ContextInfo = (function() {

        function ContextInfo(p) {
            this.mentionedJid = [];
            this.groupMentions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ContextInfo.prototype.stanzaId = null;
        ContextInfo.prototype.participant = null;
        ContextInfo.prototype.quotedMessage = null;
        ContextInfo.prototype.remoteJid = null;
        ContextInfo.prototype.mentionedJid = $util.emptyArray;
        ContextInfo.prototype.conversionSource = null;
        ContextInfo.prototype.conversionData = null;
        ContextInfo.prototype.conversionDelaySeconds = null;
        ContextInfo.prototype.forwardingScore = null;
        ContextInfo.prototype.isForwarded = null;
        ContextInfo.prototype.quotedAd = null;
        ContextInfo.prototype.placeholderKey = null;
        ContextInfo.prototype.expiration = null;
        ContextInfo.prototype.ephemeralSettingTimestamp = null;
        ContextInfo.prototype.ephemeralSharedSecret = null;
        ContextInfo.prototype.externalAdReply = null;
        ContextInfo.prototype.entryPointConversionSource = null;
        ContextInfo.prototype.entryPointConversionApp = null;
        ContextInfo.prototype.entryPointConversionDelaySeconds = null;
        ContextInfo.prototype.disappearingMode = null;
        ContextInfo.prototype.actionLink = null;
        ContextInfo.prototype.groupSubject = null;
        ContextInfo.prototype.parentGroupJid = null;
        ContextInfo.prototype.trustBannerType = null;
        ContextInfo.prototype.trustBannerAction = null;
        ContextInfo.prototype.isSampled = null;
        ContextInfo.prototype.groupMentions = $util.emptyArray;
        ContextInfo.prototype.utm = null;
        ContextInfo.prototype.forwardedNewsletterMessageInfo = null;
        ContextInfo.prototype.businessMessageForwardInfo = null;
        ContextInfo.prototype.smbClientCampaignId = null;
        ContextInfo.prototype.smbServerCampaignId = null;
        ContextInfo.prototype.dataSharingContext = null;
        ContextInfo.prototype.alwaysShowAdAttribution = null;
        ContextInfo.prototype.featureEligibilities = null;
        ContextInfo.prototype.entryPointConversionExternalSource = null;
        ContextInfo.prototype.entryPointConversionExternalMedium = null;
        ContextInfo.prototype.ctwaSignals = null;
        ContextInfo.prototype.ctwaPayload = null;
        ContextInfo.prototype.forwardedAiBotMessageInfo = null;
        ContextInfo.prototype.statusAttributionType = null;
        ContextInfo.prototype.urlTrackingMap = null;
        ContextInfo.prototype.pairedMediaType = null;
        ContextInfo.prototype.rankingVersion = null;
        ContextInfo.prototype.memberLabel = null;
        ContextInfo.prototype.isQuestion = null;
        ContextInfo.prototype.statusSourceType = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_stanzaId", {
            get: $util.oneOfGetter($oneOfFields = ["stanzaId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_participant", {
            get: $util.oneOfGetter($oneOfFields = ["participant"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_quotedMessage", {
            get: $util.oneOfGetter($oneOfFields = ["quotedMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_remoteJid", {
            get: $util.oneOfGetter($oneOfFields = ["remoteJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_conversionSource", {
            get: $util.oneOfGetter($oneOfFields = ["conversionSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_conversionData", {
            get: $util.oneOfGetter($oneOfFields = ["conversionData"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_conversionDelaySeconds", {
            get: $util.oneOfGetter($oneOfFields = ["conversionDelaySeconds"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardingScore", {
            get: $util.oneOfGetter($oneOfFields = ["forwardingScore"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isForwarded", {
            get: $util.oneOfGetter($oneOfFields = ["isForwarded"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_quotedAd", {
            get: $util.oneOfGetter($oneOfFields = ["quotedAd"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_placeholderKey", {
            get: $util.oneOfGetter($oneOfFields = ["placeholderKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_expiration", {
            get: $util.oneOfGetter($oneOfFields = ["expiration"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ephemeralSettingTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["ephemeralSettingTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ephemeralSharedSecret", {
            get: $util.oneOfGetter($oneOfFields = ["ephemeralSharedSecret"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_externalAdReply", {
            get: $util.oneOfGetter($oneOfFields = ["externalAdReply"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionSource", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionApp", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionApp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionDelaySeconds", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionDelaySeconds"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_disappearingMode", {
            get: $util.oneOfGetter($oneOfFields = ["disappearingMode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_actionLink", {
            get: $util.oneOfGetter($oneOfFields = ["actionLink"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_groupSubject", {
            get: $util.oneOfGetter($oneOfFields = ["groupSubject"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_parentGroupJid", {
            get: $util.oneOfGetter($oneOfFields = ["parentGroupJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_trustBannerType", {
            get: $util.oneOfGetter($oneOfFields = ["trustBannerType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_trustBannerAction", {
            get: $util.oneOfGetter($oneOfFields = ["trustBannerAction"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isSampled", {
            get: $util.oneOfGetter($oneOfFields = ["isSampled"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_utm", {
            get: $util.oneOfGetter($oneOfFields = ["utm"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardedNewsletterMessageInfo", {
            get: $util.oneOfGetter($oneOfFields = ["forwardedNewsletterMessageInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_businessMessageForwardInfo", {
            get: $util.oneOfGetter($oneOfFields = ["businessMessageForwardInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_smbClientCampaignId", {
            get: $util.oneOfGetter($oneOfFields = ["smbClientCampaignId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_smbServerCampaignId", {
            get: $util.oneOfGetter($oneOfFields = ["smbServerCampaignId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_dataSharingContext", {
            get: $util.oneOfGetter($oneOfFields = ["dataSharingContext"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_alwaysShowAdAttribution", {
            get: $util.oneOfGetter($oneOfFields = ["alwaysShowAdAttribution"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_featureEligibilities", {
            get: $util.oneOfGetter($oneOfFields = ["featureEligibilities"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionExternalSource", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionExternalSource"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_entryPointConversionExternalMedium", {
            get: $util.oneOfGetter($oneOfFields = ["entryPointConversionExternalMedium"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ctwaSignals", {
            get: $util.oneOfGetter($oneOfFields = ["ctwaSignals"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_ctwaPayload", {
            get: $util.oneOfGetter($oneOfFields = ["ctwaPayload"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_forwardedAiBotMessageInfo", {
            get: $util.oneOfGetter($oneOfFields = ["forwardedAiBotMessageInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_statusAttributionType", {
            get: $util.oneOfGetter($oneOfFields = ["statusAttributionType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_urlTrackingMap", {
            get: $util.oneOfGetter($oneOfFields = ["urlTrackingMap"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_pairedMediaType", {
            get: $util.oneOfGetter($oneOfFields = ["pairedMediaType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_rankingVersion", {
            get: $util.oneOfGetter($oneOfFields = ["rankingVersion"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_memberLabel", {
            get: $util.oneOfGetter($oneOfFields = ["memberLabel"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_isQuestion", {
            get: $util.oneOfGetter($oneOfFields = ["isQuestion"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ContextInfo.prototype, "_statusSourceType", {
            get: $util.oneOfGetter($oneOfFields = ["statusSourceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        ContextInfo.create = function create(properties) {
            return new ContextInfo(properties);
        };

        ContextInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                w.uint32(10).string(m.stanzaId);
            if (m.participant != null && Object.hasOwnProperty.call(m, "participant"))
                w.uint32(18).string(m.participant);
            if (m.quotedMessage != null && Object.hasOwnProperty.call(m, "quotedMessage"))
                $root.proto.Message.encode(m.quotedMessage, w.uint32(26).fork()).ldelim();
            if (m.remoteJid != null && Object.hasOwnProperty.call(m, "remoteJid"))
                w.uint32(34).string(m.remoteJid);
            if (m.mentionedJid != null && m.mentionedJid.length) {
                for (var i = 0; i < m.mentionedJid.length; ++i)
                    w.uint32(122).string(m.mentionedJid[i]);
            }
            if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                w.uint32(146).string(m.conversionSource);
            if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                w.uint32(154).bytes(m.conversionData);
            if (m.conversionDelaySeconds != null && Object.hasOwnProperty.call(m, "conversionDelaySeconds"))
                w.uint32(160).uint32(m.conversionDelaySeconds);
            if (m.forwardingScore != null && Object.hasOwnProperty.call(m, "forwardingScore"))
                w.uint32(168).uint32(m.forwardingScore);
            if (m.isForwarded != null && Object.hasOwnProperty.call(m, "isForwarded"))
                w.uint32(176).bool(m.isForwarded);
            if (m.quotedAd != null && Object.hasOwnProperty.call(m, "quotedAd"))
                $root.proto.ContextInfo.AdReplyInfo.encode(m.quotedAd, w.uint32(186).fork()).ldelim();
            if (m.placeholderKey != null && Object.hasOwnProperty.call(m, "placeholderKey"))
                $root.proto.MessageKey.encode(m.placeholderKey, w.uint32(194).fork()).ldelim();
            if (m.expiration != null && Object.hasOwnProperty.call(m, "expiration"))
                w.uint32(200).uint32(m.expiration);
            if (m.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(m, "ephemeralSettingTimestamp"))
                w.uint32(208).int64(m.ephemeralSettingTimestamp);
            if (m.ephemeralSharedSecret != null && Object.hasOwnProperty.call(m, "ephemeralSharedSecret"))
                w.uint32(218).bytes(m.ephemeralSharedSecret);
            if (m.externalAdReply != null && Object.hasOwnProperty.call(m, "externalAdReply"))
                $root.proto.ContextInfo.ExternalAdReplyInfo.encode(m.externalAdReply, w.uint32(226).fork()).ldelim();
            if (m.entryPointConversionSource != null && Object.hasOwnProperty.call(m, "entryPointConversionSource"))
                w.uint32(234).string(m.entryPointConversionSource);
            if (m.entryPointConversionApp != null && Object.hasOwnProperty.call(m, "entryPointConversionApp"))
                w.uint32(242).string(m.entryPointConversionApp);
            if (m.entryPointConversionDelaySeconds != null && Object.hasOwnProperty.call(m, "entryPointConversionDelaySeconds"))
                w.uint32(248).uint32(m.entryPointConversionDelaySeconds);
            if (m.disappearingMode != null && Object.hasOwnProperty.call(m, "disappearingMode"))
                $root.proto.DisappearingMode.encode(m.disappearingMode, w.uint32(258).fork()).ldelim();
            if (m.actionLink != null && Object.hasOwnProperty.call(m, "actionLink"))
                $root.proto.ActionLink.encode(m.actionLink, w.uint32(266).fork()).ldelim();
            if (m.groupSubject != null && Object.hasOwnProperty.call(m, "groupSubject"))
                w.uint32(274).string(m.groupSubject);
            if (m.parentGroupJid != null && Object.hasOwnProperty.call(m, "parentGroupJid"))
                w.uint32(282).string(m.parentGroupJid);
            if (m.trustBannerType != null && Object.hasOwnProperty.call(m, "trustBannerType"))
                w.uint32(298).string(m.trustBannerType);
            if (m.trustBannerAction != null && Object.hasOwnProperty.call(m, "trustBannerAction"))
                w.uint32(304).uint32(m.trustBannerAction);
            if (m.isSampled != null && Object.hasOwnProperty.call(m, "isSampled"))
                w.uint32(312).bool(m.isSampled);
            if (m.groupMentions != null && m.groupMentions.length) {
                for (var i = 0; i < m.groupMentions.length; ++i)
                    $root.proto.GroupMention.encode(m.groupMentions[i], w.uint32(322).fork()).ldelim();
            }
            if (m.utm != null && Object.hasOwnProperty.call(m, "utm"))
                $root.proto.ContextInfo.UTMInfo.encode(m.utm, w.uint32(330).fork()).ldelim();
            if (m.forwardedNewsletterMessageInfo != null && Object.hasOwnProperty.call(m, "forwardedNewsletterMessageInfo"))
                $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.encode(m.forwardedNewsletterMessageInfo, w.uint32(346).fork()).ldelim();
            if (m.businessMessageForwardInfo != null && Object.hasOwnProperty.call(m, "businessMessageForwardInfo"))
                $root.proto.ContextInfo.BusinessMessageForwardInfo.encode(m.businessMessageForwardInfo, w.uint32(354).fork()).ldelim();
            if (m.smbClientCampaignId != null && Object.hasOwnProperty.call(m, "smbClientCampaignId"))
                w.uint32(362).string(m.smbClientCampaignId);
            if (m.smbServerCampaignId != null && Object.hasOwnProperty.call(m, "smbServerCampaignId"))
                w.uint32(370).string(m.smbServerCampaignId);
            if (m.dataSharingContext != null && Object.hasOwnProperty.call(m, "dataSharingContext"))
                $root.proto.ContextInfo.DataSharingContext.encode(m.dataSharingContext, w.uint32(378).fork()).ldelim();
            if (m.alwaysShowAdAttribution != null && Object.hasOwnProperty.call(m, "alwaysShowAdAttribution"))
                w.uint32(384).bool(m.alwaysShowAdAttribution);
            if (m.featureEligibilities != null && Object.hasOwnProperty.call(m, "featureEligibilities"))
                $root.proto.ContextInfo.FeatureEligibilities.encode(m.featureEligibilities, w.uint32(394).fork()).ldelim();
            if (m.entryPointConversionExternalSource != null && Object.hasOwnProperty.call(m, "entryPointConversionExternalSource"))
                w.uint32(402).string(m.entryPointConversionExternalSource);
            if (m.entryPointConversionExternalMedium != null && Object.hasOwnProperty.call(m, "entryPointConversionExternalMedium"))
                w.uint32(410).string(m.entryPointConversionExternalMedium);
            if (m.ctwaSignals != null && Object.hasOwnProperty.call(m, "ctwaSignals"))
                w.uint32(434).string(m.ctwaSignals);
            if (m.ctwaPayload != null && Object.hasOwnProperty.call(m, "ctwaPayload"))
                w.uint32(442).bytes(m.ctwaPayload);
            if (m.forwardedAiBotMessageInfo != null && Object.hasOwnProperty.call(m, "forwardedAiBotMessageInfo"))
                $root.proto.ContextInfo.ForwardedAIBotMessageInfo.encode(m.forwardedAiBotMessageInfo, w.uint32(450).fork()).ldelim();
            if (m.statusAttributionType != null && Object.hasOwnProperty.call(m, "statusAttributionType"))
                w.uint32(456).int32(m.statusAttributionType);
            if (m.urlTrackingMap != null && Object.hasOwnProperty.call(m, "urlTrackingMap"))
                $root.proto.UrlTrackingMap.encode(m.urlTrackingMap, w.uint32(466).fork()).ldelim();
            if (m.pairedMediaType != null && Object.hasOwnProperty.call(m, "pairedMediaType"))
                w.uint32(472).int32(m.pairedMediaType);
            if (m.rankingVersion != null && Object.hasOwnProperty.call(m, "rankingVersion"))
                w.uint32(480).uint32(m.rankingVersion);
            if (m.memberLabel != null && Object.hasOwnProperty.call(m, "memberLabel"))
                $root.proto.MemberLabel.encode(m.memberLabel, w.uint32(498).fork()).ldelim();
            if (m.isQuestion != null && Object.hasOwnProperty.call(m, "isQuestion"))
                w.uint32(504).bool(m.isQuestion);
            if (m.statusSourceType != null && Object.hasOwnProperty.call(m, "statusSourceType"))
                w.uint32(512).int32(m.statusSourceType);
            return w;
        };

        ContextInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.stanzaId = r.string();
                        break;
                    }
                case 2: {
                        m.participant = r.string();
                        break;
                    }
                case 3: {
                        m.quotedMessage = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.remoteJid = r.string();
                        break;
                    }
                case 15: {
                        if (!(m.mentionedJid && m.mentionedJid.length))
                            m.mentionedJid = [];
                        m.mentionedJid.push(r.string());
                        break;
                    }
                case 18: {
                        m.conversionSource = r.string();
                        break;
                    }
                case 19: {
                        m.conversionData = r.bytes();
                        break;
                    }
                case 20: {
                        m.conversionDelaySeconds = r.uint32();
                        break;
                    }
                case 21: {
                        m.forwardingScore = r.uint32();
                        break;
                    }
                case 22: {
                        m.isForwarded = r.bool();
                        break;
                    }
                case 23: {
                        m.quotedAd = $root.proto.ContextInfo.AdReplyInfo.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.placeholderKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 25: {
                        m.expiration = r.uint32();
                        break;
                    }
                case 26: {
                        m.ephemeralSettingTimestamp = r.int64();
                        break;
                    }
                case 27: {
                        m.ephemeralSharedSecret = r.bytes();
                        break;
                    }
                case 28: {
                        m.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.decode(r, r.uint32());
                        break;
                    }
                case 29: {
                        m.entryPointConversionSource = r.string();
                        break;
                    }
                case 30: {
                        m.entryPointConversionApp = r.string();
                        break;
                    }
                case 31: {
                        m.entryPointConversionDelaySeconds = r.uint32();
                        break;
                    }
                case 32: {
                        m.disappearingMode = $root.proto.DisappearingMode.decode(r, r.uint32());
                        break;
                    }
                case 33: {
                        m.actionLink = $root.proto.ActionLink.decode(r, r.uint32());
                        break;
                    }
                case 34: {
                        m.groupSubject = r.string();
                        break;
                    }
                case 35: {
                        m.parentGroupJid = r.string();
                        break;
                    }
                case 37: {
                        m.trustBannerType = r.string();
                        break;
                    }
                case 38: {
                        m.trustBannerAction = r.uint32();
                        break;
                    }
                case 39: {
                        m.isSampled = r.bool();
                        break;
                    }
                case 40: {
                        if (!(m.groupMentions && m.groupMentions.length))
                            m.groupMentions = [];
                        m.groupMentions.push($root.proto.GroupMention.decode(r, r.uint32()));
                        break;
                    }
                case 41: {
                        m.utm = $root.proto.ContextInfo.UTMInfo.decode(r, r.uint32());
                        break;
                    }
                case 43: {
                        m.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 44: {
                        m.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.decode(r, r.uint32());
                        break;
                    }
                case 45: {
                        m.smbClientCampaignId = r.string();
                        break;
                    }
                case 46: {
                        m.smbServerCampaignId = r.string();
                        break;
                    }
                case 47: {
                        m.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.decode(r, r.uint32());
                        break;
                    }
                case 48: {
                        m.alwaysShowAdAttribution = r.bool();
                        break;
                    }
                case 49: {
                        m.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.decode(r, r.uint32());
                        break;
                    }
                case 50: {
                        m.entryPointConversionExternalSource = r.string();
                        break;
                    }
                case 51: {
                        m.entryPointConversionExternalMedium = r.string();
                        break;
                    }
                case 54: {
                        m.ctwaSignals = r.string();
                        break;
                    }
                case 55: {
                        m.ctwaPayload = r.bytes();
                        break;
                    }
                case 56: {
                        m.forwardedAiBotMessageInfo = $root.proto.ContextInfo.ForwardedAIBotMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 57: {
                        m.statusAttributionType = r.int32();
                        break;
                    }
                case 58: {
                        m.urlTrackingMap = $root.proto.UrlTrackingMap.decode(r, r.uint32());
                        break;
                    }
                case 59: {
                        m.pairedMediaType = r.int32();
                        break;
                    }
                case 60: {
                        m.rankingVersion = r.uint32();
                        break;
                    }
                case 62: {
                        m.memberLabel = $root.proto.MemberLabel.decode(r, r.uint32());
                        break;
                    }
                case 63: {
                        m.isQuestion = r.bool();
                        break;
                    }
                case 64: {
                        m.statusSourceType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ContextInfo.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.ContextInfo)
                return d;
            var m = new $root.proto.ContextInfo();
            if (d.stanzaId != null) {
                m.stanzaId = String(d.stanzaId);
            }
            if (d.participant != null) {
                m.participant = String(d.participant);
            }
            if (d.quotedMessage != null) {
                if (typeof d.quotedMessage !== "object")
                    throw TypeError(".proto.ContextInfo.quotedMessage: object expected");
                m.quotedMessage = $root.proto.Message.fromObject(d.quotedMessage);
            }
            if (d.remoteJid != null) {
                m.remoteJid = String(d.remoteJid);
            }
            if (d.mentionedJid) {
                if (!Array.isArray(d.mentionedJid))
                    throw TypeError(".proto.ContextInfo.mentionedJid: array expected");
                m.mentionedJid = [];
                for (var i = 0; i < d.mentionedJid.length; ++i) {
                    m.mentionedJid[i] = String(d.mentionedJid[i]);
                }
            }
            if (d.conversionSource != null) {
                m.conversionSource = String(d.conversionSource);
            }
            if (d.conversionData != null) {
                if (typeof d.conversionData === "string")
                    $util.base64.decode(d.conversionData, m.conversionData = $util.newBuffer($util.base64.length(d.conversionData)), 0);
                else if (d.conversionData.length >= 0)
                    m.conversionData = d.conversionData;
            }
            if (d.conversionDelaySeconds != null) {
                m.conversionDelaySeconds = d.conversionDelaySeconds >>> 0;
            }
            if (d.forwardingScore != null) {
                m.forwardingScore = d.forwardingScore >>> 0;
            }
            if (d.isForwarded != null) {
                m.isForwarded = Boolean(d.isForwarded);
            }
            if (d.quotedAd != null) {
                if (typeof d.quotedAd !== "object")
                    throw TypeError(".proto.ContextInfo.quotedAd: object expected");
                m.quotedAd = $root.proto.ContextInfo.AdReplyInfo.fromObject(d.quotedAd);
            }
            if (d.placeholderKey != null) {
                if (typeof d.placeholderKey !== "object")
                    throw TypeError(".proto.ContextInfo.placeholderKey: object expected");
                m.placeholderKey = $root.proto.MessageKey.fromObject(d.placeholderKey);
            }
            if (d.expiration != null) {
                m.expiration = d.expiration >>> 0;
            }
            if (d.ephemeralSettingTimestamp != null) {
                if ($util.Long)
                    (m.ephemeralSettingTimestamp = $util.Long.fromValue(d.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof d.ephemeralSettingTimestamp === "string")
                    m.ephemeralSettingTimestamp = parseInt(d.ephemeralSettingTimestamp, 10);
                else if (typeof d.ephemeralSettingTimestamp === "number")
                    m.ephemeralSettingTimestamp = d.ephemeralSettingTimestamp;
                else if (typeof d.ephemeralSettingTimestamp === "object")
                    m.ephemeralSettingTimestamp = new $util.LongBits(d.ephemeralSettingTimestamp.low >>> 0, d.ephemeralSettingTimestamp.high >>> 0).toNumber();
            }
            if (d.ephemeralSharedSecret != null) {
                if (typeof d.ephemeralSharedSecret === "string")
                    $util.base64.decode(d.ephemeralSharedSecret, m.ephemeralSharedSecret = $util.newBuffer($util.base64.length(d.ephemeralSharedSecret)), 0);
                else if (d.ephemeralSharedSecret.length >= 0)
                    m.ephemeralSharedSecret = d.ephemeralSharedSecret;
            }
            if (d.externalAdReply != null) {
                if (typeof d.externalAdReply !== "object")
                    throw TypeError(".proto.ContextInfo.externalAdReply: object expected");
                m.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.fromObject(d.externalAdReply);
            }
            if (d.entryPointConversionSource != null) {
                m.entryPointConversionSource = String(d.entryPointConversionSource);
            }
            if (d.entryPointConversionApp != null) {
                m.entryPointConversionApp = String(d.entryPointConversionApp);
            }
            if (d.entryPointConversionDelaySeconds != null) {
                m.entryPointConversionDelaySeconds = d.entryPointConversionDelaySeconds >>> 0;
            }
            if (d.disappearingMode != null) {
                if (typeof d.disappearingMode !== "object")
                    throw TypeError(".proto.ContextInfo.disappearingMode: object expected");
                m.disappearingMode = $root.proto.DisappearingMode.fromObject(d.disappearingMode);
            }
            if (d.actionLink != null) {
                if (typeof d.actionLink !== "object")
                    throw TypeError(".proto.ContextInfo.actionLink: object expected");
                m.actionLink = $root.proto.ActionLink.fromObject(d.actionLink);
            }
            if (d.groupSubject != null) {
                m.groupSubject = String(d.groupSubject);
            }
            if (d.parentGroupJid != null) {
                m.parentGroupJid = String(d.parentGroupJid);
            }
            if (d.trustBannerType != null) {
                m.trustBannerType = String(d.trustBannerType);
            }
            if (d.trustBannerAction != null) {
                m.trustBannerAction = d.trustBannerAction >>> 0;
            }
            if (d.isSampled != null) {
                m.isSampled = Boolean(d.isSampled);
            }
            if (d.groupMentions) {
                if (!Array.isArray(d.groupMentions))
                    throw TypeError(".proto.ContextInfo.groupMentions: array expected");
                m.groupMentions = [];
                for (var i = 0; i < d.groupMentions.length; ++i) {
                    if (typeof d.groupMentions[i] !== "object")
                        throw TypeError(".proto.ContextInfo.groupMentions: object expected");
                    m.groupMentions[i] = $root.proto.GroupMention.fromObject(d.groupMentions[i]);
                }
            }
            if (d.utm != null) {
                if (typeof d.utm !== "object")
                    throw TypeError(".proto.ContextInfo.utm: object expected");
                m.utm = $root.proto.ContextInfo.UTMInfo.fromObject(d.utm);
            }
            if (d.forwardedNewsletterMessageInfo != null) {
                if (typeof d.forwardedNewsletterMessageInfo !== "object")
                    throw TypeError(".proto.ContextInfo.forwardedNewsletterMessageInfo: object expected");
                m.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.fromObject(d.forwardedNewsletterMessageInfo);
            }
            if (d.businessMessageForwardInfo != null) {
                if (typeof d.businessMessageForwardInfo !== "object")
                    throw TypeError(".proto.ContextInfo.businessMessageForwardInfo: object expected");
                m.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.fromObject(d.businessMessageForwardInfo);
            }
            if (d.smbClientCampaignId != null) {
                m.smbClientCampaignId = String(d.smbClientCampaignId);
            }
            if (d.smbServerCampaignId != null) {
                m.smbServerCampaignId = String(d.smbServerCampaignId);
            }
            if (d.dataSharingContext != null) {
                if (typeof d.dataSharingContext !== "object")
                    throw TypeError(".proto.ContextInfo.dataSharingContext: object expected");
                m.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.fromObject(d.dataSharingContext);
            }
            if (d.alwaysShowAdAttribution != null) {
                m.alwaysShowAdAttribution = Boolean(d.alwaysShowAdAttribution);
            }
            if (d.featureEligibilities != null) {
                if (typeof d.featureEligibilities !== "object")
                    throw TypeError(".proto.ContextInfo.featureEligibilities: object expected");
                m.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.fromObject(d.featureEligibilities);
            }
            if (d.entryPointConversionExternalSource != null) {
                m.entryPointConversionExternalSource = String(d.entryPointConversionExternalSource);
            }
            if (d.entryPointConversionExternalMedium != null) {
                m.entryPointConversionExternalMedium = String(d.entryPointConversionExternalMedium);
            }
            if (d.ctwaSignals != null) {
                m.ctwaSignals = String(d.ctwaSignals);
            }
            if (d.ctwaPayload != null) {
                if (typeof d.ctwaPayload === "string")
                    $util.base64.decode(d.ctwaPayload, m.ctwaPayload = $util.newBuffer($util.base64.length(d.ctwaPayload)), 0);
                else if (d.ctwaPayload.length >= 0)
                    m.ctwaPayload = d.ctwaPayload;
            }
            if (d.forwardedAiBotMessageInfo != null) {
                if (typeof d.forwardedAiBotMessageInfo !== "object")
                    throw TypeError(".proto.ContextInfo.forwardedAiBotMessageInfo: object expected");
                m.forwardedAiBotMessageInfo = $root.proto.ContextInfo.ForwardedAIBotMessageInfo.fromObject(d.forwardedAiBotMessageInfo);
            }
            switch (d.statusAttributionType) {
            default:
                if (typeof d.statusAttributionType === "number") {
                    m.statusAttributionType = d.statusAttributionType;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.statusAttributionType = 0;
                break;
            case "RESHARED_FROM_MENTION":
            case 1:
                m.statusAttributionType = 1;
                break;
            case "RESHARED_FROM_POST":
            case 2:
                m.statusAttributionType = 2;
                break;
            }
            if (d.urlTrackingMap != null) {
                if (typeof d.urlTrackingMap !== "object")
                    throw TypeError(".proto.ContextInfo.urlTrackingMap: object expected");
                m.urlTrackingMap = $root.proto.UrlTrackingMap.fromObject(d.urlTrackingMap);
            }
            switch (d.pairedMediaType) {
            default:
                if (typeof d.pairedMediaType === "number") {
                    m.pairedMediaType = d.pairedMediaType;
                    break;
                }
                break;
            case "NOT_PAIRED_MEDIA":
            case 0:
                m.pairedMediaType = 0;
                break;
            case "SD_VIDEO_PARENT":
            case 1:
                m.pairedMediaType = 1;
                break;
            case "HD_VIDEO_CHILD":
            case 2:
                m.pairedMediaType = 2;
                break;
            case "SD_IMAGE_PARENT":
            case 3:
                m.pairedMediaType = 3;
                break;
            case "HD_IMAGE_CHILD":
            case 4:
                m.pairedMediaType = 4;
                break;
            case "MOTION_PHOTO_PARENT":
            case 5:
                m.pairedMediaType = 5;
                break;
            case "MOTION_PHOTO_CHILD":
            case 6:
                m.pairedMediaType = 6;
                break;
            }
            if (d.rankingVersion != null) {
                m.rankingVersion = d.rankingVersion >>> 0;
            }
            if (d.memberLabel != null) {
                if (typeof d.memberLabel !== "object")
                    throw TypeError(".proto.ContextInfo.memberLabel: object expected");
                m.memberLabel = $root.proto.MemberLabel.fromObject(d.memberLabel);
            }
            if (d.isQuestion != null) {
                m.isQuestion = Boolean(d.isQuestion);
            }
            switch (d.statusSourceType) {
            default:
                if (typeof d.statusSourceType === "number") {
                    m.statusSourceType = d.statusSourceType;
                    break;
                }
                break;
            case "IMAGE":
            case 0:
                m.statusSourceType = 0;
                break;
            case "VIDEO":
            case 1:
                m.statusSourceType = 1;
                break;
            case "GIF":
            case 2:
                m.statusSourceType = 2;
                break;
            case "AUDIO":
            case 3:
                m.statusSourceType = 3;
                break;
            case "TEXT":
            case 4:
                m.statusSourceType = 4;
                break;
            case "MUSIC_STANDALONE":
            case 5:
                m.statusSourceType = 5;
                break;
            }
            return m;
        };

        ContextInfo.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.mentionedJid = [];
                d.groupMentions = [];
            }
            if (m.stanzaId != null && m.hasOwnProperty("stanzaId")) {
                d.stanzaId = m.stanzaId;
                if (o.oneofs)
                    d._stanzaId = "stanzaId";
            }
            if (m.participant != null && m.hasOwnProperty("participant")) {
                d.participant = m.participant;
                if (o.oneofs)
                    d._participant = "participant";
            }
            if (m.quotedMessage != null && m.hasOwnProperty("quotedMessage")) {
                d.quotedMessage = $root.proto.Message.toObject(m.quotedMessage, o);
                if (o.oneofs)
                    d._quotedMessage = "quotedMessage";
            }
            if (m.remoteJid != null && m.hasOwnProperty("remoteJid")) {
                d.remoteJid = m.remoteJid;
                if (o.oneofs)
                    d._remoteJid = "remoteJid";
            }
            if (m.mentionedJid && m.mentionedJid.length) {
                d.mentionedJid = [];
                for (var j = 0; j < m.mentionedJid.length; ++j) {
                    d.mentionedJid[j] = m.mentionedJid[j];
                }
            }
            if (m.conversionSource != null && m.hasOwnProperty("conversionSource")) {
                d.conversionSource = m.conversionSource;
                if (o.oneofs)
                    d._conversionSource = "conversionSource";
            }
            if (m.conversionData != null && m.hasOwnProperty("conversionData")) {
                d.conversionData = o.bytes === String ? $util.base64.encode(m.conversionData, 0, m.conversionData.length) : o.bytes === Array ? Array.prototype.slice.call(m.conversionData) : m.conversionData;
                if (o.oneofs)
                    d._conversionData = "conversionData";
            }
            if (m.conversionDelaySeconds != null && m.hasOwnProperty("conversionDelaySeconds")) {
                d.conversionDelaySeconds = m.conversionDelaySeconds;
                if (o.oneofs)
                    d._conversionDelaySeconds = "conversionDelaySeconds";
            }
            if (m.forwardingScore != null && m.hasOwnProperty("forwardingScore")) {
                d.forwardingScore = m.forwardingScore;
                if (o.oneofs)
                    d._forwardingScore = "forwardingScore";
            }
            if (m.isForwarded != null && m.hasOwnProperty("isForwarded")) {
                d.isForwarded = m.isForwarded;
                if (o.oneofs)
                    d._isForwarded = "isForwarded";
            }
            if (m.quotedAd != null && m.hasOwnProperty("quotedAd")) {
                d.quotedAd = $root.proto.ContextInfo.AdReplyInfo.toObject(m.quotedAd, o);
                if (o.oneofs)
                    d._quotedAd = "quotedAd";
            }
            if (m.placeholderKey != null && m.hasOwnProperty("placeholderKey")) {
                d.placeholderKey = $root.proto.MessageKey.toObject(m.placeholderKey, o);
                if (o.oneofs)
                    d._placeholderKey = "placeholderKey";
            }
            if (m.expiration != null && m.hasOwnProperty("expiration")) {
                d.expiration = m.expiration;
                if (o.oneofs)
                    d._expiration = "expiration";
            }
            if (m.ephemeralSettingTimestamp != null && m.hasOwnProperty("ephemeralSettingTimestamp")) {
                if (typeof m.ephemeralSettingTimestamp === "number")
                    d.ephemeralSettingTimestamp = o.longs === String ? String(m.ephemeralSettingTimestamp) : m.ephemeralSettingTimestamp;
                else
                    d.ephemeralSettingTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.ephemeralSettingTimestamp) : o.longs === Number ? new $util.LongBits(m.ephemeralSettingTimestamp.low >>> 0, m.ephemeralSettingTimestamp.high >>> 0).toNumber() : m.ephemeralSettingTimestamp;
                if (o.oneofs)
                    d._ephemeralSettingTimestamp = "ephemeralSettingTimestamp";
            }
            if (m.ephemeralSharedSecret != null && m.hasOwnProperty("ephemeralSharedSecret")) {
                d.ephemeralSharedSecret = o.bytes === String ? $util.base64.encode(m.ephemeralSharedSecret, 0, m.ephemeralSharedSecret.length) : o.bytes === Array ? Array.prototype.slice.call(m.ephemeralSharedSecret) : m.ephemeralSharedSecret;
                if (o.oneofs)
                    d._ephemeralSharedSecret = "ephemeralSharedSecret";
            }
            if (m.externalAdReply != null && m.hasOwnProperty("externalAdReply")) {
                d.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.toObject(m.externalAdReply, o);
                if (o.oneofs)
                    d._externalAdReply = "externalAdReply";
            }
            if (m.entryPointConversionSource != null && m.hasOwnProperty("entryPointConversionSource")) {
                d.entryPointConversionSource = m.entryPointConversionSource;
                if (o.oneofs)
                    d._entryPointConversionSource = "entryPointConversionSource";
            }
            if (m.entryPointConversionApp != null && m.hasOwnProperty("entryPointConversionApp")) {
                d.entryPointConversionApp = m.entryPointConversionApp;
                if (o.oneofs)
                    d._entryPointConversionApp = "entryPointConversionApp";
            }
            if (m.entryPointConversionDelaySeconds != null && m.hasOwnProperty("entryPointConversionDelaySeconds")) {
                d.entryPointConversionDelaySeconds = m.entryPointConversionDelaySeconds;
                if (o.oneofs)
                    d._entryPointConversionDelaySeconds = "entryPointConversionDelaySeconds";
            }
            if (m.disappearingMode != null && m.hasOwnProperty("disappearingMode")) {
                d.disappearingMode = $root.proto.DisappearingMode.toObject(m.disappearingMode, o);
                if (o.oneofs)
                    d._disappearingMode = "disappearingMode";
            }
            if (m.actionLink != null && m.hasOwnProperty("actionLink")) {
                d.actionLink = $root.proto.ActionLink.toObject(m.actionLink, o);
                if (o.oneofs)
                    d._actionLink = "actionLink";
            }
            if (m.groupSubject != null && m.hasOwnProperty("groupSubject")) {
                d.groupSubject = m.groupSubject;
                if (o.oneofs)
                    d._groupSubject = "groupSubject";
            }
            if (m.parentGroupJid != null && m.hasOwnProperty("parentGroupJid")) {
                d.parentGroupJid = m.parentGroupJid;
                if (o.oneofs)
                    d._parentGroupJid = "parentGroupJid";
            }
            if (m.trustBannerType != null && m.hasOwnProperty("trustBannerType")) {
                d.trustBannerType = m.trustBannerType;
                if (o.oneofs)
                    d._trustBannerType = "trustBannerType";
            }
            if (m.trustBannerAction != null && m.hasOwnProperty("trustBannerAction")) {
                d.trustBannerAction = m.trustBannerAction;
                if (o.oneofs)
                    d._trustBannerAction = "trustBannerAction";
            }
            if (m.isSampled != null && m.hasOwnProperty("isSampled")) {
                d.isSampled = m.isSampled;
                if (o.oneofs)
                    d._isSampled = "isSampled";
            }
            if (m.groupMentions && m.groupMentions.length) {
                d.groupMentions = [];
                for (var j = 0; j < m.groupMentions.length; ++j) {
                    d.groupMentions[j] = $root.proto.GroupMention.toObject(m.groupMentions[j], o);
                }
            }
            if (m.utm != null && m.hasOwnProperty("utm")) {
                d.utm = $root.proto.ContextInfo.UTMInfo.toObject(m.utm, o);
                if (o.oneofs)
                    d._utm = "utm";
            }
            if (m.forwardedNewsletterMessageInfo != null && m.hasOwnProperty("forwardedNewsletterMessageInfo")) {
                d.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.toObject(m.forwardedNewsletterMessageInfo, o);
                if (o.oneofs)
                    d._forwardedNewsletterMessageInfo = "forwardedNewsletterMessageInfo";
            }
            if (m.businessMessageForwardInfo != null && m.hasOwnProperty("businessMessageForwardInfo")) {
                d.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.toObject(m.businessMessageForwardInfo, o);
                if (o.oneofs)
                    d._businessMessageForwardInfo = "businessMessageForwardInfo";
            }
            if (m.smbClientCampaignId != null && m.hasOwnProperty("smbClientCampaignId")) {
                d.smbClientCampaignId = m.smbClientCampaignId;
                if (o.oneofs)
                    d._smbClientCampaignId = "smbClientCampaignId";
            }
            if (m.smbServerCampaignId != null && m.hasOwnProperty("smbServerCampaignId")) {
                d.smbServerCampaignId = m.smbServerCampaignId;
                if (o.oneofs)
                    d._smbServerCampaignId = "smbServerCampaignId";
            }
            if (m.dataSharingContext != null && m.hasOwnProperty("dataSharingContext")) {
                d.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.toObject(m.dataSharingContext, o);
                if (o.oneofs)
                    d._dataSharingContext = "dataSharingContext";
            }
            if (m.alwaysShowAdAttribution != null && m.hasOwnProperty("alwaysShowAdAttribution")) {
                d.alwaysShowAdAttribution = m.alwaysShowAdAttribution;
                if (o.oneofs)
                    d._alwaysShowAdAttribution = "alwaysShowAdAttribution";
            }
            if (m.featureEligibilities != null && m.hasOwnProperty("featureEligibilities")) {
                d.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.toObject(m.featureEligibilities, o);
                if (o.oneofs)
                    d._featureEligibilities = "featureEligibilities";
            }
            if (m.entryPointConversionExternalSource != null && m.hasOwnProperty("entryPointConversionExternalSource")) {
                d.entryPointConversionExternalSource = m.entryPointConversionExternalSource;
                if (o.oneofs)
                    d._entryPointConversionExternalSource = "entryPointConversionExternalSource";
            }
            if (m.entryPointConversionExternalMedium != null && m.hasOwnProperty("entryPointConversionExternalMedium")) {
                d.entryPointConversionExternalMedium = m.entryPointConversionExternalMedium;
                if (o.oneofs)
                    d._entryPointConversionExternalMedium = "entryPointConversionExternalMedium";
            }
            if (m.ctwaSignals != null && m.hasOwnProperty("ctwaSignals")) {
                d.ctwaSignals = m.ctwaSignals;
                if (o.oneofs)
                    d._ctwaSignals = "ctwaSignals";
            }
            if (m.ctwaPayload != null && m.hasOwnProperty("ctwaPayload")) {
                d.ctwaPayload = o.bytes === String ? $util.base64.encode(m.ctwaPayload, 0, m.ctwaPayload.length) : o.bytes === Array ? Array.prototype.slice.call(m.ctwaPayload) : m.ctwaPayload;
                if (o.oneofs)
                    d._ctwaPayload = "ctwaPayload";
            }
            if (m.forwardedAiBotMessageInfo != null && m.hasOwnProperty("forwardedAiBotMessageInfo")) {
                d.forwardedAiBotMessageInfo = $root.proto.ContextInfo.ForwardedAIBotMessageInfo.toObject(m.forwardedAiBotMessageInfo, o);
                if (o.oneofs)
                    d._forwardedAiBotMessageInfo = "forwardedAiBotMessageInfo";
            }
            if (m.statusAttributionType != null && m.hasOwnProperty("statusAttributionType")) {
                d.statusAttributionType = o.enums === String ? $root.proto.ContextInfo.StatusAttributionType[m.statusAttributionType] === undefined ? m.statusAttributionType : $root.proto.ContextInfo.StatusAttributionType[m.statusAttributionType] : m.statusAttributionType;
                if (o.oneofs)
                    d._statusAttributionType = "statusAttributionType";
            }
            if (m.urlTrackingMap != null && m.hasOwnProperty("urlTrackingMap")) {
                d.urlTrackingMap = $root.proto.UrlTrackingMap.toObject(m.urlTrackingMap, o);
                if (o.oneofs)
                    d._urlTrackingMap = "urlTrackingMap";
            }
            if (m.pairedMediaType != null && m.hasOwnProperty("pairedMediaType")) {
                d.pairedMediaType = o.enums === String ? $root.proto.ContextInfo.PairedMediaType[m.pairedMediaType] === undefined ? m.pairedMediaType : $root.proto.ContextInfo.PairedMediaType[m.pairedMediaType] : m.pairedMediaType;
                if (o.oneofs)
                    d._pairedMediaType = "pairedMediaType";
            }
            if (m.rankingVersion != null && m.hasOwnProperty("rankingVersion")) {
                d.rankingVersion = m.rankingVersion;
                if (o.oneofs)
                    d._rankingVersion = "rankingVersion";
            }
            if (m.memberLabel != null && m.hasOwnProperty("memberLabel")) {
                d.memberLabel = $root.proto.MemberLabel.toObject(m.memberLabel, o);
                if (o.oneofs)
                    d._memberLabel = "memberLabel";
            }
            if (m.isQuestion != null && m.hasOwnProperty("isQuestion")) {
                d.isQuestion = m.isQuestion;
                if (o.oneofs)
                    d._isQuestion = "isQuestion";
            }
            if (m.statusSourceType != null && m.hasOwnProperty("statusSourceType")) {
                d.statusSourceType = o.enums === String ? $root.proto.ContextInfo.StatusSourceType[m.statusSourceType] === undefined ? m.statusSourceType : $root.proto.ContextInfo.StatusSourceType[m.statusSourceType] : m.statusSourceType;
                if (o.oneofs)
                    d._statusSourceType = "statusSourceType";
            }
            return d;
        };

        ContextInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ContextInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ContextInfo";
        };

        ContextInfo.AdReplyInfo = (function() {

            function AdReplyInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AdReplyInfo.prototype.advertiserName = null;
            AdReplyInfo.prototype.mediaType = null;
            AdReplyInfo.prototype.jpegThumbnail = null;
            AdReplyInfo.prototype.caption = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_advertiserName", {
                get: $util.oneOfGetter($oneOfFields = ["advertiserName"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_mediaType", {
                get: $util.oneOfGetter($oneOfFields = ["mediaType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_jpegThumbnail", {
                get: $util.oneOfGetter($oneOfFields = ["jpegThumbnail"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AdReplyInfo.prototype, "_caption", {
                get: $util.oneOfGetter($oneOfFields = ["caption"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AdReplyInfo.create = function create(properties) {
                return new AdReplyInfo(properties);
            };

            AdReplyInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.advertiserName != null && Object.hasOwnProperty.call(m, "advertiserName"))
                    w.uint32(10).string(m.advertiserName);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(16).int32(m.mediaType);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(138).string(m.caption);
                return w;
            };

            AdReplyInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.AdReplyInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.advertiserName = r.string();
                            break;
                        }
                    case 2: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.caption = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AdReplyInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.AdReplyInfo)
                    return d;
                var m = new $root.proto.ContextInfo.AdReplyInfo();
                if (d.advertiserName != null) {
                    m.advertiserName = String(d.advertiserName);
                }
                switch (d.mediaType) {
                default:
                    if (typeof d.mediaType === "number") {
                        m.mediaType = d.mediaType;
                        break;
                    }
                    break;
                case "NONE":
                case 0:
                    m.mediaType = 0;
                    break;
                case "IMAGE":
                case 1:
                    m.mediaType = 1;
                    break;
                case "VIDEO":
                case 2:
                    m.mediaType = 2;
                    break;
                }
                if (d.jpegThumbnail != null) {
                    if (typeof d.jpegThumbnail === "string")
                        $util.base64.decode(d.jpegThumbnail, m.jpegThumbnail = $util.newBuffer($util.base64.length(d.jpegThumbnail)), 0);
                    else if (d.jpegThumbnail.length >= 0)
                        m.jpegThumbnail = d.jpegThumbnail;
                }
                if (d.caption != null) {
                    m.caption = String(d.caption);
                }
                return m;
            };

            AdReplyInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.advertiserName != null && m.hasOwnProperty("advertiserName")) {
                    d.advertiserName = m.advertiserName;
                    if (o.oneofs)
                        d._advertiserName = "advertiserName";
                }
                if (m.mediaType != null && m.hasOwnProperty("mediaType")) {
                    d.mediaType = o.enums === String ? $root.proto.ContextInfo.AdReplyInfo.MediaType[m.mediaType] === undefined ? m.mediaType : $root.proto.ContextInfo.AdReplyInfo.MediaType[m.mediaType] : m.mediaType;
                    if (o.oneofs)
                        d._mediaType = "mediaType";
                }
                if (m.jpegThumbnail != null && m.hasOwnProperty("jpegThumbnail")) {
                    d.jpegThumbnail = o.bytes === String ? $util.base64.encode(m.jpegThumbnail, 0, m.jpegThumbnail.length) : o.bytes === Array ? Array.prototype.slice.call(m.jpegThumbnail) : m.jpegThumbnail;
                    if (o.oneofs)
                        d._jpegThumbnail = "jpegThumbnail";
                }
                if (m.caption != null && m.hasOwnProperty("caption")) {
                    d.caption = m.caption;
                    if (o.oneofs)
                        d._caption = "caption";
                }
                return d;
            };

            AdReplyInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AdReplyInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.AdReplyInfo";
            };

            AdReplyInfo.MediaType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return AdReplyInfo;
        })();

        ContextInfo.BusinessMessageForwardInfo = (function() {

            function BusinessMessageForwardInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BusinessMessageForwardInfo.prototype.businessOwnerJid = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BusinessMessageForwardInfo.prototype, "_businessOwnerJid", {
                get: $util.oneOfGetter($oneOfFields = ["businessOwnerJid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            BusinessMessageForwardInfo.create = function create(properties) {
                return new BusinessMessageForwardInfo(properties);
            };

            BusinessMessageForwardInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.businessOwnerJid != null && Object.hasOwnProperty.call(m, "businessOwnerJid"))
                    w.uint32(10).string(m.businessOwnerJid);
                return w;
            };

            BusinessMessageForwardInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.BusinessMessageForwardInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.businessOwnerJid = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BusinessMessageForwardInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.BusinessMessageForwardInfo)
                    return d;
                var m = new $root.proto.ContextInfo.BusinessMessageForwardInfo();
                if (d.businessOwnerJid != null) {
                    m.businessOwnerJid = String(d.businessOwnerJid);
                }
                return m;
            };

            BusinessMessageForwardInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.businessOwnerJid != null && m.hasOwnProperty("businessOwnerJid")) {
                    d.businessOwnerJid = m.businessOwnerJid;
                    if (o.oneofs)
                        d._businessOwnerJid = "businessOwnerJid";
                }
                return d;
            };

            BusinessMessageForwardInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            BusinessMessageForwardInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.BusinessMessageForwardInfo";
            };

            return BusinessMessageForwardInfo;
        })();

        ContextInfo.DataSharingContext = (function() {

            function DataSharingContext(p) {
                this.parameters = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DataSharingContext.prototype.showMmDisclosure = null;
            DataSharingContext.prototype.encryptedSignalTokenConsented = null;
            DataSharingContext.prototype.parameters = $util.emptyArray;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DataSharingContext.prototype, "_showMmDisclosure", {
                get: $util.oneOfGetter($oneOfFields = ["showMmDisclosure"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(DataSharingContext.prototype, "_encryptedSignalTokenConsented", {
                get: $util.oneOfGetter($oneOfFields = ["encryptedSignalTokenConsented"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            DataSharingContext.create = function create(properties) {
                return new DataSharingContext(properties);
            };

            DataSharingContext.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.showMmDisclosure != null && Object.hasOwnProperty.call(m, "showMmDisclosure"))
                    w.uint32(8).bool(m.showMmDisclosure);
                if (m.encryptedSignalTokenConsented != null && Object.hasOwnProperty.call(m, "encryptedSignalTokenConsented"))
                    w.uint32(18).string(m.encryptedSignalTokenConsented);
                if (m.parameters != null && m.parameters.length) {
                    for (var i = 0; i < m.parameters.length; ++i)
                        $root.proto.ContextInfo.DataSharingContext.Parameters.encode(m.parameters[i], w.uint32(26).fork()).ldelim();
                }
                return w;
            };

            DataSharingContext.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.DataSharingContext();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.showMmDisclosure = r.bool();
                            break;
                        }
                    case 2: {
                            m.encryptedSignalTokenConsented = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.parameters && m.parameters.length))
                                m.parameters = [];
                            m.parameters.push($root.proto.ContextInfo.DataSharingContext.Parameters.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DataSharingContext.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.DataSharingContext)
                    return d;
                var m = new $root.proto.ContextInfo.DataSharingContext();
                if (d.showMmDisclosure != null) {
                    m.showMmDisclosure = Boolean(d.showMmDisclosure);
                }
                if (d.encryptedSignalTokenConsented != null) {
                    m.encryptedSignalTokenConsented = String(d.encryptedSignalTokenConsented);
                }
                if (d.parameters) {
                    if (!Array.isArray(d.parameters))
                        throw TypeError(".proto.ContextInfo.DataSharingContext.parameters: array expected");
                    m.parameters = [];
                    for (var i = 0; i < d.parameters.length; ++i) {
                        if (typeof d.parameters[i] !== "object")
                            throw TypeError(".proto.ContextInfo.DataSharingContext.parameters: object expected");
                        m.parameters[i] = $root.proto.ContextInfo.DataSharingContext.Parameters.fromObject(d.parameters[i]);
                    }
                }
                return m;
            };

            DataSharingContext.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (o.arrays || o.defaults) {
                    d.parameters = [];
                }
                if (m.showMmDisclosure != null && m.hasOwnProperty("showMmDisclosure")) {
                    d.showMmDisclosure = m.showMmDisclosure;
                    if (o.oneofs)
                        d._showMmDisclosure = "showMmDisclosure";
                }
                if (m.encryptedSignalTokenConsented != null && m.hasOwnProperty("encryptedSignalTokenConsented")) {
                    d.encryptedSignalTokenConsented = m.encryptedSignalTokenConsented;
                    if (o.oneofs)
                        d._encryptedSignalTokenConsented = "encryptedSignalTokenConsented";
                }
                if (m.parameters && m.parameters.length) {
                    d.parameters = [];
                    for (var j = 0; j < m.parameters.length; ++j) {
                        d.parameters[j] = $root.proto.ContextInfo.DataSharingContext.Parameters.toObject(m.parameters[j], o);
                    }
                }
                return d;
            };

            DataSharingContext.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            DataSharingContext.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.DataSharingContext";
            };

            DataSharingContext.Parameters = (function() {

                function Parameters(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Parameters.prototype.key = null;
                Parameters.prototype.stringData = null;
                Parameters.prototype.intData = null;
                Parameters.prototype.floatData = null;
                Parameters.prototype.contents = null;

                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_key", {
                    get: $util.oneOfGetter($oneOfFields = ["key"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_stringData", {
                    get: $util.oneOfGetter($oneOfFields = ["stringData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_intData", {
                    get: $util.oneOfGetter($oneOfFields = ["intData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_floatData", {
                    get: $util.oneOfGetter($oneOfFields = ["floatData"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(Parameters.prototype, "_contents", {
                    get: $util.oneOfGetter($oneOfFields = ["contents"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                Parameters.create = function create(properties) {
                    return new Parameters(properties);
                };

                Parameters.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                        w.uint32(10).string(m.key);
                    if (m.stringData != null && Object.hasOwnProperty.call(m, "stringData"))
                        w.uint32(18).string(m.stringData);
                    if (m.intData != null && Object.hasOwnProperty.call(m, "intData"))
                        w.uint32(24).int64(m.intData);
                    if (m.floatData != null && Object.hasOwnProperty.call(m, "floatData"))
                        w.uint32(37).float(m.floatData);
                    if (m.contents != null && Object.hasOwnProperty.call(m, "contents"))
                        $root.proto.ContextInfo.DataSharingContext.Parameters.encode(m.contents, w.uint32(42).fork()).ldelim();
                    return w;
                };

                Parameters.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.DataSharingContext.Parameters();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.key = r.string();
                                break;
                            }
                        case 2: {
                                m.stringData = r.string();
                                break;
                            }
                        case 3: {
                                m.intData = r.int64();
                                break;
                            }
                        case 4: {
                                m.floatData = r.float();
                                break;
                            }
                        case 5: {
                                m.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Parameters.fromObject = function fromObject(d) {
                    if (d instanceof $root.proto.ContextInfo.DataSharingContext.Parameters)
                        return d;
                    var m = new $root.proto.ContextInfo.DataSharingContext.Parameters();
                    if (d.key != null) {
                        m.key = String(d.key);
                    }
                    if (d.stringData != null) {
                        m.stringData = String(d.stringData);
                    }
                    if (d.intData != null) {
                        if ($util.Long)
                            (m.intData = $util.Long.fromValue(d.intData)).unsigned = false;
                        else if (typeof d.intData === "string")
                            m.intData = parseInt(d.intData, 10);
                        else if (typeof d.intData === "number")
                            m.intData = d.intData;
                        else if (typeof d.intData === "object")
                            m.intData = new $util.LongBits(d.intData.low >>> 0, d.intData.high >>> 0).toNumber();
                    }
                    if (d.floatData != null) {
                        m.floatData = Number(d.floatData);
                    }
                    if (d.contents != null) {
                        if (typeof d.contents !== "object")
                            throw TypeError(".proto.ContextInfo.DataSharingContext.Parameters.contents: object expected");
                        m.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.fromObject(d.contents);
                    }
                    return m;
                };

                Parameters.toObject = function toObject(m, o) {
                    if (!o)
                        o = {};
                    var d = {};
                    if (m.key != null && m.hasOwnProperty("key")) {
                        d.key = m.key;
                        if (o.oneofs)
                            d._key = "key";
                    }
                    if (m.stringData != null && m.hasOwnProperty("stringData")) {
                        d.stringData = m.stringData;
                        if (o.oneofs)
                            d._stringData = "stringData";
                    }
                    if (m.intData != null && m.hasOwnProperty("intData")) {
                        if (typeof m.intData === "number")
                            d.intData = o.longs === String ? String(m.intData) : m.intData;
                        else
                            d.intData = o.longs === String ? $util.Long.prototype.toString.call(m.intData) : o.longs === Number ? new $util.LongBits(m.intData.low >>> 0, m.intData.high >>> 0).toNumber() : m.intData;
                        if (o.oneofs)
                            d._intData = "intData";
                    }
                    if (m.floatData != null && m.hasOwnProperty("floatData")) {
                        d.floatData = o.json && !isFinite(m.floatData) ? String(m.floatData) : m.floatData;
                        if (o.oneofs)
                            d._floatData = "floatData";
                    }
                    if (m.contents != null && m.hasOwnProperty("contents")) {
                        d.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.toObject(m.contents, o);
                        if (o.oneofs)
                            d._contents = "contents";
                    }
                    return d;
                };

                Parameters.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                Parameters.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ContextInfo.DataSharingContext.Parameters";
                };

                return Parameters;
            })();

            return DataSharingContext;
        })();

        ContextInfo.ExternalAdReplyInfo = (function() {

            function ExternalAdReplyInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ExternalAdReplyInfo.prototype.title = null;
            ExternalAdReplyInfo.prototype.body = null;
            ExternalAdReplyInfo.prototype.mediaType = null;
            ExternalAdReplyInfo.prototype.thumbnailUrl = null;
            ExternalAdReplyInfo.prototype.mediaUrl = null;
            ExternalAdReplyInfo.prototype.thumbnail = null;
            ExternalAdReplyInfo.prototype.sourceType = null;
            ExternalAdReplyInfo.prototype.sourceId = null;
            ExternalAdReplyInfo.prototype.sourceUrl = null;
            ExternalAdReplyInfo.prototype.containsAutoReply = null;
            ExternalAdReplyInfo.prototype.renderLargerThumbnail = null;
            ExternalAdReplyInfo.prototype.showAdAttribution = null;
            ExternalAdReplyInfo.prototype.ctwaClid = null;
            ExternalAdReplyInfo.prototype.ref = null;
            ExternalAdReplyInfo.prototype.clickToWhatsappCall = null;
            ExternalAdReplyInfo.prototype.adContextPreviewDismissed = null;
            ExternalAdReplyInfo.prototype.sourceApp = null;
            ExternalAdReplyInfo.prototype.automatedGreetingMessageShown = null;
            ExternalAdReplyInfo.prototype.greetingMessageBody = null;
            ExternalAdReplyInfo.prototype.ctaPayload = null;
            ExternalAdReplyInfo.prototype.disableNudge = null;
            ExternalAdReplyInfo.prototype.originalImageUrl = null;
            ExternalAdReplyInfo.prototype.automatedGreetingMessageCtaType = null;
            ExternalAdReplyInfo.prototype.wtwaAdFormat = null;
            ExternalAdReplyInfo.prototype.adType = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_title", {
                get: $util.oneOfGetter($oneOfFields = ["title"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_body", {
                get: $util.oneOfGetter($oneOfFields = ["body"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_mediaType", {
                get: $util.oneOfGetter($oneOfFields = ["mediaType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_thumbnailUrl", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_mediaUrl", {
                get: $util.oneOfGetter($oneOfFields = ["mediaUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_thumbnail", {
                get: $util.oneOfGetter($oneOfFields = ["thumbnail"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceType", {
                get: $util.oneOfGetter($oneOfFields = ["sourceType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceId", {
                get: $util.oneOfGetter($oneOfFields = ["sourceId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceUrl", {
                get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_containsAutoReply", {
                get: $util.oneOfGetter($oneOfFields = ["containsAutoReply"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_renderLargerThumbnail", {
                get: $util.oneOfGetter($oneOfFields = ["renderLargerThumbnail"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_showAdAttribution", {
                get: $util.oneOfGetter($oneOfFields = ["showAdAttribution"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_ctwaClid", {
                get: $util.oneOfGetter($oneOfFields = ["ctwaClid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_ref", {
                get: $util.oneOfGetter($oneOfFields = ["ref"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_clickToWhatsappCall", {
                get: $util.oneOfGetter($oneOfFields = ["clickToWhatsappCall"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_adContextPreviewDismissed", {
                get: $util.oneOfGetter($oneOfFields = ["adContextPreviewDismissed"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_sourceApp", {
                get: $util.oneOfGetter($oneOfFields = ["sourceApp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_automatedGreetingMessageShown", {
                get: $util.oneOfGetter($oneOfFields = ["automatedGreetingMessageShown"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_greetingMessageBody", {
                get: $util.oneOfGetter($oneOfFields = ["greetingMessageBody"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_ctaPayload", {
                get: $util.oneOfGetter($oneOfFields = ["ctaPayload"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_disableNudge", {
                get: $util.oneOfGetter($oneOfFields = ["disableNudge"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_originalImageUrl", {
                get: $util.oneOfGetter($oneOfFields = ["originalImageUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_automatedGreetingMessageCtaType", {
                get: $util.oneOfGetter($oneOfFields = ["automatedGreetingMessageCtaType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_wtwaAdFormat", {
                get: $util.oneOfGetter($oneOfFields = ["wtwaAdFormat"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ExternalAdReplyInfo.prototype, "_adType", {
                get: $util.oneOfGetter($oneOfFields = ["adType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ExternalAdReplyInfo.create = function create(properties) {
                return new ExternalAdReplyInfo(properties);
            };

            ExternalAdReplyInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    w.uint32(18).string(m.body);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(24).int32(m.mediaType);
                if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                    w.uint32(34).string(m.thumbnailUrl);
                if (m.mediaUrl != null && Object.hasOwnProperty.call(m, "mediaUrl"))
                    w.uint32(42).string(m.mediaUrl);
                if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                    w.uint32(50).bytes(m.thumbnail);
                if (m.sourceType != null && Object.hasOwnProperty.call(m, "sourceType"))
                    w.uint32(58).string(m.sourceType);
                if (m.sourceId != null && Object.hasOwnProperty.call(m, "sourceId"))
                    w.uint32(66).string(m.sourceId);
                if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                    w.uint32(74).string(m.sourceUrl);
                if (m.containsAutoReply != null && Object.hasOwnProperty.call(m, "containsAutoReply"))
                    w.uint32(80).bool(m.containsAutoReply);
                if (m.renderLargerThumbnail != null && Object.hasOwnProperty.call(m, "renderLargerThumbnail"))
                    w.uint32(88).bool(m.renderLargerThumbnail);
                if (m.showAdAttribution != null && Object.hasOwnProperty.call(m, "showAdAttribution"))
                    w.uint32(96).bool(m.showAdAttribution);
                if (m.ctwaClid != null && Object.hasOwnProperty.call(m, "ctwaClid"))
                    w.uint32(106).string(m.ctwaClid);
                if (m.ref != null && Object.hasOwnProperty.call(m, "ref"))
                    w.uint32(114).string(m.ref);
                if (m.clickToWhatsappCall != null && Object.hasOwnProperty.call(m, "clickToWhatsappCall"))
                    w.uint32(120).bool(m.clickToWhatsappCall);
                if (m.adContextPreviewDismissed != null && Object.hasOwnProperty.call(m, "adContextPreviewDismissed"))
                    w.uint32(128).bool(m.adContextPreviewDismissed);
                if (m.sourceApp != null && Object.hasOwnProperty.call(m, "sourceApp"))
                    w.uint32(138).string(m.sourceApp);
                if (m.automatedGreetingMessageShown != null && Object.hasOwnProperty.call(m, "automatedGreetingMessageShown"))
                    w.uint32(144).bool(m.automatedGreetingMessageShown);
                if (m.greetingMessageBody != null && Object.hasOwnProperty.call(m, "greetingMessageBody"))
                    w.uint32(154).string(m.greetingMessageBody);
                if (m.ctaPayload != null && Object.hasOwnProperty.call(m, "ctaPayload"))
                    w.uint32(162).string(m.ctaPayload);
                if (m.disableNudge != null && Object.hasOwnProperty.call(m, "disableNudge"))
                    w.uint32(168).bool(m.disableNudge);
                if (m.originalImageUrl != null && Object.hasOwnProperty.call(m, "originalImageUrl"))
                    w.uint32(178).string(m.originalImageUrl);
                if (m.automatedGreetingMessageCtaType != null && Object.hasOwnProperty.call(m, "automatedGreetingMessageCtaType"))
                    w.uint32(186).string(m.automatedGreetingMessageCtaType);
                if (m.wtwaAdFormat != null && Object.hasOwnProperty.call(m, "wtwaAdFormat"))
                    w.uint32(192).bool(m.wtwaAdFormat);
                if (m.adType != null && Object.hasOwnProperty.call(m, "adType"))
                    w.uint32(200).int32(m.adType);
                return w;
            };

            ExternalAdReplyInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ExternalAdReplyInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    case 2: {
                            m.body = r.string();
                            break;
                        }
                    case 3: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 4: {
                            m.thumbnailUrl = r.string();
                            break;
                        }
                    case 5: {
                            m.mediaUrl = r.string();
                            break;
                        }
                    case 6: {
                            m.thumbnail = r.bytes();
                            break;
                        }
                    case 7: {
                            m.sourceType = r.string();
                            break;
                        }
                    case 8: {
                            m.sourceId = r.string();
                            break;
                        }
                    case 9: {
                            m.sourceUrl = r.string();
                            break;
                        }
                    case 10: {
                            m.containsAutoReply = r.bool();
                            break;
                        }
                    case 11: {
                            m.renderLargerThumbnail = r.bool();
                            break;
                        }
                    case 12: {
                            m.showAdAttribution = r.bool();
                            break;
                        }
                    case 13: {
                            m.ctwaClid = r.string();
                            break;
                        }
                    case 14: {
                            m.ref = r.string();
                            break;
                        }
                    case 15: {
                            m.clickToWhatsappCall = r.bool();
                            break;
                        }
                    case 16: {
                            m.adContextPreviewDismissed = r.bool();
                            break;
                        }
                    case 17: {
                            m.sourceApp = r.string();
                            break;
                        }
                    case 18: {
                            m.automatedGreetingMessageShown = r.bool();
                            break;
                        }
                    case 19: {
                            m.greetingMessageBody = r.string();
                            break;
                        }
                    case 20: {
                            m.ctaPayload = r.string();
                            break;
                        }
                    case 21: {
                            m.disableNudge = r.bool();
                            break;
                        }
                    case 22: {
                            m.originalImageUrl = r.string();
                            break;
                        }
                    case 23: {
                            m.automatedGreetingMessageCtaType = r.string();
                            break;
                        }
                    case 24: {
                            m.wtwaAdFormat = r.bool();
                            break;
                        }
                    case 25: {
                            m.adType = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ExternalAdReplyInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.ExternalAdReplyInfo)
                    return d;
                var m = new $root.proto.ContextInfo.ExternalAdReplyInfo();
                if (d.title != null) {
                    m.title = String(d.title);
                }
                if (d.body != null) {
                    m.body = String(d.body);
                }
                switch (d.mediaType) {
                default:
                    if (typeof d.mediaType === "number") {
                        m.mediaType = d.mediaType;
                        break;
                    }
                    break;
                case "NONE":
                case 0:
                    m.mediaType = 0;
                    break;
                case "IMAGE":
                case 1:
                    m.mediaType = 1;
                    break;
                case "VIDEO":
                case 2:
                    m.mediaType = 2;
                    break;
                }
                if (d.thumbnailUrl != null) {
                    m.thumbnailUrl = String(d.thumbnailUrl);
                }
                if (d.mediaUrl != null) {
                    m.mediaUrl = String(d.mediaUrl);
                }
                if (d.thumbnail != null) {
                    if (typeof d.thumbnail === "string")
                        $util.base64.decode(d.thumbnail, m.thumbnail = $util.newBuffer($util.base64.length(d.thumbnail)), 0);
                    else if (d.thumbnail.length >= 0)
                        m.thumbnail = d.thumbnail;
                }
                if (d.sourceType != null) {
                    m.sourceType = String(d.sourceType);
                }
                if (d.sourceId != null) {
                    m.sourceId = String(d.sourceId);
                }
                if (d.sourceUrl != null) {
                    m.sourceUrl = String(d.sourceUrl);
                }
                if (d.containsAutoReply != null) {
                    m.containsAutoReply = Boolean(d.containsAutoReply);
                }
                if (d.renderLargerThumbnail != null) {
                    m.renderLargerThumbnail = Boolean(d.renderLargerThumbnail);
                }
                if (d.showAdAttribution != null) {
                    m.showAdAttribution = Boolean(d.showAdAttribution);
                }
                if (d.ctwaClid != null) {
                    m.ctwaClid = String(d.ctwaClid);
                }
                if (d.ref != null) {
                    m.ref = String(d.ref);
                }
                if (d.clickToWhatsappCall != null) {
                    m.clickToWhatsappCall = Boolean(d.clickToWhatsappCall);
                }
                if (d.adContextPreviewDismissed != null) {
                    m.adContextPreviewDismissed = Boolean(d.adContextPreviewDismissed);
                }
                if (d.sourceApp != null) {
                    m.sourceApp = String(d.sourceApp);
                }
                if (d.automatedGreetingMessageShown != null) {
                    m.automatedGreetingMessageShown = Boolean(d.automatedGreetingMessageShown);
                }
                if (d.greetingMessageBody != null) {
                    m.greetingMessageBody = String(d.greetingMessageBody);
                }
                if (d.ctaPayload != null) {
                    m.ctaPayload = String(d.ctaPayload);
                }
                if (d.disableNudge != null) {
                    m.disableNudge = Boolean(d.disableNudge);
                }
                if (d.originalImageUrl != null) {
                    m.originalImageUrl = String(d.originalImageUrl);
                }
                if (d.automatedGreetingMessageCtaType != null) {
                    m.automatedGreetingMessageCtaType = String(d.automatedGreetingMessageCtaType);
                }
                if (d.wtwaAdFormat != null) {
                    m.wtwaAdFormat = Boolean(d.wtwaAdFormat);
                }
                switch (d.adType) {
                default:
                    if (typeof d.adType === "number") {
                        m.adType = d.adType;
                        break;
                    }
                    break;
                case "CTWA":
                case 0:
                    m.adType = 0;
                    break;
                case "CAWC":
                case 1:
                    m.adType = 1;
                    break;
                }
                return m;
            };

            ExternalAdReplyInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.title != null && m.hasOwnProperty("title")) {
                    d.title = m.title;
                    if (o.oneofs)
                        d._title = "title";
                }
                if (m.body != null && m.hasOwnProperty("body")) {
                    d.body = m.body;
                    if (o.oneofs)
                        d._body = "body";
                }
                if (m.mediaType != null && m.hasOwnProperty("mediaType")) {
                    d.mediaType = o.enums === String ? $root.proto.ContextInfo.ExternalAdReplyInfo.MediaType[m.mediaType] === undefined ? m.mediaType : $root.proto.ContextInfo.ExternalAdReplyInfo.MediaType[m.mediaType] : m.mediaType;
                    if (o.oneofs)
                        d._mediaType = "mediaType";
                }
                if (m.thumbnailUrl != null && m.hasOwnProperty("thumbnailUrl")) {
                    d.thumbnailUrl = m.thumbnailUrl;
                    if (o.oneofs)
                        d._thumbnailUrl = "thumbnailUrl";
                }
                if (m.mediaUrl != null && m.hasOwnProperty("mediaUrl")) {
                    d.mediaUrl = m.mediaUrl;
                    if (o.oneofs)
                        d._mediaUrl = "mediaUrl";
                }
                if (m.thumbnail != null && m.hasOwnProperty("thumbnail")) {
                    d.thumbnail = o.bytes === String ? $util.base64.encode(m.thumbnail, 0, m.thumbnail.length) : o.bytes === Array ? Array.prototype.slice.call(m.thumbnail) : m.thumbnail;
                    if (o.oneofs)
                        d._thumbnail = "thumbnail";
                }
                if (m.sourceType != null && m.hasOwnProperty("sourceType")) {
                    d.sourceType = m.sourceType;
                    if (o.oneofs)
                        d._sourceType = "sourceType";
                }
                if (m.sourceId != null && m.hasOwnProperty("sourceId")) {
                    d.sourceId = m.sourceId;
                    if (o.oneofs)
                        d._sourceId = "sourceId";
                }
                if (m.sourceUrl != null && m.hasOwnProperty("sourceUrl")) {
                    d.sourceUrl = m.sourceUrl;
                    if (o.oneofs)
                        d._sourceUrl = "sourceUrl";
                }
                if (m.containsAutoReply != null && m.hasOwnProperty("containsAutoReply")) {
                    d.containsAutoReply = m.containsAutoReply;
                    if (o.oneofs)
                        d._containsAutoReply = "containsAutoReply";
                }
                if (m.renderLargerThumbnail != null && m.hasOwnProperty("renderLargerThumbnail")) {
                    d.renderLargerThumbnail = m.renderLargerThumbnail;
                    if (o.oneofs)
                        d._renderLargerThumbnail = "renderLargerThumbnail";
                }
                if (m.showAdAttribution != null && m.hasOwnProperty("showAdAttribution")) {
                    d.showAdAttribution = m.showAdAttribution;
                    if (o.oneofs)
                        d._showAdAttribution = "showAdAttribution";
                }
                if (m.ctwaClid != null && m.hasOwnProperty("ctwaClid")) {
                    d.ctwaClid = m.ctwaClid;
                    if (o.oneofs)
                        d._ctwaClid = "ctwaClid";
                }
                if (m.ref != null && m.hasOwnProperty("ref")) {
                    d.ref = m.ref;
                    if (o.oneofs)
                        d._ref = "ref";
                }
                if (m.clickToWhatsappCall != null && m.hasOwnProperty("clickToWhatsappCall")) {
                    d.clickToWhatsappCall = m.clickToWhatsappCall;
                    if (o.oneofs)
                        d._clickToWhatsappCall = "clickToWhatsappCall";
                }
                if (m.adContextPreviewDismissed != null && m.hasOwnProperty("adContextPreviewDismissed")) {
                    d.adContextPreviewDismissed = m.adContextPreviewDismissed;
                    if (o.oneofs)
                        d._adContextPreviewDismissed = "adContextPreviewDismissed";
                }
                if (m.sourceApp != null && m.hasOwnProperty("sourceApp")) {
                    d.sourceApp = m.sourceApp;
                    if (o.oneofs)
                        d._sourceApp = "sourceApp";
                }
                if (m.automatedGreetingMessageShown != null && m.hasOwnProperty("automatedGreetingMessageShown")) {
                    d.automatedGreetingMessageShown = m.automatedGreetingMessageShown;
                    if (o.oneofs)
                        d._automatedGreetingMessageShown = "automatedGreetingMessageShown";
                }
                if (m.greetingMessageBody != null && m.hasOwnProperty("greetingMessageBody")) {
                    d.greetingMessageBody = m.greetingMessageBody;
                    if (o.oneofs)
                        d._greetingMessageBody = "greetingMessageBody";
                }
                if (m.ctaPayload != null && m.hasOwnProperty("ctaPayload")) {
                    d.ctaPayload = m.ctaPayload;
                    if (o.oneofs)
                        d._ctaPayload = "ctaPayload";
                }
                if (m.disableNudge != null && m.hasOwnProperty("disableNudge")) {
                    d.disableNudge = m.disableNudge;
                    if (o.oneofs)
                        d._disableNudge = "disableNudge";
                }
                if (m.originalImageUrl != null && m.hasOwnProperty("originalImageUrl")) {
                    d.originalImageUrl = m.originalImageUrl;
                    if (o.oneofs)
                        d._originalImageUrl = "originalImageUrl";
                }
                if (m.automatedGreetingMessageCtaType != null && m.hasOwnProperty("automatedGreetingMessageCtaType")) {
                    d.automatedGreetingMessageCtaType = m.automatedGreetingMessageCtaType;
                    if (o.oneofs)
                        d._automatedGreetingMessageCtaType = "automatedGreetingMessageCtaType";
                }
                if (m.wtwaAdFormat != null && m.hasOwnProperty("wtwaAdFormat")) {
                    d.wtwaAdFormat = m.wtwaAdFormat;
                    if (o.oneofs)
                        d._wtwaAdFormat = "wtwaAdFormat";
                }
                if (m.adType != null && m.hasOwnProperty("adType")) {
                    d.adType = o.enums === String ? $root.proto.ContextInfo.ExternalAdReplyInfo.AdType[m.adType] === undefined ? m.adType : $root.proto.ContextInfo.ExternalAdReplyInfo.AdType[m.adType] : m.adType;
                    if (o.oneofs)
                        d._adType = "adType";
                }
                return d;
            };

            ExternalAdReplyInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            ExternalAdReplyInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.ExternalAdReplyInfo";
            };

            ExternalAdReplyInfo.AdType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "CTWA"] = 0;
                values[valuesById[1] = "CAWC"] = 1;
                return values;
            })();

            ExternalAdReplyInfo.MediaType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return ExternalAdReplyInfo;
        })();

        ContextInfo.FeatureEligibilities = (function() {

            function FeatureEligibilities(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            FeatureEligibilities.prototype.cannotBeReactedTo = null;
            FeatureEligibilities.prototype.cannotBeRanked = null;
            FeatureEligibilities.prototype.canRequestFeedback = null;
            FeatureEligibilities.prototype.canBeReshared = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(FeatureEligibilities.prototype, "_cannotBeReactedTo", {
                get: $util.oneOfGetter($oneOfFields = ["cannotBeReactedTo"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(FeatureEligibilities.prototype, "_cannotBeRanked", {
                get: $util.oneOfGetter($oneOfFields = ["cannotBeRanked"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(FeatureEligibilities.prototype, "_canRequestFeedback", {
                get: $util.oneOfGetter($oneOfFields = ["canRequestFeedback"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(FeatureEligibilities.prototype, "_canBeReshared", {
                get: $util.oneOfGetter($oneOfFields = ["canBeReshared"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            FeatureEligibilities.create = function create(properties) {
                return new FeatureEligibilities(properties);
            };

            FeatureEligibilities.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.cannotBeReactedTo != null && Object.hasOwnProperty.call(m, "cannotBeReactedTo"))
                    w.uint32(8).bool(m.cannotBeReactedTo);
                if (m.cannotBeRanked != null && Object.hasOwnProperty.call(m, "cannotBeRanked"))
                    w.uint32(16).bool(m.cannotBeRanked);
                if (m.canRequestFeedback != null && Object.hasOwnProperty.call(m, "canRequestFeedback"))
                    w.uint32(24).bool(m.canRequestFeedback);
                if (m.canBeReshared != null && Object.hasOwnProperty.call(m, "canBeReshared"))
                    w.uint32(32).bool(m.canBeReshared);
                return w;
            };

            FeatureEligibilities.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.FeatureEligibilities();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.cannotBeReactedTo = r.bool();
                            break;
                        }
                    case 2: {
                            m.cannotBeRanked = r.bool();
                            break;
                        }
                    case 3: {
                            m.canRequestFeedback = r.bool();
                            break;
                        }
                    case 4: {
                            m.canBeReshared = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            FeatureEligibilities.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.FeatureEligibilities)
                    return d;
                var m = new $root.proto.ContextInfo.FeatureEligibilities();
                if (d.cannotBeReactedTo != null) {
                    m.cannotBeReactedTo = Boolean(d.cannotBeReactedTo);
                }
                if (d.cannotBeRanked != null) {
                    m.cannotBeRanked = Boolean(d.cannotBeRanked);
                }
                if (d.canRequestFeedback != null) {
                    m.canRequestFeedback = Boolean(d.canRequestFeedback);
                }
                if (d.canBeReshared != null) {
                    m.canBeReshared = Boolean(d.canBeReshared);
                }
                return m;
            };

            FeatureEligibilities.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.cannotBeReactedTo != null && m.hasOwnProperty("cannotBeReactedTo")) {
                    d.cannotBeReactedTo = m.cannotBeReactedTo;
                    if (o.oneofs)
                        d._cannotBeReactedTo = "cannotBeReactedTo";
                }
                if (m.cannotBeRanked != null && m.hasOwnProperty("cannotBeRanked")) {
                    d.cannotBeRanked = m.cannotBeRanked;
                    if (o.oneofs)
                        d._cannotBeRanked = "cannotBeRanked";
                }
                if (m.canRequestFeedback != null && m.hasOwnProperty("canRequestFeedback")) {
                    d.canRequestFeedback = m.canRequestFeedback;
                    if (o.oneofs)
                        d._canRequestFeedback = "canRequestFeedback";
                }
                if (m.canBeReshared != null && m.hasOwnProperty("canBeReshared")) {
                    d.canBeReshared = m.canBeReshared;
                    if (o.oneofs)
                        d._canBeReshared = "canBeReshared";
                }
                return d;
            };

            FeatureEligibilities.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            FeatureEligibilities.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.FeatureEligibilities";
            };

            return FeatureEligibilities;
        })();

        ContextInfo.ForwardedAIBotMessageInfo = (function() {

            function ForwardedAIBotMessageInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ForwardedAIBotMessageInfo.prototype.botName = null;
            ForwardedAIBotMessageInfo.prototype.botJid = null;
            ForwardedAIBotMessageInfo.prototype.creatorName = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedAIBotMessageInfo.prototype, "_botName", {
                get: $util.oneOfGetter($oneOfFields = ["botName"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedAIBotMessageInfo.prototype, "_botJid", {
                get: $util.oneOfGetter($oneOfFields = ["botJid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedAIBotMessageInfo.prototype, "_creatorName", {
                get: $util.oneOfGetter($oneOfFields = ["creatorName"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ForwardedAIBotMessageInfo.create = function create(properties) {
                return new ForwardedAIBotMessageInfo(properties);
            };

            ForwardedAIBotMessageInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.botName != null && Object.hasOwnProperty.call(m, "botName"))
                    w.uint32(10).string(m.botName);
                if (m.botJid != null && Object.hasOwnProperty.call(m, "botJid"))
                    w.uint32(18).string(m.botJid);
                if (m.creatorName != null && Object.hasOwnProperty.call(m, "creatorName"))
                    w.uint32(26).string(m.creatorName);
                return w;
            };

            ForwardedAIBotMessageInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ForwardedAIBotMessageInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.botName = r.string();
                            break;
                        }
                    case 2: {
                            m.botJid = r.string();
                            break;
                        }
                    case 3: {
                            m.creatorName = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ForwardedAIBotMessageInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.ForwardedAIBotMessageInfo)
                    return d;
                var m = new $root.proto.ContextInfo.ForwardedAIBotMessageInfo();
                if (d.botName != null) {
                    m.botName = String(d.botName);
                }
                if (d.botJid != null) {
                    m.botJid = String(d.botJid);
                }
                if (d.creatorName != null) {
                    m.creatorName = String(d.creatorName);
                }
                return m;
            };

            ForwardedAIBotMessageInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.botName != null && m.hasOwnProperty("botName")) {
                    d.botName = m.botName;
                    if (o.oneofs)
                        d._botName = "botName";
                }
                if (m.botJid != null && m.hasOwnProperty("botJid")) {
                    d.botJid = m.botJid;
                    if (o.oneofs)
                        d._botJid = "botJid";
                }
                if (m.creatorName != null && m.hasOwnProperty("creatorName")) {
                    d.creatorName = m.creatorName;
                    if (o.oneofs)
                        d._creatorName = "creatorName";
                }
                return d;
            };

            ForwardedAIBotMessageInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            ForwardedAIBotMessageInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.ForwardedAIBotMessageInfo";
            };

            return ForwardedAIBotMessageInfo;
        })();

        ContextInfo.ForwardedNewsletterMessageInfo = (function() {

            function ForwardedNewsletterMessageInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ForwardedNewsletterMessageInfo.prototype.newsletterJid = null;
            ForwardedNewsletterMessageInfo.prototype.serverMessageId = null;
            ForwardedNewsletterMessageInfo.prototype.newsletterName = null;
            ForwardedNewsletterMessageInfo.prototype.contentType = null;
            ForwardedNewsletterMessageInfo.prototype.accessibilityText = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedNewsletterMessageInfo.prototype, "_newsletterJid", {
                get: $util.oneOfGetter($oneOfFields = ["newsletterJid"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedNewsletterMessageInfo.prototype, "_serverMessageId", {
                get: $util.oneOfGetter($oneOfFields = ["serverMessageId"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedNewsletterMessageInfo.prototype, "_newsletterName", {
                get: $util.oneOfGetter($oneOfFields = ["newsletterName"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedNewsletterMessageInfo.prototype, "_contentType", {
                get: $util.oneOfGetter($oneOfFields = ["contentType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(ForwardedNewsletterMessageInfo.prototype, "_accessibilityText", {
                get: $util.oneOfGetter($oneOfFields = ["accessibilityText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ForwardedNewsletterMessageInfo.create = function create(properties) {
                return new ForwardedNewsletterMessageInfo(properties);
            };

            ForwardedNewsletterMessageInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.newsletterJid != null && Object.hasOwnProperty.call(m, "newsletterJid"))
                    w.uint32(10).string(m.newsletterJid);
                if (m.serverMessageId != null && Object.hasOwnProperty.call(m, "serverMessageId"))
                    w.uint32(16).int32(m.serverMessageId);
                if (m.newsletterName != null && Object.hasOwnProperty.call(m, "newsletterName"))
                    w.uint32(26).string(m.newsletterName);
                if (m.contentType != null && Object.hasOwnProperty.call(m, "contentType"))
                    w.uint32(32).int32(m.contentType);
                if (m.accessibilityText != null && Object.hasOwnProperty.call(m, "accessibilityText"))
                    w.uint32(42).string(m.accessibilityText);
                return w;
            };

            ForwardedNewsletterMessageInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ForwardedNewsletterMessageInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.newsletterJid = r.string();
                            break;
                        }
                    case 2: {
                            m.serverMessageId = r.int32();
                            break;
                        }
                    case 3: {
                            m.newsletterName = r.string();
                            break;
                        }
                    case 4: {
                            m.contentType = r.int32();
                            break;
                        }
                    case 5: {
                            m.accessibilityText = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ForwardedNewsletterMessageInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.ForwardedNewsletterMessageInfo)
                    return d;
                var m = new $root.proto.ContextInfo.ForwardedNewsletterMessageInfo();
                if (d.newsletterJid != null) {
                    m.newsletterJid = String(d.newsletterJid);
                }
                if (d.serverMessageId != null) {
                    m.serverMessageId = d.serverMessageId | 0;
                }
                if (d.newsletterName != null) {
                    m.newsletterName = String(d.newsletterName);
                }
                switch (d.contentType) {
                default:
                    if (typeof d.contentType === "number") {
                        m.contentType = d.contentType;
                        break;
                    }
                    break;
                case "UPDATE":
                case 1:
                    m.contentType = 1;
                    break;
                case "UPDATE_CARD":
                case 2:
                    m.contentType = 2;
                    break;
                case "LINK_CARD":
                case 3:
                    m.contentType = 3;
                    break;
                }
                if (d.accessibilityText != null) {
                    m.accessibilityText = String(d.accessibilityText);
                }
                return m;
            };

            ForwardedNewsletterMessageInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.newsletterJid != null && m.hasOwnProperty("newsletterJid")) {
                    d.newsletterJid = m.newsletterJid;
                    if (o.oneofs)
                        d._newsletterJid = "newsletterJid";
                }
                if (m.serverMessageId != null && m.hasOwnProperty("serverMessageId")) {
                    d.serverMessageId = m.serverMessageId;
                    if (o.oneofs)
                        d._serverMessageId = "serverMessageId";
                }
                if (m.newsletterName != null && m.hasOwnProperty("newsletterName")) {
                    d.newsletterName = m.newsletterName;
                    if (o.oneofs)
                        d._newsletterName = "newsletterName";
                }
                if (m.contentType != null && m.hasOwnProperty("contentType")) {
                    d.contentType = o.enums === String ? $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.ContentType[m.contentType] === undefined ? m.contentType : $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.ContentType[m.contentType] : m.contentType;
                    if (o.oneofs)
                        d._contentType = "contentType";
                }
                if (m.accessibilityText != null && m.hasOwnProperty("accessibilityText")) {
                    d.accessibilityText = m.accessibilityText;
                    if (o.oneofs)
                        d._accessibilityText = "accessibilityText";
                }
                return d;
            };

            ForwardedNewsletterMessageInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            ForwardedNewsletterMessageInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.ForwardedNewsletterMessageInfo";
            };

            ForwardedNewsletterMessageInfo.ContentType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "UPDATE"] = 1;
                values[valuesById[2] = "UPDATE_CARD"] = 2;
                values[valuesById[3] = "LINK_CARD"] = 3;
                return values;
            })();

            return ForwardedNewsletterMessageInfo;
        })();

        ContextInfo.PairedMediaType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NOT_PAIRED_MEDIA"] = 0;
            values[valuesById[1] = "SD_VIDEO_PARENT"] = 1;
            values[valuesById[2] = "HD_VIDEO_CHILD"] = 2;
            values[valuesById[3] = "SD_IMAGE_PARENT"] = 3;
            values[valuesById[4] = "HD_IMAGE_CHILD"] = 4;
            values[valuesById[5] = "MOTION_PHOTO_PARENT"] = 5;
            values[valuesById[6] = "MOTION_PHOTO_CHILD"] = 6;
            return values;
        })();

        ContextInfo.StatusAttributionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "RESHARED_FROM_MENTION"] = 1;
            values[valuesById[2] = "RESHARED_FROM_POST"] = 2;
            return values;
        })();

        ContextInfo.StatusSourceType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "IMAGE"] = 0;
            values[valuesById[1] = "VIDEO"] = 1;
            values[valuesById[2] = "GIF"] = 2;
            values[valuesById[3] = "AUDIO"] = 3;
            values[valuesById[4] = "TEXT"] = 4;
            values[valuesById[5] = "MUSIC_STANDALONE"] = 5;
            return values;
        })();

        ContextInfo.UTMInfo = (function() {

            function UTMInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            UTMInfo.prototype.utmSource = null;
            UTMInfo.prototype.utmCampaign = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UTMInfo.prototype, "_utmSource", {
                get: $util.oneOfGetter($oneOfFields = ["utmSource"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(UTMInfo.prototype, "_utmCampaign", {
                get: $util.oneOfGetter($oneOfFields = ["utmCampaign"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            UTMInfo.create = function create(properties) {
                return new UTMInfo(properties);
            };

            UTMInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.utmSource != null && Object.hasOwnProperty.call(m, "utmSource"))
                    w.uint32(10).string(m.utmSource);
                if (m.utmCampaign != null && Object.hasOwnProperty.call(m, "utmCampaign"))
                    w.uint32(18).string(m.utmCampaign);
                return w;
            };

            UTMInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.UTMInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.utmSource = r.string();
                            break;
                        }
                    case 2: {
                            m.utmCampaign = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            UTMInfo.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.ContextInfo.UTMInfo)
                    return d;
                var m = new $root.proto.ContextInfo.UTMInfo();
                if (d.utmSource != null) {
                    m.utmSource = String(d.utmSource);
                }
                if (d.utmCampaign != null) {
                    m.utmCampaign = String(d.utmCampaign);
                }
                return m;
            };

            UTMInfo.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.utmSource != null && m.hasOwnProperty("utmSource")) {
                    d.utmSource = m.utmSource;
                    if (o.oneofs)
                        d._utmSource = "utmSource";
                }
                if (m.utmCampaign != null && m.hasOwnProperty("utmCampaign")) {
                    d.utmCampaign = m.utmCampaign;
                    if (o.oneofs)
                        d._utmCampaign = "utmCampaign";
                }
                return d;
            };

            UTMInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            UTMInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.UTMInfo";
            };

            return UTMInfo;
        })();

        return ContextInfo;
    })();

    proto.Conversation = (function() {

        function Conversation(p) {
            this.messages = [];
            this.participant = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Conversation.prototype.id = "";
        Conversation.prototype.messages = $util.emptyArray;
        Conversation.prototype.newJid = null;
        Conversation.prototype.oldJid = null;
        Conversation.prototype.lastMsgTimestamp = null;
        Conversation.prototype.unreadCount = null;
        Conversation.prototype.readOnly = null;
        Conversation.prototype.endOfHistoryTransfer = null;
        Conversation.prototype.ephemeralExpiration = null;
        Conversation.prototype.ephemeralSettingTimestamp = null;
        Conversation.prototype.endOfHistoryTransferType = null;
        Conversation.prototype.conversationTimestamp = null;
        Conversation.prototype.name = null;
        Conversation.prototype.pHash = null;
        Conversation.prototype.notSpam = null;
        Conversation.prototype.archived = null;
        Conversation.prototype.disappearingMode = null;
        Conversation.prototype.unreadMentionCount = null;
        Conversation.prototype.markedAsUnread = null;
        Conversation.prototype.participant = $util.emptyArray;
        Conversation.prototype.tcToken = null;
        Conversation.prototype.tcTokenTimestamp = null;
        Conversation.prototype.contactPrimaryIdentityKey = null;
        Conversation.prototype.pinned = null;
        Conversation.prototype.muteEndTime = null;
        Conversation.prototype.wallpaper = null;
        Conversation.prototype.mediaVisibility = null;
        Conversation.prototype.tcTokenSenderTimestamp = null;
        Conversation.prototype.suspended = null;
        Conversation.prototype.terminated = null;
        Conversation.prototype.createdAt = null;
        Conversation.prototype.createdBy = null;
        Conversation.prototype.description = null;
        Conversation.prototype.support = null;
        Conversation.prototype.isParentGroup = null;
        Conversation.prototype.parentGroupId = null;
        Conversation.prototype.isDefaultSubgroup = null;
        Conversation.prototype.displayName = null;
        Conversation.prototype.pnJid = null;
        Conversation.prototype.shareOwnPn = null;
        Conversation.prototype.pnhDuplicateLidThread = null;
        Conversation.prototype.lidJid = null;
        Conversation.prototype.username = null;
        Conversation.prototype.lidOriginType = null;
        Conversation.prototype.commentsCount = null;
        Conversation.prototype.locked = null;
        Conversation.prototype.systemMessageToInsert = null;
        Conversation.prototype.capiCreatedGroup = null;
        Conversation.prototype.accountLid = null;
        Conversation.prototype.limitSharing = null;
        Conversation.prototype.limitSharingSettingTimestamp = null;
        Conversation.prototype.limitSharingTrigger = null;
        Conversation.prototype.limitSharingInitiatedByMe = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_newJid", {
            get: $util.oneOfGetter($oneOfFields = ["newJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_oldJid", {
            get: $util.oneOfGetter($oneOfFields = ["oldJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_lastMsgTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["lastMsgTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_unreadCount", {
            get: $util.oneOfGetter($oneOfFields = ["unreadCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_readOnly", {
            get: $util.oneOfGetter($oneOfFields = ["readOnly"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_endOfHistoryTransfer", {
            get: $util.oneOfGetter($oneOfFields = ["endOfHistoryTransfer"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_ephemeralExpiration", {
            get: $util.oneOfGetter($oneOfFields = ["ephemeralExpiration"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_ephemeralSettingTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["ephemeralSettingTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_endOfHistoryTransferType", {
            get: $util.oneOfGetter($oneOfFields = ["endOfHistoryTransferType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_conversationTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["conversationTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_name", {
            get: $util.oneOfGetter($oneOfFields = ["name"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_pHash", {
            get: $util.oneOfGetter($oneOfFields = ["pHash"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_notSpam", {
            get: $util.oneOfGetter($oneOfFields = ["notSpam"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_archived", {
            get: $util.oneOfGetter($oneOfFields = ["archived"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_disappearingMode", {
            get: $util.oneOfGetter($oneOfFields = ["disappearingMode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_unreadMentionCount", {
            get: $util.oneOfGetter($oneOfFields = ["unreadMentionCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_markedAsUnread", {
            get: $util.oneOfGetter($oneOfFields = ["markedAsUnread"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_tcToken", {
            get: $util.oneOfGetter($oneOfFields = ["tcToken"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_tcTokenTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["tcTokenTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_contactPrimaryIdentityKey", {
            get: $util.oneOfGetter($oneOfFields = ["contactPrimaryIdentityKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_pinned", {
            get: $util.oneOfGetter($oneOfFields = ["pinned"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_muteEndTime", {
            get: $util.oneOfGetter($oneOfFields = ["muteEndTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_wallpaper", {
            get: $util.oneOfGetter($oneOfFields = ["wallpaper"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_mediaVisibility", {
            get: $util.oneOfGetter($oneOfFields = ["mediaVisibility"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_tcTokenSenderTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["tcTokenSenderTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_suspended", {
            get: $util.oneOfGetter($oneOfFields = ["suspended"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_terminated", {
            get: $util.oneOfGetter($oneOfFields = ["terminated"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_createdAt", {
            get: $util.oneOfGetter($oneOfFields = ["createdAt"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_createdBy", {
            get: $util.oneOfGetter($oneOfFields = ["createdBy"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_description", {
            get: $util.oneOfGetter($oneOfFields = ["description"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_support", {
            get: $util.oneOfGetter($oneOfFields = ["support"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_isParentGroup", {
            get: $util.oneOfGetter($oneOfFields = ["isParentGroup"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_parentGroupId", {
            get: $util.oneOfGetter($oneOfFields = ["parentGroupId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_isDefaultSubgroup", {
            get: $util.oneOfGetter($oneOfFields = ["isDefaultSubgroup"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_displayName", {
            get: $util.oneOfGetter($oneOfFields = ["displayName"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_pnJid", {
            get: $util.oneOfGetter($oneOfFields = ["pnJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_shareOwnPn", {
            get: $util.oneOfGetter($oneOfFields = ["shareOwnPn"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_pnhDuplicateLidThread", {
            get: $util.oneOfGetter($oneOfFields = ["pnhDuplicateLidThread"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_lidJid", {
            get: $util.oneOfGetter($oneOfFields = ["lidJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_username", {
            get: $util.oneOfGetter($oneOfFields = ["username"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_lidOriginType", {
            get: $util.oneOfGetter($oneOfFields = ["lidOriginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_commentsCount", {
            get: $util.oneOfGetter($oneOfFields = ["commentsCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_locked", {
            get: $util.oneOfGetter($oneOfFields = ["locked"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_systemMessageToInsert", {
            get: $util.oneOfGetter($oneOfFields = ["systemMessageToInsert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_capiCreatedGroup", {
            get: $util.oneOfGetter($oneOfFields = ["capiCreatedGroup"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_accountLid", {
            get: $util.oneOfGetter($oneOfFields = ["accountLid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_limitSharing", {
            get: $util.oneOfGetter($oneOfFields = ["limitSharing"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_limitSharingSettingTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["limitSharingSettingTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_limitSharingTrigger", {
            get: $util.oneOfGetter($oneOfFields = ["limitSharingTrigger"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Conversation.prototype, "_limitSharingInitiatedByMe", {
            get: $util.oneOfGetter($oneOfFields = ["limitSharingInitiatedByMe"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        Conversation.create = function create(properties) {
            return new Conversation(properties);
        };

        Conversation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                w.uint32(10).string(m.id);
            if (m.messages != null && m.messages.length) {
                for (var i = 0; i < m.messages.length; ++i)
                    $root.proto.HistorySyncMsg.encode(m.messages[i], w.uint32(18).fork()).ldelim();
            }
            if (m.newJid != null && Object.hasOwnProperty.call(m, "newJid"))
                w.uint32(26).string(m.newJid);
            if (m.oldJid != null && Object.hasOwnProperty.call(m, "oldJid"))
                w.uint32(34).string(m.oldJid);
            if (m.lastMsgTimestamp != null && Object.hasOwnProperty.call(m, "lastMsgTimestamp"))
                w.uint32(40).uint64(m.lastMsgTimestamp);
            if (m.unreadCount != null && Object.hasOwnProperty.call(m, "unreadCount"))
                w.uint32(48).uint32(m.unreadCount);
            if (m.readOnly != null && Object.hasOwnProperty.call(m, "readOnly"))
                w.uint32(56).bool(m.readOnly);
            if (m.endOfHistoryTransfer != null && Object.hasOwnProperty.call(m, "endOfHistoryTransfer"))
                w.uint32(64).bool(m.endOfHistoryTransfer);
            if (m.ephemeralExpiration != null && Object.hasOwnProperty.call(m, "ephemeralExpiration"))
                w.uint32(72).uint32(m.ephemeralExpiration);
            if (m.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(m, "ephemeralSettingTimestamp"))
                w.uint32(80).int64(m.ephemeralSettingTimestamp);
            if (m.endOfHistoryTransferType != null && Object.hasOwnProperty.call(m, "endOfHistoryTransferType"))
                w.uint32(88).int32(m.endOfHistoryTransferType);
            if (m.conversationTimestamp != null && Object.hasOwnProperty.call(m, "conversationTimestamp"))
                w.uint32(96).uint64(m.conversationTimestamp);
            if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                w.uint32(106).string(m.name);
            if (m.pHash != null && Object.hasOwnProperty.call(m, "pHash"))
                w.uint32(114).string(m.pHash);
            if (m.notSpam != null && Object.hasOwnProperty.call(m, "notSpam"))
                w.uint32(120).bool(m.notSpam);
            if (m.archived != null && Object.hasOwnProperty.call(m, "archived"))
                w.uint32(128).bool(m.archived);
            if (m.disappearingMode != null && Object.hasOwnProperty.call(m, "disappearingMode"))
                $root.proto.DisappearingMode.encode(m.disappearingMode, w.uint32(138).fork()).ldelim();
            if (m.unreadMentionCount != null && Object.hasOwnProperty.call(m, "unreadMentionCount"))
                w.uint32(144).uint32(m.unreadMentionCount);
            if (m.markedAsUnread != null && Object.hasOwnProperty.call(m, "markedAsUnread"))
                w.uint32(152).bool(m.markedAsUnread);
            if (m.participant != null && m.participant.length) {
                for (var i = 0; i < m.participant.length; ++i)
                    $root.proto.GroupParticipant.encode(m.participant[i], w.uint32(162).fork()).ldelim();
            }
            if (m.tcToken != null && Object.hasOwnProperty.call(m, "tcToken"))
                w.uint32(170).bytes(m.tcToken);
            if (m.tcTokenTimestamp != null && Object.hasOwnProperty.call(m, "tcTokenTimestamp"))
                w.uint32(176).uint64(m.tcTokenTimestamp);
            if (m.contactPrimaryIdentityKey != null && Object.hasOwnProperty.call(m, "contactPrimaryIdentityKey"))
                w.uint32(186).bytes(m.contactPrimaryIdentityKey);
            if (m.pinned != null && Object.hasOwnProperty.call(m, "pinned"))
                w.uint32(192).uint32(m.pinned);
            if (m.muteEndTime != null && Object.hasOwnProperty.call(m, "muteEndTime"))
                w.uint32(200).uint64(m.muteEndTime);
            if (m.wallpaper != null && Object.hasOwnProperty.call(m, "wallpaper"))
                $root.proto.WallpaperSettings.encode(m.wallpaper, w.uint32(210).fork()).ldelim();
            if (m.mediaVisibility != null && Object.hasOwnProperty.call(m, "mediaVisibility"))
                w.uint32(216).int32(m.mediaVisibility);
            if (m.tcTokenSenderTimestamp != null && Object.hasOwnProperty.call(m, "tcTokenSenderTimestamp"))
                w.uint32(224).uint64(m.tcTokenSenderTimestamp);
            if (m.suspended != null && Object.hasOwnProperty.call(m, "suspended"))
                w.uint32(232).bool(m.suspended);
            if (m.terminated != null && Object.hasOwnProperty.call(m, "terminated"))
                w.uint32(240).bool(m.terminated);
            if (m.createdAt != null && Object.hasOwnProperty.call(m, "createdAt"))
                w.uint32(248).uint64(m.createdAt);
            if (m.createdBy != null && Object.hasOwnProperty.call(m, "createdBy"))
                w.uint32(258).string(m.createdBy);
            if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                w.uint32(266).string(m.description);
            if (m.support != null && Object.hasOwnProperty.call(m, "support"))
                w.uint32(272).bool(m.support);
            if (m.isParentGroup != null && Object.hasOwnProperty.call(m, "isParentGroup"))
                w.uint32(280).bool(m.isParentGroup);
            if (m.isDefaultSubgroup != null && Object.hasOwnProperty.call(m, "isDefaultSubgroup"))
                w.uint32(288).bool(m.isDefaultSubgroup);
            if (m.parentGroupId != null && Object.hasOwnProperty.call(m, "parentGroupId"))
                w.uint32(298).string(m.parentGroupId);
            if (m.displayName != null && Object.hasOwnProperty.call(m, "displayName"))
                w.uint32(306).string(m.displayName);
            if (m.pnJid != null && Object.hasOwnProperty.call(m, "pnJid"))
                w.uint32(314).string(m.pnJid);
            if (m.shareOwnPn != null && Object.hasOwnProperty.call(m, "shareOwnPn"))
                w.uint32(320).bool(m.shareOwnPn);
            if (m.pnhDuplicateLidThread != null && Object.hasOwnProperty.call(m, "pnhDuplicateLidThread"))
                w.uint32(328).bool(m.pnhDuplicateLidThread);
            if (m.lidJid != null && Object.hasOwnProperty.call(m, "lidJid"))
                w.uint32(338).string(m.lidJid);
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(346).string(m.username);
            if (m.lidOriginType != null && Object.hasOwnProperty.call(m, "lidOriginType"))
                w.uint32(354).string(m.lidOriginType);
            if (m.commentsCount != null && Object.hasOwnProperty.call(m, "commentsCount"))
                w.uint32(360).uint32(m.commentsCount);
            if (m.locked != null && Object.hasOwnProperty.call(m, "locked"))
                w.uint32(368).bool(m.locked);
            if (m.systemMessageToInsert != null && Object.hasOwnProperty.call(m, "systemMessageToInsert"))
                w.uint32(376).int32(m.systemMessageToInsert);
            if (m.capiCreatedGroup != null && Object.hasOwnProperty.call(m, "capiCreatedGroup"))
                w.uint32(384).bool(m.capiCreatedGroup);
            if (m.accountLid != null && Object.hasOwnProperty.call(m, "accountLid"))
                w.uint32(394).string(m.accountLid);
            if (m.limitSharing != null && Object.hasOwnProperty.call(m, "limitSharing"))
                w.uint32(400).bool(m.limitSharing);
            if (m.limitSharingSettingTimestamp != null && Object.hasOwnProperty.call(m, "limitSharingSettingTimestamp"))
                w.uint32(408).int64(m.limitSharingSettingTimestamp);
            if (m.limitSharingTrigger != null && Object.hasOwnProperty.call(m, "limitSharingTrigger"))
                w.uint32(416).int32(m.limitSharingTrigger);
            if (m.limitSharingInitiatedByMe != null && Object.hasOwnProperty.call(m, "limitSharingInitiatedByMe"))
                w.uint32(424).bool(m.limitSharingInitiatedByMe);
            return w;
        };

        Conversation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Conversation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.id = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.messages && m.messages.length))
                            m.messages = [];
                        m.messages.push($root.proto.HistorySyncMsg.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.newJid = r.string();
                        break;
                    }
                case 4: {
                        m.oldJid = r.string();
                        break;
                    }
                case 5: {
                        m.lastMsgTimestamp = r.uint64();
                        break;
                    }
                case 6: {
                        m.unreadCount = r.uint32();
                        break;
                    }
                case 7: {
                        m.readOnly = r.bool();
                        break;
                    }
                case 8: {
                        m.endOfHistoryTransfer = r.bool();
                        break;
                    }
                case 9: {
                        m.ephemeralExpiration = r.uint32();
                        break;
                    }
                case 10: {
                        m.ephemeralSettingTimestamp = r.int64();
                        break;
                    }
                case 11: {
                        m.endOfHistoryTransferType = r.int32();
                        break;
                    }
                case 12: {
                        m.conversationTimestamp = r.uint64();
                        break;
                    }
                case 13: {
                        m.name = r.string();
                        break;
                    }
                case 14: {
                        m.pHash = r.string();
                        break;
                    }
                case 15: {
                        m.notSpam = r.bool();
                        break;
                    }
                case 16: {
                        m.archived = r.bool();
                        break;
                    }
                case 17: {
                        m.disappearingMode = $root.proto.DisappearingMode.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.unreadMentionCount = r.uint32();
                        break;
                    }
                case 19: {
                        m.markedAsUnread = r.bool();
                        break;
                    }
                case 20: {
                        if (!(m.participant && m.participant.length))
                            m.participant = [];
                        m.participant.push($root.proto.GroupParticipant.decode(r, r.uint32()));
                        break;
                    }
                case 21: {
                        m.tcToken = r.bytes();
                        break;
                    }
                case 22: {
                        m.tcTokenTimestamp = r.uint64();
                        break;
                    }
                case 23: {
                        m.contactPrimaryIdentityKey = r.bytes();
                        break;
                    }
                case 24: {
                        m.pinned = r.uint32();
                        break;
                    }
                case 25: {
                        m.muteEndTime = r.uint64();
                        break;
                    }
                case 26: {
                        m.wallpaper = $root.proto.WallpaperSettings.decode(r, r.uint32());
                        break;
                    }
                case 27: {
                        m.mediaVisibility = r.int32();
                        break;
                    }
                case 28: {
                        m.tcTokenSenderTimestamp = r.uint64();
                        break;
                    }
                case 29: {
                        m.suspended = r.bool();
                        break;
                    }
                case 30: {
                        m.terminated = r.bool();
                        break;
                    }
                case 31: {
                        m.createdAt = r.uint64();
                        break;
                    }
                case 32: {
                        m.createdBy = r.string();
                        break;
                    }
                case 33: {
                        m.description = r.string();
                        break;
                    }
                case 34: {
                        m.support = r.bool();
                        break;
                    }
                case 35: {
                        m.isParentGroup = r.bool();
                        break;
                    }
                case 37: {
                        m.parentGroupId = r.string();
                        break;
                    }
                case 36: {
                        m.isDefaultSubgroup = r.bool();
                        break;
                    }
                case 38: {
                        m.displayName = r.string();
                        break;
                    }
                case 39: {
                        m.pnJid = r.string();
                        break;
                    }
                case 40: {
                        m.shareOwnPn = r.bool();
                        break;
                    }
                case 41: {
                        m.pnhDuplicateLidThread = r.bool();
                        break;
                    }
                case 42: {
                        m.lidJid = r.string();
                        break;
                    }
                case 43: {
                        m.username = r.string();
                        break;
                    }
                case 44: {
                        m.lidOriginType = r.string();
                        break;
                    }
                case 45: {
                        m.commentsCount = r.uint32();
                        break;
                    }
                case 46: {
                        m.locked = r.bool();
                        break;
                    }
                case 47: {
                        m.systemMessageToInsert = r.int32();
                        break;
                    }
                case 48: {
                        m.capiCreatedGroup = r.bool();
                        break;
                    }
                case 49: {
                        m.accountLid = r.string();
                        break;
                    }
                case 50: {
                        m.limitSharing = r.bool();
                        break;
                    }
                case 51: {
                        m.limitSharingSettingTimestamp = r.int64();
                        break;
                    }
                case 52: {
                        m.limitSharingTrigger = r.int32();
                        break;
                    }
                case 53: {
                        m.limitSharingInitiatedByMe = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Conversation.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.Conversation)
                return d;
            var m = new $root.proto.Conversation();
            if (d.id != null) {
                m.id = String(d.id);
            }
            if (d.messages) {
                if (!Array.isArray(d.messages))
                    throw TypeError(".proto.Conversation.messages: array expected");
                m.messages = [];
                for (var i = 0; i < d.messages.length; ++i) {
                    if (typeof d.messages[i] !== "object")
                        throw TypeError(".proto.Conversation.messages: object expected");
                    m.messages[i] = $root.proto.HistorySyncMsg.fromObject(d.messages[i]);
                }
            }
            if (d.newJid != null) {
                m.newJid = String(d.newJid);
            }
            if (d.oldJid != null) {
                m.oldJid = String(d.oldJid);
            }
            if (d.lastMsgTimestamp != null) {
                if ($util.Long)
                    (m.lastMsgTimestamp = $util.Long.fromValue(d.lastMsgTimestamp)).unsigned = true;
                else if (typeof d.lastMsgTimestamp === "string")
                    m.lastMsgTimestamp = parseInt(d.lastMsgTimestamp, 10);
                else if (typeof d.lastMsgTimestamp === "number")
                    m.lastMsgTimestamp = d.lastMsgTimestamp;
                else if (typeof d.lastMsgTimestamp === "object")
                    m.lastMsgTimestamp = new $util.LongBits(d.lastMsgTimestamp.low >>> 0, d.lastMsgTimestamp.high >>> 0).toNumber(true);
            }
            if (d.unreadCount != null) {
                m.unreadCount = d.unreadCount >>> 0;
            }
            if (d.readOnly != null) {
                m.readOnly = Boolean(d.readOnly);
            }
            if (d.endOfHistoryTransfer != null) {
                m.endOfHistoryTransfer = Boolean(d.endOfHistoryTransfer);
            }
            if (d.ephemeralExpiration != null) {
                m.ephemeralExpiration = d.ephemeralExpiration >>> 0;
            }
            if (d.ephemeralSettingTimestamp != null) {
                if ($util.Long)
                    (m.ephemeralSettingTimestamp = $util.Long.fromValue(d.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof d.ephemeralSettingTimestamp === "string")
                    m.ephemeralSettingTimestamp = parseInt(d.ephemeralSettingTimestamp, 10);
                else if (typeof d.ephemeralSettingTimestamp === "number")
                    m.ephemeralSettingTimestamp = d.ephemeralSettingTimestamp;
                else if (typeof d.ephemeralSettingTimestamp === "object")
                    m.ephemeralSettingTimestamp = new $util.LongBits(d.ephemeralSettingTimestamp.low >>> 0, d.ephemeralSettingTimestamp.high >>> 0).toNumber();
            }
            switch (d.endOfHistoryTransferType) {
            default:
                if (typeof d.endOfHistoryTransferType === "number") {
                    m.endOfHistoryTransferType = d.endOfHistoryTransferType;
                    break;
                }
                break;
            case "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY":
            case 0:
                m.endOfHistoryTransferType = 0;
                break;
            case "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY":
            case 1:
                m.endOfHistoryTransferType = 1;
                break;
            case "COMPLETE_ON_DEMAND_SYNC_BUT_MORE_MSG_REMAIN_ON_PRIMARY":
            case 2:
                m.endOfHistoryTransferType = 2;
                break;
            }
            if (d.conversationTimestamp != null) {
                if ($util.Long)
                    (m.conversationTimestamp = $util.Long.fromValue(d.conversationTimestamp)).unsigned = true;
                else if (typeof d.conversationTimestamp === "string")
                    m.conversationTimestamp = parseInt(d.conversationTimestamp, 10);
                else if (typeof d.conversationTimestamp === "number")
                    m.conversationTimestamp = d.conversationTimestamp;
                else if (typeof d.conversationTimestamp === "object")
                    m.conversationTimestamp = new $util.LongBits(d.conversationTimestamp.low >>> 0, d.conversationTimestamp.high >>> 0).toNumber(true);
            }
            if (d.name != null) {
                m.name = String(d.name);
            }
            if (d.pHash != null) {
                m.pHash = String(d.pHash);
            }
            if (d.notSpam != null) {
                m.notSpam = Boolean(d.notSpam);
            }
            if (d.archived != null) {
                m.archived = Boolean(d.archived);
            }
            if (d.disappearingMode != null) {
                if (typeof d.disappearingMode !== "object")
                    throw TypeError(".proto.Conversation.disappearingMode: object expected");
                m.disappearingMode = $root.proto.DisappearingMode.fromObject(d.disappearingMode);
            }
            if (d.unreadMentionCount != null) {
                m.unreadMentionCount = d.unreadMentionCount >>> 0;
            }
            if (d.markedAsUnread != null) {
                m.markedAsUnread = Boolean(d.markedAsUnread);
            }
            if (d.participant) {
                if (!Array.isArray(d.participant))
                    throw TypeError(".proto.Conversation.participant: array expected");
                m.participant = [];
                for (var i = 0; i < d.participant.length; ++i) {
                    if (typeof d.participant[i] !== "object")
                        throw TypeError(".proto.Conversation.participant: object expected");
                    m.participant[i] = $root.proto.GroupParticipant.fromObject(d.participant[i]);
                }
            }
            if (d.tcToken != null) {
                if (typeof d.tcToken === "string")
                    $util.base64.decode(d.tcToken, m.tcToken = $util.newBuffer($util.base64.length(d.tcToken)), 0);
                else if (d.tcToken.length >= 0)
                    m.tcToken = d.tcToken;
            }
            if (d.tcTokenTimestamp != null) {
                if ($util.Long)
                    (m.tcTokenTimestamp = $util.Long.fromValue(d.tcTokenTimestamp)).unsigned = true;
                else if (typeof d.tcTokenTimestamp === "string")
                    m.tcTokenTimestamp = parseInt(d.tcTokenTimestamp, 10);
                else if (typeof d.tcTokenTimestamp === "number")
                    m.tcTokenTimestamp = d.tcTokenTimestamp;
                else if (typeof d.tcTokenTimestamp === "object")
                    m.tcTokenTimestamp = new $util.LongBits(d.tcTokenTimestamp.low >>> 0, d.tcTokenTimestamp.high >>> 0).toNumber(true);
            }
            if (d.contactPrimaryIdentityKey != null) {
                if (typeof d.contactPrimaryIdentityKey === "string")
                    $util.base64.decode(d.contactPrimaryIdentityKey, m.contactPrimaryIdentityKey = $util.newBuffer($util.base64.length(d.contactPrimaryIdentityKey)), 0);
                else if (d.contactPrimaryIdentityKey.length >= 0)
                    m.contactPrimaryIdentityKey = d.contactPrimaryIdentityKey;
            }
            if (d.pinned != null) {
                m.pinned = d.pinned >>> 0;
            }
            if (d.muteEndTime != null) {
                if ($util.Long)
                    (m.muteEndTime = $util.Long.fromValue(d.muteEndTime)).unsigned = true;
                else if (typeof d.muteEndTime === "string")
                    m.muteEndTime = parseInt(d.muteEndTime, 10);
                else if (typeof d.muteEndTime === "number")
                    m.muteEndTime = d.muteEndTime;
                else if (typeof d.muteEndTime === "object")
                    m.muteEndTime = new $util.LongBits(d.muteEndTime.low >>> 0, d.muteEndTime.high >>> 0).toNumber(true);
            }
            if (d.wallpaper != null) {
                if (typeof d.wallpaper !== "object")
                    throw TypeError(".proto.Conversation.wallpaper: object expected");
                m.wallpaper = $root.proto.WallpaperSettings.fromObject(d.wallpaper);
            }
            switch (d.mediaVisibility) {
            default:
                if (typeof d.mediaVisibility === "number") {
                    m.mediaVisibility = d.mediaVisibility;
                    break;
                }
                break;
            case "DEFAULT":
            case 0:
                m.mediaVisibility = 0;
                break;
            case "OFF":
            case 1:
                m.mediaVisibility = 1;
                break;
            case "ON":
            case 2:
                m.mediaVisibility = 2;
                break;
            }
            if (d.tcTokenSenderTimestamp != null) {
                if ($util.Long)
                    (m.tcTokenSenderTimestamp = $util.Long.fromValue(d.tcTokenSenderTimestamp)).unsigned = true;
                else if (typeof d.tcTokenSenderTimestamp === "string")
                    m.tcTokenSenderTimestamp = parseInt(d.tcTokenSenderTimestamp, 10);
                else if (typeof d.tcTokenSenderTimestamp === "number")
                    m.tcTokenSenderTimestamp = d.tcTokenSenderTimestamp;
                else if (typeof d.tcTokenSenderTimestamp === "object")
                    m.tcTokenSenderTimestamp = new $util.LongBits(d.tcTokenSenderTimestamp.low >>> 0, d.tcTokenSenderTimestamp.high >>> 0).toNumber(true);
            }
            if (d.suspended != null) {
                m.suspended = Boolean(d.suspended);
            }
            if (d.terminated != null) {
                m.terminated = Boolean(d.terminated);
            }
            if (d.createdAt != null) {
                if ($util.Long)
                    (m.createdAt = $util.Long.fromValue(d.createdAt)).unsigned = true;
                else if (typeof d.createdAt === "string")
                    m.createdAt = parseInt(d.createdAt, 10);
                else if (typeof d.createdAt === "number")
                    m.createdAt = d.createdAt;
                else if (typeof d.createdAt === "object")
                    m.createdAt = new $util.LongBits(d.createdAt.low >>> 0, d.createdAt.high >>> 0).toNumber(true);
            }
            if (d.createdBy != null) {
                m.createdBy = String(d.createdBy);
            }
            if (d.description != null) {
                m.description = String(d.description);
            }
            if (d.support != null) {
                m.support = Boolean(d.support);
            }
            if (d.isParentGroup != null) {
                m.isParentGroup = Boolean(d.isParentGroup);
            }
            if (d.parentGroupId != null) {
                m.parentGroupId = String(d.parentGroupId);
            }
            if (d.isDefaultSubgroup != null) {
                m.isDefaultSubgroup = Boolean(d.isDefaultSubgroup);
            }
            if (d.displayName != null) {
                m.displayName = String(d.displayName);
            }
            if (d.pnJid != null) {
                m.pnJid = String(d.pnJid);
            }
            if (d.shareOwnPn != null) {
                m.shareOwnPn = Boolean(d.shareOwnPn);
            }
            if (d.pnhDuplicateLidThread != null) {
                m.pnhDuplicateLidThread = Boolean(d.pnhDuplicateLidThread);
            }
            if (d.lidJid != null) {
                m.lidJid = String(d.lidJid);
            }
            if (d.username != null) {
                m.username = String(d.username);
            }
            if (d.lidOriginType != null) {
                m.lidOriginType = String(d.lidOriginType);
            }
            if (d.commentsCount != null) {
                m.commentsCount = d.commentsCount >>> 0;
            }
            if (d.locked != null) {
                m.locked = Boolean(d.locked);
            }
            switch (d.systemMessageToInsert) {
            default:
                if (typeof d.systemMessageToInsert === "number") {
                    m.systemMessageToInsert = d.systemMessageToInsert;
                    break;
                }
                break;
            case "E2EE_MSG":
            case 1:
                m.systemMessageToInsert = 1;
                break;
            case "NE2EE_SELF":
            case 2:
                m.systemMessageToInsert = 2;
                break;
            case "NE2EE_OTHER":
            case 3:
                m.systemMessageToInsert = 3;
                break;
            }
            if (d.capiCreatedGroup != null) {
                m.capiCreatedGroup = Boolean(d.capiCreatedGroup);
            }
            if (d.accountLid != null) {
                m.accountLid = String(d.accountLid);
            }
            if (d.limitSharing != null) {
                m.limitSharing = Boolean(d.limitSharing);
            }
            if (d.limitSharingSettingTimestamp != null) {
                if ($util.Long)
                    (m.limitSharingSettingTimestamp = $util.Long.fromValue(d.limitSharingSettingTimestamp)).unsigned = false;
                else if (typeof d.limitSharingSettingTimestamp === "string")
                    m.limitSharingSettingTimestamp = parseInt(d.limitSharingSettingTimestamp, 10);
                else if (typeof d.limitSharingSettingTimestamp === "number")
                    m.limitSharingSettingTimestamp = d.limitSharingSettingTimestamp;
                else if (typeof d.limitSharingSettingTimestamp === "object")
                    m.limitSharingSettingTimestamp = new $util.LongBits(d.limitSharingSettingTimestamp.low >>> 0, d.limitSharingSettingTimestamp.high >>> 0).toNumber();
            }
            switch (d.limitSharingTrigger) {
            default:
                if (typeof d.limitSharingTrigger === "number") {
                    m.limitSharingTrigger = d.limitSharingTrigger;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.limitSharingTrigger = 0;
                break;
            case "CHAT_SETTING":
            case 1:
                m.limitSharingTrigger = 1;
                break;
            case "BIZ_SUPPORTS_FB_HOSTING":
            case 2:
                m.limitSharingTrigger = 2;
                break;
            case "UNKNOWN_GROUP":
            case 3:
                m.limitSharingTrigger = 3;
                break;
            }
            if (d.limitSharingInitiatedByMe != null) {
                m.limitSharingInitiatedByMe = Boolean(d.limitSharingInitiatedByMe);
            }
            return m;
        };

        Conversation.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.messages = [];
                d.participant = [];
            }
            if (o.defaults) {
                d.id = "";
            }
            if (m.id != null && m.hasOwnProperty("id")) {
                d.id = m.id;
            }
            if (m.messages && m.messages.length) {
                d.messages = [];
                for (var j = 0; j < m.messages.length; ++j) {
                    d.messages[j] = $root.proto.HistorySyncMsg.toObject(m.messages[j], o);
                }
            }
            if (m.newJid != null && m.hasOwnProperty("newJid")) {
                d.newJid = m.newJid;
                if (o.oneofs)
                    d._newJid = "newJid";
            }
            if (m.oldJid != null && m.hasOwnProperty("oldJid")) {
                d.oldJid = m.oldJid;
                if (o.oneofs)
                    d._oldJid = "oldJid";
            }
            if (m.lastMsgTimestamp != null && m.hasOwnProperty("lastMsgTimestamp")) {
                if (typeof m.lastMsgTimestamp === "number")
                    d.lastMsgTimestamp = o.longs === String ? String(m.lastMsgTimestamp) : m.lastMsgTimestamp;
                else
                    d.lastMsgTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.lastMsgTimestamp) : o.longs === Number ? new $util.LongBits(m.lastMsgTimestamp.low >>> 0, m.lastMsgTimestamp.high >>> 0).toNumber(true) : m.lastMsgTimestamp;
                if (o.oneofs)
                    d._lastMsgTimestamp = "lastMsgTimestamp";
            }
            if (m.unreadCount != null && m.hasOwnProperty("unreadCount")) {
                d.unreadCount = m.unreadCount;
                if (o.oneofs)
                    d._unreadCount = "unreadCount";
            }
            if (m.readOnly != null && m.hasOwnProperty("readOnly")) {
                d.readOnly = m.readOnly;
                if (o.oneofs)
                    d._readOnly = "readOnly";
            }
            if (m.endOfHistoryTransfer != null && m.hasOwnProperty("endOfHistoryTransfer")) {
                d.endOfHistoryTransfer = m.endOfHistoryTransfer;
                if (o.oneofs)
                    d._endOfHistoryTransfer = "endOfHistoryTransfer";
            }
            if (m.ephemeralExpiration != null && m.hasOwnProperty("ephemeralExpiration")) {
                d.ephemeralExpiration = m.ephemeralExpiration;
                if (o.oneofs)
                    d._ephemeralExpiration = "ephemeralExpiration";
            }
            if (m.ephemeralSettingTimestamp != null && m.hasOwnProperty("ephemeralSettingTimestamp")) {
                if (typeof m.ephemeralSettingTimestamp === "number")
                    d.ephemeralSettingTimestamp = o.longs === String ? String(m.ephemeralSettingTimestamp) : m.ephemeralSettingTimestamp;
                else
                    d.ephemeralSettingTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.ephemeralSettingTimestamp) : o.longs === Number ? new $util.LongBits(m.ephemeralSettingTimestamp.low >>> 0, m.ephemeralSettingTimestamp.high >>> 0).toNumber() : m.ephemeralSettingTimestamp;
                if (o.oneofs)
                    d._ephemeralSettingTimestamp = "ephemeralSettingTimestamp";
            }
            if (m.endOfHistoryTransferType != null && m.hasOwnProperty("endOfHistoryTransferType")) {
                d.endOfHistoryTransferType = o.enums === String ? $root.proto.Conversation.EndOfHistoryTransferType[m.endOfHistoryTransferType] === undefined ? m.endOfHistoryTransferType : $root.proto.Conversation.EndOfHistoryTransferType[m.endOfHistoryTransferType] : m.endOfHistoryTransferType;
                if (o.oneofs)
                    d._endOfHistoryTransferType = "endOfHistoryTransferType";
            }
            if (m.conversationTimestamp != null && m.hasOwnProperty("conversationTimestamp")) {
                if (typeof m.conversationTimestamp === "number")
                    d.conversationTimestamp = o.longs === String ? String(m.conversationTimestamp) : m.conversationTimestamp;
                else
                    d.conversationTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.conversationTimestamp) : o.longs === Number ? new $util.LongBits(m.conversationTimestamp.low >>> 0, m.conversationTimestamp.high >>> 0).toNumber(true) : m.conversationTimestamp;
                if (o.oneofs)
                    d._conversationTimestamp = "conversationTimestamp";
            }
            if (m.name != null && m.hasOwnProperty("name")) {
                d.name = m.name;
                if (o.oneofs)
                    d._name = "name";
            }
            if (m.pHash != null && m.hasOwnProperty("pHash")) {
                d.pHash = m.pHash;
                if (o.oneofs)
                    d._pHash = "pHash";
            }
            if (m.notSpam != null && m.hasOwnProperty("notSpam")) {
                d.notSpam = m.notSpam;
                if (o.oneofs)
                    d._notSpam = "notSpam";
            }
            if (m.archived != null && m.hasOwnProperty("archived")) {
                d.archived = m.archived;
                if (o.oneofs)
                    d._archived = "archived";
            }
            if (m.disappearingMode != null && m.hasOwnProperty("disappearingMode")) {
                d.disappearingMode = $root.proto.DisappearingMode.toObject(m.disappearingMode, o);
                if (o.oneofs)
                    d._disappearingMode = "disappearingMode";
            }
            if (m.unreadMentionCount != null && m.hasOwnProperty("unreadMentionCount")) {
                d.unreadMentionCount = m.unreadMentionCount;
                if (o.oneofs)
                    d._unreadMentionCount = "unreadMentionCount";
            }
            if (m.markedAsUnread != null && m.hasOwnProperty("markedAsUnread")) {
                d.markedAsUnread = m.markedAsUnread;
                if (o.oneofs)
                    d._markedAsUnread = "markedAsUnread";
            }
            if (m.participant && m.participant.length) {
                d.participant = [];
                for (var j = 0; j < m.participant.length; ++j) {
                    d.participant[j] = $root.proto.GroupParticipant.toObject(m.participant[j], o);
                }
            }
            if (m.tcToken != null && m.hasOwnProperty("tcToken")) {
                d.tcToken = o.bytes === String ? $util.base64.encode(m.tcToken, 0, m.tcToken.length) : o.bytes === Array ? Array.prototype.slice.call(m.tcToken) : m.tcToken;
                if (o.oneofs)
                    d._tcToken = "tcToken";
            }
            if (m.tcTokenTimestamp != null && m.hasOwnProperty("tcTokenTimestamp")) {
                if (typeof m.tcTokenTimestamp === "number")
                    d.tcTokenTimestamp = o.longs === String ? String(m.tcTokenTimestamp) : m.tcTokenTimestamp;
                else
                    d.tcTokenTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.tcTokenTimestamp) : o.longs === Number ? new $util.LongBits(m.tcTokenTimestamp.low >>> 0, m.tcTokenTimestamp.high >>> 0).toNumber(true) : m.tcTokenTimestamp;
                if (o.oneofs)
                    d._tcTokenTimestamp = "tcTokenTimestamp";
            }
            if (m.contactPrimaryIdentityKey != null && m.hasOwnProperty("contactPrimaryIdentityKey")) {
                d.contactPrimaryIdentityKey = o.bytes === String ? $util.base64.encode(m.contactPrimaryIdentityKey, 0, m.contactPrimaryIdentityKey.length) : o.bytes === Array ? Array.prototype.slice.call(m.contactPrimaryIdentityKey) : m.contactPrimaryIdentityKey;
                if (o.oneofs)
                    d._contactPrimaryIdentityKey = "contactPrimaryIdentityKey";
            }
            if (m.pinned != null && m.hasOwnProperty("pinned")) {
                d.pinned = m.pinned;
                if (o.oneofs)
                    d._pinned = "pinned";
            }
            if (m.muteEndTime != null && m.hasOwnProperty("muteEndTime")) {
                if (typeof m.muteEndTime === "number")
                    d.muteEndTime = o.longs === String ? String(m.muteEndTime) : m.muteEndTime;
                else
                    d.muteEndTime = o.longs === String ? $util.Long.prototype.toString.call(m.muteEndTime) : o.longs === Number ? new $util.LongBits(m.muteEndTime.low >>> 0, m.muteEndTime.high >>> 0).toNumber(true) : m.muteEndTime;
                if (o.oneofs)
                    d._muteEndTime = "muteEndTime";
            }
            if (m.wallpaper != null && m.hasOwnProperty("wallpaper")) {
                d.wallpaper = $root.proto.WallpaperSettings.toObject(m.wallpaper, o);
                if (o.oneofs)
                    d._wallpaper = "wallpaper";
            }
            if (m.mediaVisibility != null && m.hasOwnProperty("mediaVisibility")) {
                d.mediaVisibility = o.enums === String ? $root.proto.MediaVisibility[m.mediaVisibility] === undefined ? m.mediaVisibility : $root.proto.MediaVisibility[m.mediaVisibility] : m.mediaVisibility;
                if (o.oneofs)
                    d._mediaVisibility = "mediaVisibility";
            }
            if (m.tcTokenSenderTimestamp != null && m.hasOwnProperty("tcTokenSenderTimestamp")) {
                if (typeof m.tcTokenSenderTimestamp === "number")
                    d.tcTokenSenderTimestamp = o.longs === String ? String(m.tcTokenSenderTimestamp) : m.tcTokenSenderTimestamp;
                else
                    d.tcTokenSenderTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.tcTokenSenderTimestamp) : o.longs === Number ? new $util.LongBits(m.tcTokenSenderTimestamp.low >>> 0, m.tcTokenSenderTimestamp.high >>> 0).toNumber(true) : m.tcTokenSenderTimestamp;
                if (o.oneofs)
                    d._tcTokenSenderTimestamp = "tcTokenSenderTimestamp";
            }
            if (m.suspended != null && m.hasOwnProperty("suspended")) {
                d.suspended = m.suspended;
                if (o.oneofs)
                    d._suspended = "suspended";
            }
            if (m.terminated != null && m.hasOwnProperty("terminated")) {
                d.terminated = m.terminated;
                if (o.oneofs)
                    d._terminated = "terminated";
            }
            if (m.createdAt != null && m.hasOwnProperty("createdAt")) {
                if (typeof m.createdAt === "number")
                    d.createdAt = o.longs === String ? String(m.createdAt) : m.createdAt;
                else
                    d.createdAt = o.longs === String ? $util.Long.prototype.toString.call(m.createdAt) : o.longs === Number ? new $util.LongBits(m.createdAt.low >>> 0, m.createdAt.high >>> 0).toNumber(true) : m.createdAt;
                if (o.oneofs)
                    d._createdAt = "createdAt";
            }
            if (m.createdBy != null && m.hasOwnProperty("createdBy")) {
                d.createdBy = m.createdBy;
                if (o.oneofs)
                    d._createdBy = "createdBy";
            }
            if (m.description != null && m.hasOwnProperty("description")) {
                d.description = m.description;
                if (o.oneofs)
                    d._description = "description";
            }
            if (m.support != null && m.hasOwnProperty("support")) {
                d.support = m.support;
                if (o.oneofs)
                    d._support = "support";
            }
            if (m.isParentGroup != null && m.hasOwnProperty("isParentGroup")) {
                d.isParentGroup = m.isParentGroup;
                if (o.oneofs)
                    d._isParentGroup = "isParentGroup";
            }
            if (m.isDefaultSubgroup != null && m.hasOwnProperty("isDefaultSubgroup")) {
                d.isDefaultSubgroup = m.isDefaultSubgroup;
                if (o.oneofs)
                    d._isDefaultSubgroup = "isDefaultSubgroup";
            }
            if (m.parentGroupId != null && m.hasOwnProperty("parentGroupId")) {
                d.parentGroupId = m.parentGroupId;
                if (o.oneofs)
                    d._parentGroupId = "parentGroupId";
            }
            if (m.displayName != null && m.hasOwnProperty("displayName")) {
                d.displayName = m.displayName;
                if (o.oneofs)
                    d._displayName = "displayName";
            }
            if (m.pnJid != null && m.hasOwnProperty("pnJid")) {
                d.pnJid = m.pnJid;
                if (o.oneofs)
                    d._pnJid = "pnJid";
            }
            if (m.shareOwnPn != null && m.hasOwnProperty("shareOwnPn")) {
                d.shareOwnPn = m.shareOwnPn;
                if (o.oneofs)
                    d._shareOwnPn = "shareOwnPn";
            }
            if (m.pnhDuplicateLidThread != null && m.hasOwnProperty("pnhDuplicateLidThread")) {
                d.pnhDuplicateLidThread = m.pnhDuplicateLidThread;
                if (o.oneofs)
                    d._pnhDuplicateLidThread = "pnhDuplicateLidThread";
            }
            if (m.lidJid != null && m.hasOwnProperty("lidJid")) {
                d.lidJid = m.lidJid;
                if (o.oneofs)
                    d._lidJid = "lidJid";
            }
            if (m.username != null && m.hasOwnProperty("username")) {
                d.username = m.username;
                if (o.oneofs)
                    d._username = "username";
            }
            if (m.lidOriginType != null && m.hasOwnProperty("lidOriginType")) {
                d.lidOriginType = m.lidOriginType;
                if (o.oneofs)
                    d._lidOriginType = "lidOriginType";
            }
            if (m.commentsCount != null && m.hasOwnProperty("commentsCount")) {
                d.commentsCount = m.commentsCount;
                if (o.oneofs)
                    d._commentsCount = "commentsCount";
            }
            if (m.locked != null && m.hasOwnProperty("locked")) {
                d.locked = m.locked;
                if (o.oneofs)
                    d._locked = "locked";
            }
            if (m.systemMessageToInsert != null && m.hasOwnProperty("systemMessageToInsert")) {
                d.systemMessageToInsert = o.enums === String ? $root.proto.PrivacySystemMessage[m.systemMessageToInsert] === undefined ? m.systemMessageToInsert : $root.proto.PrivacySystemMessage[m.systemMessageToInsert] : m.systemMessageToInsert;
                if (o.oneofs)
                    d._systemMessageToInsert = "systemMessageToInsert";
            }
            if (m.capiCreatedGroup != null && m.hasOwnProperty("capiCreatedGroup")) {
                d.capiCreatedGroup = m.capiCreatedGroup;
                if (o.oneofs)
                    d._capiCreatedGroup = "capiCreatedGroup";
            }
            if (m.accountLid != null && m.hasOwnProperty("accountLid")) {
                d.accountLid = m.accountLid;
                if (o.oneofs)
                    d._accountLid = "accountLid";
            }
            if (m.limitSharing != null && m.hasOwnProperty("limitSharing")) {
                d.limitSharing = m.limitSharing;
                if (o.oneofs)
                    d._limitSharing = "limitSharing";
            }
            if (m.limitSharingSettingTimestamp != null && m.hasOwnProperty("limitSharingSettingTimestamp")) {
                if (typeof m.limitSharingSettingTimestamp === "number")
                    d.limitSharingSettingTimestamp = o.longs === String ? String(m.limitSharingSettingTimestamp) : m.limitSharingSettingTimestamp;
                else
                    d.limitSharingSettingTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.limitSharingSettingTimestamp) : o.longs === Number ? new $util.LongBits(m.limitSharingSettingTimestamp.low >>> 0, m.limitSharingSettingTimestamp.high >>> 0).toNumber() : m.limitSharingSettingTimestamp;
                if (o.oneofs)
                    d._limitSharingSettingTimestamp = "limitSharingSettingTimestamp";
            }
            if (m.limitSharingTrigger != null && m.hasOwnProperty("limitSharingTrigger")) {
                d.limitSharingTrigger = o.enums === String ? $root.proto.LimitSharing.TriggerType[m.limitSharingTrigger] === undefined ? m.limitSharingTrigger : $root.proto.LimitSharing.TriggerType[m.limitSharingTrigger] : m.limitSharingTrigger;
                if (o.oneofs)
                    d._limitSharingTrigger = "limitSharingTrigger";
            }
            if (m.limitSharingInitiatedByMe != null && m.hasOwnProperty("limitSharingInitiatedByMe")) {
                d.limitSharingInitiatedByMe = m.limitSharingInitiatedByMe;
                if (o.oneofs)
                    d._limitSharingInitiatedByMe = "limitSharingInitiatedByMe";
            }
            return d;
        };

        Conversation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Conversation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Conversation";
        };

        Conversation.EndOfHistoryTransferType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY"] = 0;
            values[valuesById[1] = "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY"] = 1;
            values[valuesById[2] = "COMPLETE_ON_DEMAND_SYNC_BUT_MORE_MSG_REMAIN_ON_PRIMARY"] = 2;
            return values;
        })();

        return Conversation;
    })();

    proto.DeviceCapabilities = (function() {

        function DeviceCapabilities(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceCapabilities.prototype.chatLockSupportLevel = null;
        DeviceCapabilities.prototype.lidMigration = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceCapabilities.prototype, "_chatLockSupportLevel", {
            get: $util.oneOfGetter($oneOfFields = ["chatLockSupportLevel"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceCapabilities.prototype, "_lidMigration", {
            get: $util.oneOfGetter($oneOfFields = ["lidMigration"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        DeviceCapabilities.create = function create(properties) {
            return new DeviceCapabilities(properties);
        };

        DeviceCapabilities.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.chatLockSupportLevel != null && Object.hasOwnProperty.call(m, "chatLockSupportLevel"))
                w.uint32(8).int32(m.chatLockSupportLevel);
            if (m.lidMigration != null && Object.hasOwnProperty.call(m, "lidMigration"))
                $root.proto.DeviceCapabilities.LIDMigration.encode(m.lidMigration, w.uint32(18).fork()).ldelim();
            return w;
        };

        DeviceCapabilities.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceCapabilities();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.chatLockSupportLevel = r.int32();
                        break;
                    }
                case 2: {
                        m.lidMigration = $root.proto.DeviceCapabilities.LIDMigration.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceCapabilities.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.DeviceCapabilities)
                return d;
            var m = new $root.proto.DeviceCapabilities();
            switch (d.chatLockSupportLevel) {
            default:
                if (typeof d.chatLockSupportLevel === "number") {
                    m.chatLockSupportLevel = d.chatLockSupportLevel;
                    break;
                }
                break;
            case "NONE":
            case 0:
                m.chatLockSupportLevel = 0;
                break;
            case "MINIMAL":
            case 1:
                m.chatLockSupportLevel = 1;
                break;
            case "FULL":
            case 2:
                m.chatLockSupportLevel = 2;
                break;
            }
            if (d.lidMigration != null) {
                if (typeof d.lidMigration !== "object")
                    throw TypeError(".proto.DeviceCapabilities.lidMigration: object expected");
                m.lidMigration = $root.proto.DeviceCapabilities.LIDMigration.fromObject(d.lidMigration);
            }
            return m;
        };

        DeviceCapabilities.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.chatLockSupportLevel != null && m.hasOwnProperty("chatLockSupportLevel")) {
                d.chatLockSupportLevel = o.enums === String ? $root.proto.DeviceCapabilities.ChatLockSupportLevel[m.chatLockSupportLevel] === undefined ? m.chatLockSupportLevel : $root.proto.DeviceCapabilities.ChatLockSupportLevel[m.chatLockSupportLevel] : m.chatLockSupportLevel;
                if (o.oneofs)
                    d._chatLockSupportLevel = "chatLockSupportLevel";
            }
            if (m.lidMigration != null && m.hasOwnProperty("lidMigration")) {
                d.lidMigration = $root.proto.DeviceCapabilities.LIDMigration.toObject(m.lidMigration, o);
                if (o.oneofs)
                    d._lidMigration = "lidMigration";
            }
            return d;
        };

        DeviceCapabilities.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DeviceCapabilities.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceCapabilities";
        };

        DeviceCapabilities.ChatLockSupportLevel = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "MINIMAL"] = 1;
            values[valuesById[2] = "FULL"] = 2;
            return values;
        })();

        DeviceCapabilities.LIDMigration = (function() {

            function LIDMigration(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            LIDMigration.prototype.chatDbMigrationTimestamp = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(LIDMigration.prototype, "_chatDbMigrationTimestamp", {
                get: $util.oneOfGetter($oneOfFields = ["chatDbMigrationTimestamp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            LIDMigration.create = function create(properties) {
                return new LIDMigration(properties);
            };

            LIDMigration.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.chatDbMigrationTimestamp != null && Object.hasOwnProperty.call(m, "chatDbMigrationTimestamp"))
                    w.uint32(8).uint64(m.chatDbMigrationTimestamp);
                return w;
            };

            LIDMigration.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceCapabilities.LIDMigration();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.chatDbMigrationTimestamp = r.uint64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            LIDMigration.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.DeviceCapabilities.LIDMigration)
                    return d;
                var m = new $root.proto.DeviceCapabilities.LIDMigration();
                if (d.chatDbMigrationTimestamp != null) {
                    if ($util.Long)
                        (m.chatDbMigrationTimestamp = $util.Long.fromValue(d.chatDbMigrationTimestamp)).unsigned = true;
                    else if (typeof d.chatDbMigrationTimestamp === "string")
                        m.chatDbMigrationTimestamp = parseInt(d.chatDbMigrationTimestamp, 10);
                    else if (typeof d.chatDbMigrationTimestamp === "number")
                        m.chatDbMigrationTimestamp = d.chatDbMigrationTimestamp;
                    else if (typeof d.chatDbMigrationTimestamp === "object")
                        m.chatDbMigrationTimestamp = new $util.LongBits(d.chatDbMigrationTimestamp.low >>> 0, d.chatDbMigrationTimestamp.high >>> 0).toNumber(true);
                }
                return m;
            };

            LIDMigration.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.chatDbMigrationTimestamp != null && m.hasOwnProperty("chatDbMigrationTimestamp")) {
                    if (typeof m.chatDbMigrationTimestamp === "number")
                        d.chatDbMigrationTimestamp = o.longs === String ? String(m.chatDbMigrationTimestamp) : m.chatDbMigrationTimestamp;
                    else
                        d.chatDbMigrationTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.chatDbMigrationTimestamp) : o.longs === Number ? new $util.LongBits(m.chatDbMigrationTimestamp.low >>> 0, m.chatDbMigrationTimestamp.high >>> 0).toNumber(true) : m.chatDbMigrationTimestamp;
                    if (o.oneofs)
                        d._chatDbMigrationTimestamp = "chatDbMigrationTimestamp";
                }
                return d;
            };

            LIDMigration.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            LIDMigration.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.DeviceCapabilities.LIDMigration";
            };

            return LIDMigration;
        })();

        return DeviceCapabilities;
    })();

    proto.DeviceConsistencyCodeMessage = (function() {

        function DeviceConsistencyCodeMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceConsistencyCodeMessage.prototype.generation = null;
        DeviceConsistencyCodeMessage.prototype.signature = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceConsistencyCodeMessage.prototype, "_generation", {
            get: $util.oneOfGetter($oneOfFields = ["generation"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceConsistencyCodeMessage.prototype, "_signature", {
            get: $util.oneOfGetter($oneOfFields = ["signature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        DeviceConsistencyCodeMessage.create = function create(properties) {
            return new DeviceConsistencyCodeMessage(properties);
        };

        DeviceConsistencyCodeMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.generation != null && Object.hasOwnProperty.call(m, "generation"))
                w.uint32(8).uint32(m.generation);
            if (m.signature != null && Object.hasOwnProperty.call(m, "signature"))
                w.uint32(18).bytes(m.signature);
            return w;
        };

        DeviceConsistencyCodeMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceConsistencyCodeMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.generation = r.uint32();
                        break;
                    }
                case 2: {
                        m.signature = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceConsistencyCodeMessage.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.DeviceConsistencyCodeMessage)
                return d;
            var m = new $root.proto.DeviceConsistencyCodeMessage();
            if (d.generation != null) {
                m.generation = d.generation >>> 0;
            }
            if (d.signature != null) {
                if (typeof d.signature === "string")
                    $util.base64.decode(d.signature, m.signature = $util.newBuffer($util.base64.length(d.signature)), 0);
                else if (d.signature.length >= 0)
                    m.signature = d.signature;
            }
            return m;
        };

        DeviceConsistencyCodeMessage.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.generation != null && m.hasOwnProperty("generation")) {
                d.generation = m.generation;
                if (o.oneofs)
                    d._generation = "generation";
            }
            if (m.signature != null && m.hasOwnProperty("signature")) {
                d.signature = o.bytes === String ? $util.base64.encode(m.signature, 0, m.signature.length) : o.bytes === Array ? Array.prototype.slice.call(m.signature) : m.signature;
                if (o.oneofs)
                    d._signature = "signature";
            }
            return d;
        };

        DeviceConsistencyCodeMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DeviceConsistencyCodeMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceConsistencyCodeMessage";
        };

        return DeviceConsistencyCodeMessage;
    })();

    proto.DeviceListMetadata = (function() {

        function DeviceListMetadata(p) {
            this.senderKeyIndexes = [];
            this.recipientKeyIndexes = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceListMetadata.prototype.senderKeyHash = null;
        DeviceListMetadata.prototype.senderTimestamp = null;
        DeviceListMetadata.prototype.senderKeyIndexes = $util.emptyArray;
        DeviceListMetadata.prototype.senderAccountType = null;
        DeviceListMetadata.prototype.receiverAccountType = null;
        DeviceListMetadata.prototype.recipientKeyHash = null;
        DeviceListMetadata.prototype.recipientTimestamp = null;
        DeviceListMetadata.prototype.recipientKeyIndexes = $util.emptyArray;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceListMetadata.prototype, "_senderKeyHash", {
            get: $util.oneOfGetter($oneOfFields = ["senderKeyHash"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceListMetadata.prototype, "_senderTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["senderTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceListMetadata.prototype, "_senderAccountType", {
            get: $util.oneOfGetter($oneOfFields = ["senderAccountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceListMetadata.prototype, "_receiverAccountType", {
            get: $util.oneOfGetter($oneOfFields = ["receiverAccountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceListMetadata.prototype, "_recipientKeyHash", {
            get: $util.oneOfGetter($oneOfFields = ["recipientKeyHash"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceListMetadata.prototype, "_recipientTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["recipientTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        DeviceListMetadata.create = function create(properties) {
            return new DeviceListMetadata(properties);
        };

        DeviceListMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.senderKeyHash != null && Object.hasOwnProperty.call(m, "senderKeyHash"))
                w.uint32(10).bytes(m.senderKeyHash);
            if (m.senderTimestamp != null && Object.hasOwnProperty.call(m, "senderTimestamp"))
                w.uint32(16).uint64(m.senderTimestamp);
            if (m.senderKeyIndexes != null && m.senderKeyIndexes.length) {
                w.uint32(26).fork();
                for (var i = 0; i < m.senderKeyIndexes.length; ++i)
                    w.uint32(m.senderKeyIndexes[i]);
                w.ldelim();
            }
            if (m.senderAccountType != null && Object.hasOwnProperty.call(m, "senderAccountType"))
                w.uint32(32).int32(m.senderAccountType);
            if (m.receiverAccountType != null && Object.hasOwnProperty.call(m, "receiverAccountType"))
                w.uint32(40).int32(m.receiverAccountType);
            if (m.recipientKeyHash != null && Object.hasOwnProperty.call(m, "recipientKeyHash"))
                w.uint32(66).bytes(m.recipientKeyHash);
            if (m.recipientTimestamp != null && Object.hasOwnProperty.call(m, "recipientTimestamp"))
                w.uint32(72).uint64(m.recipientTimestamp);
            if (m.recipientKeyIndexes != null && m.recipientKeyIndexes.length) {
                w.uint32(82).fork();
                for (var i = 0; i < m.recipientKeyIndexes.length; ++i)
                    w.uint32(m.recipientKeyIndexes[i]);
                w.ldelim();
            }
            return w;
        };

        DeviceListMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceListMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.senderKeyHash = r.bytes();
                        break;
                    }
                case 2: {
                        m.senderTimestamp = r.uint64();
                        break;
                    }
                case 3: {
                        if (!(m.senderKeyIndexes && m.senderKeyIndexes.length))
                            m.senderKeyIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.senderKeyIndexes.push(r.uint32());
                        } else
                            m.senderKeyIndexes.push(r.uint32());
                        break;
                    }
                case 4: {
                        m.senderAccountType = r.int32();
                        break;
                    }
                case 5: {
                        m.receiverAccountType = r.int32();
                        break;
                    }
                case 8: {
                        m.recipientKeyHash = r.bytes();
                        break;
                    }
                case 9: {
                        m.recipientTimestamp = r.uint64();
                        break;
                    }
                case 10: {
                        if (!(m.recipientKeyIndexes && m.recipientKeyIndexes.length))
                            m.recipientKeyIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.recipientKeyIndexes.push(r.uint32());
                        } else
                            m.recipientKeyIndexes.push(r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceListMetadata.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.DeviceListMetadata)
                return d;
            var m = new $root.proto.DeviceListMetadata();
            if (d.senderKeyHash != null) {
                if (typeof d.senderKeyHash === "string")
                    $util.base64.decode(d.senderKeyHash, m.senderKeyHash = $util.newBuffer($util.base64.length(d.senderKeyHash)), 0);
                else if (d.senderKeyHash.length >= 0)
                    m.senderKeyHash = d.senderKeyHash;
            }
            if (d.senderTimestamp != null) {
                if ($util.Long)
                    (m.senderTimestamp = $util.Long.fromValue(d.senderTimestamp)).unsigned = true;
                else if (typeof d.senderTimestamp === "string")
                    m.senderTimestamp = parseInt(d.senderTimestamp, 10);
                else if (typeof d.senderTimestamp === "number")
                    m.senderTimestamp = d.senderTimestamp;
                else if (typeof d.senderTimestamp === "object")
                    m.senderTimestamp = new $util.LongBits(d.senderTimestamp.low >>> 0, d.senderTimestamp.high >>> 0).toNumber(true);
            }
            if (d.senderKeyIndexes) {
                if (!Array.isArray(d.senderKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.senderKeyIndexes: array expected");
                m.senderKeyIndexes = [];
                for (var i = 0; i < d.senderKeyIndexes.length; ++i) {
                    m.senderKeyIndexes[i] = d.senderKeyIndexes[i] >>> 0;
                }
            }
            switch (d.senderAccountType) {
            default:
                if (typeof d.senderAccountType === "number") {
                    m.senderAccountType = d.senderAccountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.senderAccountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.senderAccountType = 1;
                break;
            }
            switch (d.receiverAccountType) {
            default:
                if (typeof d.receiverAccountType === "number") {
                    m.receiverAccountType = d.receiverAccountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                m.receiverAccountType = 0;
                break;
            case "HOSTED":
            case 1:
                m.receiverAccountType = 1;
                break;
            }
            if (d.recipientKeyHash != null) {
                if (typeof d.recipientKeyHash === "string")
                    $util.base64.decode(d.recipientKeyHash, m.recipientKeyHash = $util.newBuffer($util.base64.length(d.recipientKeyHash)), 0);
                else if (d.recipientKeyHash.length >= 0)
                    m.recipientKeyHash = d.recipientKeyHash;
            }
            if (d.recipientTimestamp != null) {
                if ($util.Long)
                    (m.recipientTimestamp = $util.Long.fromValue(d.recipientTimestamp)).unsigned = true;
                else if (typeof d.recipientTimestamp === "string")
                    m.recipientTimestamp = parseInt(d.recipientTimestamp, 10);
                else if (typeof d.recipientTimestamp === "number")
                    m.recipientTimestamp = d.recipientTimestamp;
                else if (typeof d.recipientTimestamp === "object")
                    m.recipientTimestamp = new $util.LongBits(d.recipientTimestamp.low >>> 0, d.recipientTimestamp.high >>> 0).toNumber(true);
            }
            if (d.recipientKeyIndexes) {
                if (!Array.isArray(d.recipientKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.recipientKeyIndexes: array expected");
                m.recipientKeyIndexes = [];
                for (var i = 0; i < d.recipientKeyIndexes.length; ++i) {
                    m.recipientKeyIndexes[i] = d.recipientKeyIndexes[i] >>> 0;
                }
            }
            return m;
        };

        DeviceListMetadata.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (o.arrays || o.defaults) {
                d.senderKeyIndexes = [];
                d.recipientKeyIndexes = [];
            }
            if (m.senderKeyHash != null && m.hasOwnProperty("senderKeyHash")) {
                d.senderKeyHash = o.bytes === String ? $util.base64.encode(m.senderKeyHash, 0, m.senderKeyHash.length) : o.bytes === Array ? Array.prototype.slice.call(m.senderKeyHash) : m.senderKeyHash;
                if (o.oneofs)
                    d._senderKeyHash = "senderKeyHash";
            }
            if (m.senderTimestamp != null && m.hasOwnProperty("senderTimestamp")) {
                if (typeof m.senderTimestamp === "number")
                    d.senderTimestamp = o.longs === String ? String(m.senderTimestamp) : m.senderTimestamp;
                else
                    d.senderTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.senderTimestamp) : o.longs === Number ? new $util.LongBits(m.senderTimestamp.low >>> 0, m.senderTimestamp.high >>> 0).toNumber(true) : m.senderTimestamp;
                if (o.oneofs)
                    d._senderTimestamp = "senderTimestamp";
            }
            if (m.senderKeyIndexes && m.senderKeyIndexes.length) {
                d.senderKeyIndexes = [];
                for (var j = 0; j < m.senderKeyIndexes.length; ++j) {
                    d.senderKeyIndexes[j] = m.senderKeyIndexes[j];
                }
            }
            if (m.senderAccountType != null && m.hasOwnProperty("senderAccountType")) {
                d.senderAccountType = o.enums === String ? $root.proto.ADVEncryptionType[m.senderAccountType] === undefined ? m.senderAccountType : $root.proto.ADVEncryptionType[m.senderAccountType] : m.senderAccountType;
                if (o.oneofs)
                    d._senderAccountType = "senderAccountType";
            }
            if (m.receiverAccountType != null && m.hasOwnProperty("receiverAccountType")) {
                d.receiverAccountType = o.enums === String ? $root.proto.ADVEncryptionType[m.receiverAccountType] === undefined ? m.receiverAccountType : $root.proto.ADVEncryptionType[m.receiverAccountType] : m.receiverAccountType;
                if (o.oneofs)
                    d._receiverAccountType = "receiverAccountType";
            }
            if (m.recipientKeyHash != null && m.hasOwnProperty("recipientKeyHash")) {
                d.recipientKeyHash = o.bytes === String ? $util.base64.encode(m.recipientKeyHash, 0, m.recipientKeyHash.length) : o.bytes === Array ? Array.prototype.slice.call(m.recipientKeyHash) : m.recipientKeyHash;
                if (o.oneofs)
                    d._recipientKeyHash = "recipientKeyHash";
            }
            if (m.recipientTimestamp != null && m.hasOwnProperty("recipientTimestamp")) {
                if (typeof m.recipientTimestamp === "number")
                    d.recipientTimestamp = o.longs === String ? String(m.recipientTimestamp) : m.recipientTimestamp;
                else
                    d.recipientTimestamp = o.longs === String ? $util.Long.prototype.toString.call(m.recipientTimestamp) : o.longs === Number ? new $util.LongBits(m.recipientTimestamp.low >>> 0, m.recipientTimestamp.high >>> 0).toNumber(true) : m.recipientTimestamp;
                if (o.oneofs)
                    d._recipientTimestamp = "recipientTimestamp";
            }
            if (m.recipientKeyIndexes && m.recipientKeyIndexes.length) {
                d.recipientKeyIndexes = [];
                for (var j = 0; j < m.recipientKeyIndexes.length; ++j) {
                    d.recipientKeyIndexes[j] = m.recipientKeyIndexes[j];
                }
            }
            return d;
        };

        DeviceListMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DeviceListMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceListMetadata";
        };

        return DeviceListMetadata;
    })();

    proto.DeviceProps = (function() {

        function DeviceProps(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceProps.prototype.os = null;
        DeviceProps.prototype.version = null;
        DeviceProps.prototype.platformType = null;
        DeviceProps.prototype.requireFullSync = null;
        DeviceProps.prototype.historySyncConfig = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceProps.prototype, "_os", {
            get: $util.oneOfGetter($oneOfFields = ["os"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceProps.prototype, "_version", {
            get: $util.oneOfGetter($oneOfFields = ["version"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceProps.prototype, "_platformType", {
            get: $util.oneOfGetter($oneOfFields = ["platformType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceProps.prototype, "_requireFullSync", {
            get: $util.oneOfGetter($oneOfFields = ["requireFullSync"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DeviceProps.prototype, "_historySyncConfig", {
            get: $util.oneOfGetter($oneOfFields = ["historySyncConfig"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        DeviceProps.create = function create(properties) {
            return new DeviceProps(properties);
        };

        DeviceProps.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.os != null && Object.hasOwnProperty.call(m, "os"))
                w.uint32(10).string(m.os);
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                $root.proto.DeviceProps.AppVersion.encode(m.version, w.uint32(18).fork()).ldelim();
            if (m.platformType != null && Object.hasOwnProperty.call(m, "platformType"))
                w.uint32(24).int32(m.platformType);
            if (m.requireFullSync != null && Object.hasOwnProperty.call(m, "requireFullSync"))
                w.uint32(32).bool(m.requireFullSync);
            if (m.historySyncConfig != null && Object.hasOwnProperty.call(m, "historySyncConfig"))
                $root.proto.DeviceProps.HistorySyncConfig.encode(m.historySyncConfig, w.uint32(42).fork()).ldelim();
            return w;
        };

        DeviceProps.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceProps();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.os = r.string();
                        break;
                    }
                case 2: {
                        m.version = $root.proto.DeviceProps.AppVersion.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.platformType = r.int32();
                        break;
                    }
                case 4: {
                        m.requireFullSync = r.bool();
                        break;
                    }
                case 5: {
                        m.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceProps.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.DeviceProps)
                return d;
            var m = new $root.proto.DeviceProps();
            if (d.os != null) {
                m.os = String(d.os);
            }
            if (d.version != null) {
                if (typeof d.version !== "object")
                    throw TypeError(".proto.DeviceProps.version: object expected");
                m.version = $root.proto.DeviceProps.AppVersion.fromObject(d.version);
            }
            switch (d.platformType) {
            default:
                if (typeof d.platformType === "number") {
                    m.platformType = d.platformType;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.platformType = 0;
                break;
            case "CHROME":
            case 1:
                m.platformType = 1;
                break;
            case "FIREFOX":
            case 2:
                m.platformType = 2;
                break;
            case "IE":
            case 3:
                m.platformType = 3;
                break;
            case "OPERA":
            case 4:
                m.platformType = 4;
                break;
            case "SAFARI":
            case 5:
                m.platformType = 5;
                break;
            case "EDGE":
            case 6:
                m.platformType = 6;
                break;
            case "DESKTOP":
            case 7:
                m.platformType = 7;
                break;
            case "IPAD":
            case 8:
                m.platformType = 8;
                break;
            case "ANDROID_TABLET":
            case 9:
                m.platformType = 9;
                break;
            case "OHANA":
            case 10:
                m.platformType = 10;
                break;
            case "ALOHA":
            case 11:
                m.platformType = 11;
                break;
            case "CATALINA":
            case 12:
                m.platformType = 12;
                break;
            case "TCL_TV":
            case 13:
                m.platformType = 13;
                break;
            case "IOS_PHONE":
            case 14:
                m.platformType = 14;
                break;
            case "IOS_CATALYST":
            case 15:
                m.platformType = 15;
                break;
            case "ANDROID_PHONE":
            case 16:
                m.platformType = 16;
                break;
            case "ANDROID_AMBIGUOUS":
            case 17:
                m.platformType = 17;
                break;
            case "WEAR_OS":
            case 18:
                m.platformType = 18;
                break;
            case "AR_WRIST":
            case 19:
                m.platformType = 19;
                break;
            case "AR_DEVICE":
            case 20:
                m.platformType = 20;
                break;
            case "UWP":
            case 21:
                m.platformType = 21;
                break;
            case "VR":
            case 22:
                m.platformType = 22;
                break;
            case "CLOUD_API":
            case 23:
                m.platformType = 23;
                break;
            case "SMARTGLASSES":
            case 24:
                m.platformType = 24;
                break;
            }
            if (d.requireFullSync != null) {
                m.requireFullSync = Boolean(d.requireFullSync);
            }
            if (d.historySyncConfig != null) {
                if (typeof d.historySyncConfig !== "object")
                    throw TypeError(".proto.DeviceProps.historySyncConfig: object expected");
                m.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.fromObject(d.historySyncConfig);
            }
            return m;
        };

        DeviceProps.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.os != null && m.hasOwnProperty("os")) {
                d.os = m.os;
                if (o.oneofs)
                    d._os = "os";
            }
            if (m.version != null && m.hasOwnProperty("version")) {
                d.version = $root.proto.DeviceProps.AppVersion.toObject(m.version, o);
                if (o.oneofs)
                    d._version = "version";
            }
            if (m.platformType != null && m.hasOwnProperty("platformType")) {
                d.platformType = o.enums === String ? $root.proto.DeviceProps.PlatformType[m.platformType] === undefined ? m.platformType : $root.proto.DeviceProps.PlatformType[m.platformType] : m.platformType;
                if (o.oneofs)
                    d._platformType = "platformType";
            }
            if (m.requireFullSync != null && m.hasOwnProperty("requireFullSync")) {
                d.requireFullSync = m.requireFullSync;
                if (o.oneofs)
                    d._requireFullSync = "requireFullSync";
            }
            if (m.historySyncConfig != null && m.hasOwnProperty("historySyncConfig")) {
                d.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.toObject(m.historySyncConfig, o);
                if (o.oneofs)
                    d._historySyncConfig = "historySyncConfig";
            }
            return d;
        };

        DeviceProps.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DeviceProps.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceProps";
        };

        DeviceProps.AppVersion = (function() {

            function AppVersion(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppVersion.prototype.primary = null;
            AppVersion.prototype.secondary = null;
            AppVersion.prototype.tertiary = null;
            AppVersion.prototype.quaternary = null;
            AppVersion.prototype.quinary = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AppVersion.prototype, "_primary", {
                get: $util.oneOfGetter($oneOfFields = ["primary"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AppVersion.prototype, "_secondary", {
                get: $util.oneOfGetter($oneOfFields = ["secondary"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AppVersion.prototype, "_tertiary", {
                get: $util.oneOfGetter($oneOfFields = ["tertiary"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AppVersion.prototype, "_quaternary", {
                get: $util.oneOfGetter($oneOfFields = ["quaternary"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AppVersion.prototype, "_quinary", {
                get: $util.oneOfGetter($oneOfFields = ["quinary"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            AppVersion.create = function create(properties) {
                return new AppVersion(properties);
            };

            AppVersion.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.primary != null && Object.hasOwnProperty.call(m, "primary"))
                    w.uint32(8).uint32(m.primary);
                if (m.secondary != null && Object.hasOwnProperty.call(m, "secondary"))
                    w.uint32(16).uint32(m.secondary);
                if (m.tertiary != null && Object.hasOwnProperty.call(m, "tertiary"))
                    w.uint32(24).uint32(m.tertiary);
                if (m.quaternary != null && Object.hasOwnProperty.call(m, "quaternary"))
                    w.uint32(32).uint32(m.quaternary);
                if (m.quinary != null && Object.hasOwnProperty.call(m, "quinary"))
                    w.uint32(40).uint32(m.quinary);
                return w;
            };

            AppVersion.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceProps.AppVersion();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.primary = r.uint32();
                            break;
                        }
                    case 2: {
                            m.secondary = r.uint32();
                            break;
                        }
                    case 3: {
                            m.tertiary = r.uint32();
                            break;
                        }
                    case 4: {
                            m.quaternary = r.uint32();
                            break;
                        }
                    case 5: {
                            m.quinary = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppVersion.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.DeviceProps.AppVersion)
                    return d;
                var m = new $root.proto.DeviceProps.AppVersion();
                if (d.primary != null) {
                    m.primary = d.primary >>> 0;
                }
                if (d.secondary != null) {
                    m.secondary = d.secondary >>> 0;
                }
                if (d.tertiary != null) {
                    m.tertiary = d.tertiary >>> 0;
                }
                if (d.quaternary != null) {
                    m.quaternary = d.quaternary >>> 0;
                }
                if (d.quinary != null) {
                    m.quinary = d.quinary >>> 0;
                }
                return m;
            };

            AppVersion.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.primary != null && m.hasOwnProperty("primary")) {
                    d.primary = m.primary;
                    if (o.oneofs)
                        d._primary = "primary";
                }
                if (m.secondary != null && m.hasOwnProperty("secondary")) {
                    d.secondary = m.secondary;
                    if (o.oneofs)
                        d._secondary = "secondary";
                }
                if (m.tertiary != null && m.hasOwnProperty("tertiary")) {
                    d.tertiary = m.tertiary;
                    if (o.oneofs)
                        d._tertiary = "tertiary";
                }
                if (m.quaternary != null && m.hasOwnProperty("quaternary")) {
                    d.quaternary = m.quaternary;
                    if (o.oneofs)
                        d._quaternary = "quaternary";
                }
                if (m.quinary != null && m.hasOwnProperty("quinary")) {
                    d.quinary = m.quinary;
                    if (o.oneofs)
                        d._quinary = "quinary";
                }
                return d;
            };

            AppVersion.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            AppVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.DeviceProps.AppVersion";
            };

            return AppVersion;
        })();

        DeviceProps.HistorySyncConfig = (function() {

            function HistorySyncConfig(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HistorySyncConfig.prototype.fullSyncDaysLimit = null;
            HistorySyncConfig.prototype.fullSyncSizeMbLimit = null;
            HistorySyncConfig.prototype.storageQuotaMb = null;
            HistorySyncConfig.prototype.inlineInitialPayloadInE2EeMsg = null;
            HistorySyncConfig.prototype.recentSyncDaysLimit = null;
            HistorySyncConfig.prototype.supportCallLogHistory = null;
            HistorySyncConfig.prototype.supportBotUserAgentChatHistory = null;
            HistorySyncConfig.prototype.supportCagReactionsAndPolls = null;
            HistorySyncConfig.prototype.supportBizHostedMsg = null;
            HistorySyncConfig.prototype.supportRecentSyncChunkMessageCountTuning = null;
            HistorySyncConfig.prototype.supportHostedGroupMsg = null;
            HistorySyncConfig.prototype.supportFbidBotChatHistory = null;
            HistorySyncConfig.prototype.supportAddOnHistorySyncMigration = null;
            HistorySyncConfig.prototype.supportMessageAssociation = null;

            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_fullSyncDaysLimit", {
                get: $util.oneOfGetter($oneOfFields = ["fullSyncDaysLimit"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_fullSyncSizeMbLimit", {
                get: $util.oneOfGetter($oneOfFields = ["fullSyncSizeMbLimit"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_storageQuotaMb", {
                get: $util.oneOfGetter($oneOfFields = ["storageQuotaMb"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_inlineInitialPayloadInE2EeMsg", {
                get: $util.oneOfGetter($oneOfFields = ["inlineInitialPayloadInE2EeMsg"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_recentSyncDaysLimit", {
                get: $util.oneOfGetter($oneOfFields = ["recentSyncDaysLimit"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportCallLogHistory", {
                get: $util.oneOfGetter($oneOfFields = ["supportCallLogHistory"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportBotUserAgentChatHistory", {
                get: $util.oneOfGetter($oneOfFields = ["supportBotUserAgentChatHistory"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportCagReactionsAndPolls", {
                get: $util.oneOfGetter($oneOfFields = ["supportCagReactionsAndPolls"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportBizHostedMsg", {
                get: $util.oneOfGetter($oneOfFields = ["supportBizHostedMsg"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportRecentSyncChunkMessageCountTuning", {
                get: $util.oneOfGetter($oneOfFields = ["supportRecentSyncChunkMessageCountTuning"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportHostedGroupMsg", {
                get: $util.oneOfGetter($oneOfFields = ["supportHostedGroupMsg"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportFbidBotChatHistory", {
                get: $util.oneOfGetter($oneOfFields = ["supportFbidBotChatHistory"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportAddOnHistorySyncMigration", {
                get: $util.oneOfGetter($oneOfFields = ["supportAddOnHistorySyncMigration"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(HistorySyncConfig.prototype, "_supportMessageAssociation", {
                get: $util.oneOfGetter($oneOfFields = ["supportMessageAssociation"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            HistorySyncConfig.create = function create(properties) {
                return new HistorySyncConfig(properties);
            };

            HistorySyncConfig.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.fullSyncDaysLimit != null && Object.hasOwnProperty.call(m, "fullSyncDaysLimit"))
                    w.uint32(8).uint32(m.fullSyncDaysLimit);
                if (m.fullSyncSizeMbLimit != null && Object.hasOwnProperty.call(m, "fullSyncSizeMbLimit"))
                    w.uint32(16).uint32(m.fullSyncSizeMbLimit);
                if (m.storageQuotaMb != null && Object.hasOwnProperty.call(m, "storageQuotaMb"))
                    w.uint32(24).uint32(m.storageQuotaMb);
                if (m.inlineInitialPayloadInE2EeMsg != null && Object.hasOwnProperty.call(m, "inlineInitialPayloadInE2EeMsg"))
                    w.uint32(32).bool(m.inlineInitialPayloadInE2EeMsg);
                if (m.recentSyncDaysLimit != null && Object.hasOwnProperty.call(m, "recentSyncDaysLimit"))
                    w.uint32(40).uint32(m.recentSyncDaysLimit);
                if (m.supportCallLogHistory != null && Object.hasOwnProperty.call(m, "supportCallLogHistory"))
                    w.uint32(48).bool(m.supportCallLogHistory);
                if (m.supportBotUserAgentChatHistory != null && Object.hasOwnProperty.call(m, "supportBotUserAgentChatHistory"))
                    w.uint32(56).bool(m.supportBotUserAgentChatHistory);
                if (m.supportCagReactionsAndPolls != null && Object.hasOwnProperty.call(m, "supportCagReactionsAndPolls"))
                    w.uint32(64).bool(m.supportCagReactionsAndPolls);
                if (m.supportBizHostedMsg != null && Object.hasOwnProperty.call(m, "supportBizHostedMsg"))
                    w.uint32(72).bool(m.supportBizHostedMsg);
                if (m.supportRecentSyncChunkMessageCountTuning != null && Object.hasOwnProperty.call(m, "supportRecentSyncChunkMessageCountTuning"))
                    w.uint32(80).bool(m.supportRecentSyncChunkMessageCountTuning);
                if (m.supportHostedGroupMsg != null && Object.hasOwnProperty.call(m, "supportHostedGroupMsg"))
                    w.uint32(88).bool(m.supportHostedGroupMsg);
                if (m.supportFbidBotChatHistory != null && Object.hasOwnProperty.call(m, "supportFbidBotChatHistory"))
                    w.uint32(96).bool(m.supportFbidBotChatHistory);
                if (m.supportAddOnHistorySyncMigration != null && Object.hasOwnProperty.call(m, "supportAddOnHistorySyncMigration"))
                    w.uint32(104).bool(m.supportAddOnHistorySyncMigration);
                if (m.supportMessageAssociation != null && Object.hasOwnProperty.call(m, "supportMessageAssociation"))
                    w.uint32(112).bool(m.supportMessageAssociation);
                return w;
            };

            HistorySyncConfig.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceProps.HistorySyncConfig();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.fullSyncDaysLimit = r.uint32();
                            break;
                        }
                    case 2: {
                            m.fullSyncSizeMbLimit = r.uint32();
                            break;
                        }
                    case 3: {
                            m.storageQuotaMb = r.uint32();
                            break;
                        }
                    case 4: {
                            m.inlineInitialPayloadInE2EeMsg = r.bool();
                            break;
                        }
                    case 5: {
                            m.recentSyncDaysLimit = r.uint32();
                            break;
                        }
                    case 6: {
                            m.supportCallLogHistory = r.bool();
                            break;
                        }
                    case 7: {
                            m.supportBotUserAgentChatHistory = r.bool();
                            break;
                        }
                    case 8: {
                            m.supportCagReactionsAndPolls = r.bool();
                            break;
                        }
                    case 9: {
                            m.supportBizHostedMsg = r.bool();
                            break;
                        }
                    case 10: {
                            m.supportRecentSyncChunkMessageCountTuning = r.bool();
                            break;
                        }
                    case 11: {
                            m.supportHostedGroupMsg = r.bool();
                            break;
                        }
                    case 12: {
                            m.supportFbidBotChatHistory = r.bool();
                            break;
                        }
                    case 13: {
                            m.supportAddOnHistorySyncMigration = r.bool();
                            break;
                        }
                    case 14: {
                            m.supportMessageAssociation = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HistorySyncConfig.fromObject = function fromObject(d) {
                if (d instanceof $root.proto.DeviceProps.HistorySyncConfig)
                    return d;
                var m = new $root.proto.DeviceProps.HistorySyncConfig();
                if (d.fullSyncDaysLimit != null) {
                    m.fullSyncDaysLimit = d.fullSyncDaysLimit >>> 0;
                }
                if (d.fullSyncSizeMbLimit != null) {
                    m.fullSyncSizeMbLimit = d.fullSyncSizeMbLimit >>> 0;
                }
                if (d.storageQuotaMb != null) {
                    m.storageQuotaMb = d.storageQuotaMb >>> 0;
                }
                if (d.inlineInitialPayloadInE2EeMsg != null) {
                    m.inlineInitialPayloadInE2EeMsg = Boolean(d.inlineInitialPayloadInE2EeMsg);
                }
                if (d.recentSyncDaysLimit != null) {
                    m.recentSyncDaysLimit = d.recentSyncDaysLimit >>> 0;
                }
                if (d.supportCallLogHistory != null) {
                    m.supportCallLogHistory = Boolean(d.supportCallLogHistory);
                }
                if (d.supportBotUserAgentChatHistory != null) {
                    m.supportBotUserAgentChatHistory = Boolean(d.supportBotUserAgentChatHistory);
                }
                if (d.supportCagReactionsAndPolls != null) {
                    m.supportCagReactionsAndPolls = Boolean(d.supportCagReactionsAndPolls);
                }
                if (d.supportBizHostedMsg != null) {
                    m.supportBizHostedMsg = Boolean(d.supportBizHostedMsg);
                }
                if (d.supportRecentSyncChunkMessageCountTuning != null) {
                    m.supportRecentSyncChunkMessageCountTuning = Boolean(d.supportRecentSyncChunkMessageCountTuning);
                }
                if (d.supportHostedGroupMsg != null) {
                    m.supportHostedGroupMsg = Boolean(d.supportHostedGroupMsg);
                }
                if (d.supportFbidBotChatHistory != null) {
                    m.supportFbidBotChatHistory = Boolean(d.supportFbidBotChatHistory);
                }
                if (d.supportAddOnHistorySyncMigration != null) {
                    m.supportAddOnHistorySyncMigration = Boolean(d.supportAddOnHistorySyncMigration);
                }
                if (d.supportMessageAssociation != null) {
                    m.supportMessageAssociation = Boolean(d.supportMessageAssociation);
                }
                return m;
            };

            HistorySyncConfig.toObject = function toObject(m, o) {
                if (!o)
                    o = {};
                var d = {};
                if (m.fullSyncDaysLimit != null && m.hasOwnProperty("fullSyncDaysLimit")) {
                    d.fullSyncDaysLimit = m.fullSyncDaysLimit;
                    if (o.oneofs)
                        d._fullSyncDaysLimit = "fullSyncDaysLimit";
                }
                if (m.fullSyncSizeMbLimit != null && m.hasOwnProperty("fullSyncSizeMbLimit")) {
                    d.fullSyncSizeMbLimit = m.fullSyncSizeMbLimit;
                    if (o.oneofs)
                        d._fullSyncSizeMbLimit = "fullSyncSizeMbLimit";
                }
                if (m.storageQuotaMb != null && m.hasOwnProperty("storageQuotaMb")) {
                    d.storageQuotaMb = m.storageQuotaMb;
                    if (o.oneofs)
                        d._storageQuotaMb = "storageQuotaMb";
                }
                if (m.inlineInitialPayloadInE2EeMsg != null && m.hasOwnProperty("inlineInitialPayloadInE2EeMsg")) {
                    d.inlineInitialPayloadInE2EeMsg = m.inlineInitialPayloadInE2EeMsg;
                    if (o.oneofs)
                        d._inlineInitialPayloadInE2EeMsg = "inlineInitialPayloadInE2EeMsg";
                }
                if (m.recentSyncDaysLimit != null && m.hasOwnProperty("recentSyncDaysLimit")) {
                    d.recentSyncDaysLimit = m.recentSyncDaysLimit;
                    if (o.oneofs)
                        d._recentSyncDaysLimit = "recentSyncDaysLimit";
                }
                if (m.supportCallLogHistory != null && m.hasOwnProperty("supportCallLogHistory")) {
                    d.supportCallLogHistory = m.supportCallLogHistory;
                    if (o.oneofs)
                        d._supportCallLogHistory = "supportCallLogHistory";
                }
                if (m.supportBotUserAgentChatHistory != null && m.hasOwnProperty("supportBotUserAgentChatHistory")) {
                    d.supportBotUserAgentChatHistory = m.supportBotUserAgentChatHistory;
                    if (o.oneofs)
                        d._supportBotUserAgentChatHistory = "supportBotUserAgentChatHistory";
                }
                if (m.supportCagReactionsAndPolls != null && m.hasOwnProperty("supportCagReactionsAndPolls")) {
                    d.supportCagReactionsAndPolls = m.supportCagReactionsAndPolls;
                    if (o.oneofs)
                        d._supportCagReactionsAndPolls = "supportCagReactionsAndPolls";
                }
                if (m.supportBizHostedMsg != null && m.hasOwnProperty("supportBizHostedMsg")) {
                    d.supportBizHostedMsg = m.supportBizHostedMsg;
                    if (o.oneofs)
                        d._supportBizHostedMsg = "supportBizHostedMsg";
                }
                if (m.supportRecentSyncChunkMessageCountTuning != null && m.hasOwnProperty("supportRecentSyncChunkMessageCountTuning")) {
                    d.supportRecentSyncChunkMessageCountTuning = m.supportRecentSyncChunkMessageCountTuning;
                    if (o.oneofs)
                        d._supportRecentSyncChunkMessageCountTuning = "supportRecentSyncChunkMessageCountTuning";
                }
                if (m.supportHostedGroupMsg != null && m.hasOwnProperty("supportHostedGroupMsg")) {
                    d.supportHostedGroupMsg = m.supportHostedGroupMsg;
                    if (o.oneofs)
                        d._supportHostedGroupMsg = "supportHostedGroupMsg";
                }
                if (m.supportFbidBotChatHistory != null && m.hasOwnProperty("supportFbidBotChatHistory")) {
                    d.supportFbidBotChatHistory = m.supportFbidBotChatHistory;
                    if (o.oneofs)
                        d._supportFbidBotChatHistory = "supportFbidBotChatHistory";
                }
                if (m.supportAddOnHistorySyncMigration != null && m.hasOwnProperty("supportAddOnHistorySyncMigration")) {
                    d.supportAddOnHistorySyncMigration = m.supportAddOnHistorySyncMigration;
                    if (o.oneofs)
                        d._supportAddOnHistorySyncMigration = "supportAddOnHistorySyncMigration";
                }
                if (m.supportMessageAssociation != null && m.hasOwnProperty("supportMessageAssociation")) {
                    d.supportMessageAssociation = m.supportMessageAssociation;
                    if (o.oneofs)
                        d._supportMessageAssociation = "supportMessageAssociation";
                }
                return d;
            };

            HistorySyncConfig.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            HistorySyncConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.DeviceProps.HistorySyncConfig";
            };

            return HistorySyncConfig;
        })();

        DeviceProps.PlatformType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHROME"] = 1;
            values[valuesById[2] = "FIREFOX"] = 2;
            values[valuesById[3] = "IE"] = 3;
            values[valuesById[4] = "OPERA"] = 4;
            values[valuesById[5] = "SAFARI"] = 5;
            values[valuesById[6] = "EDGE"] = 6;
            values[valuesById[7] = "DESKTOP"] = 7;
            values[valuesById[8] = "IPAD"] = 8;
            values[valuesById[9] = "ANDROID_TABLET"] = 9;
            values[valuesById[10] = "OHANA"] = 10;
            values[valuesById[11] = "ALOHA"] = 11;
            values[valuesById[12] = "CATALINA"] = 12;
            values[valuesById[13] = "TCL_TV"] = 13;
            values[valuesById[14] = "IOS_PHONE"] = 14;
            values[valuesById[15] = "IOS_CATALYST"] = 15;
            values[valuesById[16] = "ANDROID_PHONE"] = 16;
            values[valuesById[17] = "ANDROID_AMBIGUOUS"] = 17;
            values[valuesById[18] = "WEAR_OS"] = 18;
            values[valuesById[19] = "AR_WRIST"] = 19;
            values[valuesById[20] = "AR_DEVICE"] = 20;
            values[valuesById[21] = "UWP"] = 21;
            values[valuesById[22] = "VR"] = 22;
            values[valuesById[23] = "CLOUD_API"] = 23;
            values[valuesById[24] = "SMARTGLASSES"] = 24;
            return values;
        })();

        return DeviceProps;
    })();

    proto.DisappearingMode = (function() {

        function DisappearingMode(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DisappearingMode.prototype.initiator = null;
        DisappearingMode.prototype.trigger = null;
        DisappearingMode.prototype.initiatorDeviceJid = null;
        DisappearingMode.prototype.initiatedByMe = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DisappearingMode.prototype, "_initiator", {
            get: $util.oneOfGetter($oneOfFields = ["initiator"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DisappearingMode.prototype, "_trigger", {
            get: $util.oneOfGetter($oneOfFields = ["trigger"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DisappearingMode.prototype, "_initiatorDeviceJid", {
            get: $util.oneOfGetter($oneOfFields = ["initiatorDeviceJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(DisappearingMode.prototype, "_initiatedByMe", {
            get: $util.oneOfGetter($oneOfFields = ["initiatedByMe"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        DisappearingMode.create = function create(properties) {
            return new DisappearingMode(properties);
        };

        DisappearingMode.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.initiator != null && Object.hasOwnProperty.call(m, "initiator"))
                w.uint32(8).int32(m.initiator);
            if (m.trigger != null && Object.hasOwnProperty.call(m, "trigger"))
                w.uint32(16).int32(m.trigger);
            if (m.initiatorDeviceJid != null && Object.hasOwnProperty.call(m, "initiatorDeviceJid"))
                w.uint32(26).string(m.initiatorDeviceJid);
            if (m.initiatedByMe != null && Object.hasOwnProperty.call(m, "initiatedByMe"))
                w.uint32(32).bool(m.initiatedByMe);
            return w;
        };

        DisappearingMode.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DisappearingMode();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.initiator = r.int32();
                        break;
                    }
                case 2: {
                        m.trigger = r.int32();
                        break;
                    }
                case 3: {
                        m.initiatorDeviceJid = r.string();
                        break;
                    }
                case 4: {
                        m.initiatedByMe = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DisappearingMode.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.DisappearingMode)
                return d;
            var m = new $root.proto.DisappearingMode();
            switch (d.initiator) {
            default:
                if (typeof d.initiator === "number") {
                    m.initiator = d.initiator;
                    break;
                }
                break;
            case "CHANGED_IN_CHAT":
            case 0:
                m.initiator = 0;
                break;
            case "INITIATED_BY_ME":
            case 1:
                m.initiator = 1;
                break;
            case "INITIATED_BY_OTHER":
            case 2:
                m.initiator = 2;
                break;
            case "BIZ_UPGRADE_FB_HOSTING":
            case 3:
                m.initiator = 3;
                break;
            }
            switch (d.trigger) {
            default:
                if (typeof d.trigger === "number") {
                    m.trigger = d.trigger;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                m.trigger = 0;
                break;
            case "CHAT_SETTING":
            case 1:
                m.trigger = 1;
                break;
            case "ACCOUNT_SETTING":
            case 2:
                m.trigger = 2;
                break;
            case "BULK_CHANGE":
            case 3:
                m.trigger = 3;
                break;
            case "BIZ_SUPPORTS_FB_HOSTING":
            case 4:
                m.trigger = 4;
                break;
            case "UNKNOWN_GROUPS":
            case 5:
                m.trigger = 5;
                break;
            }
            if (d.initiatorDeviceJid != null) {
                m.initiatorDeviceJid = String(d.initiatorDeviceJid);
            }
            if (d.initiatedByMe != null) {
                m.initiatedByMe = Boolean(d.initiatedByMe);
            }
            return m;
        };

        DisappearingMode.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.initiator != null && m.hasOwnProperty("initiator")) {
                d.initiator = o.enums === String ? $root.proto.DisappearingMode.Initiator[m.initiator] === undefined ? m.initiator : $root.proto.DisappearingMode.Initiator[m.initiator] : m.initiator;
                if (o.oneofs)
                    d._initiator = "initiator";
            }
            if (m.trigger != null && m.hasOwnProperty("trigger")) {
                d.trigger = o.enums === String ? $root.proto.DisappearingMode.Trigger[m.trigger] === undefined ? m.trigger : $root.proto.DisappearingMode.Trigger[m.trigger] : m.trigger;
                if (o.oneofs)
                    d._trigger = "trigger";
            }
            if (m.initiatorDeviceJid != null && m.hasOwnProperty("initiatorDeviceJid")) {
                d.initiatorDeviceJid = m.initiatorDeviceJid;
                if (o.oneofs)
                    d._initiatorDeviceJid = "initiatorDeviceJid";
            }
            if (m.initiatedByMe != null && m.hasOwnProperty("initiatedByMe")) {
                d.initiatedByMe = m.initiatedByMe;
                if (o.oneofs)
                    d._initiatedByMe = "initiatedByMe";
            }
            return d;
        };

        DisappearingMode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DisappearingMode.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DisappearingMode";
        };

        DisappearingMode.Initiator = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CHANGED_IN_CHAT"] = 0;
            values[valuesById[1] = "INITIATED_BY_ME"] = 1;
            values[valuesById[2] = "INITIATED_BY_OTHER"] = 2;
            values[valuesById[3] = "BIZ_UPGRADE_FB_HOSTING"] = 3;
            return values;
        })();

        DisappearingMode.Trigger = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHAT_SETTING"] = 1;
            values[valuesById[2] = "ACCOUNT_SETTING"] = 2;
            values[valuesById[3] = "BULK_CHANGE"] = 3;
            values[valuesById[4] = "BIZ_SUPPORTS_FB_HOSTING"] = 4;
            values[valuesById[5] = "UNKNOWN_GROUPS"] = 5;
            return values;
        })();

        return DisappearingMode;
    })();

    proto.EmbeddedContent = (function() {

        function EmbeddedContent(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EmbeddedContent.prototype.embeddedMessage = null;
        EmbeddedContent.prototype.embeddedMusic = null;

        let $oneOfFields;

        Object.defineProperty(EmbeddedContent.prototype, "content", {
            get: $util.oneOfGetter($oneOfFields = ["embeddedMessage", "embeddedMusic"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        EmbeddedContent.create = function create(properties) {
            return new EmbeddedContent(properties);
        };

        EmbeddedContent.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.embeddedMessage != null && Object.hasOwnProperty.call(m, "embeddedMessage"))
                $root.proto.EmbeddedMessage.encode(m.embeddedMessage, w.uint32(10).fork()).ldelim();
            if (m.embeddedMusic != null && Object.hasOwnProperty.call(m, "embeddedMusic"))
                $root.proto.EmbeddedMusic.encode(m.embeddedMusic, w.uint32(18).fork()).ldelim();
            return w;
        };

        EmbeddedContent.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EmbeddedContent();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.embeddedMessage = $root.proto.EmbeddedMessage.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.embeddedMusic = $root.proto.EmbeddedMusic.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EmbeddedContent.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.EmbeddedContent)
                return d;
            var m = new $root.proto.EmbeddedContent();
            if (d.embeddedMessage != null) {
                if (typeof d.embeddedMessage !== "object")
                    throw TypeError(".proto.EmbeddedContent.embeddedMessage: object expected");
                m.embeddedMessage = $root.proto.EmbeddedMessage.fromObject(d.embeddedMessage);
            }
            if (d.embeddedMusic != null) {
                if (typeof d.embeddedMusic !== "object")
                    throw TypeError(".proto.EmbeddedContent.embeddedMusic: object expected");
                m.embeddedMusic = $root.proto.EmbeddedMusic.fromObject(d.embeddedMusic);
            }
            return m;
        };

        EmbeddedContent.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.embeddedMessage != null && m.hasOwnProperty("embeddedMessage")) {
                d.embeddedMessage = $root.proto.EmbeddedMessage.toObject(m.embeddedMessage, o);
                if (o.oneofs)
                    d.content = "embeddedMessage";
            }
            if (m.embeddedMusic != null && m.hasOwnProperty("embeddedMusic")) {
                d.embeddedMusic = $root.proto.EmbeddedMusic.toObject(m.embeddedMusic, o);
                if (o.oneofs)
                    d.content = "embeddedMusic";
            }
            return d;
        };

        EmbeddedContent.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        EmbeddedContent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EmbeddedContent";
        };

        return EmbeddedContent;
    })();

    proto.EmbeddedMessage = (function() {

        function EmbeddedMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EmbeddedMessage.prototype.stanzaId = null;
        EmbeddedMessage.prototype.message = null;

        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(EmbeddedMessage.prototype, "_stanzaId", {
            get: $util.oneOfGetter($oneOfFields = ["stanzaId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(EmbeddedMessage.prototype, "_message", {
            get: $util.oneOfGetter($oneOfFields = ["message"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        EmbeddedMessage.create = function create(properties) {
            return new EmbeddedMessage(properties);
        };

        EmbeddedMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                w.uint32(10).string(m.stanzaId);
            if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                $root.proto.Message.encode(m.message, w.uint32(18).fork()).ldelim();
            return w;
        };

        EmbeddedMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EmbeddedMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.stanzaId = r.string();
                        break;
                    }
                case 2: {
                        m.message = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EmbeddedMessage.fromObject = function fromObject(d) {
            if (d instanceof $root.proto.EmbeddedMessage)
                return d;
            var m = new $root.proto.EmbeddedMessage();
            if (d.stanzaId != null) {
                m.stanzaId = String(d.stanzaId);
            }
            if (d.message != null) {
                if (typeof d.message !== "object")
                    throw TypeError(".proto.EmbeddedMessage.message: object expected");
                m.message = $root.proto.Message.fromObject(d.message);
            }
            return m;
        };

        EmbeddedMessage.toObject = function toObject(m, o) {
            if (!o)
                o = {};
            var d = {};
            if (m.stanzaId != null && m